/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.migration;

import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.TimedRequest;
import org.elasticsearch.common.Strings;

public class IndexUpgradeInfoRequest
extends TimedRequest
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true);

    public IndexUpgradeInfoRequest(String ... indices) {
        this.indices(indices);
    }

    public String[] indices() {
        return this.indices;
    }

    public IndexUpgradeInfoRequest indices(String ... indices) {
        this.indices = Objects.requireNonNull(indices, "indices cannot be null");
        return this;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public void indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexUpgradeInfoRequest request = (IndexUpgradeInfoRequest)o;
        return Arrays.equals(this.indices, request.indices) && Objects.equals(this.indicesOptions.toString(), request.indicesOptions.toString());
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.indicesOptions.toString());
    }
}

