/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.providers;

import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.utils.ToString;

@SdkProtectedApi
public class LazyAwsRegionProvider
implements AwsRegionProvider {
    private final Supplier<AwsRegionProvider> delegateConstructor;
    private volatile AwsRegionProvider delegate;

    public LazyAwsRegionProvider(Supplier<AwsRegionProvider> delegateConstructor) {
        this.delegateConstructor = delegateConstructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region getRegion() {
        if (this.delegate == null) {
            LazyAwsRegionProvider lazyAwsRegionProvider = this;
            synchronized (lazyAwsRegionProvider) {
                if (this.delegate == null) {
                    this.delegate = this.delegateConstructor.get();
                }
            }
        }
        return this.delegate.getRegion();
    }

    public String toString() {
        return ToString.builder((String)"LazyAwsRegionProvider").add("delegateConstructor", this.delegateConstructor).add("delegate", (Object)this.delegate).build();
    }
}

