/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import org.kuali.rice.krad.uif.util.ProcessLogger;

public final class ObjectPathExpressionParser {
    private static final ThreadLocal<ParseState> TL_EL_PARSE_STATE = new ThreadLocal();

    public static int indexOfCloseBracket(String path, int leftBracketIndex) {
        if (path == null || path.length() <= leftBracketIndex || path.charAt(leftBracketIndex) != '[') {
            return -1;
        }
        char inQuote = '\u0000';
        int pathLen = path.length() - 1;
        int bracketCount = 1;
        int currentPos = leftBracketIndex;
        do {
            char currentChar = path.charAt(++currentPos);
            if (inQuote == '\u0000' && (currentChar == '\'' || currentChar == '\"')) {
                inQuote = currentChar;
            } else if (inQuote == currentChar) {
                inQuote = '\u0000';
            }
            if (inQuote != '\u0000') continue;
            if (currentChar == '[') {
                ++bracketCount;
            }
            if (currentChar != ']') continue;
            --bracketCount;
        } while (currentPos < pathLen && bracketCount > 0);
        if (bracketCount > 0) {
            throw new IllegalArgumentException("Unmatched '[': " + path);
        }
        return currentPos;
    }

    public static boolean isPath(String propertyName) {
        if (propertyName == null) {
            return false;
        }
        int length = propertyName.length();
        for (int i = 0; i < length; ++i) {
            char c = propertyName.charAt(i);
            if (c == '_' || c == '$' || Character.isLetterOrDigit(c)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T parsePathExpression(Object root, String path, PathEntry pathEntry) {
        boolean recycle;
        ParseState parseState = TL_EL_PARSE_STATE.get();
        if (parseState == null) {
            TL_EL_PARSE_STATE.set(new ParseState());
            parseState = TL_EL_PARSE_STATE.get();
            recycle = true;
        } else if (parseState.isActive()) {
            ProcessLogger.ntrace("el-parse:", ":nested", 100L);
            parseState = new ParseState();
            recycle = false;
        } else {
            recycle = true;
        }
        try {
            parseState.originalPath = path;
            parseState.originalPathIndex = 0;
            parseState.parentPath = null;
            parseState.currentContinuation = pathEntry.parse(null, root, null);
            while (path != null) {
                path = parseState.prepareNextScan(path);
                parseState.scan(path);
                path = parseState.step(path, pathEntry);
            }
            Object object = parseState.currentContinuation;
            return (T)object;
        }
        finally {
            assert (!recycle || parseState == TL_EL_PARSE_STATE.get());
            parseState.reset();
        }
    }

    private ObjectPathExpressionParser() {
    }

    private static final class ParseState {
        private int nextScanIndex;
        private int nextTokenIndex;
        private String originalPath;
        private int originalPathIndex;
        private String parentPath;
        private Object currentContinuation;

        private ParseState() {
        }

        private boolean isActive() {
            return this.currentContinuation != null;
        }

        private void reset() {
            this.currentContinuation = null;
            this.originalPath = null;
            this.originalPathIndex = 0;
            this.parentPath = null;
        }

        public String prepareNextScan(String path) {
            this.nextScanIndex = 0;
            if (path.length() == 0) {
                throw new IllegalArgumentException("Unexpected end of input " + this.parentPath);
            }
            int endOfCollectionReference = ObjectPathExpressionParser.indexOfCloseBracket(path, 0);
            if (endOfCollectionReference == -1) {
                return path;
            }
            StringBuilder pathBuilder = new StringBuilder(path);
            pathBuilder.deleteCharAt(endOfCollectionReference);
            pathBuilder.deleteCharAt(0);
            char firstChar = pathBuilder.charAt(0);
            if ((firstChar == '\'' || firstChar == '\"') && path.charAt(endOfCollectionReference - 1) == firstChar) {
                pathBuilder.deleteCharAt(endOfCollectionReference - 2);
                pathBuilder.deleteCharAt(0);
            }
            int diff = path.length() - pathBuilder.length();
            this.nextScanIndex += endOfCollectionReference + 1 - diff;
            this.originalPathIndex += diff;
            return pathBuilder.toString();
        }

        public void scan(String path) {
            this.nextTokenIndex = -1;
            for (int currentIndex = this.nextScanIndex; currentIndex < path.length(); ++currentIndex) {
                switch (path.charAt(currentIndex)) {
                    case ']': {
                        throw new IllegalArgumentException("Unmatched ']': " + path);
                    }
                    case '.': 
                    case '[': {
                        if (this.nextTokenIndex == -1) {
                            this.nextTokenIndex = currentIndex;
                        }
                        this.originalPathIndex += this.nextTokenIndex;
                        return;
                    }
                }
            }
        }

        private String step(String path, PathEntry pathEntry) {
            if (this.nextTokenIndex == -1) {
                this.currentContinuation = pathEntry.parse(this.parentPath, this.currentContinuation, path);
                this.parentPath = this.originalPath.substring(0, this.originalPathIndex);
                return null;
            }
            char nextToken = path.charAt(this.nextTokenIndex);
            switch (nextToken) {
                case '[': {
                    this.currentContinuation = pathEntry.parse(this.parentPath, this.currentContinuation, path.substring(0, this.nextTokenIndex));
                    this.parentPath = this.originalPath.substring(0, this.originalPathIndex);
                    return path.substring(this.nextTokenIndex);
                }
                case '.': {
                    this.currentContinuation = pathEntry.parse(this.parentPath, this.currentContinuation, path.substring(0, this.nextTokenIndex));
                    this.parentPath = this.originalPath.substring(0, this.originalPathIndex++);
                    return path.substring(this.nextTokenIndex + 1);
                }
            }
            throw new IllegalArgumentException("Unexpected '" + nextToken + "' :" + path);
        }
    }

    public static interface PathEntry {
        public Object parse(String var1, Object var2, String var3);
    }
}

