/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.annotations.OptimisticLocking;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.RepositoryBoIncrementer;
import org.kuali.rice.krms.impl.repository.RuleBo;

@Entity
@Table(name="KRMS_AGENDA_ITM_T")
@OptimisticLocking(cascade=true)
public class AgendaItemBo
implements AgendaItemDefinitionContract,
Versioned,
Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final long serialVersionUID = 1L;
    public static final String COPY_OF_TEXT = "Copy of ";
    public static final String AGENDA_ITEM_SEQ_NAME = "KRMS_AGENDA_ITM_S";
    static RepositoryBoIncrementer agendaItemIdIncrementer = new RepositoryBoIncrementer("KRMS_AGENDA_ITM_S");
    @Transient
    private transient DataObjectService dataObjectService = null;
    @Transient
    private transient KrmsTypeRepositoryService krmsTypeRepositoryService = null;
    @PortableSequenceGenerator(name="KRMS_AGENDA_ITM_S")
    @GeneratedValue(generator="KRMS_AGENDA_ITM_S")
    @Id
    @Column(name="AGENDA_ITM_ID")
    private String id;
    @Column(name="AGENDA_ID")
    private String agendaId;
    @Column(name="SUB_AGENDA_ID")
    private String subAgendaId;
    @Column(name="WHEN_TRUE", insertable=false, updatable=false)
    private String whenTrueId;
    @Column(name="WHEN_FALSE", insertable=false, updatable=false)
    private String whenFalseId;
    @Column(name="ALWAYS", insertable=false, updatable=false)
    private String alwaysId;
    @ManyToOne(targetEntity=RuleBo.class, fetch=FetchType.LAZY, cascade={CascadeType.REFRESH, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="RULE_ID", referencedColumnName="RULE_ID")
    private RuleBo rule;
    @Column(name="VER_NBR")
    @Version
    private Long versionNumber;
    @ManyToOne(targetEntity=AgendaItemBo.class, cascade={CascadeType.REFRESH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @JoinColumn(name="WHEN_TRUE", referencedColumnName="AGENDA_ITM_ID")
    private AgendaItemBo whenTrue;
    @ManyToOne(targetEntity=AgendaItemBo.class, cascade={CascadeType.REFRESH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @JoinColumn(name="WHEN_FALSE", referencedColumnName="AGENDA_ITM_ID")
    private AgendaItemBo whenFalse;
    @ManyToOne(targetEntity=AgendaItemBo.class, cascade={CascadeType.REFRESH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE})
    @JoinColumn(name="ALWAYS", referencedColumnName="AGENDA_ITM_ID")
    private AgendaItemBo always;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_rule_vh;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public String getUl(AgendaItemBo firstItem) {
        return "<ul>" + this.getUlHelper(firstItem) + "</ul>";
    }

    public String getUlHelper(AgendaItemBo item) {
        StringBuilder sb = new StringBuilder();
        sb.append("<li>" + this.getRuleId() + "</li>");
        if (this._persistence_get_whenTrue() != null) {
            sb.append("<ul><li>when true</li><ul>");
            sb.append(this.getUlHelper(this._persistence_get_whenTrue()));
            sb.append("</ul></ul>");
        }
        if (this._persistence_get_whenFalse() != null) {
            sb.append("<ul><li>when false</li><ul>");
            sb.append(this.getUlHelper(this._persistence_get_whenFalse()));
            sb.append("</ul></ul>");
        }
        if (this._persistence_get_always() != null) {
            sb.append(this.getUlHelper(this._persistence_get_always()));
        }
        return sb.toString();
    }

    public String getRuleText() {
        StringBuilder resultBuilder = new StringBuilder();
        if (this.getRule() != null) {
            if (StringUtils.isBlank((String)this.getRule().getName())) {
                resultBuilder.append("- unnamed rule -");
            } else {
                resultBuilder.append(this.getRule().getName());
            }
            if (!StringUtils.isBlank((String)this.getRule().getDescription())) {
                resultBuilder.append(": ");
                resultBuilder.append(this.getRule().getDescription());
            }
            if (!CollectionUtils.isEmpty(this.getRule().getActions())) {
                resultBuilder.append("   [");
                ActionBo action = this.getRule().getActions().get(0);
                KrmsTypeDefinition krmsTypeDefn = this.getKrmsTypeRepositoryService().getTypeById(action.getTypeId());
                resultBuilder.append(krmsTypeDefn.getName());
                resultBuilder.append(": ");
                resultBuilder.append(action.getName());
                if (this.getRule().getActions().size() > 1) {
                    resultBuilder.append(" ... ");
                }
                resultBuilder.append("]");
            }
        } else {
            throw new IllegalStateException();
        }
        return resultBuilder.toString();
    }

    public List<AgendaItemBo> getAlwaysList() {
        ArrayList<AgendaItemBo> results = new ArrayList<AgendaItemBo>();
        AgendaItemBo currentNode = this;
        while (currentNode._persistence_get_always() != null) {
            results.add(currentNode._persistence_get_always());
            currentNode = currentNode._persistence_get_always();
        }
        return results;
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getAgendaId() {
        return this._persistence_get_agendaId();
    }

    public void setAgendaId(String agendaId) {
        this._persistence_set_agendaId(agendaId);
    }

    public String getRuleId() {
        if (this._persistence_get_rule() != null) {
            return this._persistence_get_rule().getId();
        }
        return null;
    }

    public String getSubAgendaId() {
        return this._persistence_get_subAgendaId();
    }

    public void setSubAgendaId(String subAgendaId) {
        this._persistence_set_subAgendaId(subAgendaId);
    }

    public String getWhenTrueId() {
        return this._persistence_get_whenTrueId();
    }

    public void setWhenTrueId(String whenTrueId) {
        this._persistence_set_whenTrueId(whenTrueId);
    }

    public String getWhenFalseId() {
        return this._persistence_get_whenFalseId();
    }

    public void setWhenFalseId(String whenFalseId) {
        this._persistence_set_whenFalseId(whenFalseId);
    }

    public String getAlwaysId() {
        return this._persistence_get_alwaysId();
    }

    public void setAlwaysId(String alwaysId) {
        this._persistence_set_alwaysId(alwaysId);
    }

    public Long getVersionNumber() {
        return this._persistence_get_versionNumber();
    }

    public void setVersionNumber(Long versionNumber) {
        this._persistence_set_versionNumber(versionNumber);
    }

    public AgendaItemBo getWhenTrue() {
        return this._persistence_get_whenTrue();
    }

    public void setWhenTrue(AgendaItemBo whenTrue) {
        this._persistence_set_whenTrue(whenTrue);
        if (whenTrue != null) {
            this.setWhenTrueId(whenTrue.getId());
        } else {
            this.setWhenTrueId(null);
        }
    }

    public AgendaItemBo getWhenFalse() {
        return this._persistence_get_whenFalse();
    }

    public void setWhenFalse(AgendaItemBo whenFalse) {
        this._persistence_set_whenFalse(whenFalse);
        if (whenFalse != null) {
            this.setWhenFalseId(whenFalse.getId());
        } else {
            this.setWhenFalseId(null);
        }
    }

    public AgendaItemBo getAlways() {
        return this._persistence_get_always();
    }

    public void setAlways(AgendaItemBo always) {
        this._persistence_set_always(always);
        if (always != null) {
            this.setAlwaysId(always.getId());
        } else {
            this.setAlwaysId(null);
        }
    }

    public RuleBo getRule() {
        return this._persistence_get_rule();
    }

    public AgendaDefinitionContract getSubAgenda() {
        return null;
    }

    public void setRule(RuleBo rule) {
        this._persistence_set_rule(rule);
    }

    static AgendaItemDefinition to(AgendaItemBo bo) {
        if (bo == null) {
            return null;
        }
        AgendaItemDefinition.Builder builder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)bo);
        return builder.build();
    }

    public static AgendaItemBo from(AgendaItemDefinition im) {
        if (im == null) {
            return null;
        }
        AgendaItemBo bo = new AgendaItemBo();
        bo._persistence_set_id(im.getId());
        bo._persistence_set_agendaId(im.getAgendaId());
        bo._persistence_set_subAgendaId(im.getSubAgendaId());
        bo._persistence_set_whenTrueId(im.getWhenTrueId());
        bo._persistence_set_whenFalseId(im.getWhenFalseId());
        bo._persistence_set_alwaysId(im.getAlwaysId());
        bo._persistence_set_versionNumber(im.getVersionNumber());
        bo._persistence_set_rule(RuleBo.from(im.getRule()));
        bo._persistence_set_whenTrue(AgendaItemBo.from(im.getWhenTrue()));
        bo._persistence_set_whenFalse(AgendaItemBo.from(im.getWhenFalse()));
        bo._persistence_set_always(AgendaItemBo.from(im.getAlways()));
        return bo;
    }

    public AgendaItemBo copyAgendaItem(AgendaBo copiedAgenda, Map<String, RuleBo> oldRuleIdToNew, Map<String, AgendaItemBo> oldAgendaItemIdToNew, List<AgendaItemBo> copiedAgendaItems, String dts) {
        AgendaItemBo copiedAgendaItem = (AgendaItemBo)this.getDataObjectService().copyInstance((Object)this, new CopyOption[]{CopyOption.RESET_PK_FIELDS, CopyOption.RESET_OBJECT_ID});
        copiedAgendaItem.setId(agendaItemIdIncrementer.getNewId());
        copiedAgendaItem.setAgendaId(copiedAgenda.getId());
        oldAgendaItemIdToNew.put(this.getId(), copiedAgendaItem);
        if (!oldRuleIdToNew.containsKey(this.getRuleId())) {
            if (this.getRule() != null) {
                copiedAgendaItem.setRule(this.getRule().copyRule(COPY_OF_TEXT + this.getRule().getName() + " " + dts));
                oldRuleIdToNew.put(this.getRuleId(), copiedAgendaItem.getRule());
            }
        } else {
            copiedAgendaItem.setRule(oldRuleIdToNew.get(this.getRuleId()));
        }
        if (copiedAgendaItem.getWhenFalse() != null) {
            if (!oldAgendaItemIdToNew.containsKey(this.getWhenFalseId())) {
                copiedAgendaItem.setWhenFalse(this.getWhenFalse().copyAgendaItem(copiedAgenda, oldRuleIdToNew, oldAgendaItemIdToNew, copiedAgendaItems, dts));
                oldAgendaItemIdToNew.put(this.getWhenFalseId(), copiedAgendaItem.getWhenFalse());
                copiedAgendaItems.add(copiedAgendaItem.getWhenFalse());
            } else {
                copiedAgendaItem.setWhenFalse(oldAgendaItemIdToNew.get(this.getWhenFalseId()));
            }
        }
        if (copiedAgendaItem.getWhenTrue() != null) {
            if (!oldAgendaItemIdToNew.containsKey(this.getWhenTrueId())) {
                copiedAgendaItem.setWhenTrue(this.getWhenTrue().copyAgendaItem(copiedAgenda, oldRuleIdToNew, oldAgendaItemIdToNew, copiedAgendaItems, dts));
                oldAgendaItemIdToNew.put(this.getWhenTrueId(), copiedAgendaItem.getWhenTrue());
                copiedAgendaItems.add(copiedAgendaItem.getWhenTrue());
            } else {
                copiedAgendaItem.setWhenTrue(oldAgendaItemIdToNew.get(this.getWhenTrueId()));
            }
        }
        if (copiedAgendaItem.getAlways() != null) {
            if (!oldAgendaItemIdToNew.containsKey(this.getAlwaysId())) {
                copiedAgendaItem.setAlways(this.getAlways().copyAgendaItem(copiedAgenda, oldRuleIdToNew, oldAgendaItemIdToNew, copiedAgendaItems, dts));
                oldAgendaItemIdToNew.put(this.getAlwaysId(), copiedAgendaItem.getAlways());
                copiedAgendaItems.add(copiedAgendaItem.getAlways());
            } else {
                copiedAgendaItem.setAlways(oldAgendaItemIdToNew.get(this.getAlwaysId()));
            }
        }
        return copiedAgendaItem;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KradDataServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public KrmsTypeRepositoryService getKrmsTypeRepositoryService() {
        if (this.krmsTypeRepositoryService == null) {
            this.krmsTypeRepositoryService = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
        }
        return this.krmsTypeRepositoryService;
    }

    public void setKrmsTypeRepositoryService(KrmsTypeRepositoryService dataObjectService) {
        this.krmsTypeRepositoryService = dataObjectService;
    }

    public Object _persistence_post_clone() {
        if (this._persistence_rule_vh != null) {
            this._persistence_rule_vh = (WeavedAttributeValueHolderInterface)this._persistence_rule_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new AgendaItemBo();
    }

    public Object _persistence_get(String string) {
        if (string == "always") {
            return this.always;
        }
        if (string == "subAgendaId") {
            return this.subAgendaId;
        }
        if (string == "whenFalse") {
            return this.whenFalse;
        }
        if (string == "alwaysId") {
            return this.alwaysId;
        }
        if (string == "rule") {
            return this.rule;
        }
        if (string == "whenTrueId") {
            return this.whenTrueId;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "whenTrue") {
            return this.whenTrue;
        }
        if (string == "whenFalseId") {
            return this.whenFalseId;
        }
        if (string == "agendaId") {
            return this.agendaId;
        }
        if (string == "versionNumber") {
            return this.versionNumber;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "always") {
            this.always = (AgendaItemBo)object;
            return;
        }
        if (string == "subAgendaId") {
            this.subAgendaId = (String)object;
            return;
        }
        if (string == "whenFalse") {
            this.whenFalse = (AgendaItemBo)object;
            return;
        }
        if (string == "alwaysId") {
            this.alwaysId = (String)object;
            return;
        }
        if (string == "rule") {
            this.rule = (RuleBo)object;
            return;
        }
        if (string == "whenTrueId") {
            this.whenTrueId = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "whenTrue") {
            this.whenTrue = (AgendaItemBo)object;
            return;
        }
        if (string == "whenFalseId") {
            this.whenFalseId = (String)object;
            return;
        }
        if (string == "agendaId") {
            this.agendaId = (String)object;
            return;
        }
        if (string == "versionNumber") {
            this.versionNumber = (Long)object;
            return;
        }
    }

    public AgendaItemBo _persistence_get_always() {
        this._persistence_checkFetched("always");
        return this.always;
    }

    public void _persistence_set_always(AgendaItemBo agendaItemBo) {
        this._persistence_checkFetchedForSet("always");
        this._persistence_propertyChange("always", this.always, agendaItemBo);
        this.always = agendaItemBo;
    }

    public String _persistence_get_subAgendaId() {
        this._persistence_checkFetched("subAgendaId");
        return this.subAgendaId;
    }

    public void _persistence_set_subAgendaId(String string) {
        this._persistence_checkFetchedForSet("subAgendaId");
        this._persistence_propertyChange("subAgendaId", this.subAgendaId, string);
        this.subAgendaId = string;
    }

    public AgendaItemBo _persistence_get_whenFalse() {
        this._persistence_checkFetched("whenFalse");
        return this.whenFalse;
    }

    public void _persistence_set_whenFalse(AgendaItemBo agendaItemBo) {
        this._persistence_checkFetchedForSet("whenFalse");
        this._persistence_propertyChange("whenFalse", this.whenFalse, agendaItemBo);
        this.whenFalse = agendaItemBo;
    }

    public String _persistence_get_alwaysId() {
        this._persistence_checkFetched("alwaysId");
        return this.alwaysId;
    }

    public void _persistence_set_alwaysId(String string) {
        this._persistence_checkFetchedForSet("alwaysId");
        this._persistence_propertyChange("alwaysId", this.alwaysId, string);
        this.alwaysId = string;
    }

    protected void _persistence_initialize_rule_vh() {
        if (this._persistence_rule_vh == null) {
            this._persistence_rule_vh = new ValueHolder((Object)this.rule);
            this._persistence_rule_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_rule_vh() {
        RuleBo ruleBo;
        this._persistence_initialize_rule_vh();
        if ((this._persistence_rule_vh.isCoordinatedWithProperty() || this._persistence_rule_vh.isNewlyWeavedValueHolder()) && (ruleBo = this._persistence_get_rule()) != this._persistence_rule_vh.getValue()) {
            this._persistence_set_rule(ruleBo);
        }
        return this._persistence_rule_vh;
    }

    public void _persistence_set_rule_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_rule_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            RuleBo ruleBo = this._persistence_get_rule();
            if (ruleBo != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_rule((RuleBo)object);
            }
        } else {
            this.rule = null;
        }
    }

    public RuleBo _persistence_get_rule() {
        this._persistence_checkFetched("rule");
        this._persistence_initialize_rule_vh();
        this.rule = (RuleBo)this._persistence_rule_vh.getValue();
        return this.rule;
    }

    public void _persistence_set_rule(RuleBo ruleBo) {
        this._persistence_checkFetchedForSet("rule");
        this._persistence_initialize_rule_vh();
        this.rule = (RuleBo)this._persistence_rule_vh.getValue();
        this._persistence_propertyChange("rule", this.rule, ruleBo);
        this.rule = ruleBo;
        this._persistence_rule_vh.setValue((Object)ruleBo);
    }

    public String _persistence_get_whenTrueId() {
        this._persistence_checkFetched("whenTrueId");
        return this.whenTrueId;
    }

    public void _persistence_set_whenTrueId(String string) {
        this._persistence_checkFetchedForSet("whenTrueId");
        this._persistence_propertyChange("whenTrueId", this.whenTrueId, string);
        this.whenTrueId = string;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public AgendaItemBo _persistence_get_whenTrue() {
        this._persistence_checkFetched("whenTrue");
        return this.whenTrue;
    }

    public void _persistence_set_whenTrue(AgendaItemBo agendaItemBo) {
        this._persistence_checkFetchedForSet("whenTrue");
        this._persistence_propertyChange("whenTrue", this.whenTrue, agendaItemBo);
        this.whenTrue = agendaItemBo;
    }

    public String _persistence_get_whenFalseId() {
        this._persistence_checkFetched("whenFalseId");
        return this.whenFalseId;
    }

    public void _persistence_set_whenFalseId(String string) {
        this._persistence_checkFetchedForSet("whenFalseId");
        this._persistence_propertyChange("whenFalseId", this.whenFalseId, string);
        this.whenFalseId = string;
    }

    public String _persistence_get_agendaId() {
        this._persistence_checkFetched("agendaId");
        return this.agendaId;
    }

    public void _persistence_set_agendaId(String string) {
        this._persistence_checkFetchedForSet("agendaId");
        this._persistence_propertyChange("agendaId", this.agendaId, string);
        this.agendaId = string;
    }

    public Long _persistence_get_versionNumber() {
        this._persistence_checkFetched("versionNumber");
        return this.versionNumber;
    }

    public void _persistence_set_versionNumber(Long l) {
        this._persistence_checkFetchedForSet("versionNumber");
        this._persistence_propertyChange("versionNumber", this.versionNumber, l);
        this.versionNumber = l;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

