/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.kuali.rice.krad.datadictionary.validation.constraint.FloatingPointPatternConstraint;
import org.kuali.rice.krad.uif.UifConstants;

public class CurrencyPatternConstraint
extends FloatingPointPatternConstraint {
    @Override
    protected String getRegexString() {
        StringBuilder regexString = new StringBuilder(super.getRegexString());
        NumberFormat formatter = this.getCurrencyInstanceUsingParseBigDecimal();
        if (!(formatter instanceof DecimalFormat)) {
            return regexString.toString();
        }
        String prefix = ((DecimalFormat)formatter).getPositivePrefix();
        String suffix = ((DecimalFormat)formatter).getPositiveSuffix();
        if (prefix != null) {
            StringBuilder escapedPrefix = new StringBuilder();
            for (char c : prefix.toCharArray()) {
                if (UifConstants.JS_REGEX_SPECIAL_CHARS.indexOf(c) != -1) {
                    escapedPrefix.append("\\");
                }
                escapedPrefix.append(c);
            }
            regexString.insert(0, "(" + escapedPrefix + ")?");
        }
        if (suffix != null) {
            StringBuilder escapedSuffix = new StringBuilder();
            for (char c : suffix.toCharArray()) {
                if (UifConstants.JS_REGEX_SPECIAL_CHARS.indexOf(c) != -1) {
                    escapedSuffix.append("\\");
                }
                escapedSuffix.append(c);
            }
            regexString.append("(" + escapedSuffix + ")?");
        }
        return regexString.toString();
    }

    private NumberFormat getCurrencyInstanceUsingParseBigDecimal() {
        NumberFormat formatter = NumberFormat.getCurrencyInstance();
        if (formatter instanceof DecimalFormat) {
            ((DecimalFormat)formatter).setParseBigDecimal(true);
        }
        return formatter;
    }
}

