/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.keyvalues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public class PersistableBusinessObjectValuesFinder
extends KeyValuesBase {
    private static final Logger LOG = LogManager.getLogger(PersistableBusinessObjectValuesFinder.class);
    private static final long serialVersionUID = 1L;
    protected Class<?> businessObjectClass;
    protected String keyAttributeName;
    protected String labelAttributeName;
    protected boolean includeKeyInDescription = false;
    protected boolean includeBlankRow = false;

    public List<KeyValue> getKeyValues() {
        try {
            Collection objects = KRADServiceLocatorWeb.getLegacyDataAdapter().findMatching(this.businessObjectClass, Collections.emptyMap());
            ArrayList<KeyValue> labels = new ArrayList<KeyValue>(objects.size());
            if (this.includeBlankRow) {
                labels.add((KeyValue)new ConcreteKeyValue("", ""));
            }
            for (Object object : objects) {
                Object key = PropertyUtils.getProperty(object, (String)this.keyAttributeName);
                Object label = (String)PropertyUtils.getProperty(object, (String)this.labelAttributeName);
                if (this.includeKeyInDescription) {
                    label = key + " - " + (String)label;
                }
                labels.add((KeyValue)new ConcreteKeyValue(key.toString(), (String)label));
            }
            return labels;
        }
        catch (Exception e) {
            LOG.error("Exception occurred while trying to build keyValues List: " + this, (Throwable)e);
            throw new RuntimeException("Exception occurred while trying to build keyValues List: " + this, e);
        }
    }

    public void setBusinessObjectClass(Class<?> businessObjectClass) {
        this.businessObjectClass = businessObjectClass;
    }

    public void setIncludeKeyInDescription(boolean includeKeyInDescription) {
        this.includeKeyInDescription = includeKeyInDescription;
    }

    public void setKeyAttributeName(String keyAttributeName) {
        this.keyAttributeName = keyAttributeName;
    }

    public void setLabelAttributeName(String labelAttributeName) {
        this.labelAttributeName = labelAttributeName;
    }

    public void setIncludeBlankRow(boolean includeBlankRow) {
        this.includeBlankRow = includeBlankRow;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PersistableBusinessObjectValuesFinder [businessObjectClass=").append(this.businessObjectClass).append(", keyAttributeName=").append(this.keyAttributeName).append(", labelAttributeName=").append(this.labelAttributeName).append(", includeKeyInDescription=").append(this.includeKeyInDescription).append(", includeBlankRow=").append(this.includeBlankRow).append("]");
        return builder.toString();
    }
}

