/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.core;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.BudgetParentDocument;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.lock.ProposalBudgetLockService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.FormView;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalBudgetView
extends FormView {
    private static final String KC_ERROR_TRANSACTIONAL_LOCKED = "kc.error.transactional.locked.budget";
    private static final String ERROR_TRANSACTIONAL_LOCKED = "error.transactional.locked.budget";
    private ParameterService parameterService;
    private ProposalBudgetLockService proposalBudgetLockService;

    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        this.generatePessimisticLockMessages((ProposalBudgetForm)model);
        ((ProposalBudgetForm)model).setCanEditView(this.getReadOnly() == false);
    }

    protected void generatePessimisticLockMessages(ProposalBudgetForm form) {
        BudgetParentDocument<DevelopmentProposal> document = form.getBudget().getDevelopmentProposal().getDocument();
        Person user = GlobalVariables.getUserSession().getPerson();
        int budgetVersion = form.getBudget().getBudgetVersionNumber();
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (lock.isOwnedByUser(user) || !this.getProposalBudgetLockService().doesBudgetVersionMatchDescriptor(lock.getLockDescriptor(), budgetVersion)) continue;
            String lockDescriptor = (String)StringUtils.defaultIfBlank((CharSequence)lock.getLockDescriptor(), (CharSequence)"full");
            String lockOwner = lock.getOwnedByUser().getName();
            String lockTime = RiceConstants.getDefaultTimeFormat().format(lock.getGeneratedTimestamp());
            String lockDate = RiceConstants.getDefaultDateFormat().format(lock.getGeneratedTimestamp());
            if (!this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "ALLOW_CLEAR_PESSIMISTIC_LOCK").booleanValue()) {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", ERROR_TRANSACTIONAL_LOCKED, new String[]{lockDescriptor, lockOwner, lockTime, lockDate});
                continue;
            }
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", KC_ERROR_TRANSACTIONAL_LOCKED, new String[]{lockDescriptor, lockOwner, lockTime, lockDate, lock.getId().toString()});
        }
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ProposalBudgetLockService getProposalBudgetLockService() {
        if (this.proposalBudgetLockService == null) {
            this.proposalBudgetLockService = KcServiceLocator.getService(ProposalBudgetLockService.class);
        }
        return this.proposalBudgetLockService;
    }

    public void setProposalBudgetLockService(ProposalBudgetLockService proposalBudgetLockService) {
        this.proposalBudgetLockService = proposalBudgetLockService;
    }
}

