/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.web.struts.form;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.web.format.DateDisplayTimestampObjectFormatter;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.bo.ui.GroupDocumentMember;
import org.kuali.rice.kim.document.IdentityManagementGroupDocument;
import org.kuali.rice.kim.impl.group.GroupBo;
import org.kuali.rice.kim.impl.identity.PersonImpl;
import org.kuali.rice.kim.impl.role.RoleBo;
import org.kuali.rice.kim.impl.type.KimTypeBo;
import org.kuali.rice.kim.web.struts.form.IdentityManagementDocumentFormBase;

public class IdentityManagementGroupDocumentForm
extends IdentityManagementDocumentFormBase {
    protected static final long serialVersionUID = -107836689162363400L;
    protected boolean canAssignGroup;
    protected KimType kimType;
    protected GroupDocumentMember member;
    protected String groupId;

    public IdentityManagementGroupDocumentForm() {
        this.requiredNonEditableProperties.add("methodToCall");
        this.canAssignGroup = true;
        this.member = new GroupDocumentMember();
        this.setFormatterType("document.members.activeFromDate", DateDisplayTimestampObjectFormatter.class);
        this.setFormatterType("document.members.activeToDate", DateDisplayTimestampObjectFormatter.class);
    }

    public String getDefaultDocumentTypeName() {
        return "IdentityManagementGroupDocument";
    }

    public IdentityManagementGroupDocument getGroupDocument() {
        return (IdentityManagementGroupDocument)this.getDocument();
    }

    public String getMemberFieldConversions() {
        if (this.member == null) {
            return "";
        }
        return this.getMemberFieldConversions(this.member.getMemberTypeCode());
    }

    public String getMemberBusinessObjectName() {
        if (this.member == null) {
            return "";
        }
        return this.getMemberBusinessObjectName(this.member.getMemberTypeCode());
    }

    protected String getMemberFieldConversions(String memberTypeCode) {
        if (MemberType.PRINCIPAL.getCode().equals(memberTypeCode)) {
            return "principalId:member.memberId,principalName:member.memberName";
        }
        if (MemberType.ROLE.getCode().equals(memberTypeCode)) {
            return "id:member.memberId,name:member.memberName";
        }
        if (MemberType.GROUP.getCode().equals(memberTypeCode)) {
            return "id:member.memberId,name:member.memberName,namespaceCode:member.memberNamespaceCode";
        }
        return "";
    }

    protected String getMemberBusinessObjectName(String memberTypeCode) {
        if (MemberType.PRINCIPAL.getCode().equals(memberTypeCode)) {
            return PersonImpl.class.getName();
        }
        if (MemberType.ROLE.getCode().equals(memberTypeCode)) {
            return RoleBo.class.getName();
        }
        if (MemberType.GROUP.getCode().equals(memberTypeCode)) {
            return GroupBo.class.getName();
        }
        return "";
    }

    public KimType getKimType() {
        if (StringUtils.isNotBlank((String)this.getGroupDocument().getGroupTypeId())) {
            return KimApiServiceLocator.getKimTypeInfoService().getKimType(this.getGroupDocument().getGroupTypeId());
        }
        return this.kimType;
    }

    public String getKimTypeClass() {
        return KimTypeBo.class.getName();
    }

    public boolean isCanAssignGroup() {
        return this.canAssignGroup;
    }

    public void setCanAssignGroup(boolean canAssignGroup) {
        this.canAssignGroup = canAssignGroup;
    }

    public GroupDocumentMember getMember() {
        return this.member;
    }

    public void setMember(GroupDocumentMember member) {
        this.member = member;
    }

    @Override
    public List getMemberRows() {
        return this.getGroupDocument().getMembers();
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setKimType(KimType kimType) {
        this.kimType = kimType;
    }
}

