/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.phone;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.phone.EntityPhoneContract;
import org.w3c.dom.Element;

@XmlRootElement(name="entityPhone")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityPhoneType", propOrder={"id", "entityTypeCode", "entityId", "phoneType", "countryCode", "phoneNumber", "extensionNumber", "formattedPhoneNumber", "countryCodeUnmasked", "phoneNumberUnmasked", "extensionNumberUnmasked", "formattedPhoneNumberUnmasked", "suppressPhone", "defaultValue", "active", "versionNumber", "objectId", "_futureElements"})
public final class EntityPhone
extends AbstractDataTransferObject
implements EntityPhoneContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="entityTypeCode", required=false)
    private final String entityTypeCode;
    @XmlElement(name="entityId", required=false)
    private final String entityId;
    @XmlElement(name="phoneType", required=false)
    private final CodedAttribute phoneType;
    @XmlElement(name="phoneNumber", required=false)
    private final String phoneNumber;
    @XmlElement(name="extensionNumber", required=false)
    private final String extensionNumber;
    @XmlElement(name="countryCode", required=false)
    private final String countryCode;
    @XmlElement(name="phoneNumberUnmasked", required=false)
    private final String phoneNumberUnmasked;
    @XmlElement(name="extensionNumberUnmasked", required=false)
    private final String extensionNumberUnmasked;
    @XmlElement(name="countryCodeUnmasked", required=false)
    private final String countryCodeUnmasked;
    @XmlElement(name="formattedPhoneNumber", required=false)
    private final String formattedPhoneNumber;
    @XmlElement(name="formattedPhoneNumberUnmasked", required=false)
    private final String formattedPhoneNumberUnmasked;
    @XmlElement(name="suppressPhone", required=false)
    private final boolean suppressPhone;
    @XmlElement(name="defaultValue", required=false)
    private final boolean defaultValue;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private EntityPhone() {
        this.id = null;
        this.entityId = null;
        this.entityTypeCode = null;
        this.phoneType = null;
        this.phoneNumber = null;
        this.extensionNumber = null;
        this.countryCode = null;
        this.phoneNumberUnmasked = null;
        this.extensionNumberUnmasked = null;
        this.countryCodeUnmasked = null;
        this.formattedPhoneNumber = null;
        this.formattedPhoneNumberUnmasked = null;
        this.suppressPhone = false;
        this.defaultValue = false;
        this.versionNumber = null;
        this.objectId = null;
        this.active = false;
    }

    private EntityPhone(Builder builder) {
        this.id = builder.getId();
        this.entityId = builder.getEntityId();
        this.entityTypeCode = builder.getEntityTypeCode();
        this.phoneType = builder.getPhoneType() != null ? builder.getPhoneType().build() : null;
        this.phoneNumber = builder.getPhoneNumber();
        this.extensionNumber = builder.getExtensionNumber();
        this.countryCode = builder.getCountryCode();
        this.phoneNumberUnmasked = builder.getPhoneNumberUnmasked();
        this.extensionNumberUnmasked = builder.getExtensionNumberUnmasked();
        this.countryCodeUnmasked = builder.getCountryCodeUnmasked();
        this.formattedPhoneNumber = builder.getFormattedPhoneNumber();
        this.formattedPhoneNumberUnmasked = builder.getFormattedPhoneNumberUnmasked();
        this.suppressPhone = builder.isSuppressPhone();
        this.defaultValue = builder.isDefaultValue();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.active = builder.isActive();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public String getEntityTypeCode() {
        return this.entityTypeCode;
    }

    @Override
    public CodedAttribute getPhoneType() {
        return this.phoneType;
    }

    @Override
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String getExtensionNumber() {
        return this.extensionNumber;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getPhoneNumberUnmasked() {
        return this.phoneNumberUnmasked;
    }

    @Override
    public String getExtensionNumberUnmasked() {
        return this.extensionNumberUnmasked;
    }

    @Override
    public String getCountryCodeUnmasked() {
        return this.countryCodeUnmasked;
    }

    @Override
    public String getFormattedPhoneNumber() {
        return this.formattedPhoneNumber;
    }

    @Override
    public String getFormattedPhoneNumberUnmasked() {
        return this.formattedPhoneNumberUnmasked;
    }

    @Override
    public boolean isSuppressPhone() {
        return this.suppressPhone;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isActive() {
        return this.active;
    }

    static class Elements {
        static final String ID = "id";
        static final String ENTITY_TYPE_CODE = "entityTypeCode";
        static final String ENTITY_ID = "entityId";
        static final String PHONE_TYPE = "phoneType";
        static final String PHONE_NUMBER = "phoneNumber";
        static final String EXTENSION_NUMBER = "extensionNumber";
        static final String COUNTRY_CODE = "countryCode";
        static final String PHONE_NUMBER_UNMASKED = "phoneNumberUnmasked";
        static final String EXTENSION_NUMBER_UNMASKED = "extensionNumberUnmasked";
        static final String COUNTRY_CODE_UNMASKED = "countryCodeUnmasked";
        static final String FORMATTED_PHONE_NUMBER = "formattedPhoneNumber";
        static final String FORMATTED_PHONE_NUMBER_UNMASKED = "formattedPhoneNumberUnmasked";
        static final String SUPPRESS_PHONE = "suppressPhone";
        static final String DEFAULT_VALUE = "defaultValue";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entityPhone";
        static final String TYPE_NAME = "EntityPhoneType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    EntityPhoneContract {
        private String id;
        private String entityId;
        private String entityTypeCode;
        private CodedAttribute.Builder phoneType;
        private String phoneNumberUnmasked;
        private String extensionNumberUnmasked;
        private String countryCodeUnmasked;
        private boolean suppressPhone;
        private boolean defaultValue;
        private Long versionNumber;
        private String objectId;
        private boolean active;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(EntityPhoneContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setId(contract.getId());
            builder.setEntityId(contract.getEntityId());
            builder.setEntityTypeCode(contract.getEntityTypeCode());
            builder.setSuppressPhone(contract.isSuppressPhone());
            if (contract.getPhoneType() != null) {
                builder.setPhoneType(CodedAttribute.Builder.create(contract.getPhoneType()));
            }
            builder.setPhoneNumber(contract.getPhoneNumberUnmasked());
            builder.setExtensionNumber(contract.getExtensionNumberUnmasked());
            builder.setCountryCode(contract.getCountryCodeUnmasked());
            builder.setDefaultValue(contract.isDefaultValue());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setActive(contract.isActive());
            return builder;
        }

        public EntityPhone build() {
            return new EntityPhone(this);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getEntityTypeCode() {
            return this.entityTypeCode;
        }

        @Override
        public String getEntityId() {
            return this.entityId;
        }

        @Override
        public CodedAttribute.Builder getPhoneType() {
            return this.phoneType;
        }

        @Override
        public String getPhoneNumber() {
            if (this.isSuppressPhone()) {
                return "000-000-0000";
            }
            return this.phoneNumberUnmasked;
        }

        @Override
        public String getExtensionNumber() {
            if (this.isSuppressPhone()) {
                return "Xxxxxx";
            }
            return this.extensionNumberUnmasked;
        }

        @Override
        public String getCountryCode() {
            if (this.isSuppressPhone()) {
                return "XX";
            }
            return this.countryCodeUnmasked;
        }

        @Override
        public String getPhoneNumberUnmasked() {
            return this.phoneNumberUnmasked;
        }

        @Override
        public String getExtensionNumberUnmasked() {
            return this.extensionNumberUnmasked;
        }

        @Override
        public String getCountryCodeUnmasked() {
            return this.countryCodeUnmasked;
        }

        @Override
        public String getFormattedPhoneNumber() {
            if (this.isSuppressPhone()) {
                return "Xxxxxx";
            }
            return this.getFormattedPhoneNumberUnmasked();
        }

        @Override
        public String getFormattedPhoneNumberUnmasked() {
            StringBuffer sb = new StringBuffer(30);
            sb.append(this.phoneNumberUnmasked);
            if (StringUtils.isNotBlank((String)this.extensionNumberUnmasked)) {
                sb.append(" x");
                sb.append(this.extensionNumberUnmasked);
            }
            return sb.toString();
        }

        @Override
        public boolean isSuppressPhone() {
            return this.suppressPhone;
        }

        public boolean isDefaultValue() {
            return this.defaultValue;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }

        public void setEntityTypeCode(String entityTypeCode) {
            this.entityTypeCode = entityTypeCode;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public void setPhoneType(CodedAttribute.Builder phoneType) {
            this.phoneType = phoneType;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumberUnmasked = phoneNumber;
        }

        public void setExtensionNumber(String extensionNumber) {
            this.extensionNumberUnmasked = extensionNumber;
        }

        public void setCountryCode(String countryCode) {
            this.countryCodeUnmasked = countryCode;
        }

        private void setSuppressPhone(boolean suppressPhone) {
            this.suppressPhone = suppressPhone;
        }

        public void setDefaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

