/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlFormatter;
import net.sourceforge.schemaspy.view.HtmlTablePage;

public class HtmlColumnsPage
extends HtmlFormatter {
    private static HtmlColumnsPage instance = new HtmlColumnsPage();

    private HtmlColumnsPage() {
    }

    public static HtmlColumnsPage getInstance() {
        return instance;
    }

    public Map<String, ColumnInfo> getColumnInfos() {
        HashMap<String, ColumnInfo> hashMap = new HashMap<String, ColumnInfo>();
        hashMap.put("id", new ColumnInfo("Id", new Table.ByColumnIdComparator()));
        hashMap.put("table", new ColumnInfo("Table", new ByTableComparator()));
        hashMap.put("column", new ColumnInfo("Column", new ByColumnComparator()));
        hashMap.put("type", new ColumnInfo("Type", new ByTypeComparator()));
        hashMap.put("size", new ColumnInfo("Size", new BySizeComparator()));
        hashMap.put("nulls", new ColumnInfo("Nulls", new ByNullableComparator()));
        hashMap.put("auto", new ColumnInfo("Auto", new ByAutoUpdateComparator()));
        hashMap.put("default", new ColumnInfo("Default", new ByDefaultValueComparator()));
        hashMap.put("children", new ColumnInfo("Children", new ByChildrenComparator()));
        hashMap.put("parents", new ColumnInfo("Parents", new ByParentsComparator()));
        hashMap.put("comments", new ColumnInfo("Comments", new ByCommentsComparator()));
        LinkedHashMap<String, ColumnInfo> linkedHashMap = new LinkedHashMap<String, ColumnInfo>();
        for (String string : Config.getInstance().getColumnDetails()) {
            ColumnInfo columnInfo = (ColumnInfo)hashMap.get(string);
            if (columnInfo == null) {
                throw new IllegalArgumentException("Undefined column detail requested: '" + string + "'. Valid details: " + hashMap.keySet());
            }
            linkedHashMap.put(string, columnInfo);
        }
        return linkedHashMap;
    }

    public void write(Database database, Collection<Table> collection, ColumnInfo columnInfo, LineWriter lineWriter) throws IOException {
        TreeSet<TableColumn> treeSet = new TreeSet<TableColumn>(columnInfo.getComparator());
        HashSet<TableColumn> hashSet = new HashSet<TableColumn>();
        HashSet<TableColumn> hashSet2 = new HashSet<TableColumn>();
        for (Table object : collection) {
            treeSet.addAll(object.getColumns());
            hashSet.addAll(object.getPrimaryColumns());
            for (TableIndex tableIndex : object.getIndexes()) {
                hashSet2.addAll(tableIndex.getColumns());
            }
        }
        this.writeHeader(database, treeSet.size(), columnInfo, lineWriter);
        HtmlTablePage htmlTablePage = HtmlTablePage.getInstance();
        for (TableColumn tableColumn : treeSet) {
            htmlTablePage.writeColumn(tableColumn, tableColumn.getTable().getName(), hashSet, hashSet2, true, false, lineWriter);
        }
        this.writeFooter(lineWriter);
    }

    private void writeHeader(Database database, int n, ColumnInfo columnInfo, LineWriter lineWriter) throws IOException {
        this.writeHeader(database, null, "Columns", lineWriter);
        lineWriter.writeln("<table width='100%' border='0'>");
        lineWriter.writeln("<tr><td class='container'>");
        this.writeGeneratedOn(database.getConnectTime(), lineWriter);
        lineWriter.writeln("</td><td class='container' rowspan='2' align='right' valign='top'>");
        this.writeLegend(false, false, lineWriter);
        lineWriter.writeln("</td></tr>");
        lineWriter.writeln("<tr valign='top'><td class='container' align='left' valign='top'>");
        lineWriter.writeln("<p>");
        lineWriter.writeln("<form name='options' action=''>");
        if (Config.getInstance().getColumnDetails().contains("comments")) {
            lineWriter.writeln(" <label for='showComments'><input type=checkbox id='showComments'>Comments</label>");
        }
        lineWriter.writeln(" <label for='showLegend'><input type=checkbox checked id='showLegend'>Legend</label>");
        lineWriter.writeln("</form>");
        lineWriter.writeln("</table>");
        lineWriter.writeln("<div class='indent'>");
        lineWriter.write("<b>");
        lineWriter.write(database.getName());
        if (database.getSchema() != null) {
            lineWriter.write(46);
            lineWriter.write(database.getSchema());
        } else if (database.getCatalog() != null) {
            lineWriter.write(46);
            lineWriter.write(database.getCatalog());
        }
        lineWriter.write(" contains ");
        lineWriter.write(String.valueOf(n));
        lineWriter.write(" columns</b> - click on heading to sort:");
        Collection<Table> collection = database.getTables();
        boolean bl = collection.size() > 0 && collection.iterator().next().getId() != null;
        this.writeMainTableHeader(bl, columnInfo, lineWriter);
        lineWriter.writeln("<tbody valign='top'>");
    }

    public void writeMainTableHeader(boolean bl, ColumnInfo columnInfo, LineWriter lineWriter) throws IOException {
        boolean bl2 = columnInfo != null;
        ArrayList<String> arrayList = null;
        lineWriter.writeln("<a name='columns'></a>");
        lineWriter.writeln("<table id='columns' class='dataTable' border='1' rules='groups'>");
        if (bl2) {
            arrayList = new ArrayList<String>(Config.getInstance().getColumnDetails());
            if (!bl) {
                arrayList.remove("id");
            }
            for (String string : arrayList) {
                if (string.equals("comments")) {
                    lineWriter.writeln("<colgroup class='comment'>");
                    continue;
                }
                lineWriter.writeln("<colgroup>");
            }
        } else {
            int n = bl ? 9 : 8;
            for (int i = 0; i < n; ++i) {
                lineWriter.writeln("<colgroup>");
            }
            lineWriter.writeln("<colgroup class='comment'>");
        }
        lineWriter.writeln("<thead align='left'>");
        lineWriter.writeln("<tr>");
        if (bl2) {
            HashMap hashMap = new HashMap();
            hashMap.put("id", this.getTH(columnInfo, "ID", null, "right"));
            hashMap.put("table", this.getTH(columnInfo, "Table", null, null));
            hashMap.put("column", this.getTH(columnInfo, "Column", null, null));
            hashMap.put("type", this.getTH(columnInfo, "Type", null, null));
            hashMap.put("size", this.getTH(columnInfo, "Size", null, null));
            hashMap.put("nulls", this.getTH(columnInfo, "Nulls", "Are nulls allowed?", null));
            hashMap.put("auto", this.getTH(columnInfo, "Auto", "Is column automatically updated?", null));
            hashMap.put("default", this.getTH(columnInfo, "Default", "Default value", null));
            hashMap.put("children", this.getTH(columnInfo, "Children", "Columns in tables that reference this column", null));
            hashMap.put("parents", this.getTH(columnInfo, "Parents", "Columns in tables that are referenced by this column", null));
            hashMap.put("comments", "<th title='Comments' class='comment'><span class='notSortedByColumn'>Comments</span></th>");
            if (arrayList != null) {
                for (String string : arrayList) {
                    lineWriter.writeln((String)hashMap.get(string));
                }
            }
        } else {
            if (bl) {
                lineWriter.writeln(this.getTH(columnInfo, "ID", null, "right"));
            }
            lineWriter.writeln(this.getTH(columnInfo, "Column", null, null));
            lineWriter.writeln(this.getTH(columnInfo, "Type", null, null));
            lineWriter.writeln(this.getTH(columnInfo, "Size", null, null));
            lineWriter.writeln(this.getTH(columnInfo, "Nulls", "Are nulls allowed?", null));
            lineWriter.writeln(this.getTH(columnInfo, "Auto", "Is column automatically updated?", null));
            lineWriter.writeln(this.getTH(columnInfo, "Default", "Default value", null));
            lineWriter.writeln(this.getTH(columnInfo, "Children", "Columns in tables that reference this column", null));
            lineWriter.writeln(this.getTH(columnInfo, "Parents", "Columns in tables that are referenced by this column", null));
            lineWriter.writeln("  <th title='Comments' class='comment'><span class='notSortedByColumn'>Comments</span></th>");
        }
        lineWriter.writeln("</tr>");
        lineWriter.writeln("</thead>");
    }

    private String getTH(ColumnInfo columnInfo, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder("  <th");
        if (string3 != null) {
            stringBuilder.append(" align='");
            stringBuilder.append(string3);
            stringBuilder.append("'");
        }
        if (string2 != null) {
            stringBuilder.append(" title='");
            stringBuilder.append(string2);
            stringBuilder.append("'");
        }
        if (columnInfo != null) {
            if (columnInfo.getColumnName().equals(string)) {
                stringBuilder.append(" class='sortedByColumn'>");
                stringBuilder.append(string);
            } else {
                stringBuilder.append(" class='notSortedByColumn'>");
                stringBuilder.append("<a href='");
                stringBuilder.append(columnInfo.getLocation(string));
                stringBuilder.append("#columns'><span class='notSortedByColumn'>");
                stringBuilder.append(string);
                stringBuilder.append("</span></a>");
            }
        } else {
            stringBuilder.append('>');
            stringBuilder.append(string);
        }
        stringBuilder.append("</th>");
        return stringBuilder.toString();
    }

    @Override
    protected void writeFooter(LineWriter lineWriter) throws IOException {
        lineWriter.writeln("</tbody>");
        lineWriter.writeln("</table>");
        lineWriter.writeln("</div>");
        super.writeFooter(lineWriter);
    }

    @Override
    protected boolean isColumnsPage() {
        return true;
    }

    private class ByParentsComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> byColumn;

        private ByParentsComparator() {
            this.byColumn = new ByColumnComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            TreeSet<CallSite> treeSet = new TreeSet<CallSite>();
            TreeSet<CallSite> treeSet2 = new TreeSet<CallSite>();
            for (TableColumn tableColumn3 : tableColumn.getParents()) {
                if (tableColumn3.getChildConstraint(tableColumn).isImplied()) continue;
                treeSet.add((CallSite)((Object)(tableColumn3.getTable().getName() + "." + tableColumn3.getTable().getSchema())));
            }
            for (TableColumn tableColumn3 : tableColumn2.getParents()) {
                if (tableColumn3.getChildConstraint(tableColumn2).isImplied()) continue;
                treeSet2.add((CallSite)((Object)(tableColumn3.getTable().getName() + "." + tableColumn3.getTable().getSchema())));
            }
            int n = ((Object)treeSet).toString().compareToIgnoreCase(((Object)treeSet2).toString());
            if (n == 0) {
                n = this.byColumn.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    private class ByChildrenComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> byColumn;

        private ByChildrenComparator() {
            this.byColumn = new ByColumnComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            TreeSet<String> treeSet = new TreeSet<String>();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            for (TableColumn tableColumn3 : tableColumn.getChildren()) {
                if (tableColumn3.getParentConstraint(tableColumn).isImplied()) continue;
                treeSet.add(tableColumn3.getTable().getName());
            }
            for (TableColumn tableColumn3 : tableColumn2.getChildren()) {
                if (tableColumn3.getParentConstraint(tableColumn2).isImplied()) continue;
                treeSet2.add(tableColumn3.getTable().getName());
            }
            int n = ((Object)treeSet).toString().compareToIgnoreCase(((Object)treeSet2).toString());
            if (n == 0) {
                n = this.byColumn.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    private class ByDefaultValueComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> byNullable;

        private ByDefaultValueComparator() {
            this.byNullable = new ByNullableComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            String string;
            String string2 = String.valueOf(tableColumn.getDefaultValue());
            int n = string2.compareToIgnoreCase(string = String.valueOf(tableColumn2.getDefaultValue()));
            if (n == 0) {
                n = this.byNullable.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    private class ByAutoUpdateComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> byColumn;

        private ByAutoUpdateComparator() {
            this.byColumn = new ByColumnComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n;
            int n2 = tableColumn.isAutoUpdated() == tableColumn2.isAutoUpdated() ? 0 : (n = tableColumn.isAutoUpdated() ? -1 : 1);
            if (n == 0) {
                n = this.byColumn.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    private class ByNullableComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> byColumn;

        private ByNullableComparator() {
            this.byColumn = new ByColumnComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n;
            int n2 = tableColumn.isNullable() == tableColumn2.isNullable() ? 0 : (n = tableColumn.isNullable() ? -1 : 1);
            if (n == 0) {
                n = this.byColumn.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    private class BySizeComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> byColumn;

        private BySizeComparator() {
            this.byColumn = new ByColumnComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n = tableColumn.getLength() - tableColumn2.getLength();
            if (n == 0 && (n = tableColumn.getDecimalDigits() - tableColumn2.getDecimalDigits()) == 0) {
                n = this.byColumn.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    private class ByCommentsComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> byType;

        private ByCommentsComparator() {
            this.byType = new ByTypeComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n;
            String string;
            String string2 = tableColumn.getComments();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = tableColumn.getComments()) == null) {
                string = "";
            }
            if ((n = string2.compareToIgnoreCase(string)) == 0) {
                n = this.byType.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    private class ByTypeComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> bySize;

        private ByTypeComparator() {
            this.bySize = new BySizeComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n = tableColumn.getTypeName().compareToIgnoreCase(tableColumn2.getTypeName());
            if (n == 0) {
                n = this.bySize.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    private class ByTableComparator
    implements Comparator<TableColumn> {
        private ByTableComparator() {
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n = tableColumn.getTable().compareTo(tableColumn2.getTable());
            if (n == 0) {
                n = tableColumn.getName().compareToIgnoreCase(tableColumn2.getName());
            }
            return n;
        }
    }

    private class ByColumnComparator
    implements Comparator<TableColumn> {
        private ByColumnComparator() {
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n = tableColumn.getName().compareToIgnoreCase(tableColumn2.getName());
            if (n == 0) {
                n = tableColumn.getTable().compareTo(tableColumn2.getTable());
            }
            return n;
        }
    }

    public class ColumnInfo {
        private final String columnName;
        private final Comparator<TableColumn> comparator;

        private ColumnInfo(String string, Comparator<TableColumn> comparator) {
            this.columnName = string;
            this.comparator = comparator;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getLocation() {
            return this.getLocation(this.columnName);
        }

        public String getLocation(String string) {
            return "columns.by" + string + ".html";
        }

        private Comparator<TableColumn> getComparator() {
            return this.comparator;
        }

        public String toString() {
            return this.getLocation();
        }
    }
}

