/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.web.struts.action;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.framework.krms.KrmsRulesExecutionService;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.controller.KcTransactionalDocumentActionBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.subaward.SubAwardForm;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAttachmentFormBean;
import org.kuali.kra.subaward.bo.SubAwardComment;
import org.kuali.kra.subaward.bo.SubAwardTemplateInfo;
import org.kuali.kra.subaward.customdata.SubAwardCustomData;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.notification.SubAwardNotification;
import org.kuali.kra.subaward.notification.SubAwardNotificationContext;
import org.kuali.kra.subaward.reporting.printing.service.SubAwardPrintingService;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.kra.subaward.subawardrule.SubAwardDocumentRule;
import org.kuali.kra.subaward.templateAttachments.SubAwardTemplateAttachmentFormBean;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class SubAwardAction
extends KcTransactionalDocumentActionBase {
    public static final String DISABLE_ATTACHMENT_REMOVAL = "disableAttachmentRemoval";
    private transient SubAwardService subAwardService;
    private static final String DOCUMENT_ROUTE_QUESTION = "DocRoute";
    private static final String FDP_PTE_INVOICE_EMAIL = "FDP_PTE_Invoice_email";
    private static final String FDP_PTE_INVOICE_ADDRESS = "FDP_PTE_Invoice_address";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        if (subAwardForm.getSubAward() != null) {
            this.getSubAwardService().calculateAmountInfo(subAwardForm.getSubAward());
        }
        ActionForward actionForward = super.execute(mapping, form, request, response);
        if (GlobalVariables.getAuditErrorMap().isEmpty()) {
            this.getAuditHelper().auditConditionally((SubAwardForm)form);
        }
        if (subAwardForm.isAuditActivated()) {
            subAwardForm.setUnitRulesMessages(this.getUnitRulesMessages(subAwardForm.getSubAwardDocument()));
        }
        return actionForward;
    }

    protected List<String> getUnitRulesMessages(SubAwardDocument subAwardDocument) {
        return this.getKrmsRulesExecutionService().processUnitValidations(subAwardDocument.getSubAward().getRequisitionerUnit(), subAwardDocument);
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        ActionForward forward = this.handleDocument(mapping, form, request, response, subAwardForm);
        SubAwardDocument subAwardDocument = (SubAwardDocument)subAwardForm.getDocument();
        subAwardForm.initializeFormOrDocumentBasedOnCommand();
        SubAward subAward = this.getSubAwardService().calculateAmountInfo(subAwardDocument.getSubAward());
        subAwardForm.getSubAwardDocument().setSubAward(subAward);
        return forward;
    }

    ActionForward handleDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, SubAwardForm subAwardForm) throws Exception {
        ActionForward forward = null;
        String command = subAwardForm.getCommand();
        if ("displayActionListInlineView".equals(command)) {
            this.loadDocumentInForm(request, subAwardForm);
        } else if ("subAwardActions".equals(command)) {
            this.loadDocumentInForm(request, subAwardForm);
            forward = this.subAwardActions(mapping, (ActionForm)subAwardForm, request, response);
        } else if ("financial".equals(command)) {
            this.loadDocumentInForm(request, subAwardForm);
            forward = mapping.findForward("financial");
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        return forward;
    }

    protected void loadDocumentInForm(HttpServletRequest request, SubAwardForm subAwardForm) throws WorkflowException {
        String docIdRequestParameter = request.getParameter("docId");
        SubAwardDocument retrievedDocument = (SubAwardDocument)KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
        subAwardForm.setDocument((Document)retrievedDocument);
        request.setAttribute("docId", (Object)docIdRequestParameter);
    }

    public String buildForwardStringForActionListCommand(String forwardPath, String docIdRequestParameter) {
        StringBuilder sb = new StringBuilder();
        sb.append(forwardPath);
        sb.append("?");
        sb.append("docId");
        sb.append("=");
        sb.append(docIdRequestParameter);
        return sb.toString();
    }

    protected void loadDocument(KualiDocumentFormBase kualiForm) throws WorkflowException {
        super.loadDocument(kualiForm);
        ((SubAwardForm)kualiForm).getSubAwardDocument().getSubAward();
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAward subAward = this.initialSubawardChecksAndSave((KualiDocumentFormBase)((SubAwardForm)form));
        if (this.executeSaveRules(subAward)) {
            ActionForward forward = super.save(mapping, form, request, response);
            if (subAward.getSubAwardId() == null) {
                this.getSubAwardService().updateSubAwardSequenceStatus(subAward, VersionStatus.PENDING);
            }
            return forward;
        }
        return mapping.findForward("basic");
    }

    @Override
    protected void initialDocumentSave(KualiDocumentFormBase form) throws Exception {
        this.initialSubawardChecksAndSave(form);
    }

    private SubAward initialSubawardChecksAndSave(KualiDocumentFormBase form) {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = (SubAwardDocument)subAwardForm.getDocument();
        String userId = GlobalVariables.getUserSession().getPrincipalName();
        SubAward subAward = subAwardDocument.getSubAward();
        this.checkSubAwardCode(subAward);
        this.checkSubAwardTemplateCode(subAward);
        if (subAward.getSubAwardId() == null) {
            this.getVersionHistoryService().updateVersionHistory(subAward, VersionStatus.PENDING, userId);
        }
        return subAward;
    }

    protected boolean executeSaveRules(SubAward subAward) {
        return new SubAwardDocumentRule().processAddSubAwardBusinessRules(subAward);
    }

    public ActionForward subAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("subAward");
    }

    public ActionForward fundingSource(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("fundingSource");
    }

    public ActionForward financial(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("financial");
    }

    public ActionForward templateInformation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setDisableRemovalAttachmentIndicator(((SubAwardForm)form).getSubAwardTemplateAttachmentFormBean());
        String hierarchyName = this.getParameterService().getParameterValueAsString("KC-PD", "Document", "COIHierarchyName");
        if (((SubAwardForm)form).getSubAward().getSubAwardTemplateInfo().isEmpty()) {
            ((SubAwardForm)form).getSubAward().getSubAwardTemplateInfo().add(new SubAwardTemplateInfo());
        }
        String fdpPteInvoiceEmail = this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_PTE_INVOICE_EMAIL);
        String fdpPteInvoiceAddress = this.getParameterService().getParameterValueAsString("KC-SUBAWARD", "Document", FDP_PTE_INVOICE_ADDRESS);
        ((SubAwardForm)form).getSubAward().getSubAwardTemplateInfo().forEach(info -> {
            if (info.getFcio() == null && ((SubAwardForm)form).getSubAward().getSubAwardFundingSourceList().stream().filter(source -> source.getAward() != null).filter(source -> source.getAward().getPrimeSponsor() != null).map(source -> source.getAward().getPrimeSponsorCode()).distinct().anyMatch(sponsorCode -> this.getSponsorHierarchyService().isSponsorInHierarchy(sponsorCode, hierarchyName))) {
                info.setFcio(true);
            }
            if (StringUtils.isNotBlank((CharSequence)fdpPteInvoiceEmail)) {
                if (info.getInvoiceEmailDifferent() == null) {
                    info.setInvoiceEmailDifferent(true);
                }
                if (info.getInvoicesEmailed() == null) {
                    info.setInvoicesEmailed(true);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)fdpPteInvoiceAddress) && info.getInvoiceAddressDifferent() == null) {
                info.setInvoiceAddressDifferent(true);
            }
        });
        return mapping.findForward("templateInformation");
    }

    protected void setDisableRemovalAttachmentIndicator(SubAwardTemplateAttachmentFormBean subAwardAttachmentForm) {
        if (subAwardAttachmentForm != null) {
            subAwardAttachmentForm.setDisableAttachmentRemovalIndicator(this.getParameterService().getParameterValueAsBoolean("KC-GEN", "Document", DISABLE_ATTACHMENT_REMOVAL));
        }
    }

    public ActionForward amountReleased(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("amountReleased");
    }

    public ActionForward contacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("contacts");
    }

    public ActionForward closeouts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("closeout");
    }

    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        subAwardForm.getCustomDataHelper().prepareCustomData();
        return mapping.findForward("customData");
    }

    public ActionForward subAwardActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("subAwardActions");
    }

    protected void checkSubAwardCode(SubAward subAward) {
        if (subAward.getSubAwardCode() == null) {
            String subAwardCode = this.getSubAwardService().getNextSubAwardCode();
            subAward.setSubAwardCode(subAwardCode);
        }
        for (SubAwardComment subAwardComment : subAward.getSubAwardComments()) {
            subAwardComment.setSubAward(subAward);
        }
        for (SubAwardCustomData customData : subAward.getSubAwardCustomDataList()) {
            customData.setSubAward(subAward);
        }
    }

    protected void checkSubAwardTemplateCode(SubAward subAward) {
        for (SubAwardTemplateInfo subAwardTemplateInfo : subAward.getSubAwardTemplateInfo()) {
            if (subAward.getSubAwardCode() == null || subAwardTemplateInfo.getSubAwardCode() != null) continue;
            String subAwardCode = subAward.getSubAwardCode();
            Integer subAwardSequenceNumber = subAward.getSequenceNumber();
            subAwardTemplateInfo.setSubAwardCode(subAwardCode);
            subAwardTemplateInfo.setSequenceNumber(subAwardSequenceNumber);
        }
    }

    @Override
    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        subAwardForm.setAuditActivated(false);
        AuditHelper.ValidationState status = this.getAuditHelper().isValidSubmission(subAwardForm, true);
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        if (status == AuditHelper.ValidationState.OK) {
            this.sendNotification(mapping, subAwardForm, "501", "Submit SubAward");
            return super.route(mapping, form, request, response);
        }
        if (status == AuditHelper.ValidationState.WARNING) {
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, DOCUMENT_ROUTE_QUESTION, "Validation Warning Exists. Are you sure want to submit to workflow routing.", "confirmationQuestion", methodToCall, "");
            }
            if (DOCUMENT_ROUTE_QUESTION.equals(question) && "0".equals(buttonClicked)) {
                this.sendNotification(mapping, subAwardForm, "501", "Submit SubAward");
                return super.route(mapping, form, request, response);
            }
            return mapping.findForward("basic");
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
        subAwardForm.setAuditActivated(true);
        return mapping.findForward("basic");
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        subAwardForm.setAuditActivated(false);
        AuditHelper.ValidationState status = this.getAuditHelper().isValidSubmission(subAwardForm, true);
        if (status == AuditHelper.ValidationState.OK || status == AuditHelper.ValidationState.WARNING) {
            this.sendNotification(mapping, subAwardForm, "501", "Submit SubAward");
            return super.blanketApprove(mapping, form, request, response);
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
        subAwardForm.setAuditActivated(true);
        return mapping.findForward("basic");
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        ActionForward forward = mapping.findForward("basic");
        AuditHelper.ValidationState status = this.getAuditHelper().isValidSubmission(subAwardForm, true);
        if (status == AuditHelper.ValidationState.OK || status == AuditHelper.ValidationState.WARNING) {
            return super.approve(mapping, form, request, response);
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
        return forward;
    }

    public ActionForward medusa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        if (subAwardForm.getDocument().getDocumentNumber() == null) {
            this.loadDocumentInForm(request, subAwardForm);
        }
        subAwardForm.getMedusaBean().setMedusaViewRadio("0");
        subAwardForm.getMedusaBean().setModuleName("subaward");
        subAwardForm.getMedusaBean().setModuleIdentifier(subAwardForm.getSubAwardDocument().getSubAward().getSubAwardId());
        subAwardForm.getMedusaBean().generateParentNodes();
        return mapping.findForward("medusa");
    }

    public ActionForward notesAndAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        subAwardForm.getSubAwardCommentBean().setSubAwardCommentScreenDisplayTypesOnForm();
        this.setDisableAttachmentRemovalIndicator(((SubAwardForm)form).getSubAwardAttachmentFormBean());
        return mapping.findForward("notesAndAttachments");
    }

    protected void setDisableAttachmentRemovalIndicator(SubAwardAttachmentFormBean subAwardAttachmentForm) {
        if (subAwardAttachmentForm != null) {
            subAwardAttachmentForm.setDisableAttachmentRemovalIndicator(this.getParameterService().getParameterValueAsBoolean("KC-GEN", "Document", DISABLE_ATTACHMENT_REMOVAL));
        }
    }

    protected final boolean applyRules(DocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    public ActionForward sendNotification(ActionMapping mapping, SubAwardForm subAwardForm, String notificationType, String notificationString) {
        SubAward subAward = subAwardForm.getSubAwardDocument().getSubAward();
        SubAwardNotificationContext context = new SubAwardNotificationContext(subAward, notificationType, notificationString, "subAward");
        if (subAwardForm.getNotificationHelper().getPromptUserForNotificationEditor(context)) {
            subAwardForm.getNotificationHelper().initializeDefaultValues(context);
            return mapping.findForward("notificationEditor");
        }
        this.getNotificationService().sendNotificationAndPersist(context, new SubAwardNotification(), subAward);
        return mapping.findForward("basic");
    }

    public ActionForward printForms(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        this.streamToResponse(this.getSubAwardPrintingService().printSubAwardFDPReport(subAwardForm.getSubAwardPrintAgreement(), subAwardForm.getSubAwardDocument().getSubAward()), response);
        return mapping.findForward("basic");
    }

    public ActionForward printCostReimbursementNew(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        try {
            this.streamToResponse(this.getSubAwardPrintingService().printFDPCostReimbursementNew(subAwardForm.getSubAwardPrintAgreement(), subAwardForm.getSubAwardDocument().getSubAward()), response);
            return mapping.findForward("basic");
        }
        catch (Exception e) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("print", "error.printing.service", new String[]{e.getMessage()});
            return mapping.findForward("basic");
        }
    }

    protected KrmsRulesExecutionService getKrmsRulesExecutionService() {
        return KcServiceLocator.getService(KrmsRulesExecutionService.class);
    }

    protected KcNotificationService getNotificationService() {
        return KcServiceLocator.getService(KcNotificationService.class);
    }

    protected SponsorHierarchyService getSponsorHierarchyService() {
        return KcServiceLocator.getService(SponsorHierarchyService.class);
    }

    protected SubAwardPrintingService getSubAwardPrintingService() {
        return KcServiceLocator.getService(SubAwardPrintingService.class);
    }

    protected AuditHelper getAuditHelper() {
        return KcServiceLocator.getService(AuditHelper.class);
    }

    protected VersionHistoryService getVersionHistoryService() {
        return KcServiceLocator.getService(VersionHistoryService.class);
    }

    public SubAwardService getSubAwardService() {
        if (this.subAwardService == null) {
            this.subAwardService = KcServiceLocator.getService(SubAwardService.class);
        }
        return this.subAwardService;
    }

    public void setSubAwardService(SubAwardService subAwardService) {
        this.subAwardService = subAwardService;
    }
}

