/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.signature;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.lookup.KcKualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="personSignatureLookupableHelperService")
@Scope(value="prototype")
public class PersonSignatureLookupableHelperServiceImpl
extends KcKualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = 749587517623905557L;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals("person.userName")) continue;
                field.setFieldConversions("principalName:person.userName,principalId:personId");
            }
        }
        return rows;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        KcPerson person;
        String userName = (String)lookupForm.getFieldsForLookup().get("person.userName");
        if (StringUtils.isNotEmpty((CharSequence)userName) && (person = this.getKcPersonService().getKcPersonByUserName(userName)) != null) {
            lookupForm.getFieldsForLookup().put("personId", person.getPersonId());
        }
        return super.performLookup(lookupForm, resultTable, bounded);
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

