/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidDataPatternConstraint;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

@BeanTag(name="integerPatternConstraint", parent="IntegerPatternConstraint")
public class IntegerPatternConstraint
extends ValidDataPatternConstraint {
    protected boolean allowNegative;
    protected boolean onlyNegative;
    protected boolean omitZero;

    @Override
    protected String getRegexString() {
        StringBuffer regex = new StringBuffer();
        if (this.isAllowNegative() && !this.onlyNegative) {
            regex.append("((-?");
        } else if (this.onlyNegative) {
            regex.append("((-");
        } else {
            regex.append("((");
        }
        if (this.omitZero) {
            regex.append("[1-9][0-9]*))");
        } else {
            regex.append("[1-9][0-9]*)|[0]*)");
        }
        return regex.toString();
    }

    @BeanTagAttribute(name="allowNegative")
    public boolean isAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
    }

    @BeanTagAttribute(name="onlyNegative")
    public boolean isOnlyNegative() {
        return this.onlyNegative;
    }

    public void setOnlyNegative(boolean onlyNegative) {
        this.onlyNegative = onlyNegative;
    }

    @BeanTagAttribute(name="omitZero")
    public boolean isOmitZero() {
        return this.omitZero;
    }

    public void setOmitZero(boolean omitZero) {
        this.omitZero = omitZero;
    }

    @Override
    public List<String> getValidationMessageParams() {
        if (this.validationMessageParams == null) {
            this.validationMessageParams = new ArrayList();
            MessageService messageService = KRADServiceLocatorWeb.getMessageService();
            if (this.allowNegative && !this.onlyNegative) {
                if (this.omitZero) {
                    this.validationMessageParams.add(messageService.getMessageText("validation.positiveOrNegative"));
                } else {
                    this.validationMessageParams.add(messageService.getMessageText("validation.positiveOrNegativeOrZero"));
                }
            } else if (this.onlyNegative) {
                if (this.omitZero) {
                    this.validationMessageParams.add(messageService.getMessageText("validation.negative"));
                } else {
                    this.validationMessageParams.add(messageService.getMessageText("validation.negativeOrZero"));
                }
            } else if (this.omitZero) {
                this.validationMessageParams.add(messageService.getMessageText("validation.positive"));
            } else {
                this.validationMessageParams.add(messageService.getMessageText("validation.positiveOrZero"));
            }
        }
        return this.validationMessageParams;
    }
}

