/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.RsQueryObject;
import org.apache.ojb.broker.accesslayer.SqlBasedRsIterator;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.JdbcTypesHelper;

public class SqlBasedReportQueryRsIterator
extends SqlBasedRsIterator {
    private ResultSetMetaData rsMetaData;
    private int columnCount;

    public SqlBasedReportQueryRsIterator(RsQueryObject rsQueryObject, PersistenceBrokerImpl persistenceBrokerImpl) throws PersistenceBrokerException {
        super(rsQueryObject, persistenceBrokerImpl);
        try {
            this.rsMetaData = this.getRsAndStmt().m_rs.getMetaData();
            this.columnCount = this.rsMetaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            throw new PersistenceBrokerException(sQLException);
        }
    }

    @Override
    protected Object getObjectFromResultSet() throws PersistenceBrokerException {
        Object[] objectArray = new Object[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            try {
                Object object;
                int n = this.rsMetaData.getColumnType(i + 1);
                objectArray[i] = object = JdbcTypesHelper.getObjectFromColumn(this.getRsAndStmt().m_rs, new Integer(n), i + 1);
                continue;
            }
            catch (SQLException sQLException) {
                throw new PersistenceBrokerException(sQLException);
            }
        }
        return objectArray;
    }
}

