/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.transaction.tm;

import javax.transaction.TransactionManager;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.core.NamingLocator;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactory;
import org.apache.ojb.broker.transaction.tm.TransactionManagerFactoryException;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class AbstractTransactionManagerFactory
implements TransactionManagerFactory {
    private static Logger log = LoggerFactory.getLogger(AbstractTransactionManagerFactory.class);
    public static String TM_DEFAULT_METHOD_NAME = "getTransactionManager";
    private static TransactionManager tm = null;

    public abstract String[][] getLookupInfo();

    @Override
    public synchronized TransactionManager getTransactionManager() throws TransactionManagerFactoryException {
        if (tm == null) {
            StringBuffer stringBuffer = new StringBuffer();
            String[][] stringArray = this.getLookupInfo();
            String string = SystemUtils.LINE_SEPARATOR;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i][0];
                String string3 = stringArray[i][1];
                String string4 = stringArray[i][2];
                try {
                    tm = string4 == null ? this.jndiLookup(string2, string3) : this.instantiateClass(string2, string4, string3);
                    stringBuffer.append("Successfully requested TM for " + string2 + string);
                }
                catch (Exception exception) {
                    if (string4 == null) {
                        stringBuffer.append("Error on TM request for " + string2 + ", using jndi-lookup '" + string3 + "'" + string + exception.getMessage() + string);
                    }
                    stringBuffer.append("Error on TM request for " + string2 + ", using method '" + string3 + "' for class '" + string4 + "'" + string + exception.getMessage() + string);
                }
                if (tm != null) break;
            }
            if (tm == null) {
                throw new TransactionManagerFactoryException("Can't lookup transaction manager:" + string + stringBuffer);
            }
        }
        return tm;
    }

    protected TransactionManager jndiLookup(String string, String string2) {
        log.info(string + ", lookup TransactionManager: '" + string2 + "'");
        return (TransactionManager)NamingLocator.lookup(string2);
    }

    protected TransactionManager instantiateClass(String string, String string2, String string3) throws Exception {
        log.info(string + ", invoke method '" + string3 + "()' on class " + string2);
        Class clazz = ClassHelper.getClass(string2);
        return (TransactionManager)clazz.getMethod(string3, null).invoke(null, null);
    }
}

