/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.util;

import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krms.impl.provider.repository.RepositoryToEngineTranslator;
import org.kuali.rice.krms.impl.ui.CustomOperatorUiTranslator;

public class KrmsServiceLocatorInternal {
    public static final String REPOSITORY_TO_ENGINE_TRANSLATOR = "repositoryToEngineTranslator";
    public static final String CUSTOM_OPERATOR_UI_TRANSLATOR = "rice.krms.customOperatorUiTranslator";
    public static final String KRMS_RUN_MODE_PROPERTY = "krms.mode";
    public static final String KRMS_MODULE_NAMESPACE = "KRMS";
    private static final Logger LOG = LogManager.getLogger(KrmsServiceLocatorInternal.class);

    public static <A> A getService(String serviceName) {
        return KrmsServiceLocatorInternal.getBean(serviceName, false);
    }

    public static <A> A getBean(String serviceName, boolean forceLocal) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching service " + serviceName);
        }
        QName name = new QName(serviceName);
        RunMode krmsRunMode = RunMode.valueOf((String)ConfigContext.getCurrentContextConfig().getProperty(KRMS_RUN_MODE_PROPERTY));
        if (!(forceLocal || krmsRunMode != RunMode.REMOTE && krmsRunMode != RunMode.THIN)) {
            name = new QName(KRMS_MODULE_NAMESPACE, serviceName);
        }
        return (A)GlobalResourceLoader.getResourceLoader().getService(name);
    }

    public static RepositoryToEngineTranslator getRepositoryToEngineTranslator() {
        return (RepositoryToEngineTranslator)KrmsServiceLocatorInternal.getBean(REPOSITORY_TO_ENGINE_TRANSLATOR, true);
    }

    public static CustomOperatorUiTranslator getCustomOperatorUiTranslator() {
        return (CustomOperatorUiTranslator)KrmsServiceLocatorInternal.getBean(CUSTOM_OPERATOR_UI_TRANSLATOR, true);
    }
}

