/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.util.Arrays;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.ContextClassLoaderProxy;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.messaging.bam.BAMServerProxy;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.remoting.support.RemoteInvocationTraceInterceptor;

public class KSBHttpInvokerServiceExporter
extends HttpInvokerServiceExporter {
    private List<Class<?>> serviceInterfaces;
    private ServiceDefinition serviceDefinition;
    private boolean registerTraceInterceptor = true;

    public ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public void setServiceDefinition(ServiceDefinition serviceDefinition) {
        this.serviceDefinition = serviceDefinition;
    }

    public void setRegisterTraceInterceptor(boolean registerTraceInterceptor) {
        this.registerTraceInterceptor = registerTraceInterceptor;
        super.setRegisterTraceInterceptor(registerTraceInterceptor);
    }

    protected Object getProxyForService() {
        ClassLoader classLoader;
        this.checkService();
        this.checkServiceInterface();
        ProxyFactory proxyFactory = new ProxyFactory();
        for (Class<?> serviceInterface : this.getServiceInterfaces()) {
            proxyFactory.addInterface(serviceInterface);
        }
        if (this.registerTraceInterceptor) {
            proxyFactory.addAdvice((Advice)new RemoteInvocationTraceInterceptor(this.getExporterName()));
        }
        if ((classLoader = this.serviceDefinition.getServiceClassLoader()) == null) {
            classLoader = ClassLoaderUtils.getDefaultClassLoader();
        }
        Object service = ContextClassLoaderProxy.wrap((Object)this.getService(), (ClassLoader)classLoader);
        service = BAMServerProxy.wrap(service, this.getServiceDefinition());
        proxyFactory.setTarget(service);
        return proxyFactory.getProxy(classLoader);
    }

    protected void checkServiceInterface() throws IllegalArgumentException {
        if (this.serviceInterfaces == null) {
            this.serviceInterfaces = Arrays.asList(ContextClassLoaderProxy.getInterfacesToProxy((Object)this.getService()));
        }
        if (this.getServiceInterfaces().isEmpty()) {
            throw new IllegalArgumentException("At least one service interface should be defined.");
        }
    }

    public List<Class<?>> getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    public void setServiceInterfaces(List<Class<?>> serviceInterfaces) {
        this.serviceInterfaces = serviceInterfaces;
    }

    public Object getService() {
        return super.getService();
    }
}

