/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.reflect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.rice.core.api.reflect.DataDefinition;
import org.kuali.rice.core.api.reflect.PropertyDefinition;

public class ObjectDefinition
implements Serializable {
    private static final long serialVersionUID = 835423601196288352L;
    private String className;
    private String applicationId;
    private boolean atRemotingLayer;
    private final List<DataDefinition> constructorParameters = new ArrayList<DataDefinition>();
    private final Map<String, PropertyDefinition> properties = new HashMap<String, PropertyDefinition>();

    public ObjectDefinition(Class<?> objectClass) {
        this(objectClass.getName());
    }

    public ObjectDefinition(String className, String applicationId) {
        this.className = className;
        this.applicationId = applicationId;
    }

    public ObjectDefinition(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Extension class name cannot be null");
        }
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void addConstructorParameter(DataDefinition parameter) {
        this.constructorParameters.add(parameter);
    }

    public void removeConstructorParameter(DataDefinition parameter) {
        this.constructorParameters.remove(parameter);
    }

    public void setConstructorParameters(List<DataDefinition> parameters) {
        this.constructorParameters.clear();
        this.constructorParameters.addAll(parameters);
    }

    public List<DataDefinition> getConstructorParameters() {
        return this.constructorParameters;
    }

    public void addProperty(PropertyDefinition property) {
        if (property == null) {
            return;
        }
        if (property.getName() == null) {
            throw new IllegalArgumentException("PropertyDefinition cannot have a null name.");
        }
        this.properties.put(property.getName(), property);
    }

    public PropertyDefinition getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<PropertyDefinition> getProperties() {
        return this.properties.values();
    }

    public void setProperties(Collection<PropertyDefinition> properties) {
        this.properties.clear();
        if (properties == null) {
            return;
        }
        for (PropertyDefinition prop : properties) {
            this.addProperty(prop);
        }
    }

    public String toString() {
        return "[ObjectDefinition: className: " + this.getClassName() + ", applicationId: " + this.getApplicationId() + "]";
    }

    public boolean isAtRemotingLayer() {
        return this.atRemotingLayer;
    }

    public void setAtRemotingLayer(boolean atRemotingLayer) {
        this.atRemotingLayer = atRemotingLayer;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }
}

