<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:PHSHumanSubjectsAndClinicalTrialsInfo_2_0="http://apply.grants.gov/forms/PHSHumanSubjectsAndClinicalTrialsInfo_2_0-V2.0" 
	xmlns:HumanSubjectStudy_2_0="http://apply.grants.gov/forms/HumanSubjectStudy_2_0-V2.0"
	xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0"
	xmlns:glob="http://apply.grants.gov/system/Global-V1.0" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0"
	xmlns:header="http://apply.grants.gov/system/Header-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema">
	<xsl:variable name="greyColor">#EEEEEE</xsl:variable>
	<xsl:variable name="totalColor">silver</xsl:variable>
	<xsl:variable name="defCellColor">#FFFFFF</xsl:variable>
	<xsl:variable name="enrollTypePlanned">Planned</xsl:variable>
	<xsl:param name="reportNumber" />
	<xsl:param name="govTrackingNumber" />
	<xsl:param name="opportunityID" />
	<xsl:param name="receivedDateTime" />
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="first"
					page-height="11in" page-width="8.5in" margin-left="0.6in"
					margin-right="0.6in">
					<fo:region-body margin-top="0.5in" margin-bottom="0.3in" />
					<fo:region-before region-name="header" />
					<fo:region-after region-name="footer" extent="0.3in" />
				</fo:simple-page-master>

				<fo:simple-page-master master-name="rest"
					page-height="11in" page-width="8.5in" margin-left="0.6in"
					margin-right="0.6in">
					<fo:region-body margin-top="0.8in" margin-bottom="0.2in" />
					<fo:region-before region-name="header"/>
					<fo:region-after region-name="footer" extent="0.3in" />
				</fo:simple-page-master>

				<fo:page-sequence-master master-name="all-pages">
					<fo:repeatable-page-master-alternatives>
						<fo:conditional-page-master-reference
							master-reference="first" page-position="first" />
						<fo:conditional-page-master-reference
							master-reference="rest" page-position="rest" />
					</fo:repeatable-page-master-alternatives>
				</fo:page-sequence-master>
			</fo:layout-master-set>
			
			
				<fo:page-sequence master-reference="first" format="1">
				
								<fo:static-content flow-name="footer">
					<fo:table width="100%" space-before.optimum="0pt"
						space-after.optimum="0pt" table-layout="fixed">
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-column column-width="proportional-column-width(1)" />
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell hyphenate="true" language="en"
									padding-start="0pt" padding-end="0pt" padding-before="1pt"
									padding-after="1pt"  text-align="left"
									border-style="solid" border-width="0pt" border-color="white">
									<fo:block>
										<fo:inline font-size="8px">
											Tracking Number:
											<xsl:value-of select="$govTrackingNumber" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell hyphenate="true" language="en"
									line-height="9pt" padding-start="0pt" padding-end="0pt"
									padding-before="1pt" padding-after="1pt" 
									text-align="right" border-style="solid" border-width="0pt"
									border-color="white">
									<fo:block>
										<fo:inline font-size="8px">
											Funding Opportunity Number:
											<xsl:value-of select="$opportunityID" />
										</fo:inline>
										<fo:inline font-size="8px">
											Received Date:
											<xsl:value-of select="$receivedDateTime" />
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>

					 <fo:flow flow-name="xsl-region-body">
						<xsl:call-template name="incEnrollmentReport" >
						 <xsl:with-param name="reportCount" select="$reportNumber"/>
						 </xsl:call-template>
					</fo:flow> 
				</fo:page-sequence>
		
		</fo:root>
	</xsl:template>

<xsl:template name="incEnrollmentReport">
		<xsl:param name="reportCount" />
		<fo:block>
			<fo:table width="100%" table-layout="fixed" left="100pt">
				<fo:table-column column-width="2.5in" />				
				<fo:table-column column-width="5.0in" />
				<fo:table-body start-indent="0pt">
					<!-- ====================================== -->
					<!-- Report header -->
					<!-- ====================================== -->
					<fo:table-row>
						<fo:table-cell text-align="left"
							padding-start="2pt" padding-end="0pt" padding-before="11pt" number-columns-spanned="2"
							padding-after="1pt"  border-style="solid"
							border-width="0pt" border-color="white">
							<fo:block font-size="11px" font-weight="bold">
								Inclusion Enrollment Report
								<xsl:value-of select="$reportCount" />
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<!-- Empty line -->
					<fo:table-row>
						<fo:table-cell number-columns-spanned="2">
							<fo:block/>
						</fo:table-cell>
					</fo:table-row>	
					<!-- ============================ -->
					<!-- Title -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<fo:table-cell hyphenate="true" language="en"
							line-height="11pt"
							padding-end="2pt" padding-before="2pt" padding-after="2pt" 
							 text-align="start" border-style="solid"
							border-width="1pt" border-color="white">
							<fo:block>
								<fo:inline font-size="9px">1. Inclusion Enrollment Report Title* :
								</fo:inline>
							</fo:block>
						</fo:table-cell>				
						<fo:table-cell hyphenate="true" language="en"
							line-height="11pt"
							padding-end="2pt" padding-before="2pt" padding-left="12pt" padding-after="2pt"
							 text-align="start" border-style="solid"
							border-width="1pt" border-color="white">
							<fo:block>
								<fo:inline font-size="9px"> 
									<xsl:value-of select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:InclusionEnrollmentReportTitle" />
								</fo:inline>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>		
			<fo:table width="100%" table-layout="fixed" left="100pt">
				<fo:table-column column-width="35%" />				
				<fo:table-column column-width="45%" />
				<fo:table-body start-indent="0pt">
					<!-- ====================================== -->
					<!-- Using an Existing Dataset or Resource -->
					<!-- ====================================== -->
					<fo:table-row>
						<xsl:call-template name="label">					
							<xsl:with-param name="label_text">
								2. Using an Existing Dataset or Resource* :
							</xsl:with-param>
						</xsl:call-template>

						<xsl:call-template name="radio-field">
							<xsl:with-param name="xml_field" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:ExistingDatasetOrResource"/>
							<xsl:with-param name="yes_text" select="'Yes'"/>
							<xsl:with-param name="no_text" select="'No'"/>
						</xsl:call-template>
					</fo:table-row>
					
					<fo:table-row>
						<xsl:call-template name="label">					
							<xsl:with-param name="label_text">
								3. Enrollment Location Type* :
							</xsl:with-param>
							<xsl:with-param name="padding-start" select="6"/>
						</xsl:call-template>
					 
	                    <xsl:choose>
	                     	<xsl:when test="normalize-space(HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:EnrollmentLocationType) = 'Domestic'">
							<xsl:call-template name="radio-field">
								<xsl:with-param name="yes_text" select="'Domestic'"/>
								<xsl:with-param name="no_text" select="'Foreign'"/>							
								<xsl:with-param name="xml_field" select="'Y: Yes'"/>
								<xsl:with-param name="padding-start" select="6"/>
							</xsl:call-template>                     		
	                     	</xsl:when>
	                     	<xsl:when test="normalize-space(HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:EnrollmentLocationType) = 'Foreign'">
							<xsl:call-template name="radio-field">
								<xsl:with-param name="yes_text" select="'Domestic'"/>
								<xsl:with-param name="no_text" select="'Foreign'"/>							
								<xsl:with-param name="xml_field" select="'N: No'"/>
								<xsl:with-param name="padding-start" select="6"/>							
							</xsl:call-template>                     		
	                     	</xsl:when>
	                     	<xsl:otherwise>
							<xsl:call-template name="radio-field">
								<xsl:with-param name="yes_text" select="'Domestic'"/>
								<xsl:with-param name="no_text" select="'Foreign'"/>							
								<xsl:with-param name="xml_field" select="''"/>
								<xsl:with-param name="padding-start" select="6"/>							
							</xsl:call-template>                       	
	                     	</xsl:otherwise>
						</xsl:choose>
					</fo:table-row>
				</fo:table-body>
			</fo:table>

			<fo:table font-size="12pt" width="100%"
				space-before.optimum="1pt" space-after.optimum="1pt" table-layout="fixed"
				height="100%">
				<fo:table-column column-width="2.5in" />				
				<fo:table-column column-width="5.0in" />
				<fo:table-body>			

					<!-- ============================ -->
					<!-- Enrollment Countries -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<fo:table-cell hyphenate="true" language="en"
							line-height="11pt" padding-start="1pt"
							padding-end="2pt" padding-before="6pt" padding-after="2pt"
							 text-align="start" border-style="solid"
							border-width="1pt" border-color="white">
							<fo:block>
								<fo:inline font-size="9px">4. Enrollment Country(ies):
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						<fo:table-cell hyphenate="true" language="en"
							line-height="11pt" padding-start="2pt"
							padding-end="2pt" padding-before="8pt" padding-after="2pt"
							 text-align="start" border-style="solid"
							border-width="1pt" border-color="white">
							<fo:block>
								<fo:inline font-family="arialuni" font-size="9px">
				
								<xsl:for-each select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:EnrollmentCountry">
									<xsl:value-of select="."/>
									  <xsl:if test="not(position() = last())">, </xsl:if>
									</xsl:for-each>

								</fo:inline>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<!-- ============================ -->
					<!-- Enrollment Locations -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<fo:table-cell hyphenate="true" language="en"
							line-height="11pt" 	padding-end="2pt" padding-before="2pt" padding-after="2pt"
							 text-align="start" border-style="solid"
							border-width="1pt" border-color="white">
							<fo:block>
								<fo:inline font-size="9px">5. Enrollment Location(s):
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						<xsl:call-template name="table_body_cell_tabs_newline">
							<xsl:with-param name="cell_text" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:EnrollmentLocations" />
						</xsl:call-template>
					</fo:table-row>
					<!-- ============================ -->
					<!-- Comments -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<fo:table-cell hyphenate="true" language="en"
							line-height="11pt" 	padding-end="2pt" padding-before="2pt" padding-after="2pt"
							 text-align="start" border-style="solid"
							border-width="1pt" border-color="white">
							<fo:block>
								<fo:inline font-size="9px">6. Comments:
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						<xsl:call-template name="table_body_cell_tabs_newline">
							<xsl:with-param name="cell_text" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Comments" />
						</xsl:call-template>
					</fo:table-row>
					<!-- Empty line -->
					<fo:table-row>
						<fo:table-cell number-columns-spanned="2">
							<fo:block/>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<!-- Show planned table and  cumulative all the time-->	
			<fo:table font-size="12pt" width="100%"
				space-before.optimum="1pt" space-after.optimum="1pt" table-layout="fixed"
				height="100%" keep-together="always">
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-body>			
					<fo:table-row>
						<fo:table-cell>
							<fo:block>
								<fo:inline font-size="9px" font-weight="bold">
									Planned
								</fo:inline>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<!-- ============================ -->
					<!-- Racial Categories, Ethnic Categories etc. -->
					<fo:table-row height="20px">
					
						<!-- ============================ -->
						<!-- Planned -->
						<!-- Racial Categories -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black">
							<fo:block font-size="9px" font-weight="bold">Racial
								Categories
							</fo:block>
							<fo:block>
								<fo:table width="100%" space-before.optimum="0pt"
									space-after.optimum="0pt" table-layout="fixed">
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell hyphenate="true" language="en"
												number-columns-spanned="1" padding-start="0pt" padding-end="0pt"
												padding-before="1pt" padding-after="0pt" 
												text-align="left" border-style="solid" border-width="0pt"
												border-color="white">
												<fo:block font-size="8pt">
													<fo:leader leader-pattern="space" />
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:block>
						</fo:table-cell>

						<!-- ============================ -->
						<!-- Ethnic Categories -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="11pt" number-columns-spanned="10" padding-start="0pt"
							padding-end="0pt" padding-before="0pt" padding-after="0pt"
							display-align="center" text-align="center"
                            border-top-style="solid" border-top-width="1pt" border-top-color="black" 
                            border-right-style="solid" border-right-width="1pt" border-right-color="black">
							<fo:block>
                            	<fo:table>
                                	<fo:table-column column-width="80%" />
									<fo:table-column column-width="20%" />
                                    	<fo:table-body>
                                        	<fo:table-row>	
                                                <fo:table-cell>
                            						<fo:block font-size="9px" font-weight="bold">Ethnic	Categories</fo:block>
                            					</fo:table-cell>
                                               <fo:table-cell border-left-color="black" border-left-style="solid" border-left-width="1px" background-color="{$totalColor}">
                                               		<fo:block>&#160;</fo:block>
                            				</fo:table-cell>
                                         </fo:table-row>
                                     </fo:table-body>
                               	</fo:table>             
							</fo:block>
							<fo:block>
					
									<fo:table width="100%" space-before.optimum="0pt"
									space-after.optimum="0pt" table-layout="fixed">
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" /> 
									<fo:table-body>
										<fo:table-row>
											<!-- ============================ -->
											<!-- Not Hispanic or Latino -->
											<!-- ============================ -->
											<fo:table-cell hyphenate="true" language="en"
												padding-start="0pt" padding-end="0pt" padding-before="1pt"
												padding-after="0pt" display-align="center" text-align="center"
												border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                border-right-style="solid" border-right-width="1pt" border-right-color="black"		
												number-columns-spanned="4" keep-together="auto"> <fo:block>&#160;</fo:block> 
												<fo:block font-size="9px" font-weight="bold">Not
													Hispanic
													or Latino
												</fo:block>
                                              
												<fo:block>
													<fo:table width="100%" space-before.optimum="0pt"
														space-after.optimum="0pt" table-layout="fixed">
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<!-- <fo:table-column column-width="proportional-column-width(1)" /> -->
														<fo:table-body>
															<fo:table-row>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="0pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
                            				 						border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                                    border-right-style="solid" border-right-width="1pt" border-right-color="black"
                                                                    number-columns-spanned="2">
																	<fo:block font-size="9px" font-weight="bold">Female
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="0pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
                             										border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                                    border-right-style="solid" border-right-width="1pt" border-right-color="black"	
																	number-columns-spanned="2">
																	<fo:block font-size="9px" font-weight="bold">Male
																	</fo:block>
																</fo:table-cell>
																
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:table-cell>
											<!-- ============================ -->
											<!-- Hispanic or Latino -->
											<!-- ============================ -->
											<fo:table-cell hyphenate="true" language="en"
												padding-start="0pt" padding-end="0pt" padding-before="1pt"
												padding-after="0pt" display-align="center" text-align="center"
												border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                border-right-style="solid" border-right-width="1pt" border-right-color="black"	
												number-columns-spanned="4" keep-together="auto"> <fo:block>&#160;</fo:block>
												<fo:block font-size="9px" font-weight="bold">Hispanic
													or
													Latino
												</fo:block>
                                               
												<fo:block>
													<fo:table width="100%" space-before.optimum="0pt"
														space-after.optimum="0pt" table-layout="fixed">
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<!-- <fo:table-column column-width="proportional-column-width(1)" /> -->
														<fo:table-body>
															<fo:table-row>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="0pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
                             										border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                                    border-right-style="solid" border-right-width="1pt" border-right-color="black"	
																	number-columns-spanned="2">
																	<fo:block font-size="9px" font-weight="bold">Female
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="0pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
																	border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                                    border-right-style="solid" border-right-width="0pt" border-right-color="black"	
																	number-columns-spanned="2">
																	<fo:block font-size="9px" font-weight="bold">Male
																	</fo:block>
																</fo:table-cell>
															
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:table-cell>
											
											<!-- ============================ -->
											<!-- Total -->
											<!-- ============================ -->
											<fo:table-cell hyphenate="true" language="en"
												padding-start="0pt" padding-end="0pt" padding-before="1pt"
												padding-after="0pt" display-align="center" text-align="center" 	
												number-columns-spanned="2" background-color="{$totalColor}">
												<fo:block font-size="9px" font-weight="bold">Total
												</fo:block>
												<fo:block>
													<fo:table width="100%" space-before.optimum="0pt"
														space-after.optimum="0pt" table-layout="fixed">
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-body>
															<fo:table-row>
																<fo:table-cell hyphenate="true" language="en"
																	number-columns-spanned="1" padding-start="0pt"
																	padding-end="0pt" padding-before="1pt" padding-after="0pt"
																	 text-align="center"
																	border-style="solid" border-width="0pt" border-color="black">
																	<fo:block font-size="8pt">
																		<fo:leader leader-pattern="space" />
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
					
					<!-- ============================ -->
					<!-- American Indian / Alaska Native..... First row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- American Indian / Alaska Native label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">American Indian/Alaska Native
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:AmericanIndian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:AmericanIndian"/>
						</xsl:call-template>
			
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:AmericanIndian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:AmericanIndian"/>
						</xsl:call-template>
						
				
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="totalByRowPlanned">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned
						/*/*/HumanSubjectStudy_2_0:AmericanIndian"/>
						</xsl:call-template>
						
					</fo:table-row>
					
					<!-- ============================ -->
					<!-- Asian..... Second row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- Asian label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">Asian
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Asian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Asian"/>
						</xsl:call-template>
						
	
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Asian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Asian"/>
						</xsl:call-template>
						
				
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="totalByRowPlanned">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned
						/*/*/HumanSubjectStudy_2_0:Asian"/>
						</xsl:call-template>
					</fo:table-row>
					<!-- ============================ -->
					<!-- Native Hawaiian or Other Pacific Islander..... Third row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- Native Hawaiian or Other Pacific Islander label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">Native Hawaiian or Other
									Pacific
									Islander
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Hawaiian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Hawaiian"/>
						</xsl:call-template>
						
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Hawaiian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Hawaiian"/>
						</xsl:call-template>
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
							<xsl:call-template name="totalByRowPlanned">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned
						/*/*/HumanSubjectStudy_2_0:Hawaiian"/>
						</xsl:call-template>
					</fo:table-row>
					<!-- ============================ -->
					<!-- Black or African American..... Fourth row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- Black or African American label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">Black or African American
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Black"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Black"/>
						</xsl:call-template>
						
						
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Black"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Black"/>
						</xsl:call-template>

						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
								<xsl:call-template name="totalByRowPlanned">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned
						/*/*/HumanSubjectStudy_2_0:Black"/>
						</xsl:call-template>
					</fo:table-row>
					<!-- ============================ -->
					<!-- White..... Fifth row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- White -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">White
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:White"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:White"/>
						</xsl:call-template>
						
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:White"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:White"/>
						</xsl:call-template>

						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="totalByRowPlanned">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned
						/*/*/HumanSubjectStudy_2_0:White"/>
						</xsl:call-template>
					</fo:table-row>
					
					<!-- ============================ -->
					<!-- More than One Race..... Sixth row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- More than One Race label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">More than One Race
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:MultipleRace"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:MultipleRace"/>
						</xsl:call-template>
						
						
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:MultipleRace"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:MultipleRace"/>
						</xsl:call-template>
						
						 
					
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="totalByRowPlanned">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned
						/*/*/HumanSubjectStudy_2_0:MultipleRace"/>
						</xsl:call-template>
					</fo:table-row>
					
				<!-- ============================ -->
					<!-- Total..... Eighth row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- Total label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" background-color="{$totalColor}">
							<fo:block>
								<fo:inline font-size="9px" font-weight="bold">Total
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumnPlanned">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumnPlanned">							
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male"/>
						</xsl:call-template>
						
						
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumnPlanned">							
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female"/>
						</xsl:call-template>
												
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumnPlanned">							
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male"/>
						</xsl:call-template>
						
		
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCellforPlaned">
									<xsl:with-param name="cellColor" select="$totalColor"/>
	
 										<xsl:with-param name="evaluatedCellVal" select="sum(HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Planned/* [not(self::HumanSubjectStudy_2_0:Total)]/* [not(self::HumanSubjectStudy_2_0:Total)]/* [not(self::HumanSubjectStudy_2_0:Total)])" />
						</xsl:call-template>
									
					</fo:table-row>
					<!-- Empty line -->
					<fo:table-row>
						<fo:table-cell>
							<fo:block>
								<fo:leader leader-pattern="space" />
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
				</fo:table-body>
			</fo:table>
			<fo:table font-size="12pt" width="100%"
				space-before.optimum="1pt" space-after.optimum="1pt" table-layout="fixed"
				height="100%" keep-together="always">
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-column column-width="proportional-column-width(1)" />
				<fo:table-body>							
					<fo:table-row>
						<fo:table-cell number-columns-spanned="2" >
							<fo:block>
								<fo:inline font-size="9px" font-weight="bold">
									Cumulative (Actual)
								</fo:inline>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- Cumulative -->
						<!-- Racial Categories -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black">
							<fo:block font-size="9px" font-weight="bold">Racial
								Categories
							</fo:block>
							<fo:block>
						<fo:table width="100%" keep-together.within-page="always" space-before.optimum="0pt"
									space-after.optimum="0pt" table-layout="fixed">
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell hyphenate="true" language="en"
												number-columns-spanned="1" padding-start="0pt" padding-end="0pt"
												padding-before="1pt" padding-after="0pt" 
												text-align="left" border-style="solid" border-width="0pt"
												border-color="white">
												<fo:block font-size="8pt">
													<fo:leader leader-pattern="space" />
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:block>
						</fo:table-cell>

						<!-- ============================ -->
						<!-- Ethnic Categories -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="11pt" number-columns-spanned="10" padding-start="0pt"
							padding-end="0pt" padding-before="0pt" padding-after="0pt"
							display-align="center" text-align="center"
                            border-top-style="solid" border-top-width="1pt" border-top-color="black" 
                            border-right-style="solid" border-right-width="1pt" border-right-color="black" >
							<fo:block>
                            	<fo:table>
                                	<fo:table-column column-width="90%" />
									<fo:table-column column-width="10%" />
                                    	<fo:table-body>
                                        	<fo:table-row>	
                                                <fo:table-cell>
                            						<fo:block font-size="9px" font-weight="bold">Ethnic	Categories</fo:block>
                            					</fo:table-cell>
                                               <fo:table-cell border-left-color="black" border-left-style="solid" border-left-width="1px" background-color="{$totalColor}">
                                               		<fo:block>&#160;</fo:block>
                            				</fo:table-cell>
                                         </fo:table-row>
                                     </fo:table-body>
                               	</fo:table>             
							</fo:block>
							<fo:block>
					
									<fo:table width="100%" space-before.optimum="0pt"
									space-after.optimum="0pt" table-layout="fixed">
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-column column-width="proportional-column-width(1)" />
									<fo:table-body>
										<fo:table-row>
											<!-- ============================ -->
											<!-- Not Hispanic or Latino -->
											<!-- ============================ -->
											<fo:table-cell hyphenate="true" language="en"
												padding-start="0pt" padding-end="0pt" padding-before="1pt"
												padding-after="0pt" display-align="center" text-align="center"
												border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                border-right-style="solid" border-right-width="1pt" border-right-color="black"		
												number-columns-spanned="3"> <fo:block>&#160;</fo:block> 
												<fo:block font-size="9px" font-weight="bold">Not
													Hispanic
													or Latino
												</fo:block>
                                              
												<fo:block>
													<fo:table width="100%" space-before.optimum="0pt"
														space-after.optimum="0pt" table-layout="fixed">
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-body>
															<fo:table-row>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="0pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
                            				 						border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                                    border-right-style="solid" border-right-width="1pt" border-right-color="black"
                                                                    number-columns-spanned="1">
																	<fo:block font-size="9px" font-weight="bold">Female
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="0pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
                             										border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                                    border-right-style="solid" border-right-width="1pt" border-right-color="black"	
																	number-columns-spanned="1">
																	<fo:block font-size="9px" font-weight="bold">Male
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="3pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
                             										border-top-style="solid" border-top-width="1pt" border-top-color="black"	
																	number-columns-spanned="1" keep-together="auto">
																	<fo:block font-size="9px" font-weight="bold">Unknown/Not
																		Reported
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:table-cell>
											<!-- ============================ -->
											<!-- Hispanic or Latino -->
											<!-- ============================ -->
											<fo:table-cell hyphenate="true" language="en"
												padding-start="0pt" padding-end="0pt" padding-before="1pt"
												padding-after="0pt" display-align="center" text-align="center"
												border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                border-right-style="solid" border-right-width="1pt" border-right-color="black"	
												number-columns-spanned="3"> <fo:block>&#160;</fo:block>
												<fo:block font-size="9px" font-weight="bold">Hispanic
													or
													Latino
												</fo:block>
                                               
												<fo:block>
													<fo:table width="100%" space-before.optimum="0pt"
														space-after.optimum="0pt" table-layout="fixed">
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-body>
															<fo:table-row>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="0pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
                             										border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                                    border-right-style="solid" border-right-width="1pt" border-right-color="black"	
																	number-columns-spanned="1">
																	<fo:block font-size="9px" font-weight="bold">Female
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="0pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
																	border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                                    border-right-style="solid" border-right-width="1pt" border-right-color="black"	
																	number-columns-spanned="1">
																	<fo:block font-size="9px" font-weight="bold">Male
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="3pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
																	border-top-style="solid" border-top-width="1pt" border-top-color="black"	
																	number-columns-spanned="1" keep-together="auto">
																	<fo:block font-size="9px" font-weight="bold">Unknown/Not
																		Reported
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:table-cell>
											<!-- ============================ -->
											<!-- Unknown/Not Reported Ethnicity -->
											<!-- ============================ -->
											<fo:table-cell hyphenate="true" language="en"
												padding-start="0pt" padding-end="0pt" padding-before="1pt"
												padding-after="0pt" display-align="center" text-align="center"
                                                border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                border-right-style="solid" border-right-width="1pt" border-right-color="black"	
												number-columns-spanned="3">
												<fo:block font-size="9px" font-weight="bold">Unknown/Not</fo:block>
													<fo:block font-size="9px" font-weight="bold">Reported Ethnicity
												</fo:block>
												<fo:block>
													<fo:table width="100%" space-before.optimum="0pt"
														space-after.optimum="0pt" table-layout="fixed">
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-body>
															<fo:table-row>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="0pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
																	border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                                    border-right-style="solid" border-right-width="1pt" border-right-color="black"																										
                                                					number-columns-spanned="1">
																	<fo:block font-size="9px" font-weight="bold">Female
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="0pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
                                                                    border-top-style="solid" border-top-width="1pt" border-top-color="black"
                                                                    border-right-style="solid" border-right-width="1pt" border-right-color="black"	
																	number-columns-spanned="1">
																	<fo:block font-size="9px" font-weight="bold">Male
																	</fo:block>
																</fo:table-cell>
																<fo:table-cell hyphenate="true" language="en"
																	padding-start="3pt" padding-end="0pt" padding-before="1pt"
																	padding-after="0pt" display-align="center" text-align="center"
                                                                    border-top-style="solid" border-top-width="1pt" border-top-color="black"	
																	number-columns-spanned="1" keep-together="auto">
																	<fo:block font-size="9px" font-weight="bold">Unknown/Not
																		Reported
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:table-cell>
											<!-- ============================ -->
											<!-- Total -->
											<!-- ============================ -->
											<fo:table-cell hyphenate="true" language="en"
												padding-start="0pt" padding-end="0pt" padding-before="1pt"
												padding-after="0pt" display-align="center" text-align="center" 	
												number-columns-spanned="1" background-color="{$totalColor}">
												<fo:block font-size="9px" font-weight="bold">Total
												</fo:block>
												<fo:block>
													<fo:table width="100%" space-before.optimum="0pt"
														space-after.optimum="0pt" table-layout="fixed">
														<fo:table-column column-width="proportional-column-width(1)" />
														<fo:table-body>
															<fo:table-row>
																<fo:table-cell hyphenate="true" language="en"
																	number-columns-spanned="1" padding-start="0pt"
																	padding-end="0pt" padding-before="1pt" padding-after="0pt"
																	 text-align="center"
																	border-style="solid" border-width="0pt" border-color="black">
																	<fo:block font-size="8pt">
																		<fo:leader leader-pattern="space" />
																	</fo:block>
																</fo:table-cell>
															</fo:table-row>
														</fo:table-body>
													</fo:table>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<!-- ============================ -->
					<!-- American Indian / Alaska Native..... First row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- American Indian / Alaska Native label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">American Indian/Alaska Native
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:AmericanIndian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:AmericanIndian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Unknown not Reported -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:AmericanIndian"/>
						 </xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:AmericanIndian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:AmericanIndian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:AmericanIndian"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:AmericanIndian"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:AmericanIndian"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:AmericanIndian"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="totalByRow">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative
						/*/*/HumanSubjectStudy_2_0:AmericanIndian"/>
						</xsl:call-template>
					</fo:table-row>
					
					<!-- ============================ -->
					<!-- Asian..... Second row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- Asian label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">Asian
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Asian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Asian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Unknown not Reported -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:Asian"/>
						 </xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Asian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Asian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:Asian"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Asian"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Asian"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:Asian"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="totalByRow">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative
						/*/*/HumanSubjectStudy_2_0:Asian"/>
						</xsl:call-template>
					</fo:table-row>
					<!-- ============================ -->
					<!-- Native Hawaiian or Other Pacific Islander..... Third row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- Native Hawaiian or Other Pacific Islander label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">Native Hawaiian or Other
									Pacific
									Islander
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Hawaiian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Hawaiian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Unknown not Reported -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:Hawaiian"/>
						 </xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Hawaiian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Hawaiian"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:Hawaiian"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Hawaiian"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Hawaiian"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:Hawaiian"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="totalByRow">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative
						/*/*/HumanSubjectStudy_2_0:Hawaiian"/>
						</xsl:call-template>
					</fo:table-row>
					<!-- ============================ -->
					<!-- Black or African American..... Fourth row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- Black or African American label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">Black or African American
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Black"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Black"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Unknown not Reported -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:Black"/>
						 </xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Black"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Black"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:Black"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:Black"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:Black"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:Black"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="totalByRow">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative
						/*/*/HumanSubjectStudy_2_0:Black"/>
	
						</xsl:call-template>
					</fo:table-row>
					<!-- ============================ -->
					<!-- White..... Fifth row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- White -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">White
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:White"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:White"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Unknown not Reported -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:White"/>
						 </xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:White"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:White"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:White"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:White"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:White"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:White"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="totalByRow">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative
						/*/*/HumanSubjectStudy_2_0:White"/>
						</xsl:call-template>
					</fo:table-row>
					
					<!-- ============================ -->
					<!-- More than One Race..... Sixth row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- More than One Race label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">More than One Race
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:MultipleRace"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:MultipleRace"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Unknown not Reported -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:MultipleRace"/>
						 </xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:MultipleRace"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:MultipleRace"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:MultipleRace"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:MultipleRace"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:MultipleRace"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:MultipleRace"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="totalByRow">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative
						/*/*/HumanSubjectStudy_2_0:MultipleRace"/>
						</xsl:call-template>
					</fo:table-row>
					
					<!-- ============================ -->
					<!-- Unknown or Not Reported..... Seventh row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- Unknown or Not Reported label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" keep-together="auto">
							<fo:block>
								<fo:inline font-size="8pt">Unknown or Not Reported
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:UnknownRace"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:UnknownRace"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Unknown not Reported -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:UnknownRace"/>
						 </xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal"
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:UnknownRace"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
							<xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:UnknownRace"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:UnknownRace"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Female -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Female/HumanSubjectStudy_2_0:UnknownRace"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/male -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Male/HumanSubjectStudy_2_0:UnknownRace"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
						   <xsl:with-param name="evaluatedCellVal" 
										select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:UnknownGender/HumanSubjectStudy_2_0:UnknownRace"/>
						 </xsl:call-template>
						 
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="totalByRow">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative
						/*/*/HumanSubjectStudy_2_0:UnknownRace"/>
						</xsl:call-template>
					</fo:table-row>
					<!-- ============================ -->
					<!-- Total..... Eighth row filling -->
					<!-- ============================ -->
					<fo:table-row height="20px">
						<!-- ============================ -->
						<!-- Total label -->
						<!-- ============================ -->
						<fo:table-cell hyphenate="true" language="en"
							line-height="9pt" number-columns-spanned="2" padding-start="0pt"
							padding-end="0pt" padding-before="1pt" padding-after="0pt"
							display-align="center" text-align="center" border-style="solid"
							border-width="1pt" border-color="black" background-color="{$totalColor}" >
							<fo:block>
								<fo:inline font-size="9px" font-weight="bold">Total
								</fo:inline>
							</fo:block>
						</fo:table-cell>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumn">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Female"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Male -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumn">							
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:Male"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Not Hispanic or Latino/Unknown not Reported -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumn">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:NotHispanic
						/HumanSubjectStudy_2_0:UnknownGender"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/Female -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumn">							
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Female"/>
						</xsl:call-template>
												
						<!-- ============================ -->
						<!-- Hispanic or Latino/male -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumn">							
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:Male"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Hispanic or Latino/unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumn">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:Hispanic
						/HumanSubjectStudy_2_0:UnknownGender"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Female -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumn">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Female"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/male -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumn">			
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:Male"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Unknown Not Reported Ethnicity/Unknown gender -->
						<!-- ============================ -->
						<xsl:call-template name="totalByColumn">
							<xsl:with-param name="cellValue" select="HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/HumanSubjectStudy_2_0:UnknownEthnicity
						/HumanSubjectStudy_2_0:UnknownGender"/>
						</xsl:call-template>
						
						<!-- ============================ -->
						<!-- Total -->
						<!-- ============================ -->
						<xsl:call-template name="genericTableCell">
										<xsl:with-param name="cellColor" select="$totalColor"/>
										<xsl:with-param name="evaluatedCellVal" select="sum(HumanSubjectStudy_2_0:InclusionEnrollmentReport/HumanSubjectStudy_2_0:Cumulative/* [not(self::HumanSubjectStudy_2_0:Total)]/* [not(self::HumanSubjectStudy_2_0:Total)]/* [not(self::HumanSubjectStudy_2_0:Total)])" />
						</xsl:call-template>
					
						
					</fo:table-row>
				</fo:table-body>
				</fo:table>
				
					</fo:block>
			
	</xsl:template>
	
	
	<!-- =========================================
	A Generic Table Cell template called
	by all other templates. 
	(params) evaluatedCellVal, cellColor (optional)
	========================================== -->
	<xsl:template name="genericTableCell">
		<xsl:param name="evaluatedCellVal" />
		<xsl:param name="cellColor" select="$defCellColor" />
		<fo:table-cell hyphenate="true" language="en"
			line-height="9pt" number-columns-spanned="1" padding-start="0pt"
			padding-end="0pt" padding-before="1pt" padding-after="0pt"
			display-align="center" text-align="center" border-style="solid"
			border-width="1pt" border-color="black" background-color="{$cellColor}">
			<fo:block>
				<fo:inline font-size="9px">
				<xsl:choose>
					<xsl:when test="not($evaluatedCellVal)">0</xsl:when>
					<xsl:when test="$evaluatedCellVal = ''">0</xsl:when>
					<xsl:otherwise><xsl:value-of select="$evaluatedCellVal" /></xsl:otherwise>
				</xsl:choose>
				</fo:inline>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
	<!-- =========================================
	A Generic Table Cell template called
	by other templates for planned table 
	(params) evaluatedCellVal, cellColor (optional)
	========================================== -->
	<xsl:template name="genericTableCellforPlaned">
		<xsl:param name="evaluatedCellVal" />
		<xsl:param name="cellColor" select="$defCellColor" />
		<fo:table-cell hyphenate="true" language="en"
			line-height="9pt" number-columns-spanned="2" padding-start="0pt"
			padding-end="0pt" padding-before="1pt" padding-after="0pt"
			display-align="center" text-align="center" border-style="solid"
			border-width="1pt" border-color="black" background-color="{$cellColor}">
			<fo:block>
				<fo:inline font-size="9px">
					<xsl:choose>
						<xsl:when test="normalize-space($evaluatedCellVal)=''">0</xsl:when>
						<xsl:otherwise><xsl:value-of select="$evaluatedCellVal" /></xsl:otherwise>
					</xsl:choose>
				</fo:inline>
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	<!-- =========================================
	Calculates and displays the SUM by ROW 
	(params) cellValue
	This template grabs all the nodes with the
	specified node value and sums for planned table
	========================================== -->

	
	<xsl:template name="totalByRowPlanned">
		<xsl:param name="cellValue" />		
				<xsl:call-template name="genericTableCellforPlaned">
					<xsl:with-param name="cellColor" select="$totalColor"/>
					<xsl:with-param name="evaluatedCellVal" select="sum($cellValue)" />
				</xsl:call-template>
	
	</xsl:template>
	<!-- =========================================
	Calculates and displays the SUM by ROW 
	(params) cellValue This template grabs all the nodes with the
	specified node value and sums.
	========================================== -->

	
	<xsl:template name="totalByRow">
		<xsl:param name="cellValue" />		
				<xsl:call-template name="genericTableCell">
					<xsl:with-param name="cellColor" select="$totalColor"/>
					<xsl:with-param name="evaluatedCellVal" select="sum($cellValue)" />
				</xsl:call-template>
	
	</xsl:template>
	
	<!-- =========================================
	Calculates and displays the SUM by Column 
	(params) cellValue, This template grabs all the nodes within the
	specified node value, excluding the "Total" element and sums for
	cumulative table
	========================================== -->
	<xsl:template name="totalByColumn">
		<xsl:param name="cellValue" />
				
				<xsl:call-template name="genericTableCell">
					<xsl:with-param name="cellColor" select="$totalColor"/>
					<xsl:with-param name="evaluatedCellVal" select="sum($cellValue/* [not(self::HumanSubjectStudy_2_0:Total)])" />
				</xsl:call-template>
			
	</xsl:template>
	<!-- =========================================
	Calculates and displays the SUM by Column 
	(params) cellValue,	This template grabs all the nodes within the
	specified node value, excluding the "Total" element and sums for
	planned table
	========================================== -->
	<xsl:template name="totalByColumnPlanned">
		<xsl:param name="cellValue" />
				
				<xsl:call-template name="genericTableCellforPlaned">
					<xsl:with-param name="cellColor" select="$totalColor"/>
					<xsl:with-param name="evaluatedCellVal" select="sum($cellValue/* [not(self::HumanSubjectStudy_2_0:Total)])" />
				</xsl:call-template>
			
	</xsl:template>
	
		
	<!--  Create label with display text, ${label_text} -->
	<xsl:template name="label">
		<xsl:param name="padding-start" select="1" />
		<xsl:param name="number-columns-spanned" select="1" />
		<xsl:param name="label_text" />
		<fo:table-cell 
			hyphenate="true" 
			language="en" 
			line-height="9pt"
			number-columns-spanned="{$number-columns-spanned}"
			padding-end="3pt"
			padding-before="{$padding-start}" 
			padding-start = "1pt"
			padding-after="1pt"
			display-align="center"
			text-align="start"
			border-width="1pt"
			border-color="white">
			<fo:block font-family="arialuni" font-size="9px">
				<xsl:value-of select="$label_text" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>
	
	<!-- =========================================
	Yes or No Radio button
	========================================== -->	
	
		<xsl:template name="radio-field">
		<xsl:param name="xml_field" />
		<xsl:param name="yes_text"/>
		<xsl:param name="no_text"/>
		<xsl:param name="padding-start" select="0" />
		<fo:table-cell text-align="left" display-align="center">

								<fo:table font-size="9px" table-layout="fixed" width="100%">
									<fo:table-column column-width="25%" />
									<fo:table-column column-width="25%" />
									<fo:table-column column-width="25%" />
									<fo:table-column column-width="25%" />
									<fo:table-body>
										<fo:table-row>
											<xsl:call-template name="yesOrNoRadio">
												<xsl:with-param name="xml_field" select="$xml_field" />
												<xsl:with-param name="yes_text" select="$yes_text" />
												<xsl:with-param name="no_text" select="$no_text" />
												<xsl:with-param name="padding-start" select="$padding-start" />
											</xsl:call-template>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:table-cell>

	</xsl:template>
	
		<xsl:template name="yesOrNoRadio">
		<xsl:param name="xml_field" />
		<xsl:param name="yes_text"/>
		<xsl:param name="no_text"/>
		<xsl:param name="padding-start" select="0"/>
		<!-- YES/Domestic -->
		<xsl:call-template name="options">
			<xsl:with-param name="xml_field" select="$xml_field" />
			<xsl:with-param name="padding-start" select="$padding-start"/>
			<xsl:with-param name="radio_text">
				<xsl:value-of select="$yes_text"/>
			</xsl:with-param>
			<xsl:with-param name="radio_value">
				Y: Yes
			</xsl:with-param>
		</xsl:call-template>
		<!-- NO/Foreign -->
		<xsl:call-template name="options">
			<xsl:with-param name="xml_field" select="$xml_field" />
			<xsl:with-param name="padding-start" select="$padding-start"/>
			<xsl:with-param name="radio_text">
				<xsl:value-of select="$no_text"/>
			</xsl:with-param>
			<xsl:with-param name="radio_value">
				N: No
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="options">
		<xsl:param name="xml_field" />
		<xsl:param name="radio_text" />
		<xsl:param name="radio_value" />
		<xsl:param name="padding-start"  select="0"/>
		<fo:table-cell line-height="17pt" text-align="right" border-spacing="2px" padding-before="{$padding-start}">
			<fo:block>
				<xsl:call-template name="radio">
					<xsl:with-param name="xml_field" select="$xml_field" />
					<xsl:with-param name="radio_value" select="$radio_value" />
					<xsl:with-param name="padding-start" select="$padding-start"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell line-height="15pt" text-align="left" border-spacing="2px" padding-before="{$padding-start}">
			<fo:block>
				<xsl:value-of select="$radio_text" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>

	<xsl:template name="radio">
		<xsl:param name="xml_field" />
		<xsl:param name="radio_value" />
		<xsl:param name="padding-start" select="0" />
		<xsl:choose>
			<xsl:when
				test="normalize-space($xml_field) = normalize-space($radio_value)">
				<fo:inline font-family="ZapfDingbats" font-size="9px" padding-start="7pt" padding-end="7pt" padding-before="{$padding-start}">&#x25cf;</fo:inline>
			</xsl:when>
			<xsl:otherwise>
				<fo:inline font-family="ZapfDingbats" font-size="9px" padding-start="7pt" padding-end="7pt" padding-before="{$padding-start}">&#x274d;</fo:inline>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- Preserves new line character inside table cell -->
	<xsl:template name="table_body_cell_newline">	
		<xsl:param name="cell_text" />
		<fo:table-cell hyphenate="true" language="en"
							line-height="11pt" padding-start="2pt"
							padding-end="2pt" padding-before="2pt" padding-after="2pt"
							 text-align="start" border-style="solid"
							border-width="1pt" border-color="white">
			<fo:block font-family="arialuni" font-size="9px" linefeed-treatment="preserve" white-space-collapse="false" wrap-option="wrap" white-space-treatment="preserve">
				<xsl:value-of select="$cell_text" />
			</fo:block>
		</fo:table-cell>
	</xsl:template>

	<!--  template to replace tabs with 5 spaces and to preserve new line characters-->
	<xsl:template name="table_body_cell_tabs_newline">
		<xsl:param name="cell_text" select="." />
		<xsl:param name="text" select="$cell_text" />
		
		<xsl:variable name="tabspaces" select="'     '" />
		<xsl:variable name="tabText" select="'&#x09;'" />
		<xsl:variable name="tabIndex" select="string-length(substring-before($cell_text, $tabText))" />
		<xsl:choose>
			<xsl:when test="$tabIndex > 0">
				<xsl:variable name="newLabeltext1">
				<xsl:call-template name="replace-all-string-template">
					<xsl:with-param name="text" select="$text" />
					<xsl:with-param name="replace" select="$tabText" />
					<xsl:with-param name="with" select="$tabspaces" />
				</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="table_body_cell_newline">
					<xsl:with-param name="cell_text" select="$newLabeltext1" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="table_body_cell_newline">
					<xsl:with-param name="cell_text" select="$cell_text" />
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
    
    <!-- Replace all String  
        text         : main string
        replace : the string fragment to be replaced
        with    :  the replacement string -->
	<xsl:template name="replace-all-string-template">
		<xsl:param name="text" />
		<xsl:param name="replace" />
		<xsl:param name="with" />
		<xsl:choose>
			<xsl:when test="contains($text,$replace)">
				<xsl:value-of select="substring-before($text,$replace)" />
				<xsl:value-of select="$with" />
				<xsl:call-template name="replace-all-string-template">
					<xsl:with-param name="text" select="substring-after($text,$replace)" />
					<xsl:with-param name="replace" select="$replace" />
					<xsl:with-param name="with" select="$with" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
