/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.sys.framework.persistence.KcPersistenceStructureService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.util.AbstractKeyValue;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;

public class BudgetColumnsValuesFinder
extends UifKeyValuesFinderBase {
    private transient DataDictionaryService dataDictionaryService;
    private transient KcPersistenceStructureService kcPersistenceStructureService;
    private static final Set<String> EXCLUDED_ATTRIBUTES = Stream.of("parentDocumentTypeCode", "budgetAdjustmentDocumentNumber", "residualFunds", "endDate", "documentNumber", "totalDirectCostLimit", "totalDirectCost", "ohRateClassCode", "underrecoveryAmount", "updateUser", "updateTimestamp", "versionNumber", "objectId", "budgetId", "urRateClassCode", "totalIndirectCost", "totalCostLimit", "onOffCampusFlag", "ohRateTypeCode", "startDate", "totalCost", "budgetVersionNumber").collect(Collectors.toSet());

    public List<KeyValue> getKeyValues() {
        BusinessObjectEntry entry = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(Budget.class.getName());
        Map<String, String> attrToColumnMap = this.getKcPersistenceStructureService().getPersistableAttributesColumnMap(Budget.class);
        return entry.getAttributes().stream().filter(attr -> !EXCLUDED_ATTRIBUTES.contains(attr.getName())).filter(attr -> attrToColumnMap.containsKey(attr.getName())).map(attr -> new ConcreteKeyValue((String)attrToColumnMap.get(attr.getName()), attr.getLabel())).sorted(Comparator.comparing(AbstractKeyValue::getValue, String::compareToIgnoreCase)).collect(Collectors.toList());
    }

    private KcPersistenceStructureService getKcPersistenceStructureService() {
        if (this.kcPersistenceStructureService == null) {
            this.kcPersistenceStructureService = KcServiceLocator.getService(KcPersistenceStructureService.class);
        }
        return this.kcPersistenceStructureService;
    }

    private DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KcServiceLocator.getService(DataDictionaryService.class);
        }
        return this.dataDictionaryService;
    }
}

