/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.maintenance;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.document.authorization.FieldRestriction;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentPresentationController;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentRestrictions;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.service.BusinessObjectAuthorizationService;
import org.kuali.rice.kns.service.BusinessObjectDictionaryService;
import org.kuali.rice.kns.service.BusinessObjectMetaDataService;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.util.InactiveRecordsHidingUtils;
import org.kuali.rice.kns.util.MaintenanceUtils;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.kns.web.ui.SectionBridge;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DataObjectRelationship;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.MaterializeOption;
import org.kuali.rice.krad.datadictionary.AttributeSecurity;
import org.kuali.rice.krad.datadictionary.exception.UnknownBusinessClassAttributeException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.DataObjectMetaDataService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.service.PersistenceStructureService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.valuefinder.ValueFinder;

@Deprecated
public class KualiMaintainableImpl
extends MaintainableImpl
implements Maintainable {
    private static final long serialVersionUID = 4814145799502207182L;
    private static final Logger LOG = LogManager.getLogger(KualiMaintainableImpl.class);
    protected PersistableBusinessObject businessObject;
    protected Map<String, PersistableBusinessObject> newCollectionLines = new HashMap<String, PersistableBusinessObject>();
    protected Map<String, Boolean> inactiveRecordDisplay = new HashMap<String, Boolean>();
    protected Set<String> newCollectionLineNames = new HashSet<String>();
    protected transient BusinessObjectDictionaryService businessObjectDictionaryService;
    protected transient PersonService personService;
    @Deprecated
    protected transient BusinessObjectMetaDataService businessObjectMetaDataService;
    @Deprecated
    protected transient BusinessObjectAuthorizationService businessObjectAuthorizationService;
    @Deprecated
    protected transient DocumentHelperService documentHelperService;
    protected transient MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;
    @Deprecated
    private transient DataObjectMetaDataService dataObjectMetaDataService;

    public KualiMaintainableImpl() {
    }

    public KualiMaintainableImpl(PersistableBusinessObject businessObject) {
        this.businessObject = businessObject;
        super.setDataObject((Object)businessObject);
    }

    @Override
    public Map populateBusinessObject(Map<String, String> fieldValues, MaintenanceDocument maintenanceDocument, String methodToCall) {
        fieldValues = this.decryptEncryptedData(fieldValues, maintenanceDocument, methodToCall);
        Map newFieldValues = null;
        newFieldValues = this.getPersonService().resolvePrincipalNamesToPrincipalIds((BusinessObject)this.getBusinessObject(), fieldValues);
        Map cachedValues = FieldUtils.populateBusinessObjectFromMap(this.getBusinessObject(), newFieldValues);
        this.performForceUpperCase(newFieldValues);
        return cachedValues;
    }

    protected Map<String, String> decryptEncryptedData(Map<String, String> fieldValues, MaintenanceDocument maintenanceDocument, String methodToCall) {
        try {
            MaintenanceDocumentRestrictions auths = KNSServiceLocator.getBusinessObjectAuthorizationService().getMaintenanceDocumentRestrictions(maintenanceDocument, GlobalVariables.getUserSession().getPerson());
            for (String fieldName : fieldValues.keySet()) {
                String fieldValue = fieldValues.get(fieldName);
                if (fieldValue != null && !"".equals(fieldValue) && fieldValue.endsWith("(&^#&)")) {
                    if (this.shouldFieldBeEncrypted(maintenanceDocument, fieldName, auths, methodToCall)) {
                        String encryptedValue = fieldValue;
                        encryptedValue = StringUtils.stripEnd((String)encryptedValue, (String)"(&^#&)");
                        if (!CoreApiServiceLocator.getEncryptionService().isEnabled()) continue;
                        String decryptedValue = this.getEncryptionService().decrypt(encryptedValue);
                        fieldValues.put(fieldName, decryptedValue);
                        continue;
                    }
                    throw new RuntimeException("The field value for field name " + fieldName + " should not be encrypted.");
                }
                if (fieldValue == null || "".equals(fieldValue) || !auths.hasRestriction(fieldName) || !this.shouldFieldBeEncrypted(maintenanceDocument, fieldName, auths, methodToCall)) continue;
                throw new RuntimeException("The field value for field name " + fieldName + " should be encrypted.");
            }
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Unable to decrypt secure data: " + e.getMessage(), e);
        }
        return fieldValues;
    }

    protected boolean shouldFieldBeEncrypted(MaintenanceDocument maintenanceDocument, String fieldName, MaintenanceDocumentRestrictions auths, String methodToCall) {
        if ("refresh".equals(methodToCall) && fieldName != null) {
            fieldName = fieldName.replaceAll("\\[[0-9]*+\\]", "");
            fieldName = fieldName.replaceAll("^add\\.", "");
            Map<String, AttributeSecurity> fieldNameToAttributeSecurityMap = MaintenanceUtils.retrievePropertyPathToAttributeSecurityMappings(this.getDocumentTypeName());
            AttributeSecurity attributeSecurity = fieldNameToAttributeSecurityMap.get(fieldName);
            return attributeSecurity != null && attributeSecurity.hasRestrictionThatRemovesValueFromUI();
        }
        return false;
    }

    @Override
    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        ArrayList<Section> sections = new ArrayList<Section>();
        sections.addAll(this.getCoreSections(document, oldMaintainable));
        return sections;
    }

    public List<Section> getCoreSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        ArrayList<Section> sections = new ArrayList<Section>();
        MaintenanceDocumentRestrictions maintenanceRestrictions = KNSServiceLocator.getBusinessObjectAuthorizationService().getMaintenanceDocumentRestrictions(document, GlobalVariables.getUserSession().getPerson());
        MaintenanceDocumentPresentationController maintenanceDocumentPresentationController = (MaintenanceDocumentPresentationController)((Object)this.getDocumentHelperService().getDocumentPresentationController((Document)document));
        Set<String> conditionallyRequiredFields = maintenanceDocumentPresentationController.getConditionallyRequiredPropertyNames(document);
        List<MaintainableSectionDefinition> sectionDefinitions = this.getMaintenanceDocumentDictionaryService().getMaintainableSections(this.getDocumentTypeName());
        try {
            for (MaintainableSectionDefinition maintSectionDef : sectionDefinitions) {
                ArrayList<String> displayedFieldNames = new ArrayList<String>();
                if (maintenanceRestrictions.isHiddenSectionId(maintSectionDef.getId())) continue;
                for (MaintainableItemDefinition item : maintSectionDef.getMaintainableItems()) {
                    if (!(item instanceof MaintainableFieldDefinition)) continue;
                    displayedFieldNames.add(((MaintainableFieldDefinition)item).getName());
                }
                Section section = SectionBridge.toSection(maintSectionDef, this.getBusinessObject(), this, oldMaintainable, this.getMaintenanceAction(), displayedFieldNames, conditionallyRequiredFields);
                if (maintenanceRestrictions.isReadOnlySectionId(maintSectionDef.getId())) {
                    section.setReadOnly(true);
                }
                sections.add(section);
            }
        }
        catch (InstantiationException e) {
            LOG.error("Unable to create instance of object class" + e.getMessage());
            throw new RuntimeException("Unable to create instance of object class" + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Unable to create instance of object class" + e.getMessage());
            throw new RuntimeException("Unable to create instance of object class" + e.getMessage(), e);
        }
        return sections;
    }

    @Override
    public void saveBusinessObject() {
        KNSServiceLocator.getBusinessObjectService().linkAndSave(this.businessObject);
    }

    public void saveDataObject() {
        this.saveBusinessObject();
    }

    @Override
    public String getMaintainableTitle() {
        return this.getMaintenanceDocumentDictionaryService().getMaintenanceLabel(this.getDocumentTypeName());
    }

    @Override
    public void setupNewFromExisting(MaintenanceDocument document, Map<String, String[]> parameters) {
    }

    @Override
    public boolean isBoNotesEnabled() {
        return KRADServiceLocatorWeb.getLegacyDataAdapter().areNotesSupported(this.getDataObjectClass());
    }

    public boolean isNotesEnabled() {
        return this.isBoNotesEnabled();
    }

    @Override
    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        String referencesToRefresh = (String)fieldValues.get("referencesToRefresh");
        this.refreshReferences(referencesToRefresh);
    }

    public void refreshReferences(String referencesToRefresh) {
        PersistenceStructureService persistenceStructureService = this.getPersistenceStructureService();
        if (StringUtils.isNotBlank((String)referencesToRefresh)) {
            String[] references;
            for (String reference : references = StringUtils.split((String)referencesToRefresh, (String)",")) {
                Object possibleRelationship;
                String propertyToRefresh;
                if (!StringUtils.isNotBlank((String)reference)) continue;
                if (reference.startsWith("add.")) {
                    reference = reference.substring("add".length() + 1);
                    String boToRefreshName = StringUtils.substringBeforeLast((String)reference, (String)".");
                    propertyToRefresh = StringUtils.substringAfterLast((String)reference, (String)".");
                    if (StringUtils.isNotBlank((String)propertyToRefresh)) {
                        Object possibleBO;
                        PersistableBusinessObject addlineBO = this.getNewCollectionLine(boToRefreshName);
                        Class<?> addlineBOClass = addlineBO.getClass();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Refresh this \"new\"/add object for the collections:  " + reference);
                        }
                        if (persistenceStructureService.hasReference(addlineBOClass, propertyToRefresh) || persistenceStructureService.hasCollection(addlineBOClass, propertyToRefresh)) {
                            addlineBO.refreshReferenceObject(propertyToRefresh);
                            continue;
                        }
                        if (!this.getDataDictionaryService().hasRelationship(addlineBOClass.getName(), propertyToRefresh) || (possibleBO = ObjectUtils.getPropertyValue(addlineBO, propertyToRefresh)) == null || !(possibleBO instanceof PersistableBusinessObject)) continue;
                        ((PersistableBusinessObject)possibleBO).refresh();
                        continue;
                    }
                    LOG.error("Error: unable to refresh this \"new\"/add object for the collections:  " + reference);
                    continue;
                }
                if (ObjectUtils.isNestedAttribute(reference)) {
                    Object nestedObject = ObjectUtils.getNestedValue(this.getBusinessObject(), ObjectUtils.getNestedAttributePrefix(reference));
                    if (nestedObject == null) {
                        LOG.warn("Unable to refresh ReferenceToRefresh (" + reference + ")  was found to be null");
                        continue;
                    }
                    if (nestedObject instanceof Collection) continue;
                    if (nestedObject instanceof PersistableBusinessObject) {
                        propertyToRefresh = ObjectUtils.getNestedAttributePrimitive(reference);
                        if (persistenceStructureService.hasReference(nestedObject.getClass(), propertyToRefresh) || persistenceStructureService.hasCollection(nestedObject.getClass(), propertyToRefresh)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Refeshing " + ObjectUtils.getNestedAttributePrefix(reference) + " " + ObjectUtils.getNestedAttributePrimitive(reference));
                            }
                            ((PersistableBusinessObject)nestedObject).refreshReferenceObject(propertyToRefresh);
                            continue;
                        }
                        Object possibleBO = ObjectUtils.getPropertyValue(nestedObject, propertyToRefresh);
                        if (possibleBO == null || !(possibleBO instanceof PersistableBusinessObject) || !this.getDataDictionaryService().hasRelationship(possibleBO.getClass().getName(), propertyToRefresh)) continue;
                        ((PersistableBusinessObject)possibleBO).refresh();
                        continue;
                    }
                    LOG.warn("Expected that a referenceToRefresh (" + reference + ")  would be a PersistableBusinessObject or Collection, but instead, it was of class " + nestedObject.getClass().getName());
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Refreshing " + reference);
                }
                if (persistenceStructureService.hasReference(this.getDataObjectClass(), reference) || persistenceStructureService.hasCollection(this.getDataObjectClass(), reference)) {
                    this.getBusinessObject().refreshReferenceObject(reference);
                    continue;
                }
                if (!this.getDataDictionaryService().hasRelationship(this.getBusinessObject().getClass().getName(), reference) || (possibleRelationship = ObjectUtils.getPropertyValue(this.getBusinessObject(), reference)) == null) continue;
                if (possibleRelationship instanceof PersistableBusinessObject) {
                    ((PersistableBusinessObject)possibleRelationship).refresh();
                    continue;
                }
                if (possibleRelationship instanceof Collection) continue;
                LOG.warn("Expected that a referenceToRefresh (" + reference + ")  would be a PersistableBusinessObject or Collection, but instead, it was of class " + possibleRelationship.getClass().getName());
            }
        }
    }

    @Override
    public void addMultipleValueLookupResults(MaintenanceDocument document, String collectionName, Collection<PersistableBusinessObject> rawValues, boolean needsBlank, PersistableBusinessObject bo) {
        Collection maintCollection = (Collection)ObjectUtils.getPropertyValue(bo, collectionName);
        String docTypeName = document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName();
        List<String> duplicateIdentifierFieldsFromDataDictionary = this.getDuplicateIdentifierFieldsFromDataDictionary(docTypeName, collectionName);
        List<String> existingIdentifierList = this.getMultiValueIdentifierList(maintCollection, duplicateIdentifierFieldsFromDataDictionary);
        Class collectionClass = this.getMaintenanceDocumentDictionaryService().getCollectionBusinessObjectClass(docTypeName, collectionName);
        List<MaintainableSectionDefinition> sections = this.getMaintenanceDocumentDictionaryService().getMaintainableSections(docTypeName);
        Map<String, String> template = MaintenanceUtils.generateMultipleValueLookupBOTemplate(sections, collectionName);
        try {
            for (PersistableBusinessObject nextBo : rawValues) {
                PersistableBusinessObject templatedBo;
                if (needsBlank) {
                    templatedBo = (PersistableBusinessObject)collectionClass.newInstance();
                } else {
                    try {
                        ModuleService moduleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(collectionClass);
                        templatedBo = moduleService != null && moduleService.isExternalizable(collectionClass) ? (PersistableBusinessObject)moduleService.createNewObjectFromExternalizableClass(collectionClass) : (PersistableBusinessObject)collectionClass.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot instantiate " + collectionClass.getName(), e);
                    }
                    this.setNewCollectionLineDefaultValues(collectionName, templatedBo);
                    ObjectUtils.createHybridBusinessObject(templatedBo, (BusinessObject)nextBo, template);
                    this.prepareBusinessObjectForAdditionFromMultipleValueLookup(collectionName, templatedBo);
                }
                templatedBo.setNewCollectionRecord(true);
                if (this.hasBusinessObjectExisted(templatedBo, existingIdentifierList, duplicateIdentifierFieldsFromDataDictionary)) continue;
                maintCollection.add(templatedBo);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to add multiple value lookup results " + e.getMessage());
            throw new RuntimeException("Unable to add multiple value lookup results " + e.getMessage(), e);
        }
    }

    @Override
    public List<String> getDuplicateIdentifierFieldsFromDataDictionary(String docTypeName, String collectionName) {
        ArrayList<String> duplicateIdentifierFieldNames = new ArrayList<String>();
        MaintainableCollectionDefinition collDef = this.getMaintenanceDocumentDictionaryService().getMaintainableCollection(docTypeName, collectionName);
        List<MaintainableFieldDefinition> fieldDef = collDef.getDuplicateIdentificationFields();
        for (MaintainableFieldDefinition eachFieldDef : fieldDef) {
            duplicateIdentifierFieldNames.add(eachFieldDef.getName());
        }
        return duplicateIdentifierFieldNames;
    }

    @Override
    public List<String> getMultiValueIdentifierList(Collection maintCollection, List<String> duplicateIdentifierFields) {
        ArrayList<String> identifierList = new ArrayList<String>();
        for (PersistableBusinessObject bo : maintCollection) {
            Object uniqueIdentifier = new String();
            for (String identifierField : duplicateIdentifierFields) {
                uniqueIdentifier = (String)uniqueIdentifier + identifierField + "-" + ObjectUtils.getPropertyValue(bo, identifierField);
            }
            if (!StringUtils.isNotEmpty((String)uniqueIdentifier)) continue;
            identifierList.add((String)uniqueIdentifier);
        }
        return identifierList;
    }

    @Override
    public boolean hasBusinessObjectExisted(BusinessObject bo, List<String> existingIdentifierList, List<String> duplicateIdentifierFields) {
        Object uniqueIdentifier = new String();
        for (String identifierField : duplicateIdentifierFields) {
            uniqueIdentifier = (String)uniqueIdentifier + identifierField + "-" + ObjectUtils.getPropertyValue(bo, identifierField);
        }
        return existingIdentifierList.contains(uniqueIdentifier);
    }

    public void prepareBusinessObjectForAdditionFromMultipleValueLookup(String collectionName, BusinessObject bo) {
    }

    @Override
    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        try {
            KradDataServiceLocator.getDataObjectService().wrap((Object)this.businessObject).materializeReferencedObjectsToDepth(2, new MaterializeOption[]{MaterializeOption.COLLECTIONS, MaterializeOption.UPDATE_UPDATABLE_REFS});
            KRADServiceLocatorWeb.getLegacyDataAdapter().setObjectPropertyDeep((Object)this.businessObject, "newCollectionRecord", Boolean.TYPE, (Object)true);
        }
        catch (Exception e) {
            LOG.error("unable to set newCollectionRecord property: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("unable to set newCollectionRecord property: " + e.getMessage(), e);
        }
    }

    @Override
    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> requestParameters) {
    }

    @Override
    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
    }

    @Override
    public void processAfterPost(MaintenanceDocument document, Map<String, String[]> requestParameters) {
    }

    public void setDataObject(Object object) {
        super.setDataObject(object);
        if (object instanceof PersistableBusinessObject) {
            this.businessObject = (PersistableBusinessObject)object;
        }
    }

    @Override
    public String getDocumentTitle(MaintenanceDocument document) {
        return super.getDocumentTitle((org.kuali.rice.krad.maintenance.MaintenanceDocument)document);
    }

    @Override
    public PersistableBusinessObject getBusinessObject() {
        return this.businessObject;
    }

    @Override
    public void setBusinessObject(PersistableBusinessObject businessObject) {
        this.businessObject = businessObject;
        this.setDataObject(businessObject);
    }

    @Override
    public Class getBoClass() {
        return super.getDataObjectClass();
    }

    @Override
    public void setBoClass(Class boClass) {
        this.setDataObjectClass(boClass);
    }

    @Override
    public void setGenerateDefaultValues(String docTypeName) {
        List<MaintainableSectionDefinition> sectionDefinitions = this.getMaintenanceDocumentDictionaryService().getMaintainableSections(docTypeName);
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        try {
            for (MaintainableSectionDefinition maintSectionDef : sectionDefinitions) {
                List<MaintainableItemDefinition> maintItems = maintSectionDef.getMaintainableItems();
                for (MaintainableItemDefinition item : maintItems) {
                    Class<? extends ValueFinder> defaultValueFinderClass;
                    if (!(item instanceof MaintainableFieldDefinition)) continue;
                    MaintainableFieldDefinition maintainableFieldDefinition = (MaintainableFieldDefinition)item;
                    String defaultValue = maintainableFieldDefinition.getDefaultValue();
                    if (defaultValue != null) {
                        if (defaultValue.equals("true")) {
                            defaultValue = "Yes";
                        } else if (defaultValue.equals("false")) {
                            defaultValue = "No";
                        }
                    }
                    if ((defaultValueFinderClass = maintainableFieldDefinition.getDefaultValueFinderClass()) != null) {
                        defaultValue = defaultValueFinderClass.newInstance().getValue();
                    }
                    if (defaultValue == null) continue;
                    defaultValues.put(item.getName(), defaultValue);
                }
            }
            Map iter = FieldUtils.populateBusinessObjectFromMap(this.getBusinessObject(), defaultValues);
        }
        catch (Exception e) {
            LOG.error("Unable to set default value " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("Unable to set default value" + e.getMessage(), e);
        }
    }

    @Override
    public void setGenerateBlankRequiredValues(String docTypeName) {
        try {
            List<MaintainableSectionDefinition> sectionDefinitions = this.getMaintenanceDocumentDictionaryService().getMaintainableSections(docTypeName);
            HashMap<String, String> defaultValues = new HashMap<String, String>();
            for (MaintainableSectionDefinition maintSectionDef : sectionDefinitions) {
                for (MaintainableItemDefinition item : maintSectionDef.getMaintainableItems()) {
                    String defaultValue;
                    Class<? extends ValueFinder> defaultValueFinderClass;
                    Object currPropVal;
                    MaintainableFieldDefinition maintainableFieldDefinition;
                    if (!(item instanceof MaintainableFieldDefinition) || !(maintainableFieldDefinition = (MaintainableFieldDefinition)item).isRequired() || !maintainableFieldDefinition.isUnconditionallyReadOnly() || (currPropVal = ObjectUtils.getPropertyValue(this.getBusinessObject(), item.getName())) != null && (!(currPropVal instanceof String) || !StringUtils.isBlank((String)((String)currPropVal))) || (defaultValueFinderClass = maintainableFieldDefinition.getDefaultValueFinderClass()) == null || (defaultValue = defaultValueFinderClass.newInstance().getValue()) == null) continue;
                    defaultValues.put(item.getName(), defaultValue);
                }
            }
            FieldUtils.populateBusinessObjectFromMap(this.getBusinessObject(), defaultValues);
        }
        catch (Exception e) {
            LOG.error("Unable to set blank required value " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("Unable to set blank required value" + e.getMessage(), e);
        }
    }

    @Deprecated
    public void processAfterAddLine(String colName, Class colClass) {
    }

    @Override
    public void processBeforeAddLine(String colName, Class colClass, BusinessObject addBO) {
    }

    @Override
    public boolean getShowInactiveRecords(String collectionName) {
        return InactiveRecordsHidingUtils.getShowInactiveRecords(this.inactiveRecordDisplay, collectionName);
    }

    @Override
    public void setShowInactiveRecords(String collectionName, boolean showInactive) {
        InactiveRecordsHidingUtils.setShowInactiveRecords(this.inactiveRecordDisplay, collectionName, showInactive);
    }

    @Override
    public Map<String, Boolean> getInactiveRecordDisplay() {
        return this.inactiveRecordDisplay;
    }

    @Override
    public void addNewLineToCollection(String collectionName) {
        PersistableBusinessObject addLine;
        if (LOG.isDebugEnabled()) {
            LOG.debug("addNewLineToCollection( " + collectionName + " )");
        }
        if ((addLine = this.newCollectionLines.get(collectionName)) != null) {
            addLine.setNewCollectionRecord(true);
            Collection maintCollection = (Collection)ObjectUtils.getPropertyValue(this.getBusinessObject(), collectionName);
            maintCollection.add(addLine);
            String referencesToRefresh = LookupUtils.convertReferencesToSelectCollectionToString(this.getAllRefreshableReferences(this.getBusinessObject().getClass()));
            if (LOG.isInfoEnabled()) {
                LOG.info("References to refresh for adding line to collection " + collectionName + ": " + referencesToRefresh);
            }
            this.refreshReferences(referencesToRefresh);
        }
        this.initNewCollectionLine(collectionName);
    }

    @Override
    public PersistableBusinessObject getNewCollectionLine(String collectionName) {
        PersistableBusinessObject addLine;
        if (LOG.isDebugEnabled()) {
            LOG.debug("newCollectionLines: " + this.newCollectionLines);
        }
        if ((addLine = this.newCollectionLines.get(collectionName)) == null) {
            addLine = this.initNewCollectionLine(collectionName);
        }
        return addLine;
    }

    public PersistableBusinessObject initNewCollectionLine(String collectionName) {
        PersistableBusinessObject addLine;
        if (LOG.isDebugEnabled()) {
            LOG.debug("initNewCollectionLine( " + collectionName + " )");
        }
        try {
            addLine = (PersistableBusinessObject)this.getMaintenanceDocumentDictionaryService().getCollectionBusinessObjectClass(this.getDocumentTypeName(), collectionName).newInstance();
        }
        catch (Exception ex) {
            LOG.error("unable to instantiate new collection line", (Throwable)ex);
            throw new RuntimeException("unable to instantiate new collection line", ex);
        }
        this.newCollectionLines.put(collectionName, addLine);
        this.setNewCollectionLineDefaultValues(collectionName, addLine);
        return addLine;
    }

    @Override
    public Map<String, String> populateNewCollectionLines(Map<String, String> fieldValues, MaintenanceDocument maintenanceDocument, String methodToCall) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("populateNewCollectionLines: " + fieldValues);
        }
        fieldValues = this.decryptEncryptedData(fieldValues, maintenanceDocument, methodToCall);
        HashMap<String, String> cachedValues = new HashMap<String, String>();
        List<MaintainableCollectionDefinition> collections = this.getMaintenanceDocumentDictionaryService().getMaintainableCollections(this.getDocumentTypeName());
        for (MaintainableCollectionDefinition coll : collections) {
            String collName = coll.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("checking for collection: " + collName);
            }
            HashMap<String, String> collectionValues = new HashMap<String, String>();
            HashMap<String, String> subCollectionValues = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : fieldValues.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(collName)) continue;
                String subStrKey = key.substring(collName.length() + 1);
                if (key.contains("[")) {
                    subCollectionValues.put(key, entry.getValue());
                    continue;
                }
                collectionValues.put(subStrKey, entry.getValue());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("values for collection: " + collectionValues);
            }
            cachedValues.putAll(FieldUtils.populateBusinessObjectFromMap(this.getNewCollectionLine(collName), collectionValues, "add." + collName + "."));
            this.performFieldForceUpperCase(this.getNewCollectionLine(collName), collectionValues);
            cachedValues.putAll(this.populateNewSubCollectionLines(coll, subCollectionValues));
        }
        return cachedValues;
    }

    protected Map populateNewSubCollectionLines(MaintainableCollectionDefinition parentCollection, Map fieldValues) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("populateNewSubCollectionLines: " + fieldValues);
        }
        HashMap cachedValues = new HashMap();
        for (MaintainableCollectionDefinition coll : parentCollection.getMaintainableCollections()) {
            String collName = coll.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("checking for sub collection: " + collName);
            }
            HashMap<String, String> parents = new HashMap<String, String>();
            for (Map.Entry entry : fieldValues.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.contains(collName)) continue;
                parents.put(StringUtils.substringBefore((String)key, (String)"."), "");
            }
            for (String parent : parents.keySet()) {
                HashMap collectionValues = new HashMap();
                for (Map.Entry entry : fieldValues.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.contains(parent)) continue;
                    String substr = StringUtils.substringAfterLast((String)key, (String)".");
                    collectionValues.put(substr, entry.getValue());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("values for sub collection: " + collectionValues);
                }
                GlobalVariables.getMessageMap().addToErrorPath("add." + parent + "." + collName);
                cachedValues.putAll(FieldUtils.populateBusinessObjectFromMap(this.getNewCollectionLine(parent + "." + collName), collectionValues, "add." + parent + "." + collName + "."));
                this.performFieldForceUpperCase(this.getNewCollectionLine(parent + "." + collName), collectionValues);
                GlobalVariables.getMessageMap().removeFromErrorPath("add." + parent + "." + collName);
            }
            cachedValues.putAll(this.populateNewSubCollectionLines(coll, fieldValues));
        }
        return cachedValues;
    }

    @Override
    public Collection<String> getAffectedReferencesFromLookup(BusinessObject baseBO, String attributeName, String collectionPrefix) {
        BusinessObjectMetaDataService businessObjectMetaDataService;
        DataObjectRelationship relationship;
        PersistenceStructureService pss = this.getPersistenceStructureService();
        String nestedBOPrefix = "";
        if (ObjectUtils.isNestedAttribute(attributeName)) {
            nestedBOPrefix = ObjectUtils.getNestedAttributePrefix(attributeName);
            Class reference = ObjectUtils.getPropertyType(baseBO, nestedBOPrefix, pss);
            if (!PersistableBusinessObject.class.isAssignableFrom(reference)) {
                return new ArrayList<String>();
            }
            try {
                baseBO = (PersistableBusinessObject)reference.newInstance();
            }
            catch (InstantiationException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            attributeName = ObjectUtils.getNestedAttributePrimitive(attributeName);
        }
        if (baseBO == null) {
            return new ArrayList<String>();
        }
        Map referenceNameToClassFromPSS = LookupUtils.getPrimitiveReference(baseBO, attributeName);
        if (referenceNameToClassFromPSS.size() > 1) {
            LOG.error("LookupUtils.getPrimitiveReference return results should only have at most one element");
        }
        if ((relationship = (businessObjectMetaDataService = this.getBusinessObjectMetaDataService()).getBusinessObjectRelationship(baseBO, attributeName)) == null) {
            return new ArrayList<String>();
        }
        Map fkToPkMappings = relationship.getParentToChildReferences();
        Collection<String> affectedReferences = this.generateAllAffectedReferences(baseBO.getClass(), fkToPkMappings, nestedBOPrefix, collectionPrefix);
        if (LOG.isDebugEnabled()) {
            LOG.debug("References affected by a lookup on BO attribute \"" + collectionPrefix + nestedBOPrefix + "." + attributeName + ": " + affectedReferences);
        }
        return affectedReferences;
    }

    protected boolean isRelationshipRefreshable(Class boClass, String relationshipName) {
        if (this.getPersistenceStructureService().isPersistable(boClass)) {
            if (this.getPersistenceStructureService().hasCollection(boClass, relationshipName)) {
                return !this.getPersistenceStructureService().isCollectionUpdatable(boClass, relationshipName);
            }
            if (this.getPersistenceStructureService().hasReference(boClass, relationshipName)) {
                return !this.getPersistenceStructureService().isReferenceUpdatable(boClass, relationshipName);
            }
        }
        return true;
    }

    protected Collection<String> generateAllAffectedReferences(Class boClass, Map<String, String> fkToPkMappings, String nestedBOPrefix, String collectionPrefix) {
        HashSet<String> allAffectedReferences = new HashSet<String>();
        DataDictionaryService dataDictionaryService = this.getDataDictionaryService();
        PersistenceStructureService pss = this.getPersistenceStructureService();
        collectionPrefix = StringUtils.isBlank((String)collectionPrefix) ? "" : collectionPrefix;
        Set<String> attributeReferenceFKAttributes = fkToPkMappings.keySet();
        for (String fkAttribute : attributeReferenceFKAttributes) {
            for (String string : pss.getReferencesForForeignKey(boClass, fkAttribute).keySet()) {
                if (!this.isRelationshipRefreshable(boClass, string)) continue;
                if (StringUtils.isBlank((String)nestedBOPrefix)) {
                    allAffectedReferences.add(collectionPrefix + string);
                    continue;
                }
                allAffectedReferences.add(collectionPrefix + nestedBOPrefix + "." + string);
            }
        }
        for (String collectionName : pss.listCollectionObjectTypes(boClass).keySet()) {
            if (!this.isRelationshipRefreshable(boClass, collectionName)) continue;
            Map<String, String> keyMappingsForCollection = pss.getInverseForeignKeysForCollection(boClass, collectionName);
            for (String collectionForeignKey : keyMappingsForCollection.keySet()) {
                if (!attributeReferenceFKAttributes.contains(collectionForeignKey)) continue;
                if (StringUtils.isBlank((String)nestedBOPrefix)) {
                    allAffectedReferences.add(collectionPrefix + collectionName);
                    continue;
                }
                allAffectedReferences.add(collectionPrefix + nestedBOPrefix + "." + collectionName);
            }
        }
        List ddDefinedRelationships = dataDictionaryService.getRelationshipNames(boClass.getName());
        for (String ddRelationship : ddDefinedRelationships) {
            Map map = dataDictionaryService.getRelationshipAttributeMap(boClass.getName(), ddRelationship);
            for (String sourceAttribute : map.values()) {
                if (!attributeReferenceFKAttributes.contains(sourceAttribute)) continue;
                for (String affectedReference : dataDictionaryService.getRelationshipEntriesForSourceAttribute(boClass.getName(), sourceAttribute)) {
                    if (!this.isRelationshipRefreshable(boClass, ddRelationship)) continue;
                    if (StringUtils.isBlank((String)nestedBOPrefix)) {
                        allAffectedReferences.add(affectedReference);
                        continue;
                    }
                    allAffectedReferences.add(nestedBOPrefix + "." + affectedReference);
                }
            }
        }
        return allAffectedReferences;
    }

    protected Collection<String> getAllRefreshableReferences(Class boClass) {
        HashSet<String> references = new HashSet<String>();
        for (String referenceName : this.getPersistenceStructureService().listReferenceObjectFields(boClass).keySet()) {
            if (!this.isRelationshipRefreshable(boClass, referenceName)) continue;
            references.add(referenceName);
        }
        for (String collectionName : this.getPersistenceStructureService().listCollectionObjectTypes(boClass).keySet()) {
            if (!this.isRelationshipRefreshable(boClass, collectionName)) continue;
            references.add(collectionName);
        }
        for (String relationshipName : this.getDataDictionaryService().getRelationshipNames(boClass.getName())) {
            if (!this.isRelationshipRefreshable(boClass, relationshipName)) continue;
            references.add(relationshipName);
        }
        return references;
    }

    protected void setNewCollectionLineDefaultValues(String collectionName, PersistableBusinessObject addLine) {
        PropertyDescriptor[] descriptors = PropertyUtils.getPropertyDescriptors((Object)addLine);
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = descriptors[i];
            String fieldName = propertyDescriptor.getName();
            Class<?> propertyType = propertyDescriptor.getPropertyType();
            String value = this.getMaintenanceDocumentDictionaryService().getCollectionFieldDefaultValue(this.getDocumentTypeName(), collectionName, fieldName);
            if (value == null) continue;
            try {
                ObjectUtils.setObjectProperty(addLine, fieldName, propertyType, value);
                continue;
            }
            catch (Exception ex) {
                LOG.error("Unable to set default property of collection object: \nobject: " + addLine + "\nfieldName=" + fieldName + "\npropertyType=" + propertyType + "\nvalue=" + value, (Throwable)ex);
            }
        }
    }

    @Override
    public void clearBusinessObjectOfRestrictedValues(MaintenanceDocumentRestrictions maintenanceDocumentRestrictions) {
        List<MaintainableSectionDefinition> sections = this.getMaintenanceDocumentDictionaryService().getMaintainableSections(this.getDocumentTypeName());
        for (MaintainableSectionDefinition sectionDefinition : sections) {
            for (MaintainableItemDefinition itemDefinition : sectionDefinition.getMaintainableItems()) {
                if (itemDefinition instanceof MaintainableFieldDefinition) {
                    this.clearFieldRestrictedValues("", this.businessObject, (MaintainableFieldDefinition)itemDefinition, maintenanceDocumentRestrictions);
                    continue;
                }
                if (!(itemDefinition instanceof MaintainableCollectionDefinition)) continue;
                this.clearCollectionRestrictedValues("", this.businessObject, (MaintainableCollectionDefinition)itemDefinition, maintenanceDocumentRestrictions);
            }
        }
    }

    protected void clearCollectionRestrictedValues(String fieldNamePrefix, BusinessObject businessObject, MaintainableCollectionDefinition collectionDefinition, MaintenanceDocumentRestrictions maintenanceDocumentRestrictions) {
        String collectionName = fieldNamePrefix + collectionDefinition.getName();
        Collection collection = (Collection)ObjectUtils.getPropertyValue(businessObject, collectionDefinition.getName());
        if (collection != null) {
            int i = 0;
            for (BusinessObject collectionItem : collection) {
                String collectionItemNamePrefix = collectionName + "[" + i + "].";
                for (MaintainableCollectionDefinition subCollectionDefinition : collectionDefinition.getMaintainableCollections()) {
                    this.clearCollectionRestrictedValues(collectionItemNamePrefix, collectionItem, subCollectionDefinition, maintenanceDocumentRestrictions);
                }
                for (MaintainableFieldDefinition fieldDefinition : collectionDefinition.getMaintainableFields()) {
                    this.clearFieldRestrictedValues(collectionItemNamePrefix, collectionItem, fieldDefinition, maintenanceDocumentRestrictions);
                }
                ++i;
            }
        }
    }

    protected void clearFieldRestrictedValues(String fieldNamePrefix, BusinessObject businessObject, MaintainableFieldDefinition fieldDefinition, MaintenanceDocumentRestrictions maintenanceDocumentRestrictions) {
        String fieldName = fieldNamePrefix + fieldDefinition.getName();
        FieldRestriction fieldRestriction = maintenanceDocumentRestrictions.getFieldRestriction(fieldName);
        if (fieldRestriction.isRestricted()) {
            String defaultValue = null;
            if (StringUtils.isNotBlank((String)fieldDefinition.getDefaultValue())) {
                defaultValue = fieldDefinition.getDefaultValue();
            } else if (fieldDefinition.getDefaultValueFinderClass() != null) {
                try {
                    defaultValue = fieldDefinition.getDefaultValueFinderClass().newInstance().getValue();
                }
                catch (Exception e) {
                    defaultValue = null;
                    LOG.error("Error trying to instantiate ValueFinder or to determine ValueFinder for doc type: " + this.getDocumentTypeName() + " field name " + fieldDefinition.getName() + " with field prefix: " + fieldNamePrefix, (Throwable)e);
                }
            }
            try {
                ObjectUtils.setObjectProperty(businessObject, fieldDefinition.getName(), defaultValue);
            }
            catch (Exception e) {
                LOG.error("Unable to clear maintenance document values for field name: " + fieldName + " default value: " + defaultValue, (Throwable)e);
                throw new RuntimeException("Unable to clear maintenance document values for field name: " + fieldName, e);
            }
        }
    }

    protected void performForceUpperCase(Map fieldValues) {
        List<MaintainableSectionDefinition> sections = this.getMaintenanceDocumentDictionaryService().getMaintainableSections(this.getDocumentTypeName());
        for (MaintainableSectionDefinition sectionDefinition : sections) {
            for (MaintainableItemDefinition itemDefinition : sectionDefinition.getMaintainableItems()) {
                if (itemDefinition instanceof MaintainableFieldDefinition) {
                    this.performFieldForceUpperCase("", this.businessObject, (MaintainableFieldDefinition)itemDefinition, fieldValues);
                    continue;
                }
                if (!(itemDefinition instanceof MaintainableCollectionDefinition)) continue;
                this.performCollectionForceUpperCase("", this.businessObject, (MaintainableCollectionDefinition)itemDefinition, fieldValues);
            }
        }
    }

    protected void performFieldForceUpperCase(String fieldNamePrefix, BusinessObject bo, MaintainableFieldDefinition fieldDefinition, Map fieldValues) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        String fieldName = fieldDefinition.getName();
        String mapKey = fieldNamePrefix + fieldName;
        if (fieldValues != null && fieldValues.get(mapKey) != null && PropertyUtils.isWriteable((Object)bo, (String)fieldName) && ObjectUtils.getNestedValue(bo, fieldName) != null) {
            try {
                Class type = ObjectUtils.easyGetPropertyType(bo, fieldName);
                Class<?> businessObjectClass = bo.getClass();
                boolean upperCase = false;
                try {
                    upperCase = this.getDataDictionaryService().getAttributeForceUppercase(businessObjectClass, fieldName);
                }
                catch (UnknownBusinessClassAttributeException t) {
                    boolean bl = true;
                }
                Object fieldValue = ObjectUtils.getNestedValue(bo, fieldName);
                if (upperCase && fieldValue instanceof String) {
                    fieldValue = ((String)fieldValue).toUpperCase();
                }
                ObjectUtils.setObjectProperty(bo, fieldName, type, fieldValue);
            }
            catch (FormatException e) {
                errorMap.putError(fieldName, e.getErrorKey(), e.getErrorArgs());
            }
            catch (IllegalAccessException e) {
                LOG.error("unable to populate business object" + e.getMessage());
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                LOG.error("unable to populate business object" + e.getMessage());
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                LOG.error("unable to populate business object" + e.getMessage());
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    protected void performCollectionForceUpperCase(String fieldNamePrefix, BusinessObject bo, MaintainableCollectionDefinition collectionDefinition, Map fieldValues) {
        String collectionName = fieldNamePrefix + collectionDefinition.getName();
        Collection collection = (Collection)ObjectUtils.getPropertyValue(bo, collectionDefinition.getName());
        if (collection != null) {
            int i = 0;
            for (BusinessObject collectionItem : collection) {
                String collectionItemNamePrefix = collectionName + "[" + i + "].";
                for (MaintainableFieldDefinition fieldDefinition : collectionDefinition.getMaintainableFields()) {
                    this.performFieldForceUpperCase(collectionItemNamePrefix, collectionItem, fieldDefinition, fieldValues);
                }
                for (MaintainableCollectionDefinition subCollectionDefinition : collectionDefinition.getMaintainableCollections()) {
                    this.performCollectionForceUpperCase(collectionItemNamePrefix, collectionItem, subCollectionDefinition, fieldValues);
                }
                ++i;
            }
        }
    }

    protected void performFieldForceUpperCase(BusinessObject bo, Map fieldValues) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        try {
            for (String propertyName : fieldValues.keySet()) {
                if (!PropertyUtils.isWriteable((Object)bo, (String)propertyName) || fieldValues.get(propertyName) == null) continue;
                Class type = ObjectUtils.easyGetPropertyType(bo, propertyName);
                try {
                    Class<?> businessObjectClass = bo.getClass();
                    boolean upperCase = false;
                    try {
                        upperCase = this.getDataDictionaryService().getAttributeForceUppercase(businessObjectClass, propertyName);
                    }
                    catch (UnknownBusinessClassAttributeException t) {
                        boolean bl = true;
                    }
                    Object fieldValue = fieldValues.get(propertyName);
                    if (upperCase && fieldValue instanceof String) {
                        fieldValue = ((String)fieldValue).toUpperCase();
                    }
                    ObjectUtils.setObjectProperty(bo, propertyName, type, fieldValue);
                }
                catch (FormatException e) {
                    errorMap.putError(propertyName, e.getErrorKey(), e.getErrorArgs());
                }
            }
        }
        catch (IllegalAccessException e) {
            LOG.error("unable to populate business object" + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            LOG.error("unable to populate business object" + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            LOG.error("unable to populate business object" + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean isExternalBusinessObject() {
        return false;
    }

    @Override
    public void prepareBusinessObject(BusinessObject businessObject) {
    }

    @Override
    public void deleteBusinessObject() {
        if (this.businessObject == null) {
            return;
        }
        KNSServiceLocator.getBusinessObjectService().delete(this.businessObject);
        this.businessObject = null;
    }

    @Override
    public boolean isOldBusinessObjectInDocument() {
        return super.isOldDataObjectInDocument();
    }

    protected BusinessObjectDictionaryService getBusinessObjectDictionaryService() {
        if (this.businessObjectDictionaryService == null) {
            this.businessObjectDictionaryService = KNSServiceLocator.getBusinessObjectDictionaryService();
        }
        return this.businessObjectDictionaryService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KimApiServiceLocator.getPersonService();
        }
        return this.personService;
    }

    @Deprecated
    protected BusinessObjectMetaDataService getBusinessObjectMetaDataService() {
        if (this.businessObjectMetaDataService == null) {
            this.businessObjectMetaDataService = KNSServiceLocator.getBusinessObjectMetaDataService();
        }
        return this.businessObjectMetaDataService;
    }

    protected BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        if (this.businessObjectAuthorizationService == null) {
            this.businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
        }
        return this.businessObjectAuthorizationService;
    }

    protected DocumentHelperService getDocumentHelperService() {
        if (this.documentHelperService == null) {
            this.documentHelperService = KNSServiceLocator.getDocumentHelperService();
        }
        return this.documentHelperService;
    }

    public void setBusinessObjectDictionaryService(BusinessObjectDictionaryService businessObjectDictionaryService) {
        this.businessObjectDictionaryService = businessObjectDictionaryService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    @Deprecated
    public void setBusinessObjectMetaDataService(BusinessObjectMetaDataService businessObjectMetaDataService) {
        this.businessObjectMetaDataService = businessObjectMetaDataService;
    }

    public void setBusinessObjectAuthorizationService(BusinessObjectAuthorizationService businessObjectAuthorizationService) {
        this.businessObjectAuthorizationService = businessObjectAuthorizationService;
    }

    public void setDocumentHelperService(DocumentHelperService documentHelperService) {
        this.documentHelperService = documentHelperService;
    }

    public MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (this.maintenanceDocumentDictionaryService == null) {
            this.maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return this.maintenanceDocumentDictionaryService;
    }

    public void setMaintenanceDocumentDictionaryService(MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService) {
        this.maintenanceDocumentDictionaryService = maintenanceDocumentDictionaryService;
    }

    @Deprecated
    protected DataObjectMetaDataService getDataObjectMetaDataService() {
        if (this.dataObjectMetaDataService == null) {
            this.dataObjectMetaDataService = KNSServiceLocator.getDataObjectMetaDataService();
        }
        return this.dataObjectMetaDataService;
    }

    @Deprecated
    public void setDataObjectMetaDataService(DataObjectMetaDataService dataObjectMetaDataService) {
        this.dataObjectMetaDataService = dataObjectMetaDataService;
    }

    public PersistenceStructureService getPersistenceStructureService() {
        return KNSServiceLocator.getPersistenceStructureService();
    }
}

