/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.sql;

import java.lang.ref.WeakReference;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.sql.SqlStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.logging.Logger;

public abstract class SqlPkStatement
implements SqlStatement {
    private WeakReference m_classDescriptor;
    private Logger m_logger;

    public SqlPkStatement(ClassDescriptor classDescriptor, Logger logger) {
        this.m_classDescriptor = new WeakReference<ClassDescriptor>(classDescriptor);
        this.m_logger = logger;
    }

    protected void appendTable(ClassDescriptor classDescriptor, StringBuffer stringBuffer) {
        stringBuffer.append(classDescriptor.getFullTableName());
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    protected ClassDescriptor getClassDescriptor() {
        ClassDescriptor classDescriptor = (ClassDescriptor)this.m_classDescriptor.get();
        if (classDescriptor == null) {
            throw new OJBRuntimeException("Requested ClassDescriptor instance was already GC by JVM");
        }
        return classDescriptor;
    }

    protected void appendWhereClause(FieldDescriptor[] fieldDescriptorArray, StringBuffer stringBuffer) throws PersistenceBrokerException {
        stringBuffer.append(" WHERE ");
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            FieldDescriptor fieldDescriptor = fieldDescriptorArray[i];
            stringBuffer.append(fieldDescriptor.getColumnName());
            stringBuffer.append(" = ? ");
            if (i >= fieldDescriptorArray.length - 1) continue;
            stringBuffer.append(" AND ");
        }
    }

    protected void appendWhereClause(ClassDescriptor classDescriptor, boolean bl, StringBuffer stringBuffer) {
        FieldDescriptor[] fieldDescriptorArray;
        FieldDescriptor[] fieldDescriptorArray2;
        FieldDescriptor[] fieldDescriptorArray3 = fieldDescriptorArray2 = classDescriptor.getPkFields();
        if (bl && (fieldDescriptorArray = classDescriptor.getLockingFields()).length > 0) {
            fieldDescriptorArray3 = new FieldDescriptor[fieldDescriptorArray2.length + fieldDescriptorArray.length];
            System.arraycopy(fieldDescriptorArray2, 0, fieldDescriptorArray3, 0, fieldDescriptorArray2.length);
            System.arraycopy(fieldDescriptorArray, 0, fieldDescriptorArray3, fieldDescriptorArray2.length, fieldDescriptorArray.length);
        }
        this.appendWhereClause(fieldDescriptorArray3, stringBuffer);
    }
}

