/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.kuali.rice.krad.datadictionary.mask.MaskFormatter;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;

@BeanTag(name="attributeSecurity")
public class AttributeSecurity
extends UifDictionaryBeanBase {
    private static final long serialVersionUID = -7923499408946975318L;
    private boolean readOnly = false;
    private boolean hide = false;
    private boolean mask = false;
    private boolean partialMask = false;
    private MaskFormatter partialMaskFormatter;
    private MaskFormatter maskFormatter;

    @BeanTagAttribute(name="readOnly")
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @BeanTagAttribute(name="hide")
    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    @BeanTagAttribute(name="mask")
    public boolean isMask() {
        return this.mask;
    }

    public void setMask(boolean mask) {
        this.mask = mask;
    }

    @BeanTagAttribute(name="partialMask")
    public boolean isPartialMask() {
        return this.partialMask;
    }

    public void setPartialMask(boolean partialMask) {
        this.partialMask = partialMask;
    }

    @BeanTagAttribute(name="maskFormatter", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public MaskFormatter getMaskFormatter() {
        return this.maskFormatter;
    }

    public void setMaskFormatter(MaskFormatter maskFormatter) {
        this.maskFormatter = maskFormatter;
    }

    @BeanTagAttribute(name="partialMaskFormatter", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public MaskFormatter getPartialMaskFormatter() {
        return this.partialMaskFormatter;
    }

    public void setPartialMaskFormatter(MaskFormatter partialMaskFormatter) {
        this.partialMaskFormatter = partialMaskFormatter;
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass) {
        this.completeValidation(rootBusinessObjectClass, otherBusinessObjectClass, new ValidationTrace());
    }

    public void completeValidation(Class rootBusinessObjectClass, Class otherBusinessObjectClass, ValidationTrace tracer) {
        String[] currentValues;
        tracer.addBean(this.getClass().getSimpleName(), "NOBEANID");
        if (this.mask && this.maskFormatter == null) {
            currentValues = new String[]{"mask = " + this.mask, "maskFormatter = " + this.maskFormatter};
            tracer.createError("MaskFormatter is required", currentValues);
        }
        if (this.partialMask && this.partialMaskFormatter == null) {
            currentValues = new String[]{"partialMask = " + this.partialMask, "partialMaskFormatter = " + this.partialMaskFormatter};
            tracer.createError("PartialMaskFormatter is required", currentValues);
        }
    }

    public boolean hasAnyRestriction() {
        return this.readOnly || this.mask || this.partialMask || this.hide;
    }

    public boolean hasRestrictionThatRemovesValueFromUI() {
        return this.mask || this.partialMask || this.hide;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DataObjectAttributeSecurityBase [readOnly=").append(this.readOnly).append(", hide=").append(this.hide).append(", mask=").append(this.mask).append(", partialMask=").append(this.partialMask).append(", ");
        if (this.maskFormatter != null) {
            builder.append("maskFormatter=").append(this.maskFormatter).append(", ");
        }
        if (this.partialMaskFormatter != null) {
            builder.append("partialMaskFormatter=").append(this.partialMaskFormatter);
        }
        builder.append("]");
        return builder.toString();
    }
}

