/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary.validation.constraint;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validation.constraint.ValidCharactersPatternConstraint;
import org.kuali.rice.krad.messages.MessageService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public abstract class AllowCharacterConstraint
extends ValidCharactersPatternConstraint {
    protected boolean allowWhitespace = false;
    protected boolean omitNewline = false;
    protected boolean allowUnderscore = false;
    protected boolean allowPeriod = false;
    protected boolean allowParenthesis = false;
    protected boolean allowDollar = false;
    protected boolean allowForwardSlash = false;
    protected boolean allowDoubleQuote = false;
    protected boolean allowApostrophe = false;
    protected boolean allowComma = false;
    protected boolean allowColon = false;
    protected boolean allowSemiColon = false;
    protected boolean allowQuestionMark = false;
    protected boolean allowExclaimation = false;
    protected boolean allowDash = false;
    protected boolean allowPlus = false;
    protected boolean allowEquals = false;
    protected boolean allowAsterisk = false;
    protected boolean allowAtSign = false;
    protected boolean allowPercent = false;
    protected boolean allowPound = false;
    protected boolean allowGreaterThan = false;
    protected boolean allowLessThan = false;
    protected boolean allowBrackets = false;
    protected boolean allowAmpersand = false;
    protected boolean allowCurlyBraces = false;
    protected boolean allowBackslash = false;
    protected boolean allowAll = false;

    @BeanTagAttribute(name="allowWhitespace")
    public boolean isAllowWhitespace() {
        return this.allowWhitespace;
    }

    public void setAllowWhitespace(boolean allowWhitespace) {
        this.allowWhitespace = allowWhitespace;
    }

    @BeanTagAttribute(name="allowUnderscore")
    public boolean isAllowUnderscore() {
        return this.allowUnderscore;
    }

    public void setAllowUnderscore(boolean allowUnderscore) {
        this.allowUnderscore = allowUnderscore;
    }

    @BeanTagAttribute(name="allowPeriod")
    public boolean isAllowPeriod() {
        return this.allowPeriod;
    }

    public void setAllowPeriod(boolean allowPeriod) {
        this.allowPeriod = allowPeriod;
    }

    @BeanTagAttribute(name="allowParenthesis")
    public boolean isAllowParenthesis() {
        return this.allowParenthesis;
    }

    public void setAllowParenthesis(boolean allowParenthesis) {
        this.allowParenthesis = allowParenthesis;
    }

    @BeanTagAttribute(name="allowDollar")
    public boolean isAllowDollar() {
        return this.allowDollar;
    }

    public void setAllowDollar(boolean allowDollar) {
        this.allowDollar = allowDollar;
    }

    @BeanTagAttribute(name="allowForwardSlash")
    public boolean isAllowForwardSlash() {
        return this.allowForwardSlash;
    }

    public void setAllowForwardSlash(boolean allowForwardSlash) {
        this.allowForwardSlash = allowForwardSlash;
    }

    @BeanTagAttribute(name="allowDoubleQuote")
    public boolean isAllowDoubleQuote() {
        return this.allowDoubleQuote;
    }

    public void setAllowDoubleQuote(boolean allowDoubleQuote) {
        this.allowDoubleQuote = allowDoubleQuote;
    }

    @BeanTagAttribute(name="allowApostrophe")
    public boolean isAllowApostrophe() {
        return this.allowApostrophe;
    }

    public void setAllowApostrophe(boolean allowApostrophe) {
        this.allowApostrophe = allowApostrophe;
    }

    @BeanTagAttribute(name="allowComma")
    public boolean isAllowComma() {
        return this.allowComma;
    }

    public void setAllowComma(boolean allowComma) {
        this.allowComma = allowComma;
    }

    @BeanTagAttribute(name="allowColon")
    public boolean isAllowColon() {
        return this.allowColon;
    }

    public void setAllowColon(boolean allowColon) {
        this.allowColon = allowColon;
    }

    @BeanTagAttribute(name="allowSemiColon")
    public boolean isAllowSemiColon() {
        return this.allowSemiColon;
    }

    public void setAllowSemiColon(boolean allowSemiColon) {
        this.allowSemiColon = allowSemiColon;
    }

    @BeanTagAttribute(name="allowQuestionMark")
    public boolean isAllowQuestionMark() {
        return this.allowQuestionMark;
    }

    public void setAllowQuestionMark(boolean allowQuestionMark) {
        this.allowQuestionMark = allowQuestionMark;
    }

    @BeanTagAttribute(name="allowExclaimation")
    public boolean isAllowExclaimation() {
        return this.allowExclaimation;
    }

    public void setAllowExclaimation(boolean allowExclaimation) {
        this.allowExclaimation = allowExclaimation;
    }

    @BeanTagAttribute(name="allowDash")
    public boolean isAllowDash() {
        return this.allowDash;
    }

    public void setAllowDash(boolean allowDash) {
        this.allowDash = allowDash;
    }

    @BeanTagAttribute(name="allowPlus")
    public boolean isAllowPlus() {
        return this.allowPlus;
    }

    public void setAllowPlus(boolean allowPlus) {
        this.allowPlus = allowPlus;
    }

    @BeanTagAttribute(name="allowEquals")
    public boolean isAllowEquals() {
        return this.allowEquals;
    }

    public void setAllowEquals(boolean allowEquals) {
        this.allowEquals = allowEquals;
    }

    @BeanTagAttribute(name="allowAsterisk")
    public boolean isAllowAsterisk() {
        return this.allowAsterisk;
    }

    public void setAllowAsterisk(boolean allowAsterisk) {
        this.allowAsterisk = allowAsterisk;
    }

    @BeanTagAttribute(name="allowAtSign")
    public boolean isAllowAtSign() {
        return this.allowAtSign;
    }

    public void setAllowAtSign(boolean allowAtSign) {
        this.allowAtSign = allowAtSign;
    }

    @BeanTagAttribute(name="allowPercent")
    public boolean isAllowPercent() {
        return this.allowPercent;
    }

    public void setAllowPercent(boolean allowPercent) {
        this.allowPercent = allowPercent;
    }

    @BeanTagAttribute(name="allowPound")
    public boolean isAllowPound() {
        return this.allowPound;
    }

    public void setAllowPound(boolean allowPound) {
        this.allowPound = allowPound;
    }

    @BeanTagAttribute(name="allowGreaterThan")
    public boolean isAllowGreaterThan() {
        return this.allowGreaterThan;
    }

    public void setAllowGreaterThan(boolean allowGreaterThan) {
        this.allowGreaterThan = allowGreaterThan;
    }

    @BeanTagAttribute(name="allowLessThan")
    public boolean isAllowLessThan() {
        return this.allowLessThan;
    }

    public void setAllowLessThan(boolean allowLessThan) {
        this.allowLessThan = allowLessThan;
    }

    @BeanTagAttribute(name="allowBrackets")
    public boolean isAllowBrackets() {
        return this.allowBrackets;
    }

    public void setAllowBrackets(boolean allowBrackets) {
        this.allowBrackets = allowBrackets;
    }

    @BeanTagAttribute(name="allowAmpersand")
    public boolean isAllowAmpersand() {
        return this.allowAmpersand;
    }

    public void setAllowAmpersand(boolean allowAmpersand) {
        this.allowAmpersand = allowAmpersand;
    }

    @BeanTagAttribute(name="allowCurlyBraces")
    public boolean isAllowCurlyBraces() {
        return this.allowCurlyBraces;
    }

    public void setAllowCurlyBraces(boolean allowCurlyBraces) {
        this.allowCurlyBraces = allowCurlyBraces;
    }

    @BeanTagAttribute(name="allowBackslash")
    public boolean isAllowBackslash() {
        return this.allowBackslash;
    }

    public void setAllowBackslash(boolean allowBackslash) {
        this.allowBackslash = allowBackslash;
    }

    @BeanTagAttribute(name="allowAll")
    public boolean isAllowAll() {
        return this.allowAll;
    }

    public void setAllowAll(boolean allowAll) {
        this.allowAll = allowAll;
    }

    @BeanTagAttribute(name="omitNewline")
    public boolean isOmitNewline() {
        return this.omitNewline;
    }

    public void setOmitNewline(boolean omitNewline) {
        this.omitNewline = omitNewline;
    }

    protected String getAllowedCharacterRegex() {
        StringBuilder regexString = new StringBuilder("");
        if (this.allowWhitespace || this.allowAll) {
            regexString.append("\\t\\v\\040");
            if (!this.omitNewline) {
                regexString.append("\\f\\r\\n");
            }
        }
        if (this.allowUnderscore || this.allowAll) {
            regexString.append("_");
        }
        if (this.allowPeriod || this.allowAll) {
            regexString.append(".");
        }
        if (this.allowParenthesis || this.allowAll) {
            regexString.append("(");
            regexString.append(")");
        }
        if (this.allowDollar || this.allowAll) {
            regexString.append("$");
        }
        if (this.allowForwardSlash || this.allowAll) {
            regexString.append("/");
        }
        if (this.allowDoubleQuote || this.allowAll) {
            regexString.append("\\\"");
        }
        if (this.allowApostrophe || this.allowAll) {
            regexString.append("'");
        }
        if (this.allowComma || this.allowAll) {
            regexString.append(",");
        }
        if (this.allowColon || this.allowAll) {
            regexString.append(":");
        }
        if (this.allowSemiColon || this.allowAll) {
            regexString.append(";");
        }
        if (this.allowQuestionMark || this.allowAll) {
            regexString.append("?");
        }
        if (this.allowExclaimation || this.allowAll) {
            regexString.append("!");
        }
        if (this.allowDash || this.allowAll) {
            regexString.append("\\-");
        }
        if (this.allowPlus || this.allowAll) {
            regexString.append("+");
        }
        if (this.allowEquals || this.allowAll) {
            regexString.append("=");
        }
        if (this.allowAsterisk || this.allowAll) {
            regexString.append("*");
        }
        if (this.allowAtSign || this.allowAll) {
            regexString.append("@");
        }
        if (this.allowPercent || this.allowAll) {
            regexString.append("%");
        }
        if (this.allowPound || this.allowAll) {
            regexString.append("#");
        }
        if (this.allowLessThan || this.allowAll) {
            regexString.append("\\0074");
        }
        if (this.allowGreaterThan || this.allowAll) {
            regexString.append("\\0076");
        }
        if (this.allowAmpersand || this.allowAll) {
            regexString.append("\\0046");
        }
        if (this.allowBackslash || this.allowAll) {
            regexString.append("\\0134");
        }
        if (this.allowCurlyBraces || this.allowAll) {
            regexString.append("\\0173\\0175");
        }
        if (this.allowBrackets || this.allowAll) {
            regexString.append("\\0133\\0135");
        }
        return regexString.toString();
    }

    @Override
    public List<String> getValidationMessageParams() {
        if (this.validationMessageParams == null) {
            this.validationMessageParams = new ArrayList();
            MessageService messageService = KRADServiceLocatorWeb.getMessageService();
            StringBuilder paramString = new StringBuilder("");
            if (this.allowWhitespace || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.whitespace"));
                if (!this.omitNewline) {
                    paramString.append(", " + messageService.getMessageText("validation.newline"));
                }
            }
            if (this.allowUnderscore || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.underscore"));
            }
            if (this.allowPeriod || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.period"));
            }
            if (this.allowParenthesis || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.parenthesis"));
            }
            if (this.allowDollar || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.dollar"));
            }
            if (this.allowForwardSlash || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.forwardSlash"));
            }
            if (this.allowDoubleQuote || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.doubleQuote"));
            }
            if (this.allowApostrophe || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.apostrophe"));
            }
            if (this.allowComma || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.comma"));
            }
            if (this.allowColon || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.colon"));
            }
            if (this.allowSemiColon || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.semiColon"));
            }
            if (this.allowQuestionMark || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.questionMark"));
            }
            if (this.allowExclaimation || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.exclaimation"));
            }
            if (this.allowDash || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.dash"));
            }
            if (this.allowPlus || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.plus"));
            }
            if (this.allowEquals || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.equals"));
            }
            if (this.allowAsterisk || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.asterisk"));
            }
            if (this.allowAtSign || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.atSign"));
            }
            if (this.allowPercent || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.percent"));
            }
            if (this.allowPound || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.pound"));
            }
            if (this.allowLessThan || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.lessThan"));
            }
            if (this.allowGreaterThan || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.greaterThan"));
            }
            if (this.allowAmpersand || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.ampersand"));
            }
            if (this.allowBackslash || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.backslash"));
            }
            if (this.allowCurlyBraces || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.curlyBraces"));
            }
            if (this.allowBrackets || this.allowAll) {
                paramString.append(", " + messageService.getMessageText("validation.brackets"));
            }
            this.validationMessageParams.add(paramString.toString());
        }
        return this.validationMessageParams;
    }
}

