/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.sponsor.term.SponsorTerm;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.award.AwardDocumentRule;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncPendingChangeBean;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTrackingBean;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentSchedule;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.kra.award.web.struts.action.SponsorTermActionHelper;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.PersistenceService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardPaymentReportsAndTermsAction
extends AwardAction {
    private static final Logger LOG = LogManager.getLogger(AwardPaymentReportsAndTermsAction.class);
    private static final String ROLODEX = "rolodex";
    private static final String PERIOD = ".";
    private static final String AWARD_REPORT_TERM_PROPERTY = "awardReportTermItems";
    private SponsorTermActionHelper sponsorTermActionHelper = new SponsorTermActionHelper();

    public ActionForward clearRolodex(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getAwardReportsBean().getNewAwardReportTermRecipient(this.getAwardReportTermIndex(request)).setRolodexId(null);
        ((AwardForm)form).getAwardReportsBean().getNewAwardReportTermRecipient(this.getAwardReportTermIndex(request)).setRolodex(null);
        return mapping.findForward("basic");
    }

    public ActionForward addPaymentScheduleItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getPaymentScheduleBean().addPaymentScheduleItem();
        return mapping.findForward("basic");
    }

    public ActionForward deletePaymentScheduleItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getPaymentScheduleBean().deletePaymentScheduleItem(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward generatePaymentSchedules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getPaymentScheduleBean().generatePaymentSchedules();
        return mapping.findForward("basic");
    }

    public ActionForward addApprovedEquipmentItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getApprovedEquipmentBean().addApprovedEquipmentItem();
        return mapping.findForward("basic");
    }

    public ActionForward addApprovedForeignTravel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getApprovedForeignTravelBean().addApprovedForeignTravel();
        return mapping.findForward("basic");
    }

    public ActionForward recalculateSpecialApprovalTotals(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward recalculateCostShareTotal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward refreshPulldownOptions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        awardForm.getApprovedForeignTravelBean().refreshTravelers();
        this.refreshAwardReportTermRecipients(awardForm, awardDocument);
        String lookupResultsBOClassName = request.getParameter("lookupResultsBOClassName");
        String lookupResultsSequenceNumber = request.getParameter("lookupResultsSequenceNumber");
        awardForm.setLookupResultsBOClassName(lookupResultsBOClassName);
        awardForm.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        ArrayList<AwardSyncPendingChangeBean> pendingChanges = new ArrayList<AwardSyncPendingChangeBean>();
        try {
            String thisLookupResultsSequenceNumber;
            if ("multipleValues".equals(awardForm.getRefreshCaller()) && StringUtils.isNotBlank((CharSequence)(thisLookupResultsSequenceNumber = awardForm.getLookupResultsSequenceNumber()))) {
                Class<SponsorTerm> lookupResultsBOClass = Class.forName(awardForm.getLookupResultsBOClassName());
                Collection rawValues = KNSServiceLocator.getLookupResultsService().retrieveSelectedResultBOs(thisLookupResultsSequenceNumber, lookupResultsBOClass, GlobalVariables.getUserSession().getPrincipalId());
                if (lookupResultsBOClass.isAssignableFrom(SponsorTerm.class)) {
                    for (SponsorTerm sponsorTerm : rawValues) {
                        AwardSponsorTerm awardSponsorTerm = this.sponsorTermActionHelper.addSponsorTermFromMutiValueLookup(((AwardForm)form).getSponsorTermFormHelper(), sponsorTerm, request);
                        if (awardSponsorTerm == null) continue;
                        pendingChanges.add(new AwardSyncPendingChangeBean(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)awardSponsorTerm, "awardSponsorTerms"));
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.error("exception in refresh", (Throwable)ex);
        }
        if (!pendingChanges.isEmpty()) {
            return this.confirmSyncAction(mapping, form, request, response, pendingChanges, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        ActionForward actionForward = super.reload(mapping, form, request, response);
        this.setReportsAndTermsOnAwardForm(awardForm);
        return actionForward;
    }

    public ActionForward addAwardReportTerm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (new AwardDocumentRule().processAwardReportTermSaveRules((AwardForm)form)) {
            AwardReportTerm newReport = ((AwardForm)form).getAwardReportsBean().addAwardReportTermItem(this.getReportClass(request), this.getReportClassCodeIndex(request));
            if (newReport != null) {
                ActionForward confirmSynch = this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)newReport, AWARD_REPORT_TERM_PROPERTY, null, mapping.findForward("basic"));
                ((AwardForm)form).getReportTrackingBeans().add(new ReportTrackingBean());
                return confirmSynch;
            }
            return mapping.findForward("basic");
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteAwardReportTerm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        AwardReportTerm deletedReport = awardForm.getAwardReportsBean().deleteAwardReportTermItem(this.getLineToDelete(request));
        ActionForward af = this.confirmSyncAction(mapping, form, request, response, AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)deletedReport, AWARD_REPORT_TERM_PROPERTY, null, mapping.findForward("basic"));
        List<ReportTracking> reportTrackings = this.getReportTrackingService().getReportTracking(deletedReport);
        awardForm.getReportTrackingsToDelete().addAll(reportTrackings);
        List schedulesToDelete = award.getPaymentScheduleItems().stream().filter(schedule -> this.scheduleBelongsToReportTerm((AwardPaymentSchedule)schedule, deletedReport)).collect(Collectors.toList());
        award.getPaymentScheduleItems().removeAll(schedulesToDelete);
        this.getBusinessObjectService().delete(schedulesToDelete);
        return af;
    }

    private boolean scheduleBelongsToReportTerm(AwardPaymentSchedule schedule, AwardReportTerm term) {
        return term.equals(schedule.getAwardReportTerm()) || schedule.getAwardReportTermId() != null && schedule.getAwardReportTermId().equals(term.getAwardReportTermId());
    }

    public ActionForward deleteReportTrackingRecord(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardReportsBean().deleteAwardReportTermTracking(this.getAwardReportTermItemIndex(request), this.getLineToDelete(request)).ifPresent(deletedTracking -> awardForm.getReportTrackingsToDelete().add((ReportTracking)deletedTracking));
        return mapping.findForward("basic");
    }

    public ActionForward addAwardCloseout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getAwardCloseoutBean().addAwardCloseoutItem();
        return mapping.findForward("basic");
    }

    public ActionForward deleteAwardCloseout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getAwardCloseoutBean().deleteAwardCloseoutItem(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteApprovedEquipmentItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getApprovedEquipmentBean().deleteApprovedEquipmentItem(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteApprovedForeignTravelTrip(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getApprovedForeignTravelBean().deleteApprovedForeignTravelTrip(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward addRecipient(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardReportTermRecipient newRecipient = ((AwardForm)form).getAwardReportsBean().addAwardReportTermRecipientItem(this.getAwardReportTermIndex(request));
        if (newRecipient != null) {
            return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)newRecipient, AWARD_REPORT_TERM_PROPERTY, null, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteRecipient(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardReportTermRecipient recipient = ((AwardForm)form).getAwardReportsBean().deleteAwardReportTermRecipientItem(this.getAwardReportTermIndex(request), this.getLineToDelete(request));
        return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)recipient, AWARD_REPORT_TERM_PROPERTY, null, mapping.findForward("basic"));
    }

    protected String getReportClass(HttpServletRequest request) {
        int reportClass = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            String reportClassString = StringUtils.substringBetween((String)parameterName, (String)".reportClass", (String)PERIOD);
            reportClass = Integer.parseInt(reportClassString);
        }
        return new Integer(reportClass).toString();
    }

    protected int getReportClassCodeIndex(HttpServletRequest request) {
        int reportClassIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            String reportClassIndexString = StringUtils.substringBetween((String)parameterName, (String)".reportClassIndex", (String)PERIOD);
            reportClassIndex = Integer.parseInt(reportClassIndexString);
        }
        return reportClassIndex;
    }

    protected int getAwardReportTermIndex(HttpServletRequest request) {
        int awardReportTermIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            String awardReportTermIndexString = StringUtils.substringBetween((String)parameterName, (String)".awardReportTerm", (String)PERIOD);
            awardReportTermIndex = Integer.parseInt(awardReportTermIndexString);
        }
        return awardReportTermIndex;
    }

    protected int getAwardReportTermItemIndex(HttpServletRequest request) {
        int awardReportTermIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            String awardReportTermIndexString = StringUtils.substringBetween((String)parameterName, (String)".awardReportTermItems", (String)PERIOD);
            awardReportTermIndex = Integer.parseInt(awardReportTermIndexString);
        }
        return awardReportTermIndex;
    }

    public ActionForward addAwardSponsorTerm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardSponsorTerm newSponsorTerm = this.sponsorTermActionHelper.addSponsorTerm(((AwardForm)form).getSponsorTermFormHelper(), request);
        if (newSponsorTerm != null) {
            return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)newSponsorTerm, "awardSponsorTerms", null, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteAwardSponsorTerm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        int lineToDelete = this.getLineToDelete(request);
        AwardSponsorTerm awardSponsorTerm = awardDocument.getAward().getAwardSponsorTerms().get(lineToDelete);
        awardDocument.getAward().getAwardSponsorTerms().remove(lineToDelete);
        return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)awardSponsorTerm, "awardSponsorTerms", null, mapping.findForward("basic"));
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        if (awardForm.getAwardDocument().getAward().getApprovedEquipmentItems() == null || awardForm.getAwardDocument().getAward().getApprovedEquipmentItems().isEmpty()) {
            awardForm.getAwardDocument().getAward().setApprovedEquipmentIndicator("N");
        } else {
            awardForm.getAwardDocument().getAward().setApprovedEquipmentIndicator("Y");
        }
        if (awardForm.getAwardDocument().getAward().getApprovedForeignTravelTrips() == null || awardForm.getAwardDocument().getAward().getApprovedForeignTravelTrips().isEmpty()) {
            awardForm.getAwardDocument().getAward().setApprovedForeignTripIndicator("N");
        } else {
            awardForm.getAwardDocument().getAward().setApprovedForeignTripIndicator("Y");
        }
        if (awardForm.getAwardDocument().getAward().getPaymentScheduleItems() == null || awardForm.getAwardDocument().getAward().getPaymentScheduleItems().isEmpty()) {
            awardForm.getAwardDocument().getAward().setPaymentScheduleIndicator("N");
        } else {
            awardForm.getAwardDocument().getAward().setPaymentScheduleIndicator("Y");
        }
        if (new AwardDocumentRule().processAwardReportTermBusinessRules((Document)awardDocument) && new AwardDocumentRule().processAwardReportTermSaveRules(awardForm)) {
            String lastUpdateUser = GlobalVariables.getUserSession().getPerson().getName();
            Timestamp lastUpdateDate = new Timestamp(new Date().getTime());
            for (AwardPaymentSchedule item : awardDocument.getAward().getPaymentScheduleItems()) {
                HashMap<String, Long> primaryKey = new HashMap<String, Long>();
                primaryKey.put("AWARD_PAYMENT_SCHEDULE_ID", item.getAwardPaymentScheduleId());
                AwardPaymentSchedule dbItem = (AwardPaymentSchedule)this.getBusinessObjectService().findByPrimaryKey(AwardPaymentSchedule.class, primaryKey);
                if (dbItem != null && !item.checkForUpdates(dbItem)) continue;
                item.setLastUpdateTimestamp(lastUpdateDate);
                item.setLastUpdateUser(lastUpdateUser);
            }
            List awardReportTermsId = awardDocument.getAward().getAwardReportTermItems().stream().map(AwardReportTerm::getAwardReportTermId).collect(Collectors.toList());
            this.getReportTrackingService().getReportTracking(awardDocument.getAward()).stream().filter(reportTracking -> !awardReportTermsId.contains(reportTracking.getAwardReportTermId())).forEach(reportTracking -> awardForm.getReportTrackingsToDelete().add((ReportTracking)reportTracking));
            if (!awardForm.getReportTrackingsToDelete().isEmpty()) {
                this.getBusinessObjectService().delete(awardForm.getReportTrackingsToDelete());
                awardForm.setReportTrackingsToDelete(new ArrayList<ReportTracking>());
            }
            ActionForward forward = super.save(mapping, form, request, response);
            return forward;
        }
        return mapping.findForward("basic");
    }

    protected PersistenceService getPersistenceService() {
        return KcServiceLocator.getService(PersistenceService.class);
    }

    private void refreshAwardReportTermRecipients(AwardForm awardForm, AwardDocument awardDocument) {
        ArrayList<AwardReportTermRecipient> persistableObjects = new ArrayList<AwardReportTermRecipient>();
        ArrayList<String> referenceObjectNames = new ArrayList<String>();
        for (AwardReportTermRecipient awardReportTermRecipient : awardForm.getAwardReportsBean().getNewAwardReportTermRecipients()) {
            persistableObjects.add(awardReportTermRecipient);
            referenceObjectNames.add(ROLODEX);
        }
        for (AwardReportTerm awardReportTerm : awardDocument.getAward().getAwardReportTermItems()) {
            for (AwardReportTermRecipient awardReportTermRecipient : awardReportTerm.getAwardReportTermRecipients()) {
                persistableObjects.add(awardReportTermRecipient);
                referenceObjectNames.add(ROLODEX);
            }
        }
        if (persistableObjects.size() > 0 && referenceObjectNames.size() > 0) {
            this.getPersistenceService().retrieveReferenceObjects(persistableObjects, referenceObjectNames);
        }
    }

    public ActionForward syncSponsorTerm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        AwardSponsorTerm awardSponsorTerm = award.getAwardSponsorTerms().get(this.getSelectedLine(request));
        awardForm.getAwardSyncBean().addConfirmedPendingChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)awardSponsorTerm, "awardSponsorTerms");
        return mapping.findForward("basic");
    }

    public ActionForward syncAwardReportTerm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        AwardReportTerm awardReportTerm = award.getAwardReportTermItems().get(this.getSelectedLine(request));
        awardReportTerm.refresh();
        awardForm.getAwardSyncBean().addConfirmedPendingChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)awardReportTerm, AWARD_REPORT_TERM_PROPERTY);
        return mapping.findForward("basic");
    }

    public ActionForward syncRecipient(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        AwardReportTermRecipient recipient = award.getAwardReportTermItems().get(this.getAwardReportTermIndex(request)).getAwardReportTermRecipients().get(this.getSelectedLine(request));
        awardForm.getAwardSyncBean().addConfirmedPendingChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)recipient, AWARD_REPORT_TERM_PROPERTY);
        return mapping.findForward("basic");
    }

    public ActionForward regenerateReports(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        this.getReportTrackingService().generateReportTrackingAndSave(award, true);
        return mapping.findForward("basic");
    }

    public ActionForward selectAllMultEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        int awardReportTermItemsIndex = this.getAwardReportTermItemsIndex(request);
        List<ReportTracking> reportTrackings = awardForm.getAwardDocument().getAward().getAwardReportTermItems().get(this.getAwardReportTermItemsIndex(request)).getReportTrackings();
        if (reportTrackings != null && !reportTrackings.isEmpty()) {
            this.getReportTrackingService().setReportTrackingListSelected(reportTrackings, true);
        } else {
            String fieldName = "methodToCall.selectAllMultEdit.AwardReportTermItemsIndex" + awardReportTermItemsIndex;
            KcServiceLocator.getService(ErrorReporter.class).reportError(fieldName, "error.awardReportTermItem.noReportTracking", "select");
        }
        return mapping.findForward("basic");
    }

    public ActionForward selectNoneMultiEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        int awardReportTermItemsIndex = this.getAwardReportTermItemsIndex(request);
        List<ReportTracking> reportTrackings = awardForm.getAwardDocument().getAward().getAwardReportTermItems().get(this.getAwardReportTermItemsIndex(request)).getReportTrackings();
        if (reportTrackings != null && !reportTrackings.isEmpty()) {
            this.getReportTrackingService().setReportTrackingListSelected(reportTrackings, false);
        } else {
            String fieldName = "methodToCall.selectNoneMultiEdit.AwardReportTermItemsIndex" + awardReportTermItemsIndex;
            KcServiceLocator.getService(ErrorReporter.class).reportError(fieldName, "error.awardReportTermItem.noReportTracking", "unselect");
        }
        return mapping.findForward("basic");
    }

    public ActionForward updateMultileReportTracking(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (new AwardDocumentRule().processAwardReportTermSaveRules((AwardForm)form)) {
            AwardForm awardForm = (AwardForm)form;
            int awardReportTermItemsIndex = this.getAwardReportTermItemsIndex(request);
            List<ReportTracking> reportTrackings = awardForm.getAwardDocument().getAward().getAwardReportTermItems().get(this.getAwardReportTermItemsIndex(request)).getReportTrackings();
            if (reportTrackings != null) {
                this.getReportTrackingService().updateMultipleReportTrackingRecords(reportTrackings, awardForm.getReportTrackingBeans().get(awardReportTermItemsIndex));
                this.getReportTrackingService().setReportTrackingListSelected(reportTrackings, false);
            }
            awardForm.buildReportTrackingBeans();
        }
        return mapping.findForward("basic");
    }

    private int getAwardReportTermItemsIndex(HttpServletRequest request) {
        String awardReportTermItemsIndexBase = "AwardReportTermItemsIndex";
        Map paramMap = request.getParameterMap();
        Iterator keys = paramMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            if (!StringUtils.contains((CharSequence)key, (CharSequence)"AwardReportTermItemsIndex")) continue;
            int startingSubStringIndex = StringUtils.indexOf((CharSequence)key, (CharSequence)"AwardReportTermItemsIndex") + "AwardReportTermItemsIndex".length();
            int endingSubStringIndex = key.length() - 2;
            String intValSubstring = key.substring(startingSubStringIndex, endingSubStringIndex);
            return Integer.valueOf(intValSubstring);
        }
        throw new IllegalArgumentException("AwardReportTermItemsIndex was not found in the request, can't find the index.");
    }
}

