/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.SimpleNode;
import org.kuali.rice.kew.engine.node.SimpleResult;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.util.PerformanceLogger;
import org.kuali.rice.kew.util.Utilities;

public class IteratedRequestActivationNode
implements SimpleNode {
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    private static long generatedRequestPriority = 0L;

    @Override
    public SimpleResult process(RouteContext routeContext, RouteHelper routeHelper) throws Exception {
        RequestFulfillmentCriteria criteria = this.getRequestFulfillmentCriteria(routeContext);
        boolean activatedBlockingRequests = this.activateRequests(routeContext);
        boolean initialRequestGeneration = routeContext.getNodeInstance().isInitial();
        while (criteria.pendingRequestsAreFulfilled(activatedBlockingRequests, routeContext)) {
            boolean newRequestsGenerated = this.generateNewRequests(initialRequestGeneration, routeContext, routeHelper);
            initialRequestGeneration = false;
            if (!newRequestsGenerated) {
                return new SimpleResult(true);
            }
            activatedBlockingRequests = this.activateRequests(routeContext);
            if (routeContext.isSimulation()) {
                criteria = new SimulatingCriteria();
                continue;
            }
            criteria = this.getRequestFulfillmentCriteria(routeContext);
        }
        return new SimpleResult(false);
    }

    protected RequestFulfillmentCriteria getRequestFulfillmentCriteria(RouteContext routeContext) {
        return new AllBlockingRequestsCompleteCriteria();
    }

    protected boolean generateNewRequests(boolean initial, RouteContext context, RouteHelper routeHelper) throws WorkflowException, Exception {
        return false;
    }

    protected boolean activateRequests(RouteContext routeContext) throws WorkflowException {
        DocumentRouteHeaderValue document = routeContext.getDocument();
        RouteNodeInstance nodeInstance = routeContext.getNodeInstance();
        if (routeContext.isSimulation()) {
            if (routeContext.getActivationContext().isActivateRequests()) {
                this.activateRequests(routeContext, document, nodeInstance);
            }
            return false;
        }
        return this.activateRequests(routeContext, document, nodeInstance);
    }

    private static boolean blockingRequestsArePending(DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) {
        List<ActionRequestValue> requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocIdAtRouteNode(document.getDocumentId(), nodeInstance.getRouteNodeInstanceId());
        boolean blockingRequestsArePending = false;
        for (ActionRequestValue request : requests) {
            if (!request.isApproveOrCompleteRequest()) continue;
            blockingRequestsArePending = true;
            break;
        }
        return blockingRequestsArePending;
    }

    private boolean activateRequests(RouteContext context, DocumentRouteHeaderValue document, RouteNodeInstance nodeInstance) throws WorkflowException {
        ThreadContext.put((String)"docId", (String)document.getDocumentId());
        PerformanceLogger performanceLogger = new PerformanceLogger(document.getDocumentId());
        ArrayList<ActionItem> generatedActionItems = new ArrayList<ActionItem>();
        List<ActionRequestValue> requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocIdAtRouteNode(document.getDocumentId(), nodeInstance.getRouteNodeInstanceId());
        if (context.isSimulation()) {
            requests.addAll(context.getEngineState().getGeneratedRequests());
        }
        Collections.sort(requests, new Utilities.PrioritySorter());
        this.LOG.info("Pending Root Requests " + requests.size());
        String activationType = nodeInstance.getRouteNode().getActivationType();
        boolean isParallel = "P".equals(activationType);
        boolean activatedApproveRequest = false;
        Iterator<ActionRequestValue> iter = requests.iterator();
        while (iter.hasNext()) {
            if (activatedApproveRequest && !isParallel) {
                this.LOG.info("Already activated an apprve request and serial, so not activating any more");
                break;
            }
            ActionRequestValue request = iter.next();
            this.LOG.info("ActionRequestValue: " + request);
            if (request.getParentActionRequest() != null || request.getNodeInstance() == null) continue;
            if (request.isActive()) {
                activatedApproveRequest = activatedApproveRequest || request.isApproveOrCompleteRequest();
                continue;
            }
            this.logProcessingMessage(request);
            this.LOG.info("Activating request. " + request);
            activatedApproveRequest = this.activateRequest(context, request, nodeInstance, generatedActionItems) || activatedApproveRequest;
        }
        if (!context.isSimulation()) {
            KEWServiceLocator.getNotificationService().notify(generatedActionItems);
        }
        performanceLogger.log("Time to activate requests.");
        return activatedApproveRequest;
    }

    private boolean activateRequest(RouteContext context, ActionRequestValue actionRequest, RouteNodeInstance nodeInstance, List generatedActionItems) {
        if (actionRequest.isRoleRequest()) {
            List<ActionRequestValue> actionRequests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocIdAtRouteNode(actionRequest.getDocumentId(), nodeInstance.getRouteNodeInstanceId());
            for (ActionRequestValue siblingRequest : actionRequests) {
                if (!actionRequest.getRoleName().equals(siblingRequest.getRoleName())) continue;
                KEWServiceLocator.getActionRequestService().activateRequestNoNotification(siblingRequest, context.getActivationContext());
                generatedActionItems.addAll(context.getActivationContext().getGeneratedActionItems());
            }
        }
        KEWServiceLocator.getActionRequestService().activateRequestNoNotification(actionRequest, context.getActivationContext());
        generatedActionItems.addAll(context.getActivationContext().getGeneratedActionItems());
        return actionRequest.isApproveOrCompleteRequest() && !actionRequest.isDone();
    }

    protected ActionRequestValue saveActionRequest(RouteContext context, ActionRequestValue actionRequest) {
        if (!context.isSimulation()) {
            return KEWServiceLocator.getActionRequestService().saveActionRequest(actionRequest);
        }
        actionRequest.setActionRequestId(String.valueOf(generatedRequestPriority++));
        context.getEngineState().getGeneratedRequests().add(actionRequest);
        return actionRequest;
    }

    private void logProcessingMessage(ActionRequestValue request) {
        RouteNodeInstance nodeInstance = request.getNodeInstance();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Processing AR: ").append(request.getActionRequestId()).append("\n");
        buffer.append("AR Node Name: ").append(nodeInstance != null ? nodeInstance.getName() : "null").append("\n");
        buffer.append("AR RouteLevel: ").append(request.getRouteLevel()).append("\n");
        buffer.append("AR Request Code: ").append(request.getActionRequested()).append("\n");
        buffer.append("AR Request priority: ").append(request.getPriority()).append("\n");
        this.LOG.info((CharSequence)buffer);
    }

    private static class SimulatingCriteria
    implements RequestFulfillmentCriteria {
        private SimulatingCriteria() {
        }

        @Override
        public boolean pendingRequestsAreFulfilled(boolean activatedBlockingRequests, RouteContext routeContext) {
            return true;
        }
    }

    private static class AllBlockingRequestsCompleteCriteria
    implements RequestFulfillmentCriteria {
        private AllBlockingRequestsCompleteCriteria() {
        }

        @Override
        public boolean pendingRequestsAreFulfilled(boolean activatedBlockingRequests, RouteContext routeContext) {
            if (activatedBlockingRequests) {
                assert (activatedBlockingRequests == IteratedRequestActivationNode.blockingRequestsArePending(routeContext.getDocument(), routeContext.getNodeInstance())) : "Blocking requests were activated but none were subsequently found";
                return false;
            }
            return !IteratedRequestActivationNode.blockingRequestsArePending(routeContext.getDocument(), routeContext.getNodeInstance());
        }
    }

    protected static interface RequestFulfillmentCriteria {
        public boolean pendingRequestsAreFulfilled(boolean var1, RouteContext var2);
    }
}

