/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.shipment;

import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.kra.excon.shipment.ExconIntlShipment;
import org.kuali.kra.excon.shipment.document.ExconIntlShipmentDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krms.api.engine.Facts;

public class ExconIntlShipmentFactBuilderServiceImpl
extends KcKrmsFactBuilderServiceHelper {
    private DocumentService documentService;

    @Override
    public void addFacts(Facts.Builder factsBuilder, String docContent) {
        String documentNumber = this.getElementValue(docContent, "//documentNumber");
        try {
            ExconIntlShipmentDocument exconDocument = (ExconIntlShipmentDocument)this.getDocumentService().getByDocumentHeaderId(documentNumber);
            this.addFacts(factsBuilder, exconDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder, KrmsRulesContext document) {
        ExconIntlShipmentDocument exconDocument = (ExconIntlShipmentDocument)document;
        ExconIntlShipment exconShipment = exconDocument.getExconIntlShipment();
        this.addExconIntlShipmentFacts(factsBuilder, exconShipment);
    }

    private void addExconIntlShipmentFacts(Facts.Builder factsBuilder, ExconIntlShipment exconShipment) {
        this.addObjectMembersAsFacts(factsBuilder, exconShipment, "KC-EXCON-SHIPMENT-CONTEXT", "KC-EXCON");
        factsBuilder.addFact("ExconShipment", (Object)exconShipment);
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

