/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.sorting;

import java.util.Comparator;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.sorting.ActivityTypeComparator;
import org.kuali.kra.negotiations.sorting.LastUpdateByComparator;
import org.kuali.kra.negotiations.sorting.LastUpdateComparator;
import org.kuali.kra.negotiations.sorting.LocationComparator;
import org.kuali.kra.negotiations.sorting.MultiComparator;
import org.kuali.kra.negotiations.sorting.StartDateComparator;

public enum ActivitySortingType {
    ST("Activity Start Date, Activity Type", new MultiComparator<NegotiationActivity>(new Comparator[]{new StartDateComparator(), new ActivityTypeComparator()})),
    UT("Last Update, Activity Type", new MultiComparator<NegotiationActivity>(new Comparator[]{new LastUpdateComparator(), new ActivityTypeComparator()})),
    UU("Last Update By, Last Update", new MultiComparator<NegotiationActivity>(new Comparator[]{new LastUpdateByComparator(), new LastUpdateComparator()})),
    TU("Activity Type, Last Update", new MultiComparator<NegotiationActivity>(new Comparator[]{new ActivityTypeComparator(), new LastUpdateComparator()})),
    L("Location", new LocationComparator());

    private String desc;
    private Comparator<NegotiationActivity> comparator;

    private ActivitySortingType(String desc, Comparator<NegotiationActivity> comparator) {
        this.desc = desc;
        this.comparator = comparator;
    }

    public String getDesc() {
        return this.desc;
    }

    public Comparator<NegotiationActivity> getComparator() {
        return this.comparator;
    }
}

