/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.impex.xml;

import java.util.List;
import org.kuali.rice.core.framework.impex.xml.XmlExporter;
import org.kuali.rice.core.framework.impex.xml.XmlImpexRegistry;
import org.kuali.rice.core.framework.impex.xml.XmlLoader;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class XmlImpexRegistrationBean
implements InitializingBean,
DisposableBean {
    private List<XmlLoader> xmlLoadersToRegister;
    private List<XmlExporter> xmlExportersToRegister;
    private XmlImpexRegistry xmlImpexRegistry;

    public void afterPropertiesSet() {
        if (this.xmlLoadersToRegister != null) {
            for (XmlLoader xmlLoader : this.xmlLoadersToRegister) {
                this.xmlImpexRegistry.registerLoader(xmlLoader);
            }
        }
        if (this.xmlExportersToRegister != null) {
            for (XmlExporter xmlExporter : this.xmlExportersToRegister) {
                this.xmlImpexRegistry.registerExporter(xmlExporter);
            }
        }
    }

    public void destroy() throws Exception {
        if (this.xmlLoadersToRegister != null) {
            for (XmlLoader xmlLoader : this.xmlLoadersToRegister) {
                this.xmlImpexRegistry.unregisterLoader(xmlLoader);
            }
        }
        if (this.xmlExportersToRegister != null) {
            for (XmlExporter xmlExporter : this.xmlExportersToRegister) {
                this.xmlImpexRegistry.unregisterExporter(xmlExporter);
            }
        }
    }

    public void setXmlLoadersToRegister(List<XmlLoader> xmlLoadersToRegister) {
        this.xmlLoadersToRegister = xmlLoadersToRegister;
    }

    public void setXmlExportersToRegister(List<XmlExporter> xmlExportersToRegister) {
        this.xmlExportersToRegister = xmlExportersToRegister;
    }

    public void setXmlImpexRegistry(XmlImpexRegistry xmlImpexRegistry) {
        this.xmlImpexRegistry = xmlImpexRegistry;
    }
}

