--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

DELIMITER /

-- Insert a minimum AwardDocument and InstProp document type if it doesn't already exist
-- This will assumed to become versioned once the system ingests the real KEW file
insert into KREW_DOC_HDR_S values (null)
/
insert into KREW_DOC_TYP_T (DOC_TYP_ID, ACTV_IND, CUR_IND, DOC_HDLR_URL,
		LBL, DOC_TYP_NM, OBJ_ID, POST_PRCSR) 
	SELECT (select max(ID) from KREW_DOC_HDR_S), '1', '1', '${kuali.docHandler.url.prefix}/awardHome.do?methodToCall=docHandler',
		'Award Document', 'AwardDocument', uuid() , 'org.kuali.coeus.sys.framework.workflow.KcPostProcessor'
		from dual where not exists (select * from KREW_DOC_TYP_T where DOC_TYP_NM = 'AwardDocument')
/

insert into KREW_DOC_HDR_S values (null)
/
insert into KREW_DOC_TYP_T (DOC_TYP_ID, ACTV_IND, CUR_IND, DOC_HDLR_URL,
		LBL, DOC_TYP_NM, OBJ_ID, POST_PRCSR) 
	SELECT (select max(ID) from KREW_DOC_HDR_S), '1', '1', '${kuali.docHandler.url.prefix}/institutionalProposalHome.do?methodToCall=docHandler', 
		'Institutional Proposal Document', 'InstitutionalProposalDocument', uuid() , 'org.kuali.coeus.sys.framework.workflow.KcPostProcessor'
		from dual where not exists (select * from KREW_DOC_TYP_T where DOC_TYP_NM = 'InstitutionalProposalDocument')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0001', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'InstitutionalProposalDocument'), 'F', 'KC-CGB Demo Data - LOC - by award',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0001','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0002', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'InstitutionalProposalDocument'), 'F', 'KC-CGB Demo Data - LOC - by account',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0002','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0003', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'InstitutionalProposalDocument'), 'F', 'KC-CGB Demo Data - LOC - by cc acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0003','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0004', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'InstitutionalProposalDocument'), 'F', 'KC-CGB Demo Data - MILE - by acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0004','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0005', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'InstitutionalProposalDocument'), 'F', 'KC-CGB Demo Data - PD - by acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0005','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0006', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'InstitutionalProposalDocument'), 'F', 'KC-CGB Demo Data - MONTHLY - by award',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0006','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0007', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'InstitutionalProposalDocument'), 'F', 'KC-CGB Demo Data - MONTHLY - by acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0007','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0008', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'InstitutionalProposalDocument'), 'F', 'KC-CGB Demo Data - MONTHLY - by cc acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0008','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0009', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - LOC - by award',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0009','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0010', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - LOC - by award',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0010','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0011', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - LOC - by award',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0011','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0012', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - LOC - by acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0012','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0013', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - LOC - by acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0013','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0014', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - LOC - by cc acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0014','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0015', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - LOC - by cc acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0015','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0016', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - LOC - by cc acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0016','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0017', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - LOC - by cc acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0017','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0018', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - LOC - by cc acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0018','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0019', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - MILE - by acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0019','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0020', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - PD - by acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0020','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0021', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - MONTHLY - by award',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0021','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0022', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - MONTHLY - by award',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0022','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0023', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - MONTHLY - by award',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0023','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0024', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - MONTHLY by acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0024','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0025', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - MONTHLY by acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0025','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0026', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - MONTHLY - by cc acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0026','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0027', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - MONTHLY - by cc acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0027','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0028', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - MONTHLY - by cc acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0028','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0029', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - MONTHLY - by cc acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0029','')
/

INSERT INTO KREW_DOC_HDR_T (DOC_HDR_ID, DOC_TYP_ID, DOC_HDR_STAT_CD, TTL, 
						INITR_PRNCPL_ID, RTE_PRNCPL_ID, DOC_VER_NBR, RTE_LVL, 
						CRTE_DT, RTE_STAT_MDFN_DT, APRV_DT, FNL_DT, STAT_MDFN_DT, 
						OBJ_ID, VER_NBR) 
VALUES ('KCCGB0030', (SELECT MAX(DOC_TYP_ID) FROM KREW_DOC_TYP_T WHERE DOC_TYP_NM = 'AwardDocument'), 'F', 'KC-CGB Demo Data - MONTHLY - by cc acct',
		(SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), (SELECT PRNCPL_ID FROM KRIM_PRNCPL_T WHERE PRNCPL_NM = 'quickstart'), 1, 4,
		NOW(), NOW(), NOW(), NOW(), NOW(),
		UUID(), 1)
/

INSERT INTO KREW_DOC_HDR_CNTNT_T (DOC_HDR_ID,DOC_CNTNT_TXT)
    VALUES ('KCCGB0030','')
/

 
DELIMITER ;
