/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.freemarker;

import freemarker.cache.TemplateCache;
import freemarker.core.Environment;
import freemarker.core.ParseException;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.AllHttpScopesHashModel;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.uif.freemarker.FreeMarkerInlineRenderBootstrap;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.ProcessLogger;
import org.kuali.rice.krad.uif.util.UifRenderHelperMethods;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.servlet.support.RequestContext;

public class LifecycleRenderingContext {
    private final Environment environment;
    private final Set<String> importedTemplates;
    private final ByteArrayOutputStream buffer;
    private final PrintWriter writer;

    public LifecycleRenderingContext(Object model, HttpServletRequest request) {
        try {
            ProcessLogger.countBegin("render");
            HashMap<String, Object> modelAttrs = new HashMap<String, Object>();
            modelAttrs.put("KualiForm", model);
            modelAttrs.put("UserSession", GlobalVariables.getUserSession());
            request.setAttribute("KualiForm", model);
            request.setAttribute("UserSession", (Object)GlobalVariables.getUserSession());
            modelAttrs.put("request", request);
            Map properties = CoreApiServiceLocator.getKualiConfigurationService().getAllProperties();
            modelAttrs.put("ConfigProperties", properties);
            modelAttrs.put("HelperMethods", new UifRenderHelperMethods());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            Configuration config = FreeMarkerInlineRenderBootstrap.getFreeMarkerConfig();
            Template template = new Template("", (Reader)new StringReader(""), config);
            ServletContext servletContext = FreeMarkerInlineRenderBootstrap.getServletContext();
            ObjectWrapper objectWrapper = FreeMarkerInlineRenderBootstrap.getObjectWrapper();
            ServletContextHashModel servletContextHashModel = FreeMarkerInlineRenderBootstrap.getServletContextHashModel();
            TaglibFactory taglibFactory = FreeMarkerInlineRenderBootstrap.getTaglibFactory();
            Response response = new Response((HttpServletResponse)new MockHttpServletResponse());
            AllHttpScopesHashModel global = new AllHttpScopesHashModel(objectWrapper, servletContext, request);
            global.put("JspTaglibs", (Object)taglibFactory);
            global.put("Application", (Object)servletContextHashModel);
            global.put("Session", (Object)new HttpSessionHashModel(request.getSession(), objectWrapper));
            global.put("Request", (Object)new HttpRequestHashModel(request, (HttpServletResponse)response, objectWrapper));
            global.put("RequestParameters", (Object)new HttpRequestParametersHashModel(request));
            global.put("springMacroRequestContext", (Object)new RequestContext(request, (HttpServletResponse)response, servletContext, modelAttrs));
            global.put("view", (Object)ViewLifecycle.getView());
            Environment env = template.createProcessingEnvironment((Object)global, (Writer)this.writer);
            env.importLib("/krad/WEB-INF/ftl/lib/krad.ftl", "krad");
            env.importLib("/krad/WEB-INF/ftl/lib/spring.ftl", "spring");
            this.environment = env;
            this.buffer = out;
            this.importedTemplates = new HashSet<String>();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize FreeMarker for rendering", e);
        }
        catch (TemplateException e) {
            throw new IllegalStateException("Failed to initialize FreeMarker for rendering", e);
        }
        finally {
            ProcessLogger.countEnd("render", model.getClass().getName());
        }
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void clearRenderingBuffer() {
        this.buffer.reset();
    }

    public String getRenderedOutput() {
        try {
            this.writer.flush();
            this.buffer.flush();
            return this.buffer.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is unsupported", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected exception flusing buffer", e);
        }
    }

    public void importTemplate(String template) {
        if (this.isImported(template)) {
            return;
        }
        try {
            String templateNameString = TemplateCache.getFullTemplatePath((Environment)this.environment, (String)"", (String)template);
            this.environment.include(this.environment.getTemplateForInclusion(templateNameString, null, true));
        }
        catch (ParseException e) {
            throw new IllegalStateException("Error parsing imported template " + template, e);
        }
        catch (TemplateException e) {
            throw new IllegalStateException("Error importing template " + template, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error importing template " + template, e);
        }
    }

    public boolean isImported(String template) {
        return template == null || !this.importedTemplates.add(template);
    }

    private class Response
    extends HttpServletResponseWrapper {
        public Response(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new ServletOutputStream(){

                public void write(int b) throws IOException {
                    LifecycleRenderingContext.this.buffer.write(b);
                }
            };
        }

        public PrintWriter getWriter() throws IOException {
            return LifecycleRenderingContext.this.writer;
        }

        public int getBufferSize() {
            return LifecycleRenderingContext.this.buffer.size();
        }

        public void flushBuffer() throws IOException {
            LifecycleRenderingContext.this.writer.flush();
        }

        public void reset() {
            throw new UnsupportedOperationException("reset() should not be used during rendering");
        }

        public void resetBuffer() {
            LifecycleRenderingContext.this.writer.flush();
            LifecycleRenderingContext.this.buffer.reset();
        }
    }
}

