/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.RareTermsAggregatorFactory;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class RareTermsAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource, RareTermsAggregationBuilder> {
    public static final String NAME = "rare_terms";
    private static final ParseField MAX_DOC_COUNT_FIELD_NAME = new ParseField("max_doc_count", new String[0]);
    private static final ParseField PRECISION = new ParseField("precision", new String[0]);
    private static final int MAX_MAX_DOC_COUNT = 100;
    private static final ObjectParser<RareTermsAggregationBuilder, Void> PARSER = new ObjectParser("rare_terms");
    private IncludeExclude includeExclude = null;
    private int maxDocCount = 1;
    private double precision = 0.001;

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return (AggregationBuilder)PARSER.parse(parser, (Object)new RareTermsAggregationBuilder(aggregationName, null), null);
    }

    public RareTermsAggregationBuilder(String name, ValueType valueType) {
        super(name, (ValuesSourceType)CoreValuesSourceType.ANY, valueType);
    }

    private RareTermsAggregationBuilder(RareTermsAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.includeExclude = clone.includeExclude;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new RareTermsAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public RareTermsAggregationBuilder(StreamInput in) throws IOException {
        super(in, CoreValuesSourceType.ANY);
        this.includeExclude = in.readOptionalWriteable(IncludeExclude::new);
        this.maxDocCount = in.readVInt();
    }

    @Override
    protected boolean serializeTargetValueType(Version version) {
        return true;
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.includeExclude);
        out.writeVInt(this.maxDocCount);
    }

    public RareTermsAggregationBuilder maxDocCount(long maxDocCount) {
        if (maxDocCount <= 0L) {
            throw new IllegalArgumentException("[" + MAX_DOC_COUNT_FIELD_NAME.getPreferredName() + "] must be greater than 0. Found [" + maxDocCount + "] in [" + this.name + "]");
        }
        if (maxDocCount > 100L) {
            throw new IllegalArgumentException("[" + MAX_DOC_COUNT_FIELD_NAME.getPreferredName() + "] must be smallerthan " + 100 + "in [" + this.name + "]");
        }
        this.maxDocCount = (int)maxDocCount;
        return this;
    }

    public RareTermsAggregationBuilder includeExclude(IncludeExclude includeExclude) {
        this.includeExclude = includeExclude;
        return this;
    }

    public IncludeExclude includeExclude() {
        return this.includeExclude;
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) {
        if (precision < 1.0E-5) {
            throw new IllegalArgumentException("[precision] must be greater than 0.00001");
        }
        this.precision = precision;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource> innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig<ValuesSource> config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new RareTermsAggregatorFactory(this.name, config, this.includeExclude, queryShardContext, parent, subFactoriesBuilder, this.metaData, this.maxDocCount, this.precision);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.includeExclude != null) {
            this.includeExclude.toXContent(builder, params);
        }
        builder.field(MAX_DOC_COUNT_FIELD_NAME.getPreferredName(), this.maxDocCount);
        builder.field(PRECISION.getPreferredName(), this.precision);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.includeExclude, this.maxDocCount, this.precision);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RareTermsAggregationBuilder other = (RareTermsAggregationBuilder)obj;
        return Objects.equals(this.includeExclude, other.includeExclude) && Objects.equals(this.maxDocCount, other.maxDocCount) && Objects.equals(this.precision, other.precision);
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        ValuesSourceParserHelper.declareAnyFields(PARSER, true, true);
        PARSER.declareLong(RareTermsAggregationBuilder::maxDocCount, MAX_DOC_COUNT_FIELD_NAME);
        PARSER.declareField((b, v) -> b.includeExclude(IncludeExclude.merge(v, b.includeExclude())), IncludeExclude::parseInclude, IncludeExclude.INCLUDE_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_STRING);
        PARSER.declareField((b, v) -> b.includeExclude(IncludeExclude.merge(b.includeExclude(), v)), IncludeExclude::parseExclude, IncludeExclude.EXCLUDE_FIELD, ObjectParser.ValueType.STRING_ARRAY);
        PARSER.declareDouble(RareTermsAggregationBuilder::setPrecision, PRECISION);
    }
}

