/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.function.Function;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexHistogramFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class ValuesSourceConfig<VS extends ValuesSource> {
    private final ValuesSourceType valueSourceType;
    private FieldContext fieldContext;
    private AggregationScript.LeafFactory script;
    private ValueType scriptValueType;
    private boolean unmapped = false;
    private DocValueFormat format = DocValueFormat.RAW;
    private Object missing;
    private ZoneId timeZone;

    public static <VS extends ValuesSource> ValuesSourceConfig<VS> resolve(QueryShardContext context, ValueType valueType, String field, Script script, Object missing, ZoneId timeZone, String format) {
        return ValuesSourceConfig.resolve(context, valueType, field, script, missing, timeZone, format, s -> CoreValuesSourceType.BYTES);
    }

    public static <VS extends ValuesSource> ValuesSourceConfig<VS> resolve(QueryShardContext context, ValueType valueType, String field, Script script, Object missing, ZoneId timeZone, String format, Function<Script, ValuesSourceType> resolveScriptAny) {
        if (field == null) {
            ValuesSourceType valuesSourceType;
            if (script == null) {
                ValuesSourceConfig<VS> config = new ValuesSourceConfig<VS>(CoreValuesSourceType.ANY);
                config.format(ValuesSourceConfig.resolveFormat(null, valueType, timeZone));
                return config;
            }
            ValuesSourceType valuesSourceType2 = valuesSourceType = valueType != null ? valueType.getValuesSourceType() : CoreValuesSourceType.ANY;
            if (valuesSourceType == CoreValuesSourceType.ANY) {
                valuesSourceType = resolveScriptAny.apply(script);
            }
            ValuesSourceConfig<VS> config = new ValuesSourceConfig<VS>(valuesSourceType);
            config.missing(missing);
            config.timezone(timeZone);
            config.format(ValuesSourceConfig.resolveFormat(format, valueType, timeZone));
            config.script(ValuesSourceConfig.createScript(script, context));
            config.scriptValueType(valueType);
            return config;
        }
        MappedFieldType fieldType = context.fieldMapper(field);
        if (fieldType == null) {
            ValuesSourceType valuesSourceType = valueType != null ? valueType.getValuesSourceType() : CoreValuesSourceType.ANY;
            ValuesSourceConfig<VS> config = new ValuesSourceConfig<VS>(valuesSourceType);
            config.missing(missing);
            config.timezone(timeZone);
            config.format(ValuesSourceConfig.resolveFormat(format, valueType, timeZone));
            config.unmapped(true);
            if (valueType != null) {
                config.scriptValueType(valueType);
            }
            return config;
        }
        Object indexFieldData = context.getForField(fieldType);
        ValuesSourceConfig<VS> config = indexFieldData instanceof IndexNumericFieldData ? new ValuesSourceConfig<VS>(CoreValuesSourceType.NUMERIC) : (indexFieldData instanceof IndexGeoPointFieldData ? new ValuesSourceConfig<VS>(CoreValuesSourceType.GEOPOINT) : (fieldType instanceof RangeFieldMapper.RangeFieldType ? new ValuesSourceConfig<VS>(CoreValuesSourceType.RANGE) : (indexFieldData instanceof IndexHistogramFieldData ? new ValuesSourceConfig<VS>(CoreValuesSourceType.HISTOGRAM) : (valueType == null ? new ValuesSourceConfig<VS>(CoreValuesSourceType.BYTES) : new ValuesSourceConfig<VS>(valueType.getValuesSourceType())))));
        config.fieldContext(new FieldContext(field, (IndexFieldData<?>)indexFieldData, fieldType));
        config.missing(missing);
        config.timezone(timeZone);
        config.script(ValuesSourceConfig.createScript(script, context));
        config.format(fieldType.docValueFormat(format, timeZone));
        return config;
    }

    private static AggregationScript.LeafFactory createScript(Script script, QueryShardContext context) {
        if (script == null) {
            return null;
        }
        AggregationScript.Factory factory = context.compile(script, AggregationScript.CONTEXT);
        return factory.newFactory(script.getParams(), context.lookup());
    }

    private static DocValueFormat resolveFormat(@Nullable String format, @Nullable ValueType valueType, @Nullable ZoneId tz) {
        if (valueType == null) {
            return DocValueFormat.RAW;
        }
        DocValueFormat valueFormat = valueType.defaultFormat;
        if (valueFormat instanceof DocValueFormat.Decimal && format != null) {
            valueFormat = new DocValueFormat.Decimal(format);
        }
        if (valueFormat instanceof DocValueFormat.DateTime && format != null) {
            valueFormat = new DocValueFormat.DateTime(DateFormatter.forPattern(format), tz != null ? tz : ZoneOffset.UTC, DateFieldMapper.Resolution.MILLISECONDS);
        }
        return valueFormat;
    }

    public ValuesSourceConfig(ValuesSourceType valueSourceType) {
        this.valueSourceType = valueSourceType;
    }

    public ValuesSourceType valueSourceType() {
        return this.valueSourceType;
    }

    public FieldContext fieldContext() {
        return this.fieldContext;
    }

    public AggregationScript.LeafFactory script() {
        return this.script;
    }

    public boolean unmapped() {
        return this.unmapped;
    }

    public boolean valid() {
        return this.fieldContext != null || this.script != null || this.unmapped;
    }

    public ValuesSourceConfig<VS> fieldContext(FieldContext fieldContext) {
        this.fieldContext = fieldContext;
        return this;
    }

    public ValuesSourceConfig<VS> script(AggregationScript.LeafFactory script) {
        this.script = script;
        return this;
    }

    public ValuesSourceConfig<VS> scriptValueType(ValueType scriptValueType) {
        this.scriptValueType = scriptValueType;
        return this;
    }

    public ValueType scriptValueType() {
        return this.scriptValueType;
    }

    public ValuesSourceConfig<VS> unmapped(boolean unmapped) {
        this.unmapped = unmapped;
        return this;
    }

    public ValuesSourceConfig<VS> format(DocValueFormat format) {
        this.format = format;
        return this;
    }

    public ValuesSourceConfig<VS> missing(Object missing) {
        this.missing = missing;
        return this;
    }

    public Object missing() {
        return this.missing;
    }

    public ValuesSourceConfig<VS> timezone(ZoneId timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public ZoneId timezone() {
        return this.timeZone;
    }

    public DocValueFormat format() {
        return this.format;
    }

    @Nullable
    public VS toValuesSource(QueryShardContext context) {
        return this.toValuesSource(context, value -> ValuesSource.Bytes.WithOrdinals.EMPTY);
    }

    @Nullable
    public VS toValuesSource(QueryShardContext context, Function<Object, ValuesSource> resolveMissingAny) {
        if (!this.valid()) {
            throw new IllegalStateException("value source config is invalid; must have either a field context or a script or marked as unwrapped");
        }
        ValuesSource vs = this.unmapped() ? (this.missing() == null ? null : (this.valueSourceType() == CoreValuesSourceType.ANY ? resolveMissingAny.apply(this.missing()) : this.valueSourceType().getEmpty())) : (this.fieldContext() == null ? this.valueSourceType().getScript(this.script(), this.scriptValueType()) : (this.valueSourceType() == CoreValuesSourceType.ANY ? CoreValuesSourceType.BYTES.getField(this.fieldContext(), this.script()) : this.valueSourceType().getField(this.fieldContext(), this.script())));
        if (this.missing() == null) {
            return (VS)vs;
        }
        return (VS)this.valueSourceType().replaceMissing(vs, this.missing, this.format, context::nowInMillis);
    }
}

