/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.awt.Color;
import java.nio.CharBuffer;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.fonts.TextFragment;
import org.xml.sax.Locator;

public class FOText
extends FONode
implements CharSequence,
TextFragment {
    private CharBuffer charBuffer;
    private CharacterIterator charIterator;
    private CommonFont commonFont;
    private CommonHyphenation commonHyphenation;
    private Color color;
    private KeepProperty keepTogether;
    private Property letterSpacing;
    private SpaceProperty lineHeight;
    private int whiteSpaceTreatment;
    private int whiteSpaceCollapse;
    private int textTransform;
    private Property wordSpacing;
    private int wrapOption;
    private Length baselineShift;
    private String country;
    private String language;
    private String script;
    private FOText prevFOTextThisBlock;
    private FOText nextFOTextThisBlock;
    private Block ancestorBlock;
    private CommonTextDecoration textDecoration;
    private StructureTreeElement structureTreeElement;
    private int[] bidiLevels;
    private static final int IS_WORD_CHAR_FALSE = 0;
    private static final int IS_WORD_CHAR_TRUE = 1;
    private static final int IS_WORD_CHAR_MAYBE = 2;

    public FOText(FONode parent) {
        super(parent);
        PageSequence pageSequence = this.getRoot().getLastPageSequence();
        if (pageSequence != null && pageSequence.hasChangeBars()) {
            this.nodeChangeBarList = this.getRoot().getLastPageSequence().getClonedChangeBarList();
        }
    }

    @Override
    protected void characters(char[] data, int start, int length, PropertyList list, Locator locator) throws FOPException {
        if (this.charBuffer == null) {
            int newLength = length < 16 ? 16 : length;
            this.charBuffer = CharBuffer.allocate(newLength);
        } else {
            int capacity;
            int requires = this.charBuffer.position() + length;
            if (requires > (capacity = this.charBuffer.capacity())) {
                int newCapacity = capacity * 2;
                if (requires > newCapacity) {
                    newCapacity = requires;
                }
                CharBuffer newBuffer = CharBuffer.allocate(newCapacity);
                this.charBuffer.rewind();
                newBuffer.put(this.charBuffer);
                this.charBuffer = newBuffer;
            }
        }
        this.charBuffer.limit(this.charBuffer.capacity());
        this.charBuffer.put(data, start, length);
        this.charBuffer.limit(this.charBuffer.position());
    }

    public CharSequence getCharSequence() {
        if (this.charBuffer == null) {
            return null;
        }
        this.charBuffer.rewind();
        return this.charBuffer.asReadOnlyBuffer().subSequence(0, this.charBuffer.limit());
    }

    @Override
    public FONode clone(FONode parent, boolean removeChildren) throws FOPException {
        FOText ft = (FOText)super.clone(parent, removeChildren);
        if (removeChildren && this.charBuffer != null) {
            ft.charBuffer = CharBuffer.allocate(this.charBuffer.limit());
            this.charBuffer.rewind();
            ft.charBuffer.put(this.charBuffer);
            ft.charBuffer.rewind();
        }
        ft.prevFOTextThisBlock = null;
        ft.nextFOTextThisBlock = null;
        ft.ancestorBlock = null;
        return ft;
    }

    @Override
    public void bind(PropertyList pList) throws FOPException {
        this.commonFont = pList.getFontProps();
        this.commonHyphenation = pList.getHyphenationProps();
        this.color = pList.get(72).getColor(this.getUserAgent());
        this.keepTogether = pList.get(131).getKeep();
        this.lineHeight = pList.get(144).getSpace();
        this.letterSpacing = pList.get(141);
        this.whiteSpaceCollapse = pList.get(261).getEnum();
        this.whiteSpaceTreatment = pList.get(262).getEnum();
        this.textTransform = pList.get(252).getEnum();
        this.wordSpacing = pList.get(265);
        this.wrapOption = pList.get(266).getEnum();
        this.textDecoration = pList.getTextDecorationProps();
        this.baselineShift = pList.get(15).getLength();
        this.country = pList.get(81).getString();
        this.language = pList.get(134).getString();
        this.script = pList.get(218).getString();
    }

    @Override
    public void endOfNode() throws FOPException {
        if (this.charBuffer != null) {
            this.charBuffer.rewind();
        }
        super.endOfNode();
        this.getFOEventHandler().characters(this);
    }

    @Override
    public void finalizeNode() {
        this.textTransform();
    }

    public boolean willCreateArea() {
        if (this.whiteSpaceCollapse == 48 && this.charBuffer.limit() > 0) {
            return true;
        }
        this.charBuffer.rewind();
        while (this.charBuffer.hasRemaining()) {
            char ch = this.charBuffer.get();
            if (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t') continue;
            this.charBuffer.rewind();
            return true;
        }
        return false;
    }

    @Override
    public CharIterator charIterator() {
        return new TextCharIterator();
    }

    protected void createBlockPointers(Block ancestorBlock) {
        this.ancestorBlock = ancestorBlock;
        if (ancestorBlock.lastFOTextProcessed != null) {
            if (ancestorBlock.lastFOTextProcessed.ancestorBlock == this.ancestorBlock) {
                this.prevFOTextThisBlock = ancestorBlock.lastFOTextProcessed;
                this.prevFOTextThisBlock.nextFOTextThisBlock = this;
            } else {
                this.prevFOTextThisBlock = null;
            }
        }
    }

    private void textTransform() {
        if (this.getBuilderContext().inMarker() || this.textTransform == 95) {
            return;
        }
        this.charBuffer.rewind();
        CharBuffer tmp = this.charBuffer.slice();
        int lim = this.charBuffer.limit();
        int pos = -1;
        block5: while (++pos < lim) {
            char c = this.charBuffer.get();
            switch (this.textTransform) {
                case 155: {
                    tmp.put(Character.toUpperCase(c));
                    continue block5;
                }
                case 78: {
                    tmp.put(Character.toLowerCase(c));
                    continue block5;
                }
                case 22: {
                    if (this.isStartOfWord(pos)) {
                        tmp.put(Character.toTitleCase(c));
                        continue block5;
                    }
                    tmp.put(c);
                    continue block5;
                }
            }
            assert (false);
        }
    }

    private boolean isStartOfWord(int i) {
        char prevChar = this.getRelativeCharInBlock(i, -1);
        switch (FOText.isWordChar(prevChar)) {
            case 1: {
                return false;
            }
            case 0: {
                return true;
            }
            case 2: {
                char prevPrevChar = this.getRelativeCharInBlock(i, -2);
                switch (FOText.isWordChar(prevPrevChar)) {
                    case 1: {
                        return false;
                    }
                    case 0: {
                        return true;
                    }
                    case 2: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private char getRelativeCharInBlock(int i, int offset) {
        int charIndex = i + offset;
        if (charIndex >= 0 && charIndex < this.length()) {
            return this.charAt(i + offset);
        }
        if (offset > 0) {
            return '\u0000';
        }
        boolean foundChar = false;
        char charToReturn = '\u0000';
        FOText nodeToTest = this;
        int remainingOffset = offset + i;
        while (!foundChar && nodeToTest.prevFOTextThisBlock != null) {
            nodeToTest = nodeToTest.prevFOTextThisBlock;
            int diff = nodeToTest.length() + remainingOffset - 1;
            if (diff >= 0) {
                charToReturn = nodeToTest.charAt(diff);
                foundChar = true;
                continue;
            }
            remainingOffset += diff;
        }
        return charToReturn;
    }

    private static int isWordChar(char inputChar) {
        switch (Character.getType(inputChar)) {
            case 8: {
                return 1;
            }
            case 23: {
                return 1;
            }
            case 15: {
                return 0;
            }
            case 26: {
                return 1;
            }
            case 20: {
                if (inputChar == '-') {
                    return 1;
                }
                return 0;
            }
            case 9: {
                return 1;
            }
            case 7: {
                return 0;
            }
            case 22: {
                if (inputChar == '\u2019') {
                    return 2;
                }
                return 0;
            }
            case 16: {
                return 0;
            }
            case 10: {
                return 1;
            }
            case 13: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 25: {
                return 0;
            }
            case 4: {
                return 1;
            }
            case 27: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 11: {
                return 1;
            }
            case 24: {
                if (inputChar == '\'') {
                    return 2;
                }
                return 0;
            }
            case 28: {
                return 1;
            }
            case 14: {
                return 0;
            }
            case 18: {
                return 0;
            }
            case 12: {
                return 0;
            }
            case 21: {
                return 0;
            }
            case 19: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public CommonFont getCommonFont() {
        return this.commonFont;
    }

    public CommonHyphenation getCommonHyphenation() {
        return this.commonHyphenation;
    }

    public Color getColor() {
        return this.color;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public Property getLetterSpacing() {
        return this.letterSpacing;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public int getWhitespaceTreatment() {
        return this.whiteSpaceTreatment;
    }

    public Property getWordSpacing() {
        return this.wordSpacing;
    }

    public int getWrapOption() {
        return this.wrapOption;
    }

    public CommonTextDecoration getTextDecoration() {
        return this.textDecoration;
    }

    public Length getBaseLineShift() {
        return this.baselineShift;
    }

    public String getCountry() {
        return this.country;
    }

    @Override
    public synchronized CharacterIterator getIterator() {
        if (this.charIterator != null) {
            this.charIterator = new StringCharacterIterator(this.toString());
        }
        return this.charIterator;
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this.length();
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public int getBidiLevel() {
        return this.length() > 0 ? this.bidiLevelAt(0) : -1;
    }

    @Override
    public String toString() {
        if (this.charBuffer == null) {
            return "";
        }
        CharBuffer cb = this.charBuffer.duplicate();
        cb.rewind();
        return cb.toString();
    }

    @Override
    public String getLocalName() {
        return "#PCDATA";
    }

    @Override
    public String getNormalNamespacePrefix() {
        return null;
    }

    @Override
    protected String gatherContextInfo() {
        if (this.locator != null) {
            return super.gatherContextInfo();
        }
        return this.toString();
    }

    @Override
    public char charAt(int position) {
        return this.charBuffer.get(position);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.charBuffer.subSequence(start, end);
    }

    @Override
    public int length() {
        return this.charBuffer.limit();
    }

    public void resetBuffer() {
        if (this.charBuffer != null) {
            this.charBuffer.rewind();
        }
    }

    @Override
    public boolean isDelimitedTextRangeBoundary(int boundary) {
        return false;
    }

    @Override
    public void setStructureTreeElement(StructureTreeElement structureTreeElement) {
        this.structureTreeElement = structureTreeElement;
    }

    @Override
    public StructureTreeElement getStructureTreeElement() {
        return this.structureTreeElement;
    }

    public void setBidiLevel(int level, int start, int end) {
        if (start < end) {
            if (this.bidiLevels == null) {
                this.bidiLevels = new int[this.length()];
            }
            int n = end;
            for (int i = start; i < n; ++i) {
                this.bidiLevels[i] = level;
            }
            if (this.parent != null) {
                ((FObj)this.parent).setBidiLevel(level);
            }
        } else assert (start < end);
    }

    public int[] getBidiLevels() {
        return this.bidiLevels;
    }

    public int[] getBidiLevels(int start, int end) {
        if (this.bidiLevels != null) {
            assert (start <= end);
            int n = end - start;
            int[] bidiLevels = new int[n];
            System.arraycopy(this.bidiLevels, start + 0, bidiLevels, 0, n);
            return bidiLevels;
        }
        return null;
    }

    public int bidiLevelAt(int position) throws IndexOutOfBoundsException {
        if (position < 0 || position >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.bidiLevels != null) {
            return this.bidiLevels[position];
        }
        return -1;
    }

    @Override
    protected Stack<DelimitedTextRange> collectDelimitedTextRanges(Stack<DelimitedTextRange> ranges, DelimitedTextRange currentRange) {
        if (currentRange != null) {
            currentRange.append(this.charIterator(), (FONode)this);
        }
        return ranges;
    }

    private static class MapRange {
        private int start;
        private int end;

        MapRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int hashCode() {
            return this.start * 31 + this.end;
        }

        public boolean equals(Object o) {
            if (o instanceof MapRange) {
                MapRange r = (MapRange)o;
                return r.start == this.start && r.end == this.end;
            }
            return false;
        }
    }

    private class TextCharIterator
    extends CharIterator {
        private int currentPosition;
        private boolean canRemove;
        private boolean canReplace;

        @Override
        public boolean hasNext() {
            return this.currentPosition < FOText.this.charBuffer.limit();
        }

        @Override
        public char nextChar() {
            if (this.currentPosition < FOText.this.charBuffer.limit()) {
                this.canRemove = true;
                this.canReplace = true;
                return FOText.this.charBuffer.get(this.currentPosition++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.canRemove) {
                FOText.this.charBuffer.position(this.currentPosition);
                CharBuffer tmp = FOText.this.charBuffer.slice();
                FOText.this.charBuffer.position(--this.currentPosition);
                if (tmp.hasRemaining()) {
                    FOText.this.charBuffer.mark();
                    FOText.this.charBuffer.put(tmp);
                    FOText.this.charBuffer.reset();
                }
            } else {
                throw new IllegalStateException();
            }
            FOText.this.charBuffer.limit(FOText.this.charBuffer.limit() - 1);
            this.canRemove = false;
        }

        @Override
        public void replaceChar(char c) {
            if (!this.canReplace) {
                throw new IllegalStateException();
            }
            FOText.this.charBuffer.put(this.currentPosition - 1, c);
        }
    }
}

