/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceconnectors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.security.credentials.CredentialsSource;
import org.kuali.rice.core.api.security.credentials.CredentialsSourceFactory;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.JavaServiceConfiguration;
import org.kuali.rice.ksb.api.bus.support.SoapServiceConfiguration;
import org.kuali.rice.ksb.messaging.AlternateEndpoint;
import org.kuali.rice.ksb.messaging.AlternateEndpointLocation;
import org.kuali.rice.ksb.messaging.serviceconnectors.AbstractServiceConnector;
import org.kuali.rice.ksb.messaging.serviceconnectors.BusLocalConnector;
import org.kuali.rice.ksb.messaging.serviceconnectors.HttpInvokerConnector;
import org.kuali.rice.ksb.messaging.serviceconnectors.SOAPConnector;
import org.kuali.rice.ksb.messaging.serviceconnectors.ServiceConnector;

public class ServiceConnectorFactory {
    private static final Logger LOG = LogManager.getLogger(ServiceConnectorFactory.class);

    public static ServiceConnector getServiceConnector(ServiceConfiguration serviceConfiguration) {
        CredentialsSourceFactory credentialsSourceFactory = (CredentialsSourceFactory)ConfigContext.getCurrentContextConfig().getObjects().get("credentialsSourceFactory");
        CredentialsSource credentialsSource = credentialsSourceFactory != null ? credentialsSourceFactory.getCredentialsForType(serviceConfiguration.getCredentialsType()) : null;
        AbstractServiceConnector serviceConnector = null;
        if (serviceConfiguration.getCredentialsType() != null && credentialsSource == null) {
            throw new RiceRuntimeException("Service requires credentials but no factory or CredentialsSource could be located.");
        }
        String alternateEndpoint = ServiceConnectorFactory.determineAlternateEndpoint(serviceConfiguration);
        URL alternateEndpointUrl = null;
        if (!StringUtils.isBlank((String)alternateEndpoint)) {
            try {
                alternateEndpointUrl = new URL(alternateEndpoint);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Encountered invalid alternate endpoint url: " + alternateEndpoint, e);
            }
        }
        if (ConfigContext.getCurrentContextConfig().getDevMode().booleanValue()) {
            serviceConnector = new BusLocalConnector(serviceConfiguration);
        } else if (serviceConfiguration instanceof JavaServiceConfiguration) {
            serviceConnector = new HttpInvokerConnector((JavaServiceConfiguration)serviceConfiguration, alternateEndpointUrl);
        } else if (serviceConfiguration instanceof SoapServiceConfiguration) {
            serviceConnector = new SOAPConnector((SoapServiceConfiguration)serviceConfiguration, alternateEndpointUrl);
        }
        if (serviceConnector == null) {
            throw new RiceRuntimeException("Don't support service type of " + serviceConfiguration);
        }
        serviceConnector.setCredentialsSource(credentialsSource);
        return serviceConnector;
    }

    public static String determineAlternateEndpoint(ServiceConfiguration serviceConfiguration) {
        List alternateEndpoints;
        String alternateEndpointUrl = null;
        List alternateEndpointLocations = (List)ConfigContext.getCurrentContextConfig().getObject("ksb.alternateEndpointLocations");
        if (alternateEndpointLocations != null) {
            for (AlternateEndpointLocation alternateEndpointLocation : alternateEndpointLocations) {
                if (!Pattern.matches(".*" + alternateEndpointLocation.getEndpointHostReplacementPattern() + ".*", serviceConfiguration.getEndpointUrl().toExternalForm())) continue;
                Pattern myPattern = Pattern.compile(alternateEndpointLocation.getEndpointHostReplacementPattern());
                Matcher myMatcher = myPattern.matcher(serviceConfiguration.getEndpointUrl().toExternalForm());
                String alternateEndpoint = myMatcher.replaceFirst(alternateEndpointLocation.getEndpointHostReplacementValue());
                if (LOG.isInfoEnabled()) {
                    LOG.info("Found an alternate url host value (" + alternateEndpointLocation.getEndpointHostReplacementValue() + ") for endpoint: " + serviceConfiguration.getEndpointUrl() + " -> instead using: " + alternateEndpoint);
                }
                alternateEndpointUrl = alternateEndpoint;
                break;
            }
        }
        if ((alternateEndpoints = (List)ConfigContext.getCurrentContextConfig().getObject("ksb.alternateEndpoints")) != null) {
            for (AlternateEndpoint alternateEndpoint : alternateEndpoints) {
                if (!Pattern.matches(alternateEndpoint.getEndpointUrlPattern(), serviceConfiguration.getEndpointUrl().toExternalForm())) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info("Found an alternate url for endpoint: " + serviceConfiguration.getEndpointUrl() + " -> instead using: " + alternateEndpoint.getActualEndpoint());
                }
                alternateEndpointUrl = alternateEndpoint.getActualEndpoint();
                break;
            }
        }
        return alternateEndpointUrl;
    }
}

