/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.print;

import edu.mit.coeus.utils.xml.v2.budget.BUDGETDocument;
import edu.mit.coeus.utils.xml.v2.budget.BUDGETPERIODDocument;
import edu.mit.coeus.utils.xml.v2.lookuptypes.ACTIVITYTYPEDocument;
import edu.mit.coeus.utils.xml.v2.lookuptypes.ANTICIPATEDAWARDTYPEDocument;
import edu.mit.coeus.utils.xml.v2.lookuptypes.APPLICABLEREVIEWTYPEDocument;
import edu.mit.coeus.utils.xml.v2.lookuptypes.NOTICEOFOPPORTUNITYDocument;
import edu.mit.coeus.utils.xml.v2.lookuptypes.PROPOSALSTATUSDocument;
import edu.mit.coeus.utils.xml.v2.lookuptypes.PROPOSALTYPEDocument;
import edu.mit.coeus.utils.xml.v2.lookuptypes.SPECIALREVIEWDocument;
import edu.mit.coeus.utils.xml.v2.organization.ORGANIZATIONDocument;
import edu.mit.coeus.utils.xml.v2.propdev.CREDITSPLITCOLUMNSDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPABSTRACTDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPAPPROVALMAPSDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPCHANGEDDATA31Document;
import edu.mit.coeus.utils.xml.v2.propdev.PROPCUSTOMDATADocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPINVESTIGATORTYPE;
import edu.mit.coeus.utils.xml.v2.propdev.PROPKEYPERSONSDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPLOCATIONDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPNOTEPADDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPOSALDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPOSALMASTERDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPPERCREDITSPLITDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPPERSONDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPSCIENCECODEDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPSPECIALREVIEWDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPUNITCREDITSPLITDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPUNITSDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPUSERROLESDocument;
import edu.mit.coeus.utils.xml.v2.propdev.PROPYNQDocument;
import edu.mit.coeus.utils.xml.v2.rolodex.ADDRESSDocument;
import edu.mit.coeus.utils.xml.v2.rolodex.NAMEDocument;
import edu.mit.coeus.utils.xml.v2.rolodex.ROLODEXDocument;
import edu.mit.coeus.utils.xml.v2.sponsor.SPONSORDocument;
import edu.mit.coeus.utils.xml.v2.userUnit.UNITDocument;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.ProposalPersonUnit;
import org.kuali.coeus.propdev.impl.print.ProposalBaseStream;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.sponsor.ProposalCfda;
import org.kuali.coeus.propdev.impl.ynq.ProposalYnq;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="proposalDevelopmentXmlStream")
@Scope(value="prototype")
public class ProposalDevelopmentXmlStream
extends ProposalBaseStream<PROPOSALDocument> {
    private static final String HIPHEN = " - ";
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private DevelopmentProposal developmentProposal;
    private static final String YES = "y";
    private static final String NO = "n";
    Calendar calendar;

    @Override
    public Class<PROPOSALDocument> type() {
        return PROPOSALDocument.class;
    }

    @Override
    public Map<String, PROPOSALDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        this.developmentProposal = (DevelopmentProposal)printableBusinessObject;
        PROPOSALDocument proposalDocument = PROPOSALDocument.Factory.newInstance();
        PROPOSALDocument.PROPOSAL proposal = PROPOSALDocument.PROPOSAL.Factory.newInstance();
        proposal.setPROPOSALMASTER(this.getPROPOSALMASTER());
        proposal.setPROPABSTRACTArray(this.getPROPOSALABSTRACTArray());
        proposal.setPROPAPPROVALMAPSArray(this.getPROPAPPROVALMAPSArray());
        proposal.setPROPCHANGEDDATA31Array(this.getPROPCHANGEDDATA31Array());
        proposal.setPROPCUSTOMDATAArray(this.getPROPCUSTOMDATAArray());
        proposal.setPROPINVESTIGATORSArray(this.getPROPINVESTIGATORSArray());
        proposal.setPROPINVESTIGATORSBASICDETAILSArray(this.getPROPINVESTIGATORSArray());
        proposal.setPROPKEYPERSONSArray(this.getPROPKEYPERSONSArray());
        proposal.setPROPLOCATIONArray(this.getPROPLOCATIONArray());
        proposal.setPROPNOTEPADArray(this.getPROPNOTEPADArray());
        proposal.setPROPPERSONArray(this.getPROPPERSONArray());
        proposal.setPROPSCIENCECODEArray(this.getPROPSCIENCECODEArray());
        proposal.setPROPSPECIALREVIEWArray(this.getPROPSPECIALREVIEWArray());
        proposal.setPROPPERCREDITSPLITArray(this.getPROPPERCREDITSPLITArray());
        proposal.setCREDITSPLITCOLUMNS(this.getCreditSplitColumns());
        proposal.setPROPUNITCREDITSPLITArray(this.getPROPUNITCREDITSPLITArray());
        proposal.setPROPUSERROLESArray(this.getPROPUSERROLESArray());
        proposal.setPROPYNQArray(this.getPROPYNQArray());
        if (this.getBudget(this.developmentProposal.getProposalDocument()) != null) {
            proposal.setBUDGET(this.getBUDGET());
        }
        proposal.setPROPUNITSArray(this.getPROPUNITSArray());
        proposal.setCURDATE(this.getCURDATE());
        proposal.setLOGOPATH(this.getLOGOPATH());
        proposalDocument.setPROPOSAL(proposal);
        LinkedHashMap<String, PROPOSALDocument> xmlObjectList = new LinkedHashMap<String, PROPOSALDocument>();
        xmlObjectList.put("summary", proposalDocument);
        return xmlObjectList;
    }

    private String getLOGOPATH() {
        return null;
    }

    private String getCURDATE() {
        Date todayDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy");
        return dateFormat.format(todayDate);
    }

    private PROPUNITSDocument.PROPUNITS[] getPROPUNITSArray() {
        ArrayList<PROPUNITSDocument.PROPUNITS> propUnitList = new ArrayList<PROPUNITSDocument.PROPUNITS>();
        Unit proposalUnit = this.developmentProposal.getUnit();
        PROPUNITSDocument.PROPUNITS propUnits = PROPUNITSDocument.PROPUNITS.Factory.newInstance();
        propUnits.setPROPOSALNUMBER(this.developmentProposal.getProposalNumber());
        PROPPERSONDocument.PROPPERSON propPerson = PROPPERSONDocument.PROPPERSON.Factory.newInstance();
        propUnits.setPROPPERSON(propPerson);
        UNITDocument.UNIT unit = UNITDocument.UNIT.Factory.newInstance();
        unit.setUNITNUMBER(proposalUnit.getUnitNumber());
        unit.setUNITNAME(proposalUnit.getUnitName());
        propUnits.setUNIT(unit);
        propUnitList.add(propUnits);
        return propUnitList.toArray(new PROPUNITSDocument.PROPUNITS[0]);
    }

    private PROPUNITSDocument.PROPUNITS[] getPROPUNITSArray(ProposalPerson person) {
        ArrayList<PROPUNITSDocument.PROPUNITS> propUnitList = new ArrayList<PROPUNITSDocument.PROPUNITS>();
        this.developmentProposal.refresh();
        PROPPERSONDocument.PROPPERSON propPerson = PROPPERSONDocument.PROPPERSON.Factory.newInstance();
        for (ProposalPersonUnit proposalPUnit : person.getUnits()) {
            Unit proposalUnit = proposalPUnit.getUnit();
            PROPUNITSDocument.PROPUNITS propUnits = PROPUNITSDocument.PROPUNITS.Factory.newInstance();
            propUnits.setPROPOSALNUMBER(this.developmentProposal.getProposalNumber());
            propUnits.setPROPPERSON(propPerson);
            propUnits.setLEADUNITFLAG(this.getFlag(proposalPUnit.isLeadUnit()));
            UNITDocument.UNIT unit = UNITDocument.UNIT.Factory.newInstance();
            unit.setUNITNUMBER(proposalUnit.getUnitNumber());
            unit.setUNITNAME(proposalUnit.getUnitName());
            propUnits.setUNIT(unit);
            propUnitList.add(propUnits);
        }
        return propUnitList.toArray(new PROPUNITSDocument.PROPUNITS[0]);
    }

    private BUDGETDocument.BUDGET getBUDGET() {
        BUDGETDocument.BUDGET proposalBudget = BUDGETDocument.BUDGET.Factory.newInstance();
        proposalBudget.setBudgetMaster(this.getBudgetMaster());
        return proposalBudget;
    }

    private BUDGETDocument.BUDGET.BudgetMaster getBudgetMaster() {
        BUDGETDocument.BUDGET.BudgetMaster budgetMaster = BUDGETDocument.BUDGET.BudgetMaster.Factory.newInstance();
        Budget budget = this.getBudget(this.developmentProposal.getProposalDocument());
        budgetMaster.setCOMMENTS(budget.getComments());
        budgetMaster.setCOSTSHARINGAMOUNT(budget.getCostSharingAmount().bigDecimalValue());
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(budget.getEndDate());
        budgetMaster.setENDDATE(this.calendar);
        budgetMaster.setFINALVERSIONFLAG(this.getFlag(true));
        budgetMaster.setMODULARBUDGETFLAG(this.getFlag(budget.getModularBudgetFlag()));
        budgetMaster.setOHRATECLASSCODE(this.getCode(budget.getOhRateClassCode()));
        budgetMaster.setOHRATETYPECODE(this.getCode(budget.getOhRateTypeCode()));
        budgetMaster.setPROPOSALNUMBER(this.developmentProposal.getProposalNumber());
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(budget.getStartDate());
        budgetMaster.setSTARTDATE(this.calendar);
        budgetMaster.setTOTALCOST(budget.getTotalCost().bigDecimalValue());
        budgetMaster.setTOTALCOSTLIMIT(budget.getTotalCostLimit().bigDecimalValue());
        budgetMaster.setTOTALDIRECTCOST(budget.getTotalDirectCost().bigDecimalValue());
        budgetMaster.setTOTALINDIRECTCOST(budget.getTotalIndirectCost().bigDecimalValue());
        budgetMaster.setUNDERRECOVERYAMOUNT(budget.getUnderrecoveryAmount().bigDecimalValue());
        budgetMaster.setTOTALDIRECTCOSTLIMIT(budget.getTotalDirectCostLimit().bigDecimalValue());
        if (budget.getUrRateClass() != null) {
            budgetMaster.setURRATETYPEDESCRIPTION(budget.getUrRateClass().getDescription());
        }
        if (budget.getRateClass() != null) {
            budgetMaster.setOHRATETYPEDESCRIPTION(budget.getRateClass().getDescription());
        }
        budgetMaster.setSUBMITCOSTSHARINGFLAG(this.getFlag(budget.getSubmitCostSharingFlag()));
        budgetMaster.setONOFFCAMPUSFLAG(budget.getOnOffCampusFlagDescription());
        budgetMaster.setBUDGETPERIODArray(this.getBUDGETPERIODArray());
        if (budget.getResidualFunds() != null) {
            budgetMaster.setRESIDUALFUNDS(budget.getResidualFunds().bigDecimalValue());
        }
        return budgetMaster;
    }

    private BUDGETPERIODDocument.BUDGETPERIOD[] getBUDGETPERIODArray() {
        ArrayList<BUDGETPERIODDocument.BUDGETPERIOD> budgetPeriodList = new ArrayList<BUDGETPERIODDocument.BUDGETPERIOD>();
        Budget budget = this.getBudget(this.developmentProposal.getProposalDocument());
        for (BudgetPeriod budgetPeriodData : budget.getBudgetPeriods()) {
            BUDGETPERIODDocument.BUDGETPERIOD budgetPeriod = BUDGETPERIODDocument.BUDGETPERIOD.Factory.newInstance();
            budgetPeriod.setPROPOSALNUMBER(this.developmentProposal.getProposalNumber());
            BigDecimal numberOfMonths = this.getNumberOfMonths(budgetPeriodData.getStartDate(), budgetPeriodData.getEndDate()).bigDecimalValue();
            budgetPeriod.setNOOFMONTHS(numberOfMonths);
            budgetPeriod.setBUDGETPERIODNUMBER(budgetPeriodData.getBudgetPeriod());
            budgetPeriod.setTOTALDIRECTCOST(budgetPeriodData.getTotalDirectCost().bigDecimalValue());
            budgetPeriod.setTOTALINDIRECTCOST(budgetPeriodData.getTotalIndirectCost().bigDecimalValue());
            this.calendar = Calendar.getInstance();
            this.calendar.setTime(budgetPeriodData.getEndDate());
            budgetPeriod.setENDDATE(this.calendar);
            this.calendar = Calendar.getInstance();
            this.calendar.setTime(budgetPeriodData.getStartDate());
            budgetPeriod.setSTARTDATE(this.calendar);
            budgetPeriod.setUNDERRECOVERYAMOUNT(budgetPeriodData.getUnderrecoveryAmount().bigDecimalValue());
            budgetPeriod.setCOSTSHARINGAMOUNT(budgetPeriodData.getCostSharingAmount().bigDecimalValue());
            budgetPeriod.setTOTALCOST(budgetPeriodData.getTotalCost().bigDecimalValue());
            budgetPeriodList.add(budgetPeriod);
        }
        return budgetPeriodList.toArray(new BUDGETPERIODDocument.BUDGETPERIOD[0]);
    }

    private PROPYNQDocument.PROPYNQ[] getPROPYNQArray() {
        ArrayList<PROPYNQDocument.PROPYNQ> propYnqList = new ArrayList<PROPYNQDocument.PROPYNQ>();
        for (ProposalYnq proposalYnq : this.developmentProposal.getProposalYnqs()) {
            PROPYNQDocument.PROPYNQ propynq = PROPYNQDocument.PROPYNQ.Factory.newInstance();
            propynq.setANSWER(proposalYnq.getAnswer());
            propynq.setEXPLANATION(proposalYnq.getExplanation());
            propynq.setPROPOSALNUMBER(proposalYnq.getProposalNumber());
            propynq.setQUESTIONID(proposalYnq.getQuestionId());
            this.calendar = Calendar.getInstance();
            propynq.setREVIEWDATE(this.calendar);
            this.calendar = Calendar.getInstance();
            this.calendar.setTime(proposalYnq.getUpdateTimestamp());
            propynq.setUPDATETIMESTAMP(this.calendar);
            propynq.setUPDATEUSER(proposalYnq.getUpdateUser());
            propYnqList.add(propynq);
        }
        return propYnqList.toArray(new PROPYNQDocument.PROPYNQ[0]);
    }

    private PROPUSERROLESDocument.PROPUSERROLES[] getPROPUSERROLESArray() {
        ArrayList propUserRolesList = new ArrayList();
        return propUserRolesList.toArray(new PROPUSERROLESDocument.PROPUSERROLES[0]);
    }

    private PROPUNITCREDITSPLITDocument.PROPUNITCREDITSPLIT[] getPROPUNITCREDITSPLITArray() {
        ArrayList propUnitCreditList = new ArrayList();
        return propUnitCreditList.toArray(new PROPUNITCREDITSPLITDocument.PROPUNITCREDITSPLIT[0]);
    }

    private PROPPERCREDITSPLITDocument.PROPPERCREDITSPLIT[] getPROPPERCREDITSPLITArray() {
        return null;
    }

    private PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW[] getPROPSPECIALREVIEWArray() {
        ArrayList<PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW> propSpecialReviewList = new ArrayList<PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW>();
        List<ProposalSpecialReview> propSpecialReviews = this.developmentProposal.getPropSpecialReviews();
        for (ProposalSpecialReview specialReview : propSpecialReviews) {
            PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW proposalReview = PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW.Factory.newInstance();
            proposalReview.setPROPOSALNUMBER(this.developmentProposal.getProposalNumber());
            proposalReview.setSPECIALREVIEWNUMBER(specialReview.getSpecialReviewNumber());
            SPECIALREVIEWDocument.SPECIALREVIEW proposalSpecialReview = SPECIALREVIEWDocument.SPECIALREVIEW.Factory.newInstance();
            proposalSpecialReview.setDESCRIPTION(specialReview.getSpecialReviewType().getDescription());
            proposalSpecialReview.setSPECIALREVIEWCODE(this.getCode(specialReview.getSpecialReviewType().getSpecialReviewTypeCode()));
            proposalReview.setSPECIALREVIEW(proposalSpecialReview);
            APPLICABLEREVIEWTYPEDocument.APPLICABLEREVIEWTYPE applicablereviewtype = APPLICABLEREVIEWTYPEDocument.APPLICABLEREVIEWTYPE.Factory.newInstance();
            applicablereviewtype.setAPPLICABLEREVIEWTYPECODE(this.getCode(specialReview.getApprovalTypeCode()));
            proposalReview.setAPPLICABLEREVIEWTYPE(applicablereviewtype);
            proposalReview.setPROTOCOLNUMBER(specialReview.getProtocolNumber());
            if (specialReview.getApplicationDate() != null) {
                this.calendar = Calendar.getInstance();
                this.calendar.setTime(specialReview.getApplicationDate());
                proposalReview.setAPPLICATIONDATE(this.calendar);
            }
            if (specialReview.getApprovalDate() != null) {
                this.calendar = Calendar.getInstance();
                this.calendar.setTime(specialReview.getApprovalDate());
                proposalReview.setAPPROVALDATE(this.calendar);
            }
            proposalReview.setCOMMENTS(specialReview.getComments());
            proposalReview.setUPDATEUSER(specialReview.getUpdateUser());
            if (specialReview.getUpdateTimestamp() != null) {
                this.calendar = Calendar.getInstance();
                this.calendar.setTime(ProposalDevelopmentXmlStream.toDate(specialReview.getUpdateTimestamp()));
                proposalReview.setUPDATETIMESTAMP(this.calendar);
            }
            propSpecialReviewList.add(proposalReview);
        }
        return propSpecialReviewList.toArray(new PROPSPECIALREVIEWDocument.PROPSPECIALREVIEW[0]);
    }

    private PROPSCIENCECODEDocument.PROPSCIENCECODE[] getPROPSCIENCECODEArray() {
        return null;
    }

    private PROPPERSONDocument.PROPPERSON[] getPROPPERSONArray() {
        return null;
    }

    private PROPNOTEPADDocument.PROPNOTEPAD[] getPROPNOTEPADArray() {
        return null;
    }

    private PROPOSALMASTERDocument.PROPOSALMASTER getPROPOSALMASTER() {
        PROPOSALMASTERDocument.PROPOSALMASTER proposalmaster = PROPOSALMASTERDocument.PROPOSALMASTER.Factory.newInstance();
        this.developmentProposal.refresh();
        proposalmaster.setPROPOSALNUMBER(this.developmentProposal.getProposalNumber());
        PROPOSALTYPEDocument.PROPOSALTYPE proposaltype = PROPOSALTYPEDocument.PROPOSALTYPE.Factory.newInstance();
        if (this.developmentProposal.getProposalType() != null) {
            proposaltype.setPROPOSALTYPECODE(this.getCode(this.developmentProposal.getProposalType().getCode()));
            proposaltype.setDESCRIPTION(this.developmentProposal.getProposalType().getDescription());
        }
        ACTIVITYTYPEDocument.ACTIVITYTYPE activityType = ACTIVITYTYPEDocument.ACTIVITYTYPE.Factory.newInstance();
        if (this.developmentProposal.getActivityType() != null) {
            activityType.setACTIVITYTYPECODE(this.getCode(this.developmentProposal.getActivityType().getCode()));
            activityType.setDESCRIPTION(this.developmentProposal.getActivityType().getDescription());
        }
        proposalmaster.setPROPOSALTYPE(proposaltype);
        proposalmaster.setACTIVITYTYPE(activityType);
        PROPOSALSTATUSDocument.PROPOSALSTATUS proposalstatus = PROPOSALSTATUSDocument.PROPOSALSTATUS.Factory.newInstance();
        proposalstatus.setPROPOSALSTATUSCODE(this.getCode(this.developmentProposal.getProposalStateTypeCode()));
        proposalmaster.setPROPOSALSTATUS(proposalstatus);
        ANTICIPATEDAWARDTYPEDocument.ANTICIPATEDAWARDTYPE anticipatedAwaraType = ANTICIPATEDAWARDTYPEDocument.ANTICIPATEDAWARDTYPE.Factory.newInstance();
        if (this.developmentProposal.getAnticipatedAwardType() != null) {
            anticipatedAwaraType.setDESCRIPTION(this.developmentProposal.getAnticipatedAwardType().getDescription());
        }
        proposalmaster.setANTICIPATEDAWARDTYPE(anticipatedAwaraType);
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(this.developmentProposal.getRequestedStartDateInitial());
        proposalmaster.setREQUESTEDSTARTDATEINITIAL(this.calendar);
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(this.developmentProposal.getRequestedEndDateInitial());
        proposalmaster.setREQUESTEDENDDATEINITIAL(this.calendar);
        this.calendar = Calendar.getInstance();
        if (this.developmentProposal.getDeadlineDate() != null) {
            this.calendar.setTime(this.developmentProposal.getDeadlineDate());
        }
        proposalmaster.setDEADLINEDATE(this.calendar);
        PROPOSALMASTERDocument.PROPOSALMASTER.PRIMESPONSOR primeSponsor = PROPOSALMASTERDocument.PROPOSALMASTER.PRIMESPONSOR.Factory.newInstance();
        SPONSORDocument.SPONSOR sponsor = SPONSORDocument.SPONSOR.Factory.newInstance();
        sponsor.setSPONSORCODE(this.developmentProposal.getSponsor().getSponsorCode());
        sponsor.setSPONSORNAME(this.developmentProposal.getSponsor().getSponsorName());
        proposalmaster.setSPONSOR(sponsor);
        if (this.developmentProposal.getPrimeSponsor() != null) {
            SPONSORDocument.SPONSOR primesponsor = SPONSORDocument.SPONSOR.Factory.newInstance();
            primesponsor.setSPONSORCODE(this.developmentProposal.getPrimeSponsor().getSponsorCode());
            primesponsor.setSPONSORNAME(this.developmentProposal.getPrimeSponsor().getSponsorName());
            primeSponsor.setSPONSOR(primesponsor);
            proposalmaster.setPRIMESPONSOR(primeSponsor);
        }
        Budget budget = this.getBudget(this.developmentProposal.getProposalDocument());
        if (this.developmentProposal.getNoticeOfOpportunity() != null) {
            NOTICEOFOPPORTUNITYDocument.NOTICEOFOPPORTUNITY noticeOfOpportunity = NOTICEOFOPPORTUNITYDocument.NOTICEOFOPPORTUNITY.Factory.newInstance();
            noticeOfOpportunity.setNOTICEOFOPPORTUNITYCODE(this.getCode(this.developmentProposal.getNoticeOfOpportunity().getCode()));
            noticeOfOpportunity.setDESCRIPTION(this.developmentProposal.getNoticeOfOpportunity().getDescription());
            proposalmaster.setNOTICEOFOPPORTUNITY(noticeOfOpportunity);
        }
        proposalmaster.setBUDGETSTATUS(this.developmentProposal.getBudgetStatus());
        proposalmaster.setSPONSORPROPOSALNUMBER(this.developmentProposal.getSponsorProposalNumber());
        proposalmaster.setPROGRAMANNOUNCEMENTTITLE(this.developmentProposal.getProgramAnnouncementTitle());
        proposalmaster.setPROGRAMANNOUNCEMENTNUMBER(this.developmentProposal.getProgramAnnouncementNumber());
        proposalmaster.setCFDANUMBER(this.developmentProposal.getProposalCfdas().stream().map(ProposalCfda::getCfdaNumber).collect(Collectors.joining(",")));
        proposalmaster.setCONTINUEDFROM(this.developmentProposal.getContinuedFrom());
        proposalmaster.setCURRENTAWARDNUMBER(this.developmentProposal.getCurrentAwardNumber());
        proposalmaster.setNSFCODE(this.developmentProposal.getNsfCode());
        proposalmaster.setORGANIZATION(this.getORGANIZATION());
        proposalmaster.setPRINCIPALINVESTIGATORNAME(this.developmentProposal.getPrincipalInvestigatorName());
        proposalmaster.setTITLE(this.developmentProposal.getTitle());
        proposalmaster.setPERIOD(this.getPERIOD());
        if (budget != null) {
            proposalmaster.setSPONSORCOST(this.getCurrencyFormat(budget.getTotalCost().bigDecimalValue()));
            proposalmaster.setCOSTSHARING(this.getCurrencyFormat(budget.getCostSharingAmount().bigDecimalValue()));
        }
        return proposalmaster;
    }

    private String getPERIOD() {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(this.simpleDateFormat.format(this.developmentProposal.getRequestedStartDateInitial()));
        stringBuffer.append(HIPHEN);
        stringBuffer.append(this.simpleDateFormat.format(this.developmentProposal.getRequestedEndDateInitial()));
        return stringBuffer.toString();
    }

    private ORGANIZATIONDocument.ORGANIZATION getORGANIZATION() {
        ORGANIZATIONDocument.ORGANIZATION organization = ORGANIZATIONDocument.ORGANIZATION.Factory.newInstance();
        ROLODEXDocument.ROLODEX rolodex = ROLODEXDocument.ROLODEX.Factory.newInstance();
        NAMEDocument.NAME name = NAMEDocument.NAME.Factory.newInstance();
        ADDRESSDocument.ADDRESS address = ADDRESSDocument.ADDRESS.Factory.newInstance();
        rolodex.setADDRESS(address);
        rolodex.setNAME(name);
        organization.setROLODEX(rolodex);
        return organization;
    }

    private PROPABSTRACTDocument.PROPABSTRACT[] getPROPOSALABSTRACTArray() {
        return null;
    }

    private PROPAPPROVALMAPSDocument.PROPAPPROVALMAPS[] getPROPAPPROVALMAPSArray() {
        return null;
    }

    private PROPCHANGEDDATA31Document.PROPCHANGEDDATA31[] getPROPCHANGEDDATA31Array() {
        return null;
    }

    private PROPCUSTOMDATADocument.PROPCUSTOMDATA[] getPROPCUSTOMDATAArray() {
        return null;
    }

    private CREDITSPLITCOLUMNSDocument.CREDITSPLITCOLUMNS getCreditSplitColumns() {
        CREDITSPLITCOLUMNSDocument.CREDITSPLITCOLUMNS proposalCreditSplitColumns = CREDITSPLITCOLUMNSDocument.CREDITSPLITCOLUMNS.Factory.newInstance();
        this.developmentProposal.refresh();
        if (this.developmentProposal.getInvestigatorCreditTypes() != null) {
            Collection<InvestigatorCreditType> investigatorCreditTypes = this.developmentProposal.getInvestigatorCreditTypes();
            for (InvestigatorCreditType investigatorCreditType : investigatorCreditTypes) {
                String invCreditTypeCode = investigatorCreditType.getCode();
                String invCreditDescription = investigatorCreditType.getDescription();
                if (invCreditTypeCode.equals("0")) {
                    proposalCreditSplitColumns.setColumnName1(invCreditDescription);
                    continue;
                }
                if (invCreditTypeCode.equals("1")) {
                    proposalCreditSplitColumns.setColumnName2(invCreditDescription);
                    continue;
                }
                if (invCreditTypeCode.equals("2")) {
                    proposalCreditSplitColumns.setColumnName3(invCreditDescription);
                    continue;
                }
                if (invCreditTypeCode.equals("3")) {
                    proposalCreditSplitColumns.setColumnName4(invCreditDescription);
                    continue;
                }
                if (invCreditTypeCode.equals("4")) {
                    proposalCreditSplitColumns.setColumnName5(invCreditDescription);
                    continue;
                }
                if (!invCreditTypeCode.equals("5")) continue;
                proposalCreditSplitColumns.setColumnName6(invCreditDescription);
            }
        }
        return proposalCreditSplitColumns;
    }

    private PROPINVESTIGATORTYPE[] getPROPINVESTIGATORSArray() {
        ArrayList<PROPINVESTIGATORTYPE> propInvestigatorList = new ArrayList<PROPINVESTIGATORTYPE>();
        List<ProposalPerson> investigatorList = this.developmentProposal.getInvestigators();
        for (ProposalPerson proposalPerson : investigatorList) {
            PROPINVESTIGATORTYPE propInvestigator = PROPINVESTIGATORTYPE.Factory.newInstance();
            propInvestigator.setPROPOSALNUMBER(this.developmentProposal.getProposalNumber());
            propInvestigator.setPERSONID(proposalPerson.getPersonId());
            propInvestigator.setPERSONNAME(proposalPerson.getPerson().getFullName());
            propInvestigator.setPERSONNAME(proposalPerson.getFullName());
            if ("PI".equals(proposalPerson.getProposalPersonRoleId())) {
                propInvestigator.setPRINCIPALINVESTIGATORFLAG(this.getFlag(proposalPerson.isInvestigator()));
            }
            propInvestigator.setPROPUNITSArray(this.getPROPUNITSArray(proposalPerson));
            propInvestigator.setFACULTYFLAG(this.getFlag(proposalPerson.getFacultyFlag()));
            if (proposalPerson.getPercentageEffort() != null) {
                propInvestigator.setPERCENTAGEEFFORT(proposalPerson.getPercentageEffort().bigDecimalValue());
            }
            propInvestigator.setCONFLICTOFINTERESTFLAG(this.getFlag(proposalPerson.getConflictOfInterestFlag()));
            if (proposalPerson.getUpdateTimestamp() != null) {
                this.calendar = Calendar.getInstance();
                this.calendar.setTime(ProposalDevelopmentXmlStream.toDate(proposalPerson.getUpdateTimestamp()));
                propInvestigator.setUPDATETIMESTAMP(this.calendar);
            }
            propInvestigator.setUPDATEUSER(proposalPerson.getUpdateUser());
            propInvestigatorList.add(propInvestigator);
        }
        return propInvestigatorList.toArray(new PROPINVESTIGATORTYPE[0]);
    }

    private PROPKEYPERSONSDocument.PROPKEYPERSONS[] getPROPKEYPERSONSArray() {
        return null;
    }

    private PROPLOCATIONDocument.PROPLOCATION[] getPROPLOCATIONArray() {
        return null;
    }

    public static Date toDate(Timestamp timestamp) {
        long milliseconds = timestamp.getTime() + (long)(timestamp.getNanos() / 1000000);
        return new Date(milliseconds);
    }

    private String getFlag(boolean flag) {
        if (flag) {
            return YES;
        }
        return NO;
    }

    private int getCode(String code) {
        try {
            return Integer.parseInt(code);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String getCurrencyFormat(BigDecimal amount) {
        DecimalFormat currencyFormater = new DecimalFormat("###,###,##0");
        ((NumberFormat)currencyFormater).setCurrency(Currency.getInstance(Locale.US));
        return currencyFormater.format(amount.doubleValue());
    }
}

