/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.TemplateScript;

public class PipelineProcessor
extends AbstractProcessor {
    public static final String TYPE = "pipeline";
    private final TemplateScript.Factory pipelineTemplate;
    private final IngestService ingestService;

    private PipelineProcessor(String tag, TemplateScript.Factory pipelineTemplate, IngestService ingestService) {
        super(tag);
        this.pipelineTemplate = pipelineTemplate;
        this.ingestService = ingestService;
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        String pipelineName = ingestDocument.renderTemplate(this.pipelineTemplate);
        Pipeline pipeline = this.ingestService.getPipeline(pipelineName);
        if (pipeline != null) {
            ingestDocument.executePipeline(pipeline, handler);
        } else {
            handler.accept(null, new IllegalStateException("Pipeline processor configured for non-existent pipeline [" + pipelineName + ']'));
        }
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException("this method should not get executed");
    }

    Pipeline getPipeline(IngestDocument ingestDocument) {
        String pipelineName = ingestDocument.renderTemplate(this.pipelineTemplate);
        return this.ingestService.getPipeline(pipelineName);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    TemplateScript.Factory getPipelineTemplate() {
        return this.pipelineTemplate;
    }

    public static final class Factory
    implements Processor.Factory {
        private final IngestService ingestService;

        public Factory(IngestService ingestService) {
            this.ingestService = ingestService;
        }

        @Override
        public PipelineProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            TemplateScript.Factory pipelineTemplate = ConfigurationUtils.readTemplateProperty(PipelineProcessor.TYPE, processorTag, config, "name", this.ingestService.getScriptService());
            return new PipelineProcessor(processorTag, pipelineTemplate, this.ingestService);
        }
    }
}

