/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.keyvalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public class PersistableBusinessObjectValuesFinder
extends KeyValuesBase {
    private static final long serialVersionUID = 1L;
    protected Class<?> businessObjectClass;
    protected String keyAttribute;
    protected String labelAttribute;
    protected boolean includeKeyInLabel = false;
    protected boolean includeBlankRow = false;

    public List<KeyValue> getKeyValues() {
        try {
            List objects = KRADServiceLocatorWeb.getLegacyDataAdapter().findMatching(this.businessObjectClass, Collections.emptyMap());
            ArrayList<KeyValue> labels = new ArrayList<KeyValue>(objects.size());
            if (this.includeBlankRow) {
                labels.add((KeyValue)new ConcreteKeyValue("", ""));
            }
            for (Object object : objects) {
                String key = BeanUtils.getProperty(object, (String)this.keyAttribute);
                Object label = BeanUtils.getProperty(object, (String)this.labelAttribute);
                if (this.includeKeyInLabel) {
                    label = key + " - " + (String)label;
                }
                labels.add((KeyValue)new ConcreteKeyValue(key, (String)label));
            }
            return labels;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred while trying to build keyValues List: " + this, e);
        }
    }

    public void setBusinessObjectClass(Class<?> businessObjectClass) {
        this.businessObjectClass = businessObjectClass;
    }

    public void setIncludeKeyInLabel(boolean includeKeyInLabel) {
        this.includeKeyInLabel = includeKeyInLabel;
    }

    @Deprecated
    public void setIncludeKeyInDescription(boolean includeKeyInDescription) {
        this.setIncludeKeyInLabel(includeKeyInDescription);
    }

    public void setKeyAttribute(String keyAttribute) {
        this.keyAttribute = keyAttribute;
    }

    @Deprecated
    public void setKeyAttributeName(String keyAttributeName) {
        this.setKeyAttribute(keyAttributeName);
    }

    public void setLabelAttribute(String labelAttribute) {
        this.labelAttribute = labelAttribute;
    }

    @Deprecated
    public void setLabelAttributeName(String labelAttributeName) {
        this.setLabelAttribute(labelAttributeName);
    }

    public void setIncludeBlankRow(boolean includeBlankRow) {
        this.includeBlankRow = includeBlankRow;
    }

    public String toString() {
        return "PersistableBusinessObjectValuesFinder{businessObjectClass=" + this.businessObjectClass + ", keyAttribute='" + this.keyAttribute + "', labelAttribute='" + this.labelAttribute + "', includeKeyInLabel=" + this.includeKeyInLabel + ", includeBlankRow=" + this.includeBlankRow + "}";
    }
}

