/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.api;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.award.api.AwardBudgetActionDto;
import org.kuali.coeus.award.dto.AwardBudgetExtDto;
import org.kuali.coeus.award.dto.AwardBudgetGeneralInfoDto;
import org.kuali.coeus.common.api.BudgetPeriodDto;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetCommonService;
import org.kuali.coeus.common.budget.framework.core.BudgetCommonServiceFactory;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategory;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelBudgetService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.kra.award.budget.AwardBudgetLineItemExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodCalculationService;
import org.kuali.kra.award.budget.AwardBudgetPeriodExt;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.AwardBudgetStatus;
import org.kuali.kra.award.budget.calculator.AwardBudgetCalculationService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.dao.AwardDao;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api/v2"})
@Controller(value="awardBudgetController")
public class AwardBudgetController
extends RestController {
    public static final String AWARD_BUDGET_STATUS_CODE = "awardBudgetStatusCode";
    @Autowired
    @Qualifier(value="awardDao")
    private AwardDao awardDao;
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;
    @Autowired
    @Qualifier(value="awardBudgetService")
    private AwardBudgetService budgetService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="awardBudgetService")
    private AwardBudgetService awardBudgetService;
    @Autowired
    @Qualifier(value="budgetPersonService")
    private BudgetPersonService budgetPersonService;
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;
    @Autowired
    @Qualifier(value="awardBudgetCalculationService")
    private AwardBudgetCalculationService awardBudgetCalculationService;
    @Autowired
    @Qualifier(value="budgetPersonnelBudgetService")
    private BudgetPersonnelBudgetService budgetPersonnelBudgetService;
    @Autowired
    @Qualifier(value="awardBudgetPeriodCalculationService")
    private AwardBudgetPeriodCalculationService awardBudgetPeriodCalculationService;
    @Autowired
    @Qualifier(value="auditHelper")
    private AuditHelper auditHelper;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @RequestMapping(method={RequestMethod.POST}, value={"/awards/{awardId}/budgets"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    AwardBudgetExtDto createBudget(@PathVariable Long awardId, @RequestBody AwardBudgetExtDto awardBudgetExtDto) throws WorkflowException, InvocationTargetException, IllegalAccessException {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        AwardDocument awardDocument = this.getAwardDocumentById(awardId);
        this.checkIfBudgetCanBeCreated(awardDocument, awardBudgetExtDto.getName());
        AwardBudgetExt newBudget = (AwardBudgetExt)this.budgetService.addBudgetVersion(awardDocument, awardBudgetExtDto.getName(), Collections.EMPTY_MAP);
        Integer budgetVersionNumber = newBudget.getBudgetVersionNumber();
        if (newBudget == null) {
            throw new UnprocessableEntityException("A new budget could not be created.");
        }
        AwardBudgetDocument budgetDocument = (AwardBudgetDocument)this.documentService.getByDocumentHeaderId(newBudget.getDocumentNumber());
        this.updateBudgetData(newBudget, awardBudgetExtDto);
        newBudget.setAwardId(awardId);
        this.translateBudgetPeriods(newBudget, awardBudgetExtDto);
        newBudget.setBudgetVersionNumber(budgetVersionNumber);
        this.awardBudgetService.calculateBudgetOnSave(newBudget);
        this.updateLineItemCalcAmountsIfRatesDisabled(newBudget, awardBudgetExtDto);
        this.calculateBudgetPeriods(newBudget);
        this.awardBudgetCalculationService.calculateBudget(newBudget);
        this.overrideFandAandFringeRatesIfAvailable(newBudget, awardBudgetExtDto);
        this.getBudgetCommonService(newBudget.getBudgetParent()).calculateBudgetOnSave(newBudget);
        ArrayList<AwardBudgetExt> budgets = new ArrayList<AwardBudgetExt>();
        budgets.add(newBudget);
        budgetDocument.setBudgets(budgets);
        this.commonApiService.saveDocument(budgetDocument);
        return this.commonApiService.convertObject(newBudget, AwardBudgetExtDto.class);
    }

    protected BudgetCommonService<BudgetParent> getBudgetCommonService(BudgetParent budgetParent) {
        return BudgetCommonServiceFactory.createInstance(budgetParent);
    }

    protected void calculateBudgetPeriods(AwardBudgetExt newBudget) {
        newBudget.getBudgetPeriods().stream().forEach(budgetPeriod -> this.awardBudgetPeriodCalculationService.calculateBudgetPeriod(Boolean.TRUE, newBudget, (BudgetPeriod)budgetPeriod));
    }

    protected void overrideFandAandFringeRatesIfAvailable(AwardBudgetExt newBudget, AwardBudgetExtDto awardBudgetExtDto) {
        newBudget.getBudgetPeriods().stream().forEach(budgetPeriod -> {
            BudgetPeriodDto matchingPeriodDto = awardBudgetExtDto.getBudgetPeriods().stream().filter(budgetPeriodDto -> budgetPeriodDto.getPeriodNumber().intValue() == budgetPeriod.getBudgetPeriod().intValue()).findFirst().get();
            AwardBudgetPeriodExt awardBudgetPeriod = (AwardBudgetPeriodExt)budgetPeriod;
            if (matchingPeriodDto.getTotalIndirectCost().isNonZero() || matchingPeriodDto.getTotalFringeAmount().isNonZero()) {
                if (matchingPeriodDto.getTotalIndirectCost().isNonZero()) {
                    awardBudgetPeriod.setfAndAOverridden(true);
                }
                if (matchingPeriodDto.getTotalFringeAmount().isNonZero()) {
                    awardBudgetPeriod.setFringeOverridden(true);
                }
                awardBudgetPeriod.setTotalFringeAmount(awardBudgetExtDto.getBudgetPeriods().get(0).getTotalFringeAmount());
                awardBudgetPeriod.setPrevTotalFringeAmount(ScaleTwoDecimal.ZERO);
                awardBudgetPeriod.setTotalIndirectCost(awardBudgetExtDto.getBudgetPeriods().get(0).getTotalIndirectCost());
            }
        });
    }

    private void updateLineItemCalcAmountsIfRatesDisabled(AwardBudgetExt newBudget, AwardBudgetExtDto awardBudgetExtDto) {
        if (!awardBudgetExtDto.isApplyLineItemRates()) {
            newBudget.getBudgetPeriods().get(0).getBudgetLineItems().stream().flatMap(budgetLineItem -> budgetLineItem.getBudgetLineItemCalculatedAmounts().stream()).forEach(budgetLineItemCalculatedAmount -> budgetLineItemCalculatedAmount.setApplyRateFlag(false));
        }
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/award-budgets/{budgetId}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void cancelDocument(@PathVariable Long budgetId) {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        Budget budget = (Budget)this.businessObjectService.findBySinglePrimaryKey(Budget.class, (Object)budgetId);
        if (budget != null) {
            AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)this.commonApiService.getDocumentFromDocId(Long.parseLong(budget.getDocumentNumber()));
            WorkflowDocument workflowDoc = awardBudgetDocument.getDocumentHeader().getWorkflowDocument();
            if (workflowDoc.isEnroute() && StringUtils.equals((CharSequence)this.globalVariableService.getUserSession().getPrincipalId(), (CharSequence)workflowDoc.getRoutedByPrincipalId())) {
                workflowDoc.superUserCancel("Cancelled by Routed By User");
            } else {
                try {
                    this.documentService.cancelDocument((Document)awardBudgetDocument, "X");
                }
                catch (WorkflowException e) {
                    throw new UnprocessableEntityException("Award budget with " + budgetId + " is not in a state to be cancelled.");
                }
            }
        }
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/award-budgets/{budgetId}/status"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void changeBudgetStatus(@PathVariable Long budgetId, @RequestBody AwardBudgetActionDto actionDto) throws Exception {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put(AWARD_BUDGET_STATUS_CODE, actionDto.getStatusCode());
        boolean validAwardBudgetStatus = this.businessObjectService.findMatching(AwardBudgetStatus.class, criteria).isEmpty();
        if (validAwardBudgetStatus) {
            throw new UnprocessableEntityException("Invalid status code " + actionDto.getStatusCode());
        }
        AwardBudgetExt budget = (AwardBudgetExt)this.businessObjectService.findBySinglePrimaryKey(AwardBudgetExt.class, (Object)budgetId);
        if (budget == null) {
            throw new ResourceNotFoundException("Budget with budget id " + budgetId + " not found.");
        }
        budget.setAwardBudgetStatusCode(actionDto.getStatusCode());
        this.businessObjectService.save((PersistableBusinessObject)budget);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(method={RequestMethod.PUT}, value={"/award-budgets/{budgetId}"}, params={"submit"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void routeAwardBudget(@PathVariable Long budgetId) {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        Budget budget = (Budget)this.businessObjectService.findBySinglePrimaryKey(Budget.class, (Object)budgetId);
        if (budget == null) throw new ResourceNotFoundException("Budget with budget id " + budgetId + " not found.");
        AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)this.commonApiService.getDocumentFromDocId(Long.parseLong(budget.getDocumentNumber()));
        AwardBudgetExt awardBudgetExt = awardBudgetDocument.getAwardBudget();
        Award currentAward = this.awardBudgetService.getActiveOrNewestAward(awardBudgetExt.getAward().getAwardNumber());
        ScaleTwoDecimal newCostLimit = this.awardBudgetService.getTotalCostLimit(currentAward);
        if (!newCostLimit.equals((Object)budget.getTotalCostLimit()) || !this.awardBudgetService.limitsMatch(currentAward.getAwardBudgetLimits(), awardBudgetExt.getAwardBudgetLimits())) throw new UnprocessableEntityException("Total requested cost of the budget does not match the Budget Change Total Cost Limit.");
        boolean valid = this.auditHelper.auditUnconditionally(awardBudgetDocument);
        if (!valid) {
            throw new UnprocessableEntityException("Budget document with budget id " + budgetId + " cannot be routed because of audit rules failures.");
        }
        this.awardBudgetService.processSubmision(awardBudgetDocument);
        this.commonApiService.routeDocument(awardBudgetDocument);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/award-budgets/{budgetId}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    AwardBudgetExtDto getAwardBudget(@PathVariable String budgetId) {
        this.assertUserHasReadAccess();
        AwardBudgetExt budget = this.getAwardDao().getAwardBudget(budgetId);
        if (budget == null) {
            throw new ResourceNotFoundException("Budget with budget id " + budgetId + " not found.");
        }
        return this.commonApiService.convertObject(budget, AwardBudgetExtDto.class);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/award-budgets"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    List<AwardBudgetExtDto> getAwardBudgetByStatus(@RequestParam(value="budgetStatusCode", required=true) Integer budgetStatusCode) {
        this.assertUserHasReadAccess();
        List<AwardBudgetExt> budgets = this.getAwardDao().getAwardBudgetByStatusCode(budgetStatusCode);
        return budgets.stream().map(budget -> this.commonApiService.convertObject(budget, AwardBudgetExtDto.class)).collect(Collectors.toList());
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/award-budgets/{budgetId}/general-info/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    void modifyAwardBudget(@RequestBody AwardBudgetGeneralInfoDto generalInfoDto, @PathVariable String budgetId) {
        this.assertUserHasWriteAccess();
        this.commonApiService.clearErrors();
        AwardBudgetExt budget = this.getAwardDao().getAwardBudget(budgetId);
        if (budget == null) {
            throw new ResourceNotFoundException("Budget with budget id " + budgetId + " not found.");
        }
        this.commonApiService.updateDataObjectFromDto(budget, generalInfoDto);
        this.businessObjectService.save((PersistableBusinessObject)budget);
    }

    protected void updateBudgetData(AwardBudgetExt newBudget, AwardBudgetExtDto awardBudgetExtDto) {
        newBudget.setBudgetInitiator(awardBudgetExtDto.getBudgetInitiator());
        newBudget.setAwardBudgetTypeCode(awardBudgetExtDto.getAwardBudgetTypeCode());
        newBudget.setDescription(awardBudgetExtDto.getDescription());
        newBudget.setOnOffCampusFlag(awardBudgetExtDto.getOnOffCampusFlag());
        newBudget.setEndDate(awardBudgetExtDto.getEndDate());
        newBudget.setStartDate(awardBudgetExtDto.getStartDate());
        newBudget.setOhRateTypeCode(awardBudgetExtDto.getOhRateTypeCode());
        newBudget.setOhRateClassCode(awardBudgetExtDto.getOhRateClassCode());
        newBudget.setComments(awardBudgetExtDto.getComments());
        newBudget.setModularBudgetFlag(awardBudgetExtDto.getModularBudgetFlag());
        newBudget.setUrRateClassCode(awardBudgetExtDto.getUrRateClassCode());
    }

    protected void translateBudgetPeriods(AwardBudgetExt newBudget, AwardBudgetExtDto awardBudgetExtDto) {
        List<BudgetPeriodDto> budgetPeriodDtos = awardBudgetExtDto.getBudgetPeriods();
        List<BudgetPeriod> budgetPeriods = budgetPeriodDtos.stream().map(budgetPeriodDto -> {
            AwardBudgetPeriodExt budgetPeriod = this.commonApiService.convertObject(budgetPeriodDto, AwardBudgetPeriodExt.class);
            budgetPeriod.setBudgetLineItems(new ArrayList<BudgetLineItem>());
            budgetPeriod.setBudget(newBudget);
            if (budgetPeriodDto.getPeriodNumber() == null) {
                throw new UnprocessableEntityException("Please enter a period number for the budget periods.");
            }
            budgetPeriod.setBudgetPeriod(budgetPeriodDto.getPeriodNumber());
            List<BudgetLineItem> budgetLineItems = budgetPeriodDto.getBudgetLineItems().stream().map(budgetLineItemDto -> {
                AwardBudgetLineItemExt budgetLineItem = this.commonApiService.convertObject(budgetLineItemDto, AwardBudgetLineItemExt.class);
                if (budgetLineItem.getBudgetRateAndBaseList() == null) {
                    budgetLineItem.setBudgetRateAndBaseList(new ArrayList<BudgetRateAndBase>());
                }
                BudgetCategory newBudgetCategory = new BudgetCategory();
                newBudgetCategory.setBudgetCategoryTypeCode(budgetLineItemDto.getBudgetCategoryTypeCode());
                newBudgetCategory.refreshNonUpdateableReferences();
                budgetLineItem.setBudgetCategory(newBudgetCategory);
                if (!this.isPersonnelLineItem(budgetLineItem)) {
                    this.awardBudgetService.populateNewBudgetLineItem(budgetLineItem, budgetPeriod);
                    budgetLineItem.setBudgetPersonnelDetailsList(new ArrayList<BudgetPersonnelDetails>());
                } else {
                    budgetLineItem.setBudgetPersonnelDetailsList(new ArrayList<BudgetPersonnelDetails>());
                    this.budgetPersonnelBudgetService.addBudgetPersonnelToPeriod(budgetPeriod, budgetLineItem, new BudgetPersonnelDetails());
                }
                budgetLineItem.setBudgetLineItemCalculatedAmounts(new ArrayList<BudgetLineItemCalculatedAmount>());
                return budgetLineItem;
            }).collect(Collectors.toList());
            budgetPeriod.setBudgetLineItems(budgetLineItems);
            return budgetPeriod;
        }).collect(Collectors.toList());
        newBudget.setBudgetPersons(new ArrayList<BudgetPerson>());
        awardBudgetExtDto.getBudgetPersons().stream().forEach(awardBudgetPersonDto -> {
            BudgetPerson person = this.commonApiService.convertObject(awardBudgetPersonDto, BudgetPerson.class);
            this.budgetPersonService.addBudgetPerson(newBudget, person);
            person.setBudget(newBudget);
        });
        newBudget.setAwardBudgetLimits(new ArrayList<AwardBudgetLimit>());
        newBudget.setBudgetPersonnelDetailsList(new ArrayList<BudgetPersonnelDetails>());
        newBudget.setBudgetPeriods(budgetPeriods);
    }

    protected boolean isPersonnelLineItem(BudgetLineItem budgetLineItem) {
        String personnelBudgetCategoryTypeCode = this.budgetCalculationService.getPersonnelBudgetCategoryTypeCode();
        return budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equalsIgnoreCase(personnelBudgetCategoryTypeCode);
    }

    protected boolean checkIfBudgetCanBeCreated(AwardDocument awardDocument, String name) {
        if (!this.budgetService.isBudgetVersionNameValid(awardDocument.getBudgetParent(), name) || this.budgetService.checkForOutstandingBudgets(awardDocument.getAward())) {
            throw new UnprocessableEntityException(this.commonApiService.getValidationErrors());
        }
        return true;
    }

    protected AwardDocument getAwardDocumentById(Long awardId) {
        Award award = this.awardDao.getAward(awardId);
        if (award == null) {
            throw new ResourceNotFoundException("Award with award id " + awardId + " not found.");
        }
        return (AwardDocument)this.commonApiService.getDocumentFromDocId(Long.parseLong(award.getAwardDocument().getDocumentNumber()));
    }

    protected Document getDocument(Long documentNumber) {
        return this.commonApiService.getDocumentFromDocId(documentNumber);
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public boolean isApiAuthEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "Document", "RESKC-2456_Enable_Api_Authorization");
    }

    protected void assertUserHasReadAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", AwardBudgetExt.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasWriteAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", AwardBudgetExt.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    public AwardDao getAwardDao() {
        return this.awardDao;
    }
}

