/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.finance;

import com.codiform.moo.curry.Translate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.kuali.coeus.award.api.AwardApiService;
import org.kuali.coeus.award.dto.AwardDto;
import org.kuali.coeus.award.finance.AccountDto;
import org.kuali.coeus.award.finance.AccountResults;
import org.kuali.coeus.award.finance.AwardAccount;
import org.kuali.coeus.award.finance.AwardPosts;
import org.kuali.coeus.award.finance.AwardPostsDto;
import org.kuali.coeus.award.finance.dao.AccountDao;
import org.kuali.coeus.common.api.document.service.CommonApiService;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.rest.SearchResults;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.kuali.kra.award.dao.AwardDao;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.external.award.AwardAccountService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/api"})
@Controller(value="awardAccountController")
public class AwardAccountController
extends RestController {
    public static final String NO_SUCH_ACCOUNT = "No such account.";
    @Autowired
    @Qualifier(value="accountDao")
    private AccountDao accountDao;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="awardDao")
    private AwardDao awardDao;
    @Autowired
    @Qualifier(value="commonApiService")
    private CommonApiService commonApiService;
    @Autowired
    @Qualifier(value="awardApiService")
    private AwardApiService awardApiService;
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="awardService")
    private AwardService awardService;
    @Autowired
    @Qualifier(value="awardAccountService")
    private AwardAccountService awardAccountService;

    @RequestMapping(value={"/v1/accounts"})
    @ResponseBody
    public AccountResults getAccounts(@RequestParam(value="startIndex", required=false) Integer startIndex, @RequestParam(value="size", required=false) Integer size) {
        this.assertUserHasAccountReadAccess();
        return (AccountResults)Translate.to(AccountResults.class).from(this.transformSearchResults(this.getAccountDao().getAccounts(startIndex, size)));
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"v1/accounts/{accountNumber}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateAccount(@Valid @RequestBody AccountDto account, @PathVariable String accountNumber) {
        this.assertUserHasAccountWriteAccess();
        AwardAccount currentAccount = this.accountDao.getAccount(accountNumber);
        if (Objects.isNull(currentAccount)) {
            this.sendErrorResponse(NO_SUCH_ACCOUNT);
        } else {
            if (account.getStatus() != null) {
                currentAccount.setStatus(account.getStatus());
            }
            if (account.getPending() != null) {
                currentAccount.setPending(account.getPending());
            }
            if (account.getBudgeted() != null) {
                currentAccount.setBudgeted(account.getBudgeted());
            }
            if (account.getAvailable() != null) {
                currentAccount.setAvailable(account.getAvailable());
            }
            if (account.getExpense() != null) {
                currentAccount.setExpense(account.getExpense());
            }
            if (account.getIncome() != null) {
                currentAccount.setIncome(account.getIncome());
            }
            if (account.getComment() != null) {
                currentAccount.setComment(account.getComment());
            }
            this.accountDao.saveAccount(currentAccount);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"v1/accounts/{accountNumber}"})
    @ResponseBody
    public AccountResults getAccount(@PathVariable String accountNumber) {
        this.assertUserHasAccountReadAccess();
        AwardAccount account = this.accountDao.getAccount(accountNumber);
        ArrayList<AwardAccount> accounts = new ArrayList<AwardAccount>();
        accounts.add(account);
        if (Objects.isNull(account)) {
            this.sendErrorResponse(NO_SUCH_ACCOUNT);
        }
        return (AccountResults)Translate.to(AccountResults.class).from(this.transformSearchResults(accounts));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"v1/award-posts"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<AwardPostsDto> getAwardPosts(@RequestParam(value="accountNumber", required=false) String accountNumber) {
        this.assertUserHasPostReadAccess();
        List<AwardPosts> awardPostsList = this.getAccountDao().getActiveAwardPosts(accountNumber);
        return awardPostsList.stream().map(this::translateAwardPosts).collect(Collectors.toList());
    }

    protected AwardPostsDto translateAwardPosts(AwardPosts awardPosts) {
        AwardPostsDto awardPostsDto = this.commonApiService.convertObject(awardPosts, AwardPostsDto.class);
        Award award = this.awardDao.getAward(awardPosts.getAwardId());
        AwardDto awardDto = this.awardApiService.convertAwardToDto(award);
        awardPostsDto.setAwardDto(awardDto);
        return awardPostsDto;
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"v1/award-posts/{postId}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public AwardPostsDto getAwardPosts(@PathVariable Long postId, @RequestBody AwardPostsDto awardPostsDto) {
        this.assertUserHasPostWriteAccess();
        AwardPosts awardPost = this.getAccountDao().getAwardPostsById(postId);
        if (awardPost == null) {
            throw new ResourceNotFoundException("The award post entry with id " + postId + " was not found.");
        }
        awardPost.setActive(awardPostsDto.isActive());
        this.dataObjectService.save((Object)awardPost, new PersistenceOption[0]);
        return this.commonApiService.convertObject(awardPost, AwardPostsDto.class);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"v1/postAwardAccount/{awardId}/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public AwardPostsDto createAwardAccountPost(@PathVariable Long awardId) throws WorkflowException {
        this.assertUserHasPostWriteAccess();
        AwardPosts post = null;
        this.commonApiService.clearErrors();
        AwardDocument awardDocument = this.getAwardDocumentById(awardId);
        if (awardDocument.getAward().getAccountNumber() == null || !this.canPostAward(awardDocument)) {
            throw new UnprocessableEntityException("Award has no account number or is not in state to be posted.");
        }
        post = this.awardService.addPostEntry(awardDocument.getAward(), awardDocument.getDocumentNumber(), awardDocument.getDocumentHeader().getWorkflowDocument().getStatus().getLabel(), false);
        return this.commonApiService.convertObject(post, AwardPostsDto.class);
    }

    protected boolean canPostAward(AwardDocument document) {
        boolean canPost = false;
        if (document.isInStateToBePosted() || this.getAwardAccountService().isFinancialRestApiEnabled() && document.getDocumentHeader().getWorkflowDocument().isFinal() && this.awardService.isAwardPostAccountCreateEnabled()) {
            canPost = true;
        }
        return canPost;
    }

    public AwardDocument getAwardDocumentById(Long awardId) {
        Award award = this.awardDao.getAward(awardId);
        if (award == null) {
            throw new ResourceNotFoundException("Award with award id " + awardId + " not found.");
        }
        return (AwardDocument)this.commonApiService.getDocumentFromDocId(Long.parseLong(award.getAwardDocument().getDocumentNumber()));
    }

    SearchResults<AwardAccount> transformSearchResults(List<AwardAccount> accounts) {
        SearchResults<AwardAccount> result = new SearchResults<AwardAccount>();
        result.setResults(accounts);
        result.setTotalResults(accounts.size());
        return result;
    }

    public boolean isApiAuthEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KC-GEN", "Document", "RESKC-2456_Enable_Api_Authorization");
    }

    protected void assertUserHasPostReadAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", AwardPosts.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasPostWriteAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", AwardPosts.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasAccountReadAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Read Class", Collections.singletonMap("className", AwardAccount.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void assertUserHasAccountWriteAccess() {
        if (this.isApiAuthEnabled() && (this.globalVariableService.getUserSession() == null || !this.permissionService.hasPermissionByTemplate(this.globalVariableService.getUserSession().getPrincipalId(), "KC-SYS", "Write Class", Collections.singletonMap("className", AwardAccount.class.getName())))) {
            throw new UnauthorizedAccessException();
        }
    }

    protected void sendErrorResponse(String msg) {
        throw new ResourceNotFoundException(msg);
    }

    public AccountDao getAccountDao() {
        return this.accountDao;
    }

    public void setAccountDao(AccountDao accountDao) {
        this.accountDao = accountDao;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public AwardDao getAwardDao() {
        return this.awardDao;
    }

    public void setAwardDao(AwardDao awardDao) {
        this.awardDao = awardDao;
    }

    public CommonApiService getCommonApiService() {
        return this.commonApiService;
    }

    public void setCommonApiService(CommonApiService commonApiService) {
        this.commonApiService = commonApiService;
    }

    public AwardApiService getAwardApiService() {
        return this.awardApiService;
    }

    public void setAwardApiService(AwardApiService awardApiService) {
        this.awardApiService = awardApiService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public AwardAccountService getAwardAccountService() {
        return this.awardAccountService;
    }

    public void setAwardAccountService(AwardAccountService awardAccountService) {
        this.awardAccountService = awardAccountService;
    }
}

