/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.award.impl.coi;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.coi.framework.AbstractProjectRetrievalService;
import org.kuali.coeus.coi.framework.PersonType;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPerson;
import org.kuali.coeus.coi.framework.ProjectSponsor;
import org.kuali.coeus.coi.framework.ProjectTypeCode;
import org.kuali.coeus.coi.framework.Versionedproject;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.contacts.AwardPerson;
import org.springframework.stereotype.Component;

@Component(value="awardProjectRetrievalService")
public class AwardProjectRetrievalServiceImpl
extends AbstractProjectRetrievalService {
    private static final String AWARD_ALL_HIGHEST_SEQUENCE_QUERY = "SELECT AWARD_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM AWARD GROUP BY AWARD_NUMBER";
    private static final String AWARD_AMOUNT_INFO_LOWEST_SEQUENCE_QUERY = "SELECT FINAL_EXPIRATION_DATE, AWARD_NUMBER FROM AWARD_AMOUNT_INFO oaai WHERE oaai.AWARD_AMOUNT_INFO_ID = (SELECT MAX(AWARD_AMOUNT_INFO_ID) FROM AWARD_AMOUNT_INFO iaai WHERE iaai.AWARD_NUMBER = oaai.AWARD_NUMBER)";
    private static final String AWARD_ALL_PROJECT_QUERY = "SELECT t.TITLE, t.AWARD_ID, t.STATUS_CODE, t.AWARD_EFFECTIVE_DATE, t.SPONSOR_CODE, t.AWARD_SEQUENCE_STATUS, u.SPONSOR_NAME, t.AWARD_NUMBER, t.SEQUENCE_NUMBER, t.PRIME_SPONSOR_CODE, p.SPONSOR_NAME, t.SPONSOR_AWARD_NUMBER, u.SPONSOR_TYPE_CODE, st.DESCRIPTION as SPONSOR_TYPE_DESCRIPTION, pst.SPONSOR_TYPE_CODE as PRIME_SPONSOR_TYPE_CODE, pst.DESCRIPTION as PRIME_SPONSOR_TYPE_DESCRIPTION, aai.FINAL_EXPIRATION_DATE, t.AWARD_TYPE_CODE, at.DESCRIPTION as AWARD_TYPE_DESCRIPTION, t.UPDATE_TIMESTAMP as UPDATE_TIMESTAMP FROM (SELECT AWARD_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM AWARD GROUP BY AWARD_NUMBER) x INNER JOIN AWARD t ON t.AWARD_NUMBER = x.AWARD_NUMBER and t.SEQUENCE_NUMBER = x.maxseq LEFT OUTER JOIN SPONSOR u ON t.SPONSOR_CODE = u.SPONSOR_CODE LEFT OUTER JOIN SPONSOR p ON t.PRIME_SPONSOR_CODE = p.SPONSOR_CODE LEFT OUTER JOIN SPONSOR_TYPE st ON u.SPONSOR_TYPE_CODE = st.SPONSOR_TYPE_CODE LEFT OUTER JOIN SPONSOR_TYPE pst ON p.SPONSOR_TYPE_CODE = pst.SPONSOR_TYPE_CODE LEFT OUTER JOIN AWARD_TYPE at ON t.AWARD_TYPE_CODE = at.AWARD_TYPE_CODE LEFT OUTER JOIN (SELECT FINAL_EXPIRATION_DATE, AWARD_NUMBER FROM AWARD_AMOUNT_INFO oaai WHERE oaai.AWARD_AMOUNT_INFO_ID = (SELECT MAX(AWARD_AMOUNT_INFO_ID) FROM AWARD_AMOUNT_INFO iaai WHERE iaai.AWARD_NUMBER = oaai.AWARD_NUMBER)) aai ON aai.AWARD_NUMBER = x.AWARD_NUMBER";
    private static final String AWARD_ALL_PROJECT_PERSON_QUERY = "SELECT t.AWARD_ID, t.PERSON_ID, t.ROLODEX_ID, t.CONTACT_ROLE_CODE, t.AWARD_NUMBER, t.CAN_PASSIVELY_DISCLOSE_COIS FROM (SELECT AWARD_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM AWARD GROUP BY AWARD_NUMBER) x INNER JOIN AWARD_PERSONS t ON t.AWARD_NUMBER = x.AWARD_NUMBER and t.SEQUENCE_NUMBER = x.maxseq";
    private static final String AWARD_PROJECT_QUERY = "SELECT t.TITLE, t.AWARD_ID, t.STATUS_CODE, t.AWARD_EFFECTIVE_DATE, t.SPONSOR_CODE, t.AWARD_SEQUENCE_STATUS, u.SPONSOR_NAME, t.AWARD_NUMBER, t.SEQUENCE_NUMBER, t.PRIME_SPONSOR_CODE, p.SPONSOR_NAME, t.SPONSOR_AWARD_NUMBER, u.SPONSOR_TYPE_CODE, st.DESCRIPTION as SPONSOR_TYPE_DESCRIPTION, pst.SPONSOR_TYPE_CODE as PRIME_SPONSOR_TYPE_CODE, pst.DESCRIPTION as PRIME_SPONSOR_TYPE_DESCRIPTION, aai.FINAL_EXPIRATION_DATE, t.AWARD_TYPE_CODE, at.DESCRIPTION as AWARD_TYPE_DESCRIPTION, t.UPDATE_TIMESTAMP as UPDATE_TIMESTAMP FROM (SELECT AWARD_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM AWARD GROUP BY AWARD_NUMBER) x INNER JOIN AWARD t ON t.AWARD_NUMBER = x.AWARD_NUMBER and t.SEQUENCE_NUMBER = x.maxseq LEFT OUTER JOIN SPONSOR u ON t.SPONSOR_CODE = u.SPONSOR_CODE LEFT OUTER JOIN SPONSOR p ON t.PRIME_SPONSOR_CODE = p.SPONSOR_CODE LEFT OUTER JOIN SPONSOR_TYPE st ON u.SPONSOR_TYPE_CODE = st.SPONSOR_TYPE_CODE LEFT OUTER JOIN SPONSOR_TYPE pst ON p.SPONSOR_TYPE_CODE = pst.SPONSOR_TYPE_CODE LEFT OUTER JOIN AWARD_TYPE at ON t.AWARD_TYPE_CODE = at.AWARD_TYPE_CODE LEFT OUTER JOIN (SELECT FINAL_EXPIRATION_DATE, AWARD_NUMBER FROM AWARD_AMOUNT_INFO oaai WHERE oaai.AWARD_AMOUNT_INFO_ID = (SELECT MAX(AWARD_AMOUNT_INFO_ID) FROM AWARD_AMOUNT_INFO iaai WHERE iaai.AWARD_NUMBER = oaai.AWARD_NUMBER)) aai ON aai.AWARD_NUMBER = x.AWARD_NUMBER WHERE t.AWARD_NUMBER = ?";
    private static final String AWARD_PROJECT_PERSON_QUERY = "SELECT t.AWARD_ID, t.PERSON_ID, t.ROLODEX_ID, t.CONTACT_ROLE_CODE, t.AWARD_NUMBER, t.CAN_PASSIVELY_DISCLOSE_COIS FROM (SELECT AWARD_NUMBER, MAX(SEQUENCE_NUMBER) maxseq FROM AWARD GROUP BY AWARD_NUMBER) x INNER JOIN AWARD_PERSONS t ON t.AWARD_NUMBER = x.AWARD_NUMBER and t.SEQUENCE_NUMBER = x.maxseq WHERE t.AWARD_NUMBER = ?";
    private static final String CREATED_DATE_QUERY = "select CRTE_DT from KREW_DOC_HDR_T hdr INNER JOIN AWARD a ON hdr.DOC_HDR_ID = a.DOCUMENT_NUMBER where AWARD_NUMBER = ? and SEQUENCE_NUMBER = '1' ORDER BY AWARD_ID ASC";

    @Override
    protected Project toProject(ResultSet rs) throws SQLException {
        Project project = new Project();
        project.setTitle(rs.getString(1));
        project.setTypeCode(ProjectTypeCode.AWARD.getId());
        project.setSourceSystem("KC-AWARD");
        String sourceIdentifier = rs.getString(8);
        project.setSponsorTypeCode(rs.getString(13));
        project.setSponsorTypeDescription(rs.getString(14));
        project.setSourceIdentifier(sourceIdentifier);
        project.setSourceStatus(rs.getString(3));
        project.setStartDate(rs.getDate(4));
        project.setEndDate(rs.getDate(17));
        project.setAwardTypeCode(rs.getString(18));
        project.setAwardTypeDescription(rs.getString(19));
        project.setPrimeSponsorCode(rs.getString(10));
        project.setPrimeSponsorName(rs.getString(11));
        project.setPrimeSponsorTypeCode(rs.getString(15));
        project.setPrimeSponsorTypeDescription(rs.getString(16));
        project.setShortUrl(this.getBaseShortUrl() + "/kc-common/awards/" + sourceIdentifier);
        project.setSponsorProjectId(rs.getString(12));
        if (StringUtils.equalsIgnoreCase((CharSequence)rs.getString(6), (CharSequence)VersionStatus.CANCELED.toString())) {
            project.setActive(Boolean.FALSE);
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("sourceUniqueIdentifier", rs.getString(2));
        project.setMetadata(metadata);
        this.setSponsorFields(Collections.singletonList(new ProjectSponsor("KC-AWARD", sourceIdentifier, rs.getString(5), rs.getString(7), new HashMap<String, String>(metadata), rs.getString(13), rs.getString(14))), project);
        this.setLinkedProjects(rs.getLong(2), project);
        project.setCreatedOn(this.getCreatedDate(sourceIdentifier));
        project.setUpdateTimestamp(rs.getTimestamp(20).getTime());
        return project;
    }

    @Override
    public String getCreatedDateQuery() {
        return CREATED_DATE_QUERY;
    }

    public void setLinkedProjects(Long awardId, Project project) throws SQLException {
        if (this.getParameterService().getParameterValueAsBoolean("KC-SYS", "All", "Linked_Project_Push_Enabled").booleanValue()) {
            project.setLinkedProjects(this.getLinkedProjects(this.getMedusaService().getMedusaByAward("award", awardId).get(0)));
        }
    }

    @Override
    protected ProjectPerson toProjectPerson(ResultSet rs) throws SQLException {
        ProjectPerson person = new ProjectPerson();
        person.setSourceSystem("KC-AWARD");
        person.setSourceIdentifier(rs.getString(5));
        String personId = rs.getString(2);
        String rolodexId = rs.getString(3);
        person.setPersonId(StringUtils.isNotBlank((CharSequence)personId) ? personId : rolodexId);
        person.setSourcePersonType(StringUtils.isNotBlank((CharSequence)personId) ? PersonType.EMPLOYEE.toString() : PersonType.NONEMPLOYEE.toString());
        person.setRoleCode(rs.getString(4));
        person.setQuestionnaireRequired("Y".equals(rs.getString(6)));
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("sourceUniqueIdentifier", rs.getString(1));
        person.setMetadata(metadata);
        return person;
    }

    public List<ProjectPerson> getProjectPersons(List<? extends KcPersistableBusinessObjectBase> persons, String sourceIdentifier, Map<String, String> metadata) {
        List<ProjectPerson> projectPersons = persons.stream().map(person -> {
            ProjectPerson projectPerson = new ProjectPerson();
            AwardPerson awardPerson = (AwardPerson)person;
            projectPerson.setPersonId(StringUtils.isNotBlank((CharSequence)awardPerson.getPersonId()) ? awardPerson.getPersonId() : awardPerson.getRolodexId().toString());
            projectPerson.setSourceIdentifier(sourceIdentifier);
            projectPerson.setSourcePersonType(StringUtils.isNotBlank((CharSequence)awardPerson.getPersonId()) ? PersonType.EMPLOYEE.toString() : PersonType.NONEMPLOYEE.toString());
            projectPerson.setSourceSystem("KC-AWARD");
            projectPerson.setRoleCode(awardPerson.getRoleCode());
            projectPerson.setMetadata(metadata);
            return projectPerson;
        }).collect(Collectors.toList());
        return projectPersons;
    }

    @Override
    public Project convertObjectToProject(Versionedproject versionedproject) throws SQLException {
        Project awardProject = new Project();
        awardProject.setActive(Boolean.TRUE);
        awardProject.setTitle(versionedproject.getTitle());
        awardProject.setStartDate(versionedproject.getStartDate());
        awardProject.setEndDate(versionedproject.getEndDate());
        awardProject.setShortUrl(this.getBaseShortUrl() + "/kc-common/awards/" + versionedproject.getSourceIdentifier());
        awardProject.setSourceStatus(versionedproject.getSourceStatus());
        awardProject.setTypeCode(ProjectTypeCode.AWARD.getId());
        awardProject.setSourceSystem("KC-AWARD");
        awardProject.setSourceIdentifier(versionedproject.getSourceIdentifier());
        awardProject.setSponsorProjectId(versionedproject.getSponsorProjectId());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("sourceUniqueIdentifier", versionedproject.getUniqueIdentifier().toString());
        if (Objects.nonNull(versionedproject.getSponsor())) {
            awardProject.setSponsorTypeCode(versionedproject.getSponsor().getSponsorTypeCode());
            awardProject.setSponsorName(versionedproject.getSponsor().getSponsorName());
            awardProject.setSponsorTypeDescription(Objects.nonNull(versionedproject.getSponsor().getSponsorType()) ? versionedproject.getSponsor().getSponsorType().getDescription() : null);
            awardProject.setSponsorCode(versionedproject.getSponsor().getSponsorCode());
        }
        if (Objects.nonNull(versionedproject.getPrimeSponsor())) {
            awardProject.setPrimeSponsorTypeDescription(Objects.nonNull(versionedproject.getPrimeSponsor().getSponsorType()) ? versionedproject.getPrimeSponsor().getSponsorType().getDescription() : null);
            awardProject.setPrimeSponsorTypeCode(versionedproject.getPrimeSponsor().getSponsorTypeCode());
            awardProject.setPrimeSponsorCode(versionedproject.getPrimeSponsor().getSponsorCode());
            awardProject.setPrimeSponsorName(versionedproject.getPrimeSponsor().getSponsorName());
        }
        awardProject.setPersons(this.getProjectPersons(versionedproject.getPersons(), versionedproject.getSourceIdentifier(), metadata));
        this.setSponsorFields(Collections.singletonList(new ProjectSponsor("KC-AWARD", versionedproject.getSourceIdentifier(), versionedproject.getSponsor().getSponsorCode(), versionedproject.getSponsor().getSponsorName(), new HashMap<String, String>(metadata), versionedproject.getSponsor().getSponsorTypeCode(), versionedproject.getSponsor().getSponsorType().getDescription())), awardProject);
        awardProject.setMetadata(metadata);
        this.setLinkedProjects(versionedproject.getUniqueIdentifier(), awardProject);
        return awardProject;
    }

    @Override
    protected String allProjectQuery() {
        return AWARD_ALL_PROJECT_QUERY;
    }

    @Override
    protected String allProjectPersonQuery() {
        return AWARD_ALL_PROJECT_PERSON_QUERY;
    }

    @Override
    protected String projectQuery() {
        return AWARD_PROJECT_QUERY;
    }

    @Override
    protected String projectPersonQuery() {
        return AWARD_PROJECT_PERSON_QUERY;
    }
}

