/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.api.projects;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPublisher;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v1"})
@RestController(value="projectPushController")
public class ProjectPushController
extends org.kuali.coeus.sys.framework.controller.rest.RestController {
    private ProjectPublisher projectPublisher;
    private Map<String, ProjectRetrievalService> projectRetrievalServices = new HashMap<String, ProjectRetrievalService>();

    @PostMapping(value={"/push-projects/{sourceSystem}/{sourceIdentifier}"}, consumes={"application/json"}, produces={"text/plain"})
    @ResponseStatus(value=HttpStatus.ACCEPTED)
    public String pushProjects(@PathVariable String sourceSystem, @PathVariable String sourceIdentifier) {
        Project project = this.retrieveProject(sourceSystem, sourceIdentifier);
        if (ObjectUtils.isNotEmpty((Object)project)) {
            project.setForceUpdate(true);
            this.getProjectPublisher().publishProject(project);
            return String.format("pushed project %s - %s", sourceSystem, sourceIdentifier);
        }
        throw new ResourceNotFoundException(String.format("project %s - %s not found.", sourceSystem, sourceIdentifier));
    }

    private Project retrieveProject(String sourceSystem, String sourceIdentifier) {
        switch (sourceSystem) {
            case "KC-AWARD": {
                return this.getProjectRetrievalService("awardProjectRetrievalService").retrieveProject(sourceIdentifier);
            }
            case "KC-PD": {
                return this.getProjectRetrievalService("propDevProjectRetrievalService").retrieveProject(sourceIdentifier);
            }
            case "KC-IP": {
                return this.getProjectRetrievalService("instPropProjectRetrievalService").retrieveProject(sourceIdentifier);
            }
        }
        return null;
    }

    public ProjectPublisher getProjectPublisher() {
        if (this.projectPublisher == null) {
            this.projectPublisher = KcServiceLocator.getService(ProjectPublisher.class);
        }
        return this.projectPublisher;
    }

    public void setProjectPublisher(ProjectPublisher projectPublisher) {
        this.projectPublisher = projectPublisher;
    }

    private ProjectRetrievalService getProjectRetrievalService(String serviceName) {
        ProjectRetrievalService service = this.projectRetrievalServices.get(serviceName);
        if (service == null) {
            service = (ProjectRetrievalService)KcServiceLocator.getService(serviceName);
            this.projectRetrievalServices.put(serviceName, service);
        }
        return service;
    }
}

