/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.calculator;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.calculator.BudgetSubcontractorFACalculator;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetCommonService;
import org.kuali.coeus.common.budget.framework.core.BudgetCommonServiceFactory;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategoryType;
import org.kuali.coeus.common.budget.framework.distribution.BudgetDistributionService;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetFormulatedCostDetail;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelRateAndBase;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.query.operator.And;
import org.kuali.coeus.common.budget.framework.query.operator.Equals;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.budget.framework.rate.RateClass;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.common.budget.framework.rate.ValidCeRateType;
import org.kuali.coeus.common.budget.impl.calculator.BudgetPeriodCalculator;
import org.kuali.coeus.common.budget.impl.calculator.LineItemCalculator;
import org.kuali.coeus.common.budget.impl.calculator.PersonnelLineItemCalculator;
import org.kuali.coeus.common.framework.impl.LineItemGroup;
import org.kuali.coeus.common.framework.impl.LineItemObject;
import org.kuali.coeus.common.framework.impl.Period;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyStatusConstants;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetCalculationService")
public class BudgetCalculationServiceImpl
implements BudgetCalculationService,
BudgetSubcontractorFACalculator {
    private static final String BUDGET_SUMMARY_PERIOD_HEADER_LABEL = "P";
    private static final String BUDGET_SUMMARY_PERSONNEL_GROUP_LABEL = "Personnel";
    private static final String BUDGET_SUMMARY_NONPERSONNEL_GROUP_LABEL = "Non-personnel";
    private static final String BUDGET_SUMMARY_TOTALS_GROUP_LABEL = "Totals";
    private static final String CALCULATED_COST = "calculatedCost";
    @Autowired
    @Qualifier(value="budgetDistributionService")
    private BudgetDistributionService budgetDistributionService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="budgetRatesService")
    private BudgetRatesService budgetRatesService;

    @Override
    public void calculateBudget(Budget budget) {
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            this.calculateBudgetPeriod(budget, budgetPeriod);
        }
        if (!budgetPeriods.isEmpty()) {
            this.syncCostsToBudget(budget);
        }
    }

    protected boolean isCalculationRequired(Budget budget, BudgetPeriod budgetPeriod) {
        assert (budgetPeriod != null) : "The budget period is null";
        boolean budgetLineItemDeleted = budget.isBudgetLineItemDeleted();
        if (this.getBudgetCommonService(budget).isRateOverridden(budgetPeriod)) {
            return false;
        }
        if (StringUtils.equals((CharSequence)budgetPeriod.getBudget().getBudgetParent().getHierarchyStatus(), (CharSequence)HierarchyStatusConstants.Parent.code())) {
            return true;
        }
        boolean isLineItemsEmpty = budgetPeriod.getBudgetLineItems().isEmpty();
        if (isLineItemsEmpty && !budgetLineItemDeleted) {
            Collection<? extends BudgetLineItem> deletedLineItems = this.getLineItemsFromDatabase(budgetPeriod);
            return !deletedLineItems.isEmpty();
        }
        return true;
    }

    protected Collection<? extends BudgetLineItem> getLineItemsFromDatabase(BudgetPeriod budgetPeriod) {
        HashMap<String, Number> fieldValues = new HashMap<String, Number>();
        fieldValues.put("budgetId", budgetPeriod.getBudgetId());
        fieldValues.put("budgetPeriod", budgetPeriod.getBudgetPeriod());
        return this.dataObjectService.findMatching(BudgetLineItem.class, QueryByCriteria.Builder.andAttributes(fieldValues).build()).getResults();
    }

    protected void copyLineItemToPersonnelDetails(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails) {
        budgetPersonnelDetails.setBudget(budgetLineItem.getBudget());
        budgetPersonnelDetails.setBudgetId(budgetLineItem.getBudgetId());
        budgetPersonnelDetails.setBudgetPeriod(budgetLineItem.getBudgetPeriod());
        budgetPersonnelDetails.setLineItemNumber(budgetLineItem.getLineItemNumber());
        budgetPersonnelDetails.setCostElement(budgetLineItem.getCostElement());
        budgetPersonnelDetails.setCostElementBO(budgetLineItem.getCostElementBO());
        budgetPersonnelDetails.setApplyInRateFlag(budgetLineItem.getApplyInRateFlag());
        budgetPersonnelDetails.setOnOffCampusFlag(budgetLineItem.getOnOffCampusFlag());
        budgetPersonnelDetails.setBudgetLineItem(budgetLineItem);
    }

    @Override
    public void calculateBudgetLineItem(Budget budget, BudgetPersonnelDetails budgetLineItem) {
        new PersonnelLineItemCalculator(budget, budgetLineItem).calculate();
    }

    @Override
    public void calculateBudgetLineItem(Budget budget, BudgetLineItem budgetLineItem) {
        List<BudgetPersonnelDetails> budgetPersonnelDetList = budgetLineItem.getBudgetPersonnelDetailsList();
        if (budgetLineItem.isBudgetPersonnelLineItemDeleted() || budgetPersonnelDetList != null && !budgetPersonnelDetList.isEmpty()) {
            List<BudgetLineItemCalculatedAmount> list;
            String rateKey;
            this.updatePersonnelBudgetRate(budgetLineItem);
            ScaleTwoDecimal personnelLineItemTotal = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal personnelTotalCostSharing = ScaleTwoDecimal.ZERO;
            HashMap<CallSite, ScaleTwoDecimal> totalCalculatedCost = new HashMap<CallSite, ScaleTwoDecimal>();
            HashMap<CallSite, ScaleTwoDecimal> totalCalculatedCostSharing = new HashMap<CallSite, ScaleTwoDecimal>();
            ScaleTwoDecimal newTotalUrAmount = ScaleTwoDecimal.ZERO;
            budgetLineItem.getBudgetRateAndBaseList().clear();
            int rateNumber = 0;
            boolean resetTotalUnderRecovery = false;
            ScaleTwoDecimal calcDirectCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal calcIndirectCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal calcTotalCostSharing = ScaleTwoDecimal.ZERO;
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetPersonnelDetList) {
                this.copyLineItemToPersonnelDetails(budgetLineItem, budgetPersonnelDetails);
                new PersonnelLineItemCalculator(budget, budgetPersonnelDetails).calculate();
                personnelLineItemTotal = (ScaleTwoDecimal)personnelLineItemTotal.add((AbstractDecimal)budgetPersonnelDetails.getLineItemCost());
                personnelTotalCostSharing = (ScaleTwoDecimal)personnelTotalCostSharing.add((AbstractDecimal)budgetPersonnelDetails.getCostSharingAmount());
                newTotalUrAmount = (ScaleTwoDecimal)newTotalUrAmount.add((AbstractDecimal)budgetPersonnelDetails.getUnderrecoveryAmount());
                resetTotalUnderRecovery = true;
                List<BudgetPersonnelCalculatedAmount> calAmts = budgetPersonnelDetails.getBudgetCalculatedAmounts();
                if (CollectionUtils.isNotEmpty(calAmts)) {
                    for (BudgetPersonnelCalculatedAmount personnelCalAmt : calAmts) {
                        rateKey = personnelCalAmt.getRateClassCode() + ":" + personnelCalAmt.getRateTypeCode();
                        if (!totalCalculatedCost.containsKey(rateKey)) {
                            totalCalculatedCost.put((CallSite)((Object)rateKey), personnelCalAmt.getCalculatedCost());
                            totalCalculatedCostSharing.put((CallSite)((Object)rateKey), personnelCalAmt.getCalculatedCostSharing());
                        } else {
                            ScaleTwoDecimal value = (ScaleTwoDecimal)totalCalculatedCost.get(rateKey);
                            value = (ScaleTwoDecimal)value.add((AbstractDecimal)personnelCalAmt.getCalculatedCost());
                            totalCalculatedCost.put((CallSite)((Object)rateKey), value);
                            value = (ScaleTwoDecimal)totalCalculatedCostSharing.get(rateKey);
                            value = (ScaleTwoDecimal)value.add((AbstractDecimal)personnelCalAmt.getCalculatedCostSharing());
                            totalCalculatedCostSharing.put((CallSite)((Object)rateKey), value);
                        }
                        if (personnelCalAmt.getRateClass() == null) {
                            personnelCalAmt.refreshReferenceObject("rateClass");
                        }
                        if (!personnelCalAmt.getRateClass().getRateClassTypeCode().equals(RateClassType.OVERHEAD.getRateClassType())) {
                            calcDirectCost = (ScaleTwoDecimal)calcDirectCost.add((AbstractDecimal)personnelCalAmt.getCalculatedCost());
                        } else {
                            calcIndirectCost = (ScaleTwoDecimal)calcIndirectCost.add((AbstractDecimal)personnelCalAmt.getCalculatedCost());
                        }
                        calcTotalCostSharing = (ScaleTwoDecimal)calcTotalCostSharing.add((AbstractDecimal)personnelCalAmt.getCalculatedCostSharing());
                    }
                }
                this.populateRateAndBase(budgetLineItem, budgetPersonnelDetails, rateNumber);
            }
            if (resetTotalUnderRecovery) {
                budgetLineItem.setUnderrecoveryAmount(newTotalUrAmount);
            }
            budgetLineItem.setLineItemCost(personnelLineItemTotal);
            budgetLineItem.setCostSharingAmount(personnelTotalCostSharing);
            budgetLineItem.setDirectCost((ScaleTwoDecimal)calcDirectCost.add((AbstractDecimal)personnelLineItemTotal));
            budgetLineItem.setTotalCostSharingAmount((ScaleTwoDecimal)calcTotalCostSharing.add((AbstractDecimal)personnelTotalCostSharing));
            budgetLineItem.setIndirectCost(calcIndirectCost);
            boolean lineItemCalcAmntsOutOfDate = false;
            if (budgetLineItem.getBudgetCalculatedAmounts().size() == totalCalculatedCost.size()) {
                for (BudgetLineItemCalculatedAmount lineItemCalAmt : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    rateKey = lineItemCalAmt.getRateClassCode() + ":" + lineItemCalAmt.getRateTypeCode();
                    if (totalCalculatedCost.containsKey(rateKey)) continue;
                    lineItemCalcAmntsOutOfDate = true;
                    break;
                }
            } else {
                lineItemCalcAmntsOutOfDate = true;
            }
            if (lineItemCalcAmntsOutOfDate) {
                this.rePopulateCalculatedAmount(budget, budgetLineItem);
            }
            if (CollectionUtils.isNotEmpty(list = budgetLineItem.getBudgetLineItemCalculatedAmounts())) {
                for (BudgetLineItemCalculatedAmount lineItemCalAmt : list) {
                    String rateKey2 = lineItemCalAmt.getRateClassCode() + ":" + lineItemCalAmt.getRateTypeCode();
                    if (!totalCalculatedCost.containsKey(rateKey2)) continue;
                    lineItemCalAmt.setCalculatedCost((ScaleTwoDecimal)totalCalculatedCost.get(rateKey2));
                    lineItemCalAmt.setCalculatedCostSharing((ScaleTwoDecimal)totalCalculatedCostSharing.get(rateKey2));
                }
            }
        } else {
            new LineItemCalculator(budget, budgetLineItem).calculate();
        }
    }

    protected void populateRateAndBase(BudgetLineItem bli, BudgetPersonnelDetails budgetPersonnelDetails, int rateNumber) {
        List<BudgetRateAndBase> budgetRateAndBaseList = bli.getBudgetRateAndBaseList();
        List<BudgetPersonnelRateAndBase> budgetPersonnelRateBaseList = budgetPersonnelDetails.getBudgetPersonnelRateAndBaseList();
        for (BudgetPersonnelRateAndBase budgetPersonnelRateAndBase : budgetPersonnelRateBaseList) {
            BudgetRateAndBase budgetRateBase = new BudgetRateAndBase();
            ScaleTwoDecimal appliedRate = budgetPersonnelRateAndBase.getAppliedRate();
            budgetRateBase.setAppliedRate(ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)appliedRate));
            ScaleTwoDecimal calculatedCost = budgetPersonnelRateAndBase.getCalculatedCost();
            ScaleTwoDecimal calculatedCostSharing = budgetPersonnelRateAndBase.getCalculatedCostSharing();
            budgetRateBase.setBaseCostSharing(budgetPersonnelRateAndBase.getBaseCostSharing());
            budgetRateBase.setBaseCost(budgetPersonnelRateAndBase.getSalaryRequested());
            budgetRateBase.setBudgetPeriodId(budgetPersonnelRateAndBase.getBudgetPeriodId());
            budgetRateBase.setBudgetPeriod(budgetPersonnelRateAndBase.getBudgetPeriod());
            budgetRateBase.setCalculatedCost(calculatedCost);
            budgetRateBase.setCalculatedCostSharing(calculatedCostSharing);
            budgetRateBase.setEndDate(budgetPersonnelRateAndBase.getEndDate());
            budgetRateBase.setLineItemNumber(budgetPersonnelRateAndBase.getLineItemNumber());
            budgetRateBase.setOnOffCampusFlag(budgetPersonnelRateAndBase.getOnOffCampusFlag());
            budgetRateBase.setBudgetId(budgetPersonnelRateAndBase.getBudgetId());
            budgetRateBase.setRateClassCode(budgetPersonnelRateAndBase.getRateClassCode());
            budgetRateBase.setRateNumber(++rateNumber);
            budgetRateBase.setRateTypeCode(budgetPersonnelRateAndBase.getRateTypeCode());
            budgetRateBase.setStartDate(budgetPersonnelRateAndBase.getStartDate());
            budgetRateBase.setBudgetLineItem(bli);
            budgetRateAndBaseList.add(budgetRateBase);
        }
    }

    @Override
    public void populateCalculatedAmount(Budget budget, BudgetLineItem budgetLineItem) {
        new LineItemCalculator(budget, budgetLineItem).populateCalculatedAmountLineItems();
    }

    @Override
    public void populateCalculatedAmount(Budget budget, BudgetPersonnelDetails budgetPersonnelDetails) {
        new PersonnelLineItemCalculator(budget, budgetPersonnelDetails).populateCalculatedAmountLineItems();
    }

    @Override
    public void calculateBudgetPeriod(Budget budget, BudgetPeriod budgetPeriod) {
        if (this.isCalculationRequired(budget, budgetPeriod)) {
            new BudgetPeriodCalculator().calculate(budget, budgetPeriod);
        }
        this.updateBudgetTotalCost(budget);
    }

    protected void syncCostsToBudget(Budget budget) {
        assert (budget != null) : "The budget was null";
        this.initCostDependentItems(budget);
        this.ensureBudgetPeriodHasSyncedCosts(budget);
        this.setBudgetCostsFromPeriods(budget);
    }

    protected void initCostDependentItems(Budget budget) {
        assert (budget != null) : "The budget was null";
        if (!this.isPositiveTotalUnderreoveryAmount(budget)) {
            this.initUnrecoveredFandAs(budget);
        }
        if (!this.isPositiveTotalCostSharingAmount(budget)) {
            this.initCostSharing(budget);
        }
    }

    protected void initUnrecoveredFandAs(Budget document) {
        assert (document != null) : "the document was null";
        document.getBudgetUnrecoveredFandAs().clear();
        this.getBudgetDistributionService().initializeUnrecoveredFandACollectionDefaults(document);
    }

    protected void initCostSharing(Budget document) {
        assert (document != null) : "the document was null";
        document.getBudgetCostShares().clear();
        this.getBudgetDistributionService().initializeCostSharingCollectionDefaults(document);
    }

    protected void ensureBudgetPeriodHasSyncedCosts(Budget budget) {
        assert (budget != null) : "the document was null";
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (!this.isCalculationRequired(budget, budgetPeriod)) continue;
            this.setBudgetPeriodCostsFromLineItems(budgetPeriod);
        }
    }

    protected void setBudgetCostsFromPeriods(Budget budget) {
        assert (budget != null) : "The document is null";
        budget.setTotalDirectCost(budget.getSumDirectCostAmountFromPeriods());
        budget.setTotalIndirectCost(budget.getSumIndirectCostAmountFromPeriods());
        budget.setTotalCost(budget.getSumTotalCostAmountFromPeriods());
        budget.setUnderrecoveryAmount(budget.getSumUnderreoveryAmountFromPeriods());
        budget.setCostSharingAmount(budget.getSumCostSharingAmountFromPeriods());
    }

    protected void setBudgetPeriodCostsFromLineItems(BudgetPeriod budgetPeriod) {
        assert (budgetPeriod != null) : "The period is null";
        budgetPeriod.setTotalDirectCost(budgetPeriod.getSumDirectCostAmountFromLineItems());
        budgetPeriod.setTotalIndirectCost(budgetPeriod.getSumIndirectCostAmountFromLineItems());
        budgetPeriod.setTotalCost(budgetPeriod.getSumTotalCostAmountFromLineItems());
        budgetPeriod.setUnderrecoveryAmount(budgetPeriod.getSumUnderreoveryAmountFromLineItems());
        budgetPeriod.setCostSharingAmount(budgetPeriod.getSumTotalCostSharingAmountFromLineItems());
        ScaleTwoDecimal subconFACost = this.calculateSubcontractorFACost(budgetPeriod);
        budgetPeriod.setTotalDirectCostLessSubcontractorFA((ScaleTwoDecimal)budgetPeriod.getTotalDirectCost().subtract((AbstractDecimal)subconFACost));
    }

    protected final boolean isPositiveTotalUnderreoveryAmount(Budget document) {
        assert (document != null) : "The periods is null";
        ScaleTwoDecimal lineItemsAmount = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : document.getBudgetPeriods()) {
            lineItemsAmount = (ScaleTwoDecimal)lineItemsAmount.add((AbstractDecimal)budgetPeriod.getSumUnderreoveryAmountFromLineItems());
        }
        return lineItemsAmount.isPositive() || document.getSumUnderreoveryAmountFromPeriods().isPositive();
    }

    protected final boolean isPositiveTotalCostSharingAmount(Budget document) {
        assert (document != null) : "The document is null";
        ScaleTwoDecimal lineItemsAmount = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : document.getBudgetPeriods()) {
            lineItemsAmount = (ScaleTwoDecimal)lineItemsAmount.add((AbstractDecimal)budgetPeriod.getSumTotalCostSharingAmountFromLineItems());
        }
        return lineItemsAmount.isPositive() || document.getSumCostSharingAmountFromPeriods().isPositive();
    }

    protected SortedMap<BudgetCategoryType, List<CostElement>> categorizeObjectCodesByCategory(Budget budget) {
        SortedMap<CostElement, List<ScaleTwoDecimal>> objectCodeTotals = budget.getObjectCodeTotals();
        TreeMap<BudgetCategoryType, List<CostElement>> objectCodeListByBudgetCategoryType = new TreeMap<BudgetCategoryType, List<CostElement>>();
        for (CostElement objectCode : objectCodeTotals.keySet()) {
            objectCode.refreshReferenceObject("budgetCategory");
            if (objectCode.getBudgetCategory() != null) {
                objectCode.getBudgetCategory().refreshReferenceObject("budgetCategoryType");
                objectCode.setBudgetCategoryTypeCode(objectCode.getBudgetCategory().getBudgetCategoryTypeCode());
            }
            if (objectCodeListByBudgetCategoryType.containsKey(objectCode.getBudgetCategory().getBudgetCategoryType())) continue;
            List<CostElement> filteredObjectCodes = this.filterObjectCodesByBudgetCategoryType(objectCodeTotals.keySet(), objectCode.getBudgetCategoryTypeCode());
            objectCodeListByBudgetCategoryType.put(objectCode.getBudgetCategory().getBudgetCategoryType(), filteredObjectCodes);
        }
        return objectCodeListByBudgetCategoryType;
    }

    protected BudgetCategoryType getPersonnelCategoryType() {
        return (BudgetCategoryType)this.getDataObjectService().find(BudgetCategoryType.class, (Object)this.getPersonnelBudgetCategoryTypeCode());
    }

    protected List<BudgetCategoryType> getAllBudgetCategoryTypes() {
        return this.getDataObjectService().findAll(BudgetCategoryType.class).getResults();
    }

    @Override
    @Deprecated
    public void calculateBudgetSummaryTotals(Budget budget) {
        this.calculateBudgetTotals(budget);
        SortedMap<BudgetCategoryType, List<CostElement>> objectCodeListByBudgetCategoryType = this.categorizeObjectCodesByCategory(budget);
        TreeMap<CostElement, List<BudgetPersonnelDetails>> objectCodeUniquePersonnelList = new TreeMap<CostElement, List<BudgetPersonnelDetails>>();
        TreeMap<String, List<ScaleTwoDecimal>> objectCodePersonnelSalaryTotals = new TreeMap<String, List<ScaleTwoDecimal>>();
        TreeMap<String, List<ScaleTwoDecimal>> objectCodePersonnelFringeTotals = new TreeMap<String, List<ScaleTwoDecimal>>();
        TreeSet<CallSite> objectCodePersonnelSalaryTotalsByPeriod = new TreeSet<CallSite>();
        TreeSet<CallSite> objectCodePersonnelFringeTotalsByPeriod = new TreeSet<CallSite>();
        ArrayList<ScaleTwoDecimal> periodSummarySalaryTotals = new ArrayList<ScaleTwoDecimal>();
        for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
            periodSummarySalaryTotals.add(i, ScaleTwoDecimal.ZERO);
        }
        ArrayList<ScaleTwoDecimal> periodSummaryFringeTotals = new ArrayList<ScaleTwoDecimal>();
        for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
            periodSummaryFringeTotals.add(i, ScaleTwoDecimal.ZERO);
        }
        TreeMap<String, List<ScaleTwoDecimal>> subTotalsBySubSection = new TreeMap<String, List<ScaleTwoDecimal>>();
        subTotalsBySubSection.put("personnelSalaryTotals", periodSummarySalaryTotals);
        subTotalsBySubSection.put("personnelFringeTotals", periodSummaryFringeTotals);
        BudgetCategoryType personnelCategory = this.getPersonnelCategoryType();
        List personnelObjectCodes = (List)objectCodeListByBudgetCategoryType.get(personnelCategory);
        if (CollectionUtils.isNotEmpty((Collection)personnelObjectCodes)) {
            for (CostElement personnelCostElement : personnelObjectCodes) {
                if (!objectCodeUniquePersonnelList.containsKey(personnelCostElement)) {
                    objectCodeUniquePersonnelList.put(personnelCostElement, new ArrayList());
                }
                for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                    budgetPeriod.setBudget(budget);
                    QueryList<BudgetLineItem> lineItemQueryList = new QueryList<BudgetLineItem>();
                    lineItemQueryList.addAll(budgetPeriod.getBudgetLineItems());
                    Equals objectCodeEquals = new Equals("costElement", (Comparable)((Object)personnelCostElement.getCostElement()));
                    QueryList filteredLineItems = lineItemQueryList.filter(objectCodeEquals);
                    ArrayList<BudgetPersonnelDetails> personnelQueryList = new ArrayList<BudgetPersonnelDetails>();
                    for (BudgetLineItem matchingLineItem : filteredLineItems) {
                        personnelQueryList.addAll(matchingLineItem.getBudgetPersonnelDetailsList());
                    }
                    for (BudgetLineItem matchingLineItem : filteredLineItems) {
                        boolean isLineItemCalculationNeeded;
                        for (BudgetPersonnelDetails budgetPersonnelDetails : matchingLineItem.getBudgetPersonnelDetailsList()) {
                            int i;
                            List personOccurrencesForSameObjectCode = personnelQueryList.stream().filter(budgetPersonnelDetails1 -> budgetPersonnelDetails1.getPersonId().equals(budgetPersonnelDetails.getPersonId()) && budgetPersonnelDetails1.getBudgetPerson().getPersonName().equals(budgetPersonnelDetails.getBudgetPerson().getPersonName())).collect(Collectors.toList());
                            ScaleTwoDecimal personSalaryTotalsForCurrentPeriod = personOccurrencesForSameObjectCode.stream().map(BudgetPersonnelDetails::getSalaryRequested).reduce(ScaleTwoDecimal.ZERO, AbstractDecimal::add);
                            String objectCodePersonnelSalaryTotalsKey = matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId() + "," + budgetPersonnelDetails.getBudgetPerson().getPersonName();
                            if (!objectCodePersonnelSalaryTotals.containsKey(objectCodePersonnelSalaryTotalsKey)) {
                                ((List)objectCodeUniquePersonnelList.get(matchingLineItem.getCostElementBO())).add(budgetPersonnelDetails);
                                ArrayList<ScaleTwoDecimal> periodTotals = new ArrayList<ScaleTwoDecimal>();
                                for (i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                                    periodTotals.add(i, ScaleTwoDecimal.ZERO);
                                }
                                objectCodePersonnelSalaryTotals.put(objectCodePersonnelSalaryTotalsKey, periodTotals);
                            }
                            ((List)objectCodePersonnelSalaryTotals.get(objectCodePersonnelSalaryTotalsKey)).set(budgetPeriod.getBudgetPeriod() - 1, personSalaryTotalsForCurrentPeriod);
                            if (objectCodePersonnelSalaryTotalsByPeriod.add((CallSite)((Object)(budgetPeriod.getBudgetPeriod().toString() + "," + matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId() + "," + budgetPersonnelDetails.getBudgetPerson().getPersonName())))) {
                                ((List)subTotalsBySubSection.get("personnelSalaryTotals")).set(budgetPeriod.getBudgetPeriod() - 1, (ScaleTwoDecimal)((ScaleTwoDecimal)((List)subTotalsBySubSection.get("personnelSalaryTotals")).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractDecimal)personSalaryTotalsForCurrentPeriod));
                            }
                            if (!objectCodePersonnelFringeTotals.containsKey(matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId() + "," + budgetPersonnelDetails.getPersonNumber())) {
                                ArrayList<ScaleTwoDecimal> periodFringeTotals = new ArrayList<ScaleTwoDecimal>();
                                for (i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                                    periodFringeTotals.add(i, ScaleTwoDecimal.ZERO);
                                }
                                objectCodePersonnelFringeTotals.put(matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId() + "," + budgetPersonnelDetails.getPersonNumber(), periodFringeTotals);
                            }
                            ScaleTwoDecimal personFringeTotalsForCurrentPeriod = ScaleTwoDecimal.ZERO;
                            BudgetPersonnelDetails personOccurrence = personOccurrencesForSameObjectCode.stream().filter(o -> o.getPersonNumber().equals(budgetPersonnelDetails.getPersonNumber())).findFirst().get();
                            for (BudgetPersonnelCalculatedAmount calcExpenseAmount : personOccurrence.getBudgetPersonnelCalculatedAmounts()) {
                                calcExpenseAmount.refreshReferenceObject("rateClass");
                                if (!calcExpenseAmount.getAddToFringeRate()) continue;
                                personFringeTotalsForCurrentPeriod = (ScaleTwoDecimal)personFringeTotalsForCurrentPeriod.add((AbstractDecimal)calcExpenseAmount.getCalculatedCost());
                            }
                            ((List)objectCodePersonnelFringeTotals.get(matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId() + "," + budgetPersonnelDetails.getPersonNumber())).set(budgetPeriod.getBudgetPeriod() - 1, personFringeTotalsForCurrentPeriod);
                            if (!objectCodePersonnelFringeTotalsByPeriod.add((CallSite)((Object)(budgetPeriod.getBudgetPeriod().toString() + "," + matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId())))) continue;
                            ((List)subTotalsBySubSection.get("personnelFringeTotals")).set(budgetPeriod.getBudgetPeriod() - 1, (ScaleTwoDecimal)((ScaleTwoDecimal)((List)subTotalsBySubSection.get("personnelFringeTotals")).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractDecimal)personFringeTotalsForCurrentPeriod));
                        }
                        if (!CollectionUtils.isEmpty(matchingLineItem.getBudgetPersonnelDetailsList())) continue;
                        if (!objectCodePersonnelSalaryTotals.containsKey(matchingLineItem.getCostElement())) {
                            ArrayList<ScaleTwoDecimal> periodTotals = new ArrayList<ScaleTwoDecimal>();
                            for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                                periodTotals.add(i, ScaleTwoDecimal.ZERO);
                            }
                            objectCodePersonnelSalaryTotals.put(matchingLineItem.getCostElement(), periodTotals);
                        }
                        ((List)objectCodePersonnelSalaryTotals.get(matchingLineItem.getCostElement())).set(budgetPeriod.getBudgetPeriod() - 1, (ScaleTwoDecimal)((ScaleTwoDecimal)((List)objectCodePersonnelSalaryTotals.get(matchingLineItem.getCostElement())).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractDecimal)matchingLineItem.getLineItemCost()));
                        ScaleTwoDecimal summaryFringeTotalsForCurrentPeriod = ScaleTwoDecimal.ZERO;
                        if (!objectCodePersonnelFringeTotals.containsKey(matchingLineItem.getCostElement())) {
                            ArrayList<ScaleTwoDecimal> periodFringeTotals = new ArrayList<ScaleTwoDecimal>();
                            for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                                periodFringeTotals.add(i, ScaleTwoDecimal.ZERO);
                            }
                            objectCodePersonnelFringeTotals.put(matchingLineItem.getCostElement(), periodFringeTotals);
                        }
                        if (isLineItemCalculationNeeded = matchingLineItem.getBudgetLineItemCalculatedAmounts().stream().anyMatch(budgetLineItemCalculatedAmount -> budgetLineItemCalculatedAmount.getCalculatedCost() == null)) {
                            new LineItemCalculator(budget, matchingLineItem).calculate();
                        }
                        for (BudgetLineItemCalculatedAmount lineItemCalculatedAmount : matchingLineItem.getBudgetLineItemCalculatedAmounts()) {
                            lineItemCalculatedAmount.refreshReferenceObject("rateClass");
                            if (!lineItemCalculatedAmount.getAddToFringeRate()) continue;
                            summaryFringeTotalsForCurrentPeriod = (ScaleTwoDecimal)summaryFringeTotalsForCurrentPeriod.add((AbstractDecimal)lineItemCalculatedAmount.getCalculatedCost());
                        }
                        ((List)objectCodePersonnelFringeTotals.get(matchingLineItem.getCostElement())).set(budgetPeriod.getBudgetPeriod() - 1, (ScaleTwoDecimal)((ScaleTwoDecimal)((List)objectCodePersonnelFringeTotals.get(matchingLineItem.getCostElement())).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractDecimal)summaryFringeTotalsForCurrentPeriod));
                        ((List)subTotalsBySubSection.get("personnelSalaryTotals")).set(budgetPeriod.getBudgetPeriod() - 1, (ScaleTwoDecimal)((ScaleTwoDecimal)((List)subTotalsBySubSection.get("personnelSalaryTotals")).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractDecimal)matchingLineItem.getLineItemCost()));
                        ((List)subTotalsBySubSection.get("personnelFringeTotals")).set(budgetPeriod.getBudgetPeriod() - 1, (ScaleTwoDecimal)((ScaleTwoDecimal)((List)subTotalsBySubSection.get("personnelFringeTotals")).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractDecimal)summaryFringeTotalsForCurrentPeriod));
                    }
                }
            }
        }
        budget.setBudgetSummaryTotals(subTotalsBySubSection);
        SortedMap<RateType, List<ScaleTwoDecimal>> personnelCalculatedExpenseTotals = this.calculateExpenseTotals(budget, true);
        SortedMap<RateType, List<ScaleTwoDecimal>> nonPersonnelCalculatedExpenseTotals = this.calculateExpenseTotals(budget, false);
        budget.setObjectCodeListByBudgetCategoryType(objectCodeListByBudgetCategoryType);
        budget.setObjectCodePersonnelList(objectCodeUniquePersonnelList);
        budget.setObjectCodePersonnelSalaryTotals(objectCodePersonnelSalaryTotals);
        budget.setObjectCodePersonnelFringeTotals(objectCodePersonnelFringeTotals);
        budget.setPersonnelCalculatedExpenseTotals(personnelCalculatedExpenseTotals);
        budget.setNonPersonnelCalculatedExpenseTotals(nonPersonnelCalculatedExpenseTotals);
        this.calculateNonPersonnelSummaryTotals(budget);
        this.populateBudgetPeriodSummaryCalcAmounts(budget);
    }

    protected BudgetCommonService<BudgetParent> getBudgetCommonService(Budget budget) {
        return BudgetCommonServiceFactory.createInstance(budget.getBudgetParent());
    }

    private boolean isRateOveridden(Budget budget, BudgetPeriod budgetPeriod) {
        BudgetCommonService<BudgetParent> budgetService = this.getBudgetCommonService(budget);
        return budgetService.isRateOverridden(budgetPeriod);
    }

    @Override
    public void populateBudgetPeriodSummaryCalcAmounts(Budget budget) {
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            BudgetCommonService<BudgetParent> budgetCommonService;
            if (this.isRateOveridden(budget, budgetPeriod) || !((budgetCommonService = this.getBudgetCommonService(budget)) instanceof AwardBudgetService)) continue;
            ((AwardBudgetService)budgetCommonService).populateSummaryCalcAmounts(budget, budgetPeriod);
        }
    }

    protected void calculateNonPersonnelSummaryTotals(Budget budget) {
        for (BudgetCategoryType budgetCategoryType : budget.getObjectCodeListByBudgetCategoryType().keySet()) {
            if (StringUtils.equals((CharSequence)budgetCategoryType.getCode(), (CharSequence)BUDGET_SUMMARY_PERIOD_HEADER_LABEL)) continue;
            ArrayList<ScaleTwoDecimal> nonPersonnelTotals = new ArrayList<ScaleTwoDecimal>();
            for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                nonPersonnelTotals.add(i, ScaleTwoDecimal.ZERO);
            }
            budget.getBudgetSummaryTotals().put(budgetCategoryType.getCode(), nonPersonnelTotals);
            List objectCodes = (List)budget.getObjectCodeListByBudgetCategoryType().get(budgetCategoryType);
            for (CostElement objectCode : objectCodes) {
                if (StringUtils.equalsIgnoreCase((CharSequence)objectCode.getCostElement(), (CharSequence)this.getParameterService().getParameterValueAsString(Budget.class, "proposalHierarchySubProjectIndirectCostElement"))) continue;
                List objectCodePeriodTotals = (List)budget.getObjectCodeTotals().get(objectCode);
                for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                    ((List)budget.getBudgetSummaryTotals().get(budgetCategoryType.getCode())).set(budgetPeriod.getBudgetPeriod() - 1, (ScaleTwoDecimal)((ScaleTwoDecimal)((List)budget.getBudgetSummaryTotals().get(budgetCategoryType.getCode())).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractDecimal)((ScaleTwoDecimal)objectCodePeriodTotals.get(budgetPeriod.getBudgetPeriod() - 1))));
                }
            }
        }
    }

    protected List<CostElement> filterObjectCodesByBudgetCategoryType(Set<CostElement> objectCodes, String budgetCategoryType) {
        ArrayList<CostElement> filteredObjectCodes = new ArrayList<CostElement>();
        for (CostElement costElement : objectCodes) {
            if (!costElement.getBudgetCategory().getBudgetCategoryTypeCode().equalsIgnoreCase(budgetCategoryType)) continue;
            filteredObjectCodes.add(costElement);
        }
        return filteredObjectCodes;
    }

    protected SortedMap<RateType, List<ScaleTwoDecimal>> calculateExpenseTotals(Budget budget, boolean personnelFlag) {
        TreeMap<RateType, List<ScaleTwoDecimal>> calculatedExpenseTotals = new TreeMap<RateType, List<ScaleTwoDecimal>>();
        ArrayList<ScaleTwoDecimal> calculatedDirectCostSummaryTotals = new ArrayList<ScaleTwoDecimal>();
        for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
            calculatedDirectCostSummaryTotals.add(i, ScaleTwoDecimal.ZERO);
        }
        String totalsMapKey = personnelFlag ? "personnelCalculatedExpenseSummaryTotals" : "nonPersonnelCalculatedExpenseSummaryTotals";
        budget.getBudgetSummaryTotals().put(totalsMapKey, calculatedDirectCostSummaryTotals);
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if ((!personnelFlag || !StringUtils.equals((CharSequence)budgetLineItem.getCostElementBO().getBudgetCategory().getBudgetCategoryTypeCode(), (CharSequence)BUDGET_SUMMARY_PERIOD_HEADER_LABEL)) && (personnelFlag || StringUtils.equals((CharSequence)budgetLineItem.getCostElementBO().getBudgetCategory().getBudgetCategoryTypeCode(), (CharSequence)BUDGET_SUMMARY_PERIOD_HEADER_LABEL))) continue;
                QueryList<BudgetLineItemCalculatedAmount> lineItemCalcAmtQueryList = new QueryList<BudgetLineItemCalculatedAmount>();
                lineItemCalcAmtQueryList.addAll(budgetLineItem.getBudgetLineItemCalculatedAmounts());
                ArrayList<RateType> rateTypes = new ArrayList<RateType>();
                for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    RateType rateType = this.createRateType(budgetLineItemCalculatedAmount);
                    RateClass rateClass = null;
                    if (rateType != null) {
                        rateType.refreshReferenceObject("rateClass");
                        rateClass = rateType.getRateClass();
                    }
                    if ((!personnelFlag || rateClass == null || StringUtils.equals((CharSequence)rateClass.getRateClassTypeCode(), (CharSequence)"E")) && personnelFlag || rateTypes.contains(rateType)) continue;
                    rateTypes.add(rateType);
                    Equals equalsRC = new Equals("rateClassCode", (Comparable)((Object)budgetLineItemCalculatedAmount.getRateClassCode()));
                    Equals equalsRT = new Equals("rateTypeCode", (Comparable)((Object)budgetLineItemCalculatedAmount.getRateTypeCode()));
                    And RCandRT = new And(equalsRC, equalsRT);
                    ScaleTwoDecimal rateTypeTotalInThisPeriod = lineItemCalcAmtQueryList.sumObjects(CALCULATED_COST, RCandRT);
                    if (!calculatedExpenseTotals.containsKey(rateType)) {
                        ArrayList<ScaleTwoDecimal> rateTypePeriodTotals = new ArrayList<ScaleTwoDecimal>();
                        for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                            rateTypePeriodTotals.add(i, ScaleTwoDecimal.ZERO);
                        }
                        calculatedExpenseTotals.put(rateType, rateTypePeriodTotals);
                    }
                    ((List)calculatedExpenseTotals.get(rateType)).set(budgetPeriod.getBudgetPeriod() - 1, (ScaleTwoDecimal)((ScaleTwoDecimal)((List)calculatedExpenseTotals.get(rateType)).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractDecimal)rateTypeTotalInThisPeriod));
                    if (!StringUtils.equals((CharSequence)rateClass.getRateClassTypeCode(), (CharSequence)RateClassType.OVERHEAD.getRateClassType())) {
                        ((List)budget.getBudgetSummaryTotals().get(totalsMapKey)).set(budgetPeriod.getBudgetPeriod() - 1, (ScaleTwoDecimal)((ScaleTwoDecimal)((List)budget.getBudgetSummaryTotals().get(totalsMapKey)).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractDecimal)rateTypeTotalInThisPeriod));
                    }
                    budgetPeriod.setExpenseTotal((ScaleTwoDecimal)budgetPeriod.getExpenseTotal().add((AbstractDecimal)rateTypeTotalInThisPeriod));
                }
            }
        }
        return calculatedExpenseTotals;
    }

    protected RateType createRateType(BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount) {
        RateType rateType = new RateType();
        rateType.setRateClassCode(budgetLineItemCalculatedAmount.getRateClassCode());
        rateType.setRateTypeCode(budgetLineItemCalculatedAmount.getRateTypeCode());
        rateType.setDescription(budgetLineItemCalculatedAmount.getRateTypeDescription());
        rateType.setRateClass(budgetLineItemCalculatedAmount.getRateClass());
        return rateType;
    }

    @Deprecated
    protected void calculateBudgetTotals(Budget budget) {
        TreeMap<CostElement, List<ScaleTwoDecimal>> objectCodeTotals = new TreeMap<CostElement, List<ScaleTwoDecimal>>();
        TreeMap<RateType, List<ScaleTwoDecimal>> calculatedExpenseTotals = new TreeMap<RateType, List<ScaleTwoDecimal>>();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            ArrayList<CostElement> objectCodes = new ArrayList<CostElement>();
            QueryList<BudgetLineItem> lineItemQueryList = new QueryList<BudgetLineItem>();
            lineItemQueryList.addAll(budgetPeriod.getBudgetLineItems());
            budgetPeriod.setExpenseTotal(ScaleTwoDecimal.ZERO);
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                CostElement costElement;
                if (budgetLineItem.getCostElementBO() == null) {
                    budgetLineItem.refreshReferenceObject("costElementBO");
                }
                if (!objectCodes.contains(costElement = budgetLineItem.getCostElementBO())) {
                    objectCodes.add(costElement);
                    Equals equalsCostElement = new Equals("costElement", (Comparable)((Object)budgetLineItem.getCostElement()));
                    ScaleTwoDecimal objectCodeTotalInThisPeriod = lineItemQueryList.sumObjects("lineItemCost", equalsCostElement);
                    if (!objectCodeTotals.containsKey(costElement)) {
                        ArrayList<ScaleTwoDecimal> periodTotals = new ArrayList<ScaleTwoDecimal>();
                        for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                            periodTotals.add(i, ScaleTwoDecimal.ZERO);
                        }
                        objectCodeTotals.put(costElement, periodTotals);
                    }
                    ((List)objectCodeTotals.get(costElement)).set(budgetPeriod.getBudgetPeriod() - 1, objectCodeTotalInThisPeriod);
                    budgetPeriod.setExpenseTotal((ScaleTwoDecimal)budgetPeriod.getExpenseTotal().add((AbstractDecimal)objectCodeTotalInThisPeriod));
                }
                QueryList<BudgetLineItemCalculatedAmount> lineItemCalcAmtQueryList = new QueryList<BudgetLineItemCalculatedAmount>();
                lineItemCalcAmtQueryList.addAll(budgetLineItem.getBudgetLineItemCalculatedAmounts());
                ArrayList<RateType> rateTypes = new ArrayList<RateType>();
                for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    RateType rateType = this.createRateType(budgetLineItemCalculatedAmount);
                    if (rateTypes.contains(rateType)) continue;
                    rateTypes.add(rateType);
                    Equals equalsRC = new Equals("rateClassCode", (Comparable)((Object)budgetLineItemCalculatedAmount.getRateClassCode()));
                    Equals equalsRT = new Equals("rateTypeCode", (Comparable)((Object)budgetLineItemCalculatedAmount.getRateTypeCode()));
                    And RCandRT = new And(equalsRC, equalsRT);
                    ScaleTwoDecimal rateTypeTotalInThisPeriod = lineItemCalcAmtQueryList.sumObjects(CALCULATED_COST, RCandRT);
                    if (!calculatedExpenseTotals.containsKey(rateType)) {
                        ArrayList<ScaleTwoDecimal> rateTypePeriodTotals = new ArrayList<ScaleTwoDecimal>();
                        for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                            rateTypePeriodTotals.add(i, ScaleTwoDecimal.ZERO);
                        }
                        calculatedExpenseTotals.put(rateType, rateTypePeriodTotals);
                    }
                    ((List)calculatedExpenseTotals.get(rateType)).set(budgetPeriod.getBudgetPeriod() - 1, (ScaleTwoDecimal)((ScaleTwoDecimal)((List)calculatedExpenseTotals.get(rateType)).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractDecimal)rateTypeTotalInThisPeriod));
                    budgetPeriod.setExpenseTotal((ScaleTwoDecimal)budgetPeriod.getExpenseTotal().add((AbstractDecimal)rateTypeTotalInThisPeriod));
                }
            }
        }
        budget.setObjectCodeTotals(objectCodeTotals);
        budget.setCalculatedExpenseTotals(calculatedExpenseTotals);
    }

    @Override
    public boolean syncToPeriodCostLimit(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem) {
        BudgetPeriodCalculator periodCalculator = new BudgetPeriodCalculator();
        return periodCalculator.syncToPeriodCostLimit(budget, budgetPeriod, budgetLineItem);
    }

    @Override
    public boolean syncToPeriodDirectCostLimit(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem) {
        BudgetPeriodCalculator periodCalculator = new BudgetPeriodCalculator();
        return periodCalculator.syncToPeriodDirectCostLimit(budget, budgetPeriod, budgetLineItem);
    }

    @Override
    public void applyToLaterPeriods(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem) {
        for (ValidCeRateType validCeRateType : budgetLineItem.getCostElementBO().getValidCeRateTypes()) {
            validCeRateType.getRateType().getDescription();
            validCeRateType.getRateClass().getCode();
            validCeRateType.getCostElementBo().getDescription();
        }
        BudgetPeriodCalculator periodCalculator = new BudgetPeriodCalculator();
        periodCalculator.applyToLaterPeriods(budget, budgetPeriod, budgetLineItem);
        List<String> errors = periodCalculator.getErrorMessages();
        if (!errors.isEmpty()) {
            MessageMap errorMap = this.globalVariableService.getMessageMap();
            for (String error : errors) {
                errorMap.putError("document.budgetPeriod[" + (budgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + (budgetLineItem.getLineItemNumber() - 1) + "].costElement", error, new String[0]);
            }
        }
    }

    public BudgetDistributionService getBudgetDistributionService() {
        return this.budgetDistributionService;
    }

    public void setBudgetDistributionService(BudgetDistributionService service) {
        this.budgetDistributionService = service;
    }

    @Override
    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public void rePopulateCalculatedAmount(Budget budget, BudgetLineItem budgetLineItem) {
        new LineItemCalculator(budget, budgetLineItem).setCalculatedAmounts(budgetLineItem);
    }

    @Override
    public void rePopulateCalculatedAmount(Budget budget, BudgetPersonnelDetails newBudgetPersonnelDetails) {
        new PersonnelLineItemCalculator(budget, newBudgetPersonnelDetails).setCalculatedAmounts(newBudgetPersonnelDetails);
    }

    @Override
    public void updatePersonnelBudgetRate(BudgetLineItem budgetLineItem) {
        for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            budgetPersonnelDetails.setApplyInRateFlag(budgetLineItem.getApplyInRateFlag());
            budgetPersonnelDetails.setOnOffCampusFlag(budgetLineItem.getOnOffCampusFlag());
            for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts()) {
                Boolean updatedApplyRateFlag = null;
                for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmout : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (!budgetLineItemCalculatedAmout.getRateClassCode().equalsIgnoreCase(budgetPersonnelCalculatedAmount.getRateClassCode()) || !budgetLineItemCalculatedAmout.getRateTypeCode().equalsIgnoreCase(budgetPersonnelCalculatedAmount.getRateTypeCode())) continue;
                    updatedApplyRateFlag = budgetLineItemCalculatedAmout.getApplyRateFlag();
                }
                budgetPersonnelCalculatedAmount.setApplyRateFlag(updatedApplyRateFlag);
            }
        }
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    @Override
    public List<Period> retrieveBudgetSummaryTotals(Budget budget) {
        BudgetCategoryType personnelCategoryType = this.getPersonnelCategoryType();
        String personnelBudgetCategoryType = personnelCategoryType.getCode();
        List<BudgetLineItem> budgetLineItems = this.getAllBudgetSummaryLineItems(budget);
        SortedMap<BudgetCategoryType, SortedMap<CostElement, List<BudgetLineItem>>> uniqueBudgetCategoryLineItemCostElements = this.getBudgetSummaryUniqueBudgetCategoryLineItemCostElements(budgetLineItems);
        SortedMap personnelCostElementLineItems = (SortedMap)uniqueBudgetCategoryLineItemCostElements.get(personnelCategoryType);
        ArrayList<Period> budgetSummaryPeriods = new ArrayList<Period>();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            String periodHeader = BUDGET_SUMMARY_PERIOD_HEADER_LABEL.concat(budgetPeriod.getBudgetPeriod().toString());
            Period summaryPeriod = new Period(periodHeader);
            summaryPeriod.setStartDate(budgetPeriod.getStartDate());
            summaryPeriod.setEndDate(budgetPeriod.getEndDate());
            if (personnelCostElementLineItems != null) {
                LineItemGroup personnelGroup = this.getPersonnelBudgetSummaryPeriods(budgetPeriod, personnelCostElementLineItems, personnelBudgetCategoryType);
                LineItemObject calculatedPersonnelDirectCosts = new LineItemObject(BudgetSummaryConstants.CalculatedDirectCost.getKey(), BudgetSummaryConstants.CalculatedDirectCost.getLabel(), ScaleTwoDecimal.ZERO);
                ScaleTwoDecimal personnelDirectCost = this.getCalculateBudgetSummaryExpenseTotal(budgetPeriod, true, personnelBudgetCategoryType);
                calculatedPersonnelDirectCosts.setAmount(personnelDirectCost);
                personnelGroup.getLineItems().add(calculatedPersonnelDirectCosts);
                summaryPeriod.getLineItemGroups().add(personnelGroup);
            }
            uniqueBudgetCategoryLineItemCostElements.remove(personnelCategoryType);
            LineItemGroup nonPersonnelGroup = this.getNonPersonnelBudgetSummaryPeriods(budgetPeriod, uniqueBudgetCategoryLineItemCostElements);
            LineItemObject calculatedNonPersonnelDirectCosts = new LineItemObject(BudgetSummaryConstants.CalculatedDirectCost.getKey(), BudgetSummaryConstants.CalculatedDirectCost.getLabel(), ScaleTwoDecimal.ZERO);
            ScaleTwoDecimal nonPersonnelDirectCost = this.getCalculateBudgetSummaryExpenseTotal(budgetPeriod, false, personnelBudgetCategoryType);
            calculatedNonPersonnelDirectCosts.setAmount(nonPersonnelDirectCost);
            nonPersonnelGroup.getLineItems().add(calculatedNonPersonnelDirectCosts);
            summaryPeriod.getLineItemGroups().add(nonPersonnelGroup);
            LineItemGroup totalsGroup = this.getBudgetSummaryTotals(budgetPeriod);
            summaryPeriod.getLineItemGroups().add(totalsGroup);
            budgetSummaryPeriods.add(summaryPeriod);
        }
        return budgetSummaryPeriods;
    }

    private List<BudgetLineItem> getAllBudgetSummaryLineItems(Budget budget) {
        ArrayList<BudgetLineItem> summaryLineItems = new ArrayList<BudgetLineItem>();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            summaryLineItems.addAll(budgetPeriod.getBudgetLineItems());
        }
        return summaryLineItems;
    }

    private SortedMap<CostElement, List<BudgetLineItem>> getBudgetSummaryUniqueLineItemCostElementsForBudgetCategory(List<BudgetLineItem> budgetLineItems, String budgetCategoryTypeCode) {
        TreeMap<CostElement, List<BudgetLineItem>> uniqueLineItemCostElements = new TreeMap<CostElement, List<BudgetLineItem>>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            CostElement costElement = budgetLineItem.getCostElementBO();
            String costElementBudgetCategoryTypeCode = costElement.getBudgetCategory().getBudgetCategoryTypeCode();
            if (!costElementBudgetCategoryTypeCode.equalsIgnoreCase(budgetCategoryTypeCode)) continue;
            if (!uniqueLineItemCostElements.containsKey(costElement)) {
                uniqueLineItemCostElements.put(costElement, new ArrayList());
            }
            ((List)uniqueLineItemCostElements.get(costElement)).add(budgetLineItem);
        }
        return uniqueLineItemCostElements;
    }

    private SortedMap<BudgetCategoryType, SortedMap<CostElement, List<BudgetLineItem>>> getBudgetSummaryUniqueBudgetCategoryLineItemCostElements(List<BudgetLineItem> budgetLineItems) {
        TreeMap<BudgetCategoryType, SortedMap<CostElement, List<BudgetLineItem>>> uniqueBudgetCategoryLineItemCostElements = new TreeMap<BudgetCategoryType, SortedMap<CostElement, List<BudgetLineItem>>>();
        List<BudgetCategoryType> budgetCategoryTypes = this.getAllBudgetCategoryTypes();
        for (BudgetCategoryType budgetCategoryType : budgetCategoryTypes) {
            SortedMap<CostElement, List<BudgetLineItem>> costElementLineItems = this.getBudgetSummaryUniqueLineItemCostElementsForBudgetCategory(budgetLineItems, budgetCategoryType.getCode());
            if (costElementLineItems.isEmpty()) continue;
            uniqueBudgetCategoryLineItemCostElements.put(budgetCategoryType, costElementLineItems);
        }
        return uniqueBudgetCategoryLineItemCostElements;
    }

    private LineItemGroup getPersonnelBudgetSummaryPeriods(BudgetPeriod budgetPeriod, SortedMap<CostElement, List<BudgetLineItem>> uniqueBudgetLineItemCostElements, String personnelBudgetCategoryType) {
        LineItemGroup personnelGroup = new LineItemGroup(BUDGET_SUMMARY_PERSONNEL_GROUP_LABEL, true);
        LineItemObject personnelSalaries = new LineItemObject(BudgetSummaryConstants.PersonSalary.getKey(), BudgetSummaryConstants.PersonSalary.getLabel(), ScaleTwoDecimal.ZERO);
        LineItemObject personnelFringe = new LineItemObject(BudgetSummaryConstants.PersonFringe.getKey(), BudgetSummaryConstants.PersonFringe.getLabel(), ScaleTwoDecimal.ZERO);
        ScaleTwoDecimal totalSalary = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalFringe = ScaleTwoDecimal.ZERO;
        for (Map.Entry<CostElement, List<BudgetLineItem>> uniqueLineItem : uniqueBudgetLineItemCostElements.entrySet()) {
            CostElement personnelCostElement = uniqueLineItem.getKey();
            List<BudgetLineItem> personnelLineItemsForCostElement = uniqueLineItem.getValue();
            QueryList<BudgetLineItem> periodLineItemCostElementQueryList = this.getLineItemsFilteredByCostElement(budgetPeriod, personnelCostElement.getCostElement());
            QueryList<BudgetPersonnelDetails> periodLineItemPersonnelDetailsQueryList = this.getBudgetPersonnelDetails(periodLineItemCostElementQueryList, personnelBudgetCategoryType);
            ScaleTwoDecimal totalSalaryForCostElement = periodLineItemPersonnelDetailsQueryList.sumObjects("salaryRequested");
            ScaleTwoDecimal totalFringeForCostElement = periodLineItemPersonnelDetailsQueryList.sumObjects("calculatedFringe");
            Map<String, List<BudgetPersonnelDetails>> uniquePersonList = this.getUniquePersonList(personnelLineItemsForCostElement, personnelBudgetCategoryType);
            LineItemObject salaryLineItemObject = new LineItemObject(personnelCostElement.getCostElement(), personnelCostElement.getDescription(), totalSalaryForCostElement);
            LineItemObject fringeLineItemObject = new LineItemObject(personnelCostElement.getCostElement(), personnelCostElement.getDescription(), totalFringeForCostElement);
            for (Map.Entry<String, List<BudgetPersonnelDetails>> personInfo : uniquePersonList.entrySet()) {
                BudgetPersonnelDetails budgetPersonnelDetails;
                BudgetPerson budgetPerson;
                ScaleTwoDecimal personFringeTotalsForCurrentPeriod;
                String personId = personInfo.getKey();
                boolean summaryPerson = BudgetConstants.BudgetPerson.SUMMARYPERSON.getPersonId().equals(personId);
                ScaleTwoDecimal personSalaryTotalsForCurrentPeriod = summaryPerson ? totalSalaryForCostElement : personInfo.getValue().stream().filter(b -> b.getBudgetLineItem().getBudgetPeriodId().equals(budgetPeriod.getBudgetPeriodId())).map(BudgetPersonnelDetails::getSalaryRequested).reduce(ScaleTwoDecimal.ZERO, AbstractDecimal::add);
                ScaleTwoDecimal scaleTwoDecimal = personFringeTotalsForCurrentPeriod = summaryPerson ? totalFringeForCostElement : personInfo.getValue().stream().filter(b -> b.getBudgetLineItem().getBudgetPeriodId().equals(budgetPeriod.getBudgetPeriodId())).map(BudgetPersonnelDetails::getCalculatedFringe).reduce(ScaleTwoDecimal.ZERO, AbstractDecimal::add);
                Object personName = summaryPerson ? BudgetConstants.BudgetPerson.SUMMARYPERSON.getPersonName() : (StringUtils.equals((CharSequence)(budgetPerson = (budgetPersonnelDetails = (BudgetPersonnelDetails)personInfo.getValue().stream().findAny().get()).getBudgetPerson()).getBudget().getBudgetParent().getHierarchyStatus(), (CharSequence)HierarchyStatusConstants.Parent.code()) ? budgetPerson.getPersonName() + " (" + budgetPersonnelDetails.getBudgetLineItem().getGroupName() + ")" : budgetPerson.getPersonName());
                salaryLineItemObject.getLineItems().add(new LineItemObject(personId, (String)personName, personSalaryTotalsForCurrentPeriod));
                fringeLineItemObject.getLineItems().add(new LineItemObject(personId, (String)personName, personFringeTotalsForCurrentPeriod));
            }
            salaryLineItemObject.setLineItems(salaryLineItemObject.getLineItems().stream().sorted(Comparator.comparing(LineItemObject::getName)).collect(Collectors.toList()));
            fringeLineItemObject.setLineItems(fringeLineItemObject.getLineItems().stream().sorted(Comparator.comparing(LineItemObject::getName)).collect(Collectors.toList()));
            totalSalary = (ScaleTwoDecimal)totalSalary.add((AbstractDecimal)totalSalaryForCostElement);
            totalFringe = (ScaleTwoDecimal)totalFringe.add((AbstractDecimal)totalFringeForCostElement);
            personnelSalaries.getLineItems().add(salaryLineItemObject);
            personnelFringe.getLineItems().add(fringeLineItemObject);
        }
        personnelSalaries.setAmount(totalSalary);
        personnelFringe.setAmount(totalFringe);
        personnelGroup.getLineItems().add(personnelSalaries);
        personnelGroup.getLineItems().add(personnelFringe);
        return personnelGroup;
    }

    private QueryList<BudgetLineItem> getLineItemsFilteredByCostElement(BudgetPeriod budgetPeriod, String costElement) {
        QueryList<BudgetLineItem> lineItemQueryList = new QueryList<BudgetLineItem>();
        lineItemQueryList.addAll(budgetPeriod.getBudgetLineItems());
        Equals costElementEquals = new Equals("costElement", (Comparable)((Object)costElement));
        return lineItemQueryList.filter(costElementEquals);
    }

    private LineItemGroup getNonPersonnelBudgetSummaryPeriods(BudgetPeriod budgetPeriod, SortedMap<BudgetCategoryType, SortedMap<CostElement, List<BudgetLineItem>>> uniqueBudgetCategoryLineItemCostElements) {
        LineItemGroup nonPersonnelGroup = new LineItemGroup(BUDGET_SUMMARY_NONPERSONNEL_GROUP_LABEL, true);
        for (Map.Entry<BudgetCategoryType, SortedMap<CostElement, List<BudgetLineItem>>> uniqueBudgetCategory : uniqueBudgetCategoryLineItemCostElements.entrySet()) {
            ScaleTwoDecimal totalForCategory = ScaleTwoDecimal.ZERO;
            BudgetCategoryType budgetCategoryType = uniqueBudgetCategory.getKey();
            SortedMap<CostElement, List<BudgetLineItem>> uniqueLineItemCostElements = uniqueBudgetCategory.getValue();
            LineItemObject lineItemCategory = new LineItemObject(budgetCategoryType.getCode(), budgetCategoryType.getDescription(), ScaleTwoDecimal.ZERO);
            for (Map.Entry<CostElement, List<BudgetLineItem>> uniqueLineItem : uniqueLineItemCostElements.entrySet()) {
                CostElement costElement = uniqueLineItem.getKey();
                QueryList<BudgetLineItem> periodLineItemCostElementQueryList = this.getLineItemsFilteredByCostElement(budgetPeriod, costElement.getCostElement());
                ScaleTwoDecimal totalForCostElement = ScaleTwoDecimal.ZERO;
                if (periodLineItemCostElementQueryList != null) {
                    totalForCostElement = periodLineItemCostElementQueryList.sumObjects("lineItemCost");
                }
                LineItemObject costElementLineItemObject = new LineItemObject(costElement.getCostElement(), costElement.getDescription(), totalForCostElement);
                lineItemCategory.getLineItems().add(costElementLineItemObject);
                totalForCategory = (ScaleTwoDecimal)totalForCategory.add((AbstractDecimal)totalForCostElement);
            }
            lineItemCategory.setAmount(totalForCategory);
            nonPersonnelGroup.getLineItems().add(lineItemCategory);
        }
        return nonPersonnelGroup;
    }

    private LineItemGroup getBudgetSummaryTotals(BudgetPeriod budgetPeriod) {
        LineItemGroup totalsGroup = new LineItemGroup(BUDGET_SUMMARY_TOTALS_GROUP_LABEL, true);
        LineItemObject totalDirectCost = new LineItemObject(BudgetSummaryConstants.TotalDirectCost.getKey(), BudgetSummaryConstants.TotalDirectCost.getLabel(), budgetPeriod.getTotalDirectCost());
        LineItemObject totalFnACost = new LineItemObject(BudgetSummaryConstants.TotalFnACost.getKey(), BudgetSummaryConstants.TotalFnACost.getLabel(), budgetPeriod.getTotalIndirectCost());
        totalsGroup.getLineItems().add(totalDirectCost);
        totalsGroup.getLineItems().add(totalFnACost);
        return totalsGroup;
    }

    private QueryList<BudgetPersonnelDetails> getBudgetPersonnelDetails(List<BudgetLineItem> personnelLineItemsForCostElement, String personnelBudgetCategoryType) {
        QueryList<BudgetPersonnelDetails> personnelQueryList = new QueryList<BudgetPersonnelDetails>();
        if (personnelLineItemsForCostElement != null) {
            for (BudgetLineItem budgetLineItem : personnelLineItemsForCostElement) {
                if (budgetLineItem.getCostElementBO() == null || !budgetLineItem.getCostElementBO().getBudgetCategory().getBudgetCategoryTypeCode().equalsIgnoreCase(personnelBudgetCategoryType)) continue;
                if (budgetLineItem.getBudgetPersonnelDetailsList().size() > 0) {
                    personnelQueryList.addAll(budgetLineItem.getBudgetPersonnelDetailsList());
                    continue;
                }
                personnelQueryList.add(new BudgetPersonnelDetails(budgetLineItem));
            }
        }
        return personnelQueryList;
    }

    private Map<String, List<BudgetPersonnelDetails>> getUniquePersonList(List<BudgetLineItem> personnelLineItems, String personnelBudgetCategoryType) {
        HashMap<String, List<BudgetPersonnelDetails>> uniquePersonList = new HashMap<String, List<BudgetPersonnelDetails>>();
        for (BudgetLineItem budgetLineItem : personnelLineItems) {
            if (!budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equalsIgnoreCase(personnelBudgetCategoryType)) continue;
            if (budgetLineItem.getBudgetPersonnelDetailsList().size() > 0) {
                for (BudgetPersonnelDetails budgetPersonnelDetail : budgetLineItem.getBudgetPersonnelDetailsList()) {
                    Object key;
                    if (StringUtils.isNotBlank((CharSequence)budgetPersonnelDetail.getBudgetPerson().getTbnId())) {
                        key = budgetPersonnelDetail.getBudgetPerson().getPersonName() + "$tbn$" + budgetPersonnelDetail.getPersonId();
                        if (StringUtils.equals((CharSequence)budgetLineItem.getBudget().getBudgetParent().getHierarchyStatus(), (CharSequence)HierarchyStatusConstants.Parent.code())) {
                            key = (String)key + "$pd$" + budgetLineItem.getGroupName();
                        }
                    } else {
                        key = budgetPersonnelDetail.getBudgetPerson().getRolodexId() != null ? "$rolodex$" + budgetPersonnelDetail.getPersonId() : budgetPersonnelDetail.getPersonId();
                    }
                    List value = uniquePersonList.computeIfAbsent((String)key, k -> new ArrayList());
                    value.add(budgetPersonnelDetail);
                    uniquePersonList.put((String)key, value);
                }
                continue;
            }
            uniquePersonList.put(BudgetConstants.BudgetPerson.SUMMARYPERSON.getPersonId(), Collections.emptyList());
        }
        return uniquePersonList;
    }

    @Override
    public String getPersonnelBudgetCategoryTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-B", "Document", "budgetCategoryType.personnel");
    }

    private ScaleTwoDecimal getCalculateBudgetSummaryExpenseTotal(BudgetPeriod budgetPeriod, boolean personnelFlag, String personnelCategoryTypeCode) {
        ScaleTwoDecimal calculatedExpenseTotal = ScaleTwoDecimal.ZERO;
        SortedMap<RateType, QueryList<BudgetLineItemCalculatedAmount>> uniqueLineItemCalAmounts = this.getBudgetSummaryUniqueRateTypeCalAmounts(budgetPeriod.getBudgetLineItems(), personnelFlag, personnelCategoryTypeCode);
        for (Map.Entry<RateType, QueryList<BudgetLineItemCalculatedAmount>> uniqueLineItem : uniqueLineItemCalAmounts.entrySet()) {
            RateType rateType = uniqueLineItem.getKey();
            QueryList<BudgetLineItemCalculatedAmount> lineItemCalAmounts = uniqueLineItem.getValue();
            RateClass rateClass = rateType.getRateClass();
            if (!this.isCalculatedDirectCostRate(personnelFlag, rateType, rateClass)) continue;
            ScaleTwoDecimal rateTypeTotalInThisPeriod = lineItemCalAmounts.sumObjects(CALCULATED_COST);
            calculatedExpenseTotal = (ScaleTwoDecimal)calculatedExpenseTotal.add((AbstractDecimal)rateTypeTotalInThisPeriod);
        }
        return calculatedExpenseTotal;
    }

    private boolean isCalculatedDirectCostRate(boolean personnelFlag, RateType rateType, RateClass rateClass) {
        return (this.isEbonLAorVacationLA(rateType, rateClass) || !personnelFlag) && !this.getBudgetRatesService().isOverhead(rateClass.getRateClassTypeCode()) && !this.isVacation(rateType, rateClass);
    }

    protected boolean isVacation(RateType rateType, RateClass rateClass) {
        return this.getBudgetRatesService().isVacation(rateClass.getRateClassTypeCode()) && !this.getBudgetRatesService().isVacationOnLabAllocation(rateClass.getCode(), rateType.getRateTypeCode());
    }

    private boolean isEbonLAorVacationLA(RateType rateType, RateClass rateClass) {
        return !this.getBudgetRatesService().isEmployeeBenefit(rateClass.getRateClassTypeCode()) || this.getBudgetRatesService().isVacationOnLabAllocation(rateClass.getCode(), rateType.getRateTypeCode()) || this.getBudgetRatesService().isEmployeeBenefitOnLabAllocation(rateClass.getCode(), rateType.getRateTypeCode());
    }

    private SortedMap<RateType, QueryList<BudgetLineItemCalculatedAmount>> getBudgetSummaryUniqueRateTypeCalAmounts(List<BudgetLineItem> budgetLineItems, boolean personnelFlag, String personnelCategoryTypeCode) {
        TreeMap<RateType, QueryList<BudgetLineItemCalculatedAmount>> uniqueLineItemCalAmounts = new TreeMap<RateType, QueryList<BudgetLineItemCalculatedAmount>>();
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if ((!personnelFlag || !StringUtils.equals((CharSequence)budgetLineItem.getCostElementBO().getBudgetCategory().getBudgetCategoryTypeCode(), (CharSequence)personnelCategoryTypeCode)) && (personnelFlag || StringUtils.equals((CharSequence)budgetLineItem.getCostElementBO().getBudgetCategory().getBudgetCategoryTypeCode(), (CharSequence)personnelCategoryTypeCode))) continue;
            for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                RateType rateType = this.getRateType(budgetLineItemCalculatedAmount);
                if (!uniqueLineItemCalAmounts.containsKey(rateType)) {
                    uniqueLineItemCalAmounts.put(rateType, new QueryList());
                }
                ((QueryList)uniqueLineItemCalAmounts.get(rateType)).add(budgetLineItemCalculatedAmount);
            }
        }
        return uniqueLineItemCalAmounts;
    }

    private RateType getRateType(BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount) {
        if (budgetLineItemCalculatedAmount.getRateTypeCode() != null && budgetLineItemCalculatedAmount.getRateType() == null) {
            this.getDataObjectService().wrap((Object)budgetLineItemCalculatedAmount).fetchRelationship("rateType");
        }
        return budgetLineItemCalculatedAmount.getRateType();
    }

    @Override
    public void updateBudgetTotalCost(Budget budget) {
        ScaleTwoDecimal totalDirectCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalIndirectCost = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalCost = ScaleTwoDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getTotalDirectCost().isGreaterEqual((AbstractDecimal)ScaleTwoDecimal.ZERO) || budgetPeriod.getTotalIndirectCost().isGreaterEqual((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
                budgetPeriod.setTotalCost((ScaleTwoDecimal)budgetPeriod.getTotalDirectCost().add((AbstractDecimal)budgetPeriod.getTotalIndirectCost()));
            }
            totalDirectCost = (ScaleTwoDecimal)totalDirectCost.add((AbstractDecimal)budgetPeriod.getTotalDirectCost());
            totalIndirectCost = (ScaleTwoDecimal)totalIndirectCost.add((AbstractDecimal)budgetPeriod.getTotalIndirectCost());
            totalCost = (ScaleTwoDecimal)totalCost.add((AbstractDecimal)budgetPeriod.getTotalCost());
        }
        budget.setTotalDirectCost(totalDirectCost);
        budget.setTotalIndirectCost(totalIndirectCost);
        budget.setTotalCost(totalCost);
    }

    @Override
    public void resetBudgetLineItemCalculatedAmounts(Budget budget) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                budgetLineItem.getBudgetLineItemCalculatedAmounts().clear();
                for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                    budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts().clear();
                }
            }
        }
    }

    @Override
    public void calculateAndUpdateFormulatedCost(BudgetLineItem budgetLineItem) {
        ScaleTwoDecimal formulatedCostTotal;
        if (budgetLineItem.getFormulatedCostElementFlag().booleanValue() && !CollectionUtils.isEmpty(budgetLineItem.getBudgetFormulatedCosts()) && (formulatedCostTotal = this.getFormulatedCostsTotal(budgetLineItem)) != null) {
            budgetLineItem.setLineItemCost(formulatedCostTotal);
        }
    }

    private ScaleTwoDecimal getFormulatedCostsTotal(BudgetLineItem budgetLineItem) {
        List<BudgetFormulatedCostDetail> budgetFormulatedCosts = budgetLineItem.getBudgetFormulatedCosts();
        ScaleTwoDecimal formulatedExpenses = ScaleTwoDecimal.ZERO;
        Budget budget = budgetLineItem.getBudget();
        for (BudgetFormulatedCostDetail budgetFormulatedCostDetail : budgetFormulatedCosts) {
            if (budgetFormulatedCostDetail.getFormulatedNumber() == null) {
                budgetFormulatedCostDetail.setFormulatedNumber(budget.getNextValue("BUDGET_FORMULATED_NUMBER"));
            }
            this.calculateBudgetFormulatedCost(budgetFormulatedCostDetail);
            formulatedExpenses = (ScaleTwoDecimal)formulatedExpenses.add((AbstractDecimal)budgetFormulatedCostDetail.getCalculatedExpenses());
        }
        return formulatedExpenses;
    }

    private void calculateBudgetFormulatedCost(BudgetFormulatedCostDetail budgetFormulatedCost) {
        ScaleTwoDecimal unitCost = budgetFormulatedCost.getUnitCost();
        ScaleTwoDecimal count = new ScaleTwoDecimal(budgetFormulatedCost.getCount().intValue());
        ScaleTwoDecimal frequency = new ScaleTwoDecimal(budgetFormulatedCost.getFrequency().intValue());
        ScaleTwoDecimal calculatedExpense = (ScaleTwoDecimal)((ScaleTwoDecimal)unitCost.multiply((AbstractDecimal)count)).multiply((AbstractDecimal)frequency);
        budgetFormulatedCost.setCalculatedExpenses(calculatedExpense);
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public BudgetRatesService getBudgetRatesService() {
        return this.budgetRatesService;
    }

    public void setBudgetRatesService(BudgetRatesService budgetRatesService) {
        this.budgetRatesService = budgetRatesService;
    }

    private static enum BudgetSummaryConstants {
        CalculatedDirectCost("calculatedDirectCosts", "Calculated Direct Costs"),
        TotalDirectCost("totalDirectCost", "Total Direct Cost"),
        TotalFnACost("totalFnACost", "Total F&A Costs"),
        PersonSalary("salary", "Salary"),
        PersonFringe("fringe", "Fringe");

        private final String key;
        private final String label;

        private BudgetSummaryConstants(String key, String label) {
            this.key = key;
            this.label = label;
        }

        public String getKey() {
            return this.key;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

