/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.modular;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.modular.ModularBudgetService;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.impl.modular.ModularBudgetCommunicationException;
import org.kuali.coeus.common.budget.impl.modular.StandaloneModularBudgetDto;
import org.kuali.coeus.common.budget.impl.modular.StandaloneModularBudgetPeriodDto;
import org.kuali.coeus.common.budget.impl.modular.StandaloneModularBudgetResponse;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetNavigationService;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

@Service(value="modularBudgetService")
public class ModularBudgetServiceImpl
implements ModularBudgetService {
    protected static final String STANDALONE_BUDGET_GRAPHQL_ENDPOINT = "/api/v1/budget/graphql";
    protected static final String BUDGET_ID_VARIABLE = "budgetId";
    protected static final String MOD_BUDGET_GRAPHQL_QUERY = "query AllModularBudgetData($budgetId: Int!) {  modularBudget(budgetId: $budgetId) {    budgetId    proposalNumber    periods {      period      modularAmounts {        detailedBudgetActuals        directCostLessConsortiumFA        consortiumFA        moduleRequested        modularTotalDirectCost        faBase        faRates {          rate          description          base          total        }        totalFA        modularTotal      }    }  }}";
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="restOperations")
    private RestOperations restOperations;
    @Autowired
    @Qualifier(value="proposalBudgetNavigationService")
    private ProposalBudgetNavigationService proposalBudgetNavigationService;

    public List<? extends BudgetModularContract> getModularBudgetAmounts(BudgetContract budgetContract) {
        if (!this.shouldRetrieveRemoteModularBudget()) {
            return this.mapBudgetPeriodsToModularAmounts(budgetContract);
        }
        return this.retrieveRemoteModularBudget(budgetContract);
    }

    protected List<? extends BudgetModularContract> retrieveRemoteModularBudget(BudgetContract budget) {
        String budgetBaseUrl = this.getProposalBudgetNavigationService().getStandaloneBudgetBaseUrl();
        String requestUrl = budgetBaseUrl + STANDALONE_BUDGET_GRAPHQL_ENDPOINT;
        GraphQLQuery modBudgetQuery = GraphQLQuery.of(MOD_BUDGET_GRAPHQL_QUERY).variable(BUDGET_ID_VARIABLE, budget.getBudgetId());
        try {
            ResponseEntity modBudgetResponse = this.restOperations.exchange(requestUrl, HttpMethod.POST, new HttpEntity((Object)modBudgetQuery, (MultiValueMap)this.authServiceRestUtilService.getAuthServiceStyleHttpHeadersForUser()), StandaloneModularBudgetResponse.class, new Object[0]);
            return this.mapModBudgetResponseToModularAmounts((StandaloneModularBudgetResponse)modBudgetResponse.getBody());
        }
        catch (RestClientException e) {
            throw new ModularBudgetCommunicationException(String.format("Failed to retrieve modular budget for budget ID %d", budget.getBudgetId()), e);
        }
    }

    protected List<? extends BudgetModularContract> mapBudgetPeriodsToModularAmounts(BudgetContract budget) {
        return budget.getBudgetPeriods().stream().filter(period -> period instanceof BudgetPeriod).map(period -> ((BudgetPeriod)period).getBudgetModular()).filter(modularBudget -> !Objects.isNull(modularBudget)).collect(Collectors.toList());
    }

    protected List<? extends BudgetModularContract> mapModBudgetResponseToModularAmounts(StandaloneModularBudgetResponse modBudgetResponse) {
        return Optional.of(modBudgetResponse).map(StandaloneModularBudgetResponse::getModularBudget).map(StandaloneModularBudgetDto::getPeriods).map(periods -> periods.stream().map(StandaloneModularBudgetPeriodDto::getModularAmounts).collect(Collectors.toList())).orElse(new ArrayList());
    }

    protected boolean shouldRetrieveRemoteModularBudget() {
        return this.parameterService.getParameterValueAsBoolean("KC-B", "All", "Standalone_Budget_Enabled", Boolean.valueOf(false));
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public ProposalBudgetNavigationService getProposalBudgetNavigationService() {
        return this.proposalBudgetNavigationService;
    }

    public void setProposalBudgetNavigationService(ProposalBudgetNavigationService proposalBudgetNavigationService) {
        this.proposalBudgetNavigationService = proposalBudgetNavigationService;
    }

    public static class GraphQLQuery {
        private String query;
        private String operationName;
        private Map<String, Object> variables;

        private GraphQLQuery(String query) {
            this.query = query;
            this.operationName = null;
            this.variables = new HashMap<String, Object>();
        }

        public String getQuery() {
            return this.query;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public GraphQLQuery operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public GraphQLQuery variable(String name, Object value) {
            this.variables.put(name, value);
            return this;
        }

        public static GraphQLQuery of(String query) {
            return new GraphQLQuery(query);
        }
    }
}

