/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.nonpersonnel;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.modular.ModularBudgetService;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleBase;
import org.kuali.coeus.common.budget.framework.core.BudgetAuditRuleEvent;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetExpenseService;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.impl.modular.ModularBudgetCommunicationException;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="budgetExpensesAuditRule")
public class BudgetExpensesAuditRule
extends BudgetAuditRuleBase {
    private final Logger LOG = LogManager.getLogger(BudgetExpensesAuditRule.class);
    private static final String WARN_NEGATIVE_UNRECOVERED_F_AND_A_PARM = "WARN_NEGATIVE_UNRECOVERED_F_AND_A";
    public static final String BUDGET_MODULAR_KEY = "budget.modular";
    @Autowired
    @Qualifier(value="budgetExpenseService")
    private BudgetExpenseService budgetExpenseService;
    @Autowired
    @Qualifier(value="modularBudgetService")
    private ModularBudgetService modularBudgetService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @KcEventMethod
    @Deprecated
    public boolean processRunAuditBusinessRules(BudgetAuditEvent event) {
        Budget budget = event.getBudget();
        boolean retval = true;
        if (budget.getTotalCostLimit().isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO) && budget.getTotalCost().isGreaterThan((AbstractDecimal)budget.getTotalCostLimit())) {
            ArrayList<AuditError> auditErrors;
            String key = "budgetParametersOverviewWarnings";
            AuditCluster auditCluster = this.getGlobalVariableService().getAuditErrorMap().get(key);
            if (auditCluster == null) {
                auditErrors = new ArrayList<AuditError>();
                auditCluster = new AuditCluster("Budget Overview", auditErrors, "Warnings");
                this.getGlobalVariableService().getAuditErrorMap().put(key, auditCluster);
            }
            auditErrors = auditCluster.getAuditErrorList();
            auditErrors.add(new AuditError("document.budget.totalCostLimit", "warning.budgetCostLimit.exceeded", "summary.topOfForm"));
            retval = false;
        }
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getTotalCostLimit().isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO) && budgetPeriod.getTotalCost().isGreaterThan((AbstractDecimal)budgetPeriod.getTotalCostLimit())) {
                ArrayList<AuditError> auditErrors;
                String key = "budgetPeriodProjectDateAuditWarnings";
                AuditCluster auditCluster = this.getGlobalVariableService().getAuditErrorMap().get(key);
                if (auditCluster == null) {
                    auditErrors = new ArrayList<AuditError>();
                    auditCluster = new AuditCluster("Budget Periods & Totals", auditErrors, "Warnings");
                    this.getGlobalVariableService().getAuditErrorMap().put(key, auditCluster);
                }
                auditErrors = auditCluster.getAuditErrorList();
                auditErrors.add(new AuditError("document.budget.budgetPeriods[" + (budgetPeriod.getBudgetPeriod() - 1) + "].totalCostLimit", "warning.periodCostLimit.exceeded", "summary.BudgetPeriodsTotals"));
                retval = false;
            }
            int j = 0;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                String panelName = this.budgetExpenseService.getBudgetExpensePanelName(budgetPeriod, budgetLineItem);
                if (budgetLineItem.getUnderrecoveryAmount() != null && budgetLineItem.getUnderrecoveryAmount().isNegative() && this.parameterService.getParameterValueAsBoolean("KC-B", "All", WARN_NEGATIVE_UNRECOVERED_F_AND_A_PARM).booleanValue()) {
                    ArrayList<AuditError> auditErrors;
                    String key = "budgetNonPersonnelAuditWarnings" + budgetPeriod.getBudgetPeriod() + panelName;
                    AuditCluster auditCluster = this.getGlobalVariableService().getAuditErrorMap().get(key);
                    if (auditCluster == null) {
                        auditErrors = new ArrayList<AuditError>();
                        auditCluster = new AuditCluster(panelName + " Budget Period " + budgetPeriod.getBudgetPeriod(), auditErrors, "Warnings");
                        this.getGlobalVariableService().getAuditErrorMap().put(key, auditCluster);
                    }
                    auditErrors = auditCluster.getAuditErrorList();
                    auditErrors.add(new AuditError("document.budgetPeriod[" + (budgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + j + "].underrecoveryAmount", "warning.unrecoveredFA.negative", "budgetExpenses." + budgetLineItem.getBudgetCategory().getBudgetCategoryType().getDescription() + "&viewBudgetPeriod=" + budgetPeriod.getBudgetPeriod() + "&selectedBudgetLineItemIndex=" + j + "&activePanelName=" + panelName));
                    retval = false;
                }
                int k = 0;
                for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                    List<AuditError> auditErrors;
                    AuditCluster auditCluster;
                    String key;
                    if (StringUtils.isNotEmpty((CharSequence)budgetPersonnelDetails.getEffdtAfterStartdtMsg())) {
                        key = "budgetPersonnelBudgetAuditWarnings" + budgetPeriod.getBudgetPeriod();
                        auditCluster = this.getGlobalVariableService().getAuditErrorMap().get(key);
                        if (auditCluster == null) {
                            auditErrors = new ArrayList<AuditError>();
                            auditCluster = new AuditCluster("Personnel Budget (Period " + budgetPeriod.getBudgetPeriod() + ")", auditErrors, "Warnings");
                            this.getGlobalVariableService().getAuditErrorMap().put(key, auditCluster);
                        }
                        auditErrors = auditCluster.getAuditErrorList();
                        auditErrors.add(new AuditError("document.budgetPeriod[" + (budgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + j + "].budgetPersonnelDetailsList[" + k + "].salaryRequested", "warning.effdt.after.periodStartDate", "budgetExpenses.BudgetOvervieV&viewBudgetPeriod=" + budgetPeriod.getBudgetPeriod() + "&selectedBudgetLineItemIndex=" + j + "&personnelDetailLine=" + k, new String[]{budgetPersonnelDetails.getBudgetPerson().getPersonName()}));
                    }
                    if (budgetPersonnelDetails.getBudgetPerson().getCalculationBase().equals((Object)ScaleTwoDecimal.ZERO)) {
                        key = "budgetPersonnelBudgetAuditWarnings" + budgetPeriod.getBudgetPeriod();
                        auditCluster = this.getGlobalVariableService().getAuditErrorMap().get(key);
                        if (auditCluster == null) {
                            auditErrors = new ArrayList();
                            auditCluster = new AuditCluster("Personnel Budget (Period " + budgetPeriod.getBudgetPeriod() + ")", auditErrors, "Warnings");
                            this.getGlobalVariableService().getAuditErrorMap().put(key, auditCluster);
                        }
                        auditErrors = auditCluster.getAuditErrorList();
                        auditErrors.add(new AuditError("document.budgetPeriod[" + (budgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + j + "].budgetPersonnelDetailsList[" + k + "].salaryRequested", "warning..base.salary.zero", "budgetExpenses.BudgetOvervieV&viewBudgetPeriod=" + budgetPeriod.getBudgetPeriod() + "&selectedBudgetLineItemIndex=" + j + "&personnelDetailLine=" + k, new String[]{budgetPersonnelDetails.getBudgetPerson().getPersonName()}));
                        retval = false;
                    }
                    ++k;
                }
                ++j;
            }
        }
        return retval;
    }

    @KcEventMethod
    public boolean processRunAuditBusinessRules(BudgetAuditRuleEvent event) {
        Budget budget = event.getBudget();
        boolean auditRulePassed = this.verifyTotalCostLimit(budget);
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            auditRulePassed &= this.verifyPeriodCostLimit(budgetPeriod);
        }
        for (BudgetLineItem budgetLineItem : budget.getBudgetLineItems()) {
            auditRulePassed &= this.verifyUnderRecoveryAmount(budgetLineItem);
        }
        for (BudgetPersonnelDetails budgetPersonnelDetails : budget.getBudgetPersonnelDetails()) {
            auditRulePassed &= this.verifyPersonnelDetails(budgetPersonnelDetails);
        }
        return auditRulePassed &= this.verifyModularBudgetStatus(budget);
    }

    protected boolean verifyTotalCostLimit(Budget budget) {
        if (budget.getTotalCostLimit().isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO) && budget.getTotalCost().isGreaterThan((AbstractDecimal)budget.getTotalCostLimit())) {
            BudgetConstants.BudgetAuditRules budgetSettingsRule = BudgetConstants.BudgetAuditRules.BUDGET_SETTINGS;
            List<AuditError> auditErrors = this.getAuditErrors(budgetSettingsRule, false);
            auditErrors.add(new AuditError("budget.totalCostLimit", "warning.budgetCostLimit.exceeded", budgetSettingsRule.getPageId()));
            return false;
        }
        return true;
    }

    protected boolean verifyPeriodCostLimit(BudgetPeriod budgetPeriod) {
        if (budgetPeriod.getTotalCostLimit().isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO) && budgetPeriod.getTotalCost().isGreaterThan((AbstractDecimal)budgetPeriod.getTotalCostLimit())) {
            BudgetConstants.BudgetAuditRules budgetPeriodAndTotalRule = BudgetConstants.BudgetAuditRules.PERIODS_AND_TOTALS;
            List<AuditError> auditErrors = this.getAuditErrors(budgetPeriodAndTotalRule, false);
            auditErrors.add(new AuditError(budgetPeriodAndTotalRule.getPageId(), "warning.periodCostLimit.exceeded", budgetPeriodAndTotalRule.getPageId(), new String[]{budgetPeriod.getBudgetPeriod().toString()}));
            return false;
        }
        return true;
    }

    protected boolean verifyUnderRecoveryAmount(BudgetLineItem budgetLineItem) {
        if (budgetLineItem.getUnderrecoveryAmount() != null && budgetLineItem.getUnderrecoveryAmount().isNegative() && this.parameterService.getParameterValueAsBoolean("KC-B", "All", WARN_NEGATIVE_UNRECOVERED_F_AND_A_PARM).booleanValue()) {
            BudgetConstants.BudgetAuditRules budgetNonPersonnelRule = BudgetConstants.BudgetAuditRules.NON_PERSONNEL_COSTS;
            String additionalMessage = " Budget Period " + budgetLineItem.getBudgetPeriodBO().getBudgetPeriod() + "Line item " + budgetLineItem.getCostElementBO().getDescription();
            List<AuditError> auditErrors = this.getAuditErrors(budgetNonPersonnelRule, additionalMessage, false);
            auditErrors.add(new AuditError(budgetNonPersonnelRule.getPageId(), "warning.unrecoveredFA.negative", budgetNonPersonnelRule.getPageId(), new String[]{additionalMessage}));
        }
        return true;
    }

    protected boolean verifyPersonnelDetails(BudgetPersonnelDetails budgetPersonnelDetails) {
        boolean passed = true;
        boolean salaryEffectiveAfterStartDate = budgetPersonnelDetails.isPersonSalaryEffectiveDateAfterStartDate();
        boolean personSalaryNotDefined = budgetPersonnelDetails.isPersonBaseSalaryZero();
        if (salaryEffectiveAfterStartDate || personSalaryNotDefined) {
            BudgetPeriod budgetPeriod = budgetPersonnelDetails.getBudgetLineItem().getBudgetPeriodBO();
            BudgetPerson budgetPerson = budgetPersonnelDetails.getBudgetPerson();
            BudgetConstants.BudgetAuditRules budgetProjectPersonnelRule = BudgetConstants.BudgetAuditRules.PROJECT_PERSONNEL;
            List<AuditError> auditErrors = this.getAuditErrors(budgetProjectPersonnelRule, " Budget Period " + budgetPeriod.getBudgetPeriod(), false);
            String errorKey = budgetProjectPersonnelRule.getPageId();
            if (salaryEffectiveAfterStartDate) {
                auditErrors.add(new AuditError(errorKey, "warning.effdt.after.periodStartDate", budgetProjectPersonnelRule.getPageId(), new String[]{budgetPerson.getPersonName()}));
            } else {
                auditErrors.add(new AuditError(errorKey, "warning..base.salary.zero", budgetProjectPersonnelRule.getPageId(), new String[]{budgetPerson.getPersonName()}));
            }
        }
        return passed;
    }

    protected boolean verifyModularBudgetStatus(Budget budget) {
        boolean validBudgetCompletion = true;
        if (budget.getModularBudgetFlag().booleanValue()) {
            try {
                List modularAmounts = this.getModularBudgetService().getModularBudgetAmounts((BudgetContract)budget);
                for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                    if (budgetPeriod == null) continue;
                    BudgetModularContract modularBudget = this.getModularBudgetService().getModularBudgetForPeriod(modularAmounts, (BudgetPeriodContract)budgetPeriod);
                    if (modularBudget == null || modularBudget.getTotalDirectCost() == null) {
                        validBudgetCompletion = false;
                    } else if (modularBudget.getTotalDirectCost().equals((Object)ScaleTwoDecimal.ZERO) && budgetPeriod.getTotalDirectCost().isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
                        validBudgetCompletion = false;
                    }
                    if (validBudgetCompletion) continue;
                    BudgetConstants.BudgetAuditRules budgetModularRule = BudgetConstants.BudgetAuditRules.MODULAR_BUDGET;
                    List<AuditError> auditErrors = this.getAuditErrors(budgetModularRule, true);
                    auditErrors.add(new AuditError(BUDGET_MODULAR_KEY, "error.modularBudget.not.synced", budgetModularRule.getPageId()));
                    break;
                }
            }
            catch (ModularBudgetCommunicationException e) {
                this.LOG.error("Unable to verify modular budget", (Throwable)e);
                validBudgetCompletion = false;
                BudgetConstants.BudgetAuditRules budgetsRule = BudgetConstants.BudgetAuditRules.BUDGETS_PAGE;
                this.getGlobalVariableService().getMessageMap().putError(budgetsRule.getPageId(), "error.modularBudget.communication.error", new String[]{e.getMessage()});
            }
        }
        return validBudgetCompletion;
    }

    protected BudgetExpenseService getBudgetExpenseService() {
        return this.budgetExpenseService;
    }

    public void setBudgetExpenseService(BudgetExpenseService budgetExpenseService) {
        this.budgetExpenseService = budgetExpenseService;
    }

    public ModularBudgetService getModularBudgetService() {
        return this.modularBudgetService;
    }

    public void setModularBudgetService(ModularBudgetService modularBudgetService) {
        this.modularBudgetService = modularBudgetService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

