/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.personnel;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonSalaryDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelBudgetService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetPersonnelBudgetService")
public class BudgetPersonnelBudgetServiceImpl
implements BudgetPersonnelBudgetService {
    private static final Logger LOG = LogManager.getLogger(BudgetPersonnelBudgetServiceImpl.class);
    public static final int BUDGET_PERIOD_1 = 1;
    @Autowired
    @Qualifier(value="budgetPersonService")
    private BudgetPersonService budgetPersonService;
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    @Override
    public void addBudgetPersonnelDetails(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem, BudgetPersonnelDetails newBudgetPersonnelDetails) {
        try {
            ConvertUtils.register((Converter)new SqlDateConverter(null), Date.class);
            ConvertUtils.register((Converter)new SqlTimestampConverter(null), Timestamp.class);
            BeanUtils.copyProperties((Object)newBudgetPersonnelDetails, (Object)budgetLineItem);
            newBudgetPersonnelDetails.setBudgetJustification(null);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.copyLineItemToPersonnelDetails(budgetLineItem, newBudgetPersonnelDetails);
        }
        newBudgetPersonnelDetails.setPersonNumber(budget.getNextValue("budget.budgetPersonnelDetails.personNumber"));
        newBudgetPersonnelDetails.setPersonSequenceNumber(newBudgetPersonnelDetails.getPersonSequenceNumber());
        newBudgetPersonnelDetails.setPersonId(newBudgetPersonnelDetails.getBudgetPerson().getPersonRolodexTbnId());
        newBudgetPersonnelDetails.setJobCode(newBudgetPersonnelDetails.getBudgetPerson().getJobCode());
        newBudgetPersonnelDetails.setSequenceNumber(budget.getNextValue("budget.budgetPersonnelDetails.sequenceNumber"));
        newBudgetPersonnelDetails.refreshNonUpdateableReferences();
        budgetLineItem.getBudgetPersonnelDetailsList().add(newBudgetPersonnelDetails);
    }

    @Override
    public List<BudgetPersonSalaryDetails> calculatePersonSalary(Budget budget, int personIndex) {
        ArrayList<BudgetPersonSalaryDetails> budgetPersonSalaryDetails = new ArrayList<BudgetPersonSalaryDetails>();
        String rate = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "DEFAULT_INFLATION_RATE_FOR_SALARY");
        List<BudgetPeriod> budgetPeriodList = null;
        BigDecimal actualPersonSalary = ScaleTwoDecimal.ZERO.bigDecimalValue();
        BigDecimal personSalary = ScaleTwoDecimal.ZERO.bigDecimalValue();
        BigDecimal newRate = new ScaleTwoDecimal(rate).bigDecimalValue();
        budgetPeriodList = budget.getBudgetPeriods();
        BudgetPerson budgetPerson = budget.getBudgetPerson(personIndex);
        for (BudgetPeriod budgetPeriodData : budgetPeriodList) {
            BudgetPersonSalaryDetails personSalaryDetails = new BudgetPersonSalaryDetails();
            personSalaryDetails.setBudgetPerson(budgetPerson);
            personSalaryDetails.setBudgetId(budget.getBudgetId());
            personSalaryDetails.setPersonSequenceNumber(budgetPerson.getPersonSequenceNumber());
            personSalaryDetails.setBudgetPeriod(budgetPeriodData.getBudgetPeriod());
            personSalaryDetails.setPersonId(budgetPerson.getPersonId());
            if (budgetPeriodData.getBudgetPeriod() == 1) {
                if (budgetPerson.getEffectiveDate().equals(budgetPerson.getStartDate())) {
                    personSalaryDetails.setBaseSalary(budgetPerson.getCalculationBase());
                    actualPersonSalary = budgetPerson.getCalculationBase().bigDecimalValue();
                } else {
                    actualPersonSalary = ((ScaleTwoDecimal)budgetPerson.getCalculationBase().add((AbstractDecimal)new ScaleTwoDecimal(budgetPerson.getCalculationBase().bigDecimalValue().multiply(newRate.divide(new ScaleTwoDecimal(100).bigDecimalValue(), RoundingMode.HALF_UP))))).bigDecimalValue();
                }
            } else {
                personSalary = actualPersonSalary.add(actualPersonSalary.multiply(newRate.divide(new ScaleTwoDecimal(100).bigDecimalValue(), RoundingMode.HALF_UP)));
                personSalaryDetails.setBaseSalary(new ScaleTwoDecimal(personSalary));
                actualPersonSalary = personSalary;
            }
            budgetPersonSalaryDetails.add(personSalaryDetails);
        }
        return budgetPersonSalaryDetails;
    }

    @Override
    public void calculateBudgetPersonnelBudget(Budget budget, BudgetLineItem selectedBudgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails, int lineNumber) {
        this.copyLineItemToPersonnelDetails(selectedBudgetLineItem, budgetPersonnelDetails);
        this.budgetCalculationService.calculateBudgetLineItem(budget, budgetPersonnelDetails);
        if (budgetPersonnelDetails.getSalaryRequested().equals((Object)ScaleTwoDecimal.ZERO)) {
            int budgetPeriodNumber = budgetPersonnelDetails.getBudgetPeriod() - 1;
            BudgetPeriod budgetPeriod = budget.getBudgetPeriod(budgetPeriodNumber);
            Date personEffectiveDate = budgetPersonnelDetails.getBudgetPerson().getEffectiveDate();
            if (personEffectiveDate.after(budgetPeriod.getEndDate())) {
                MessageMap errorMap = this.globalVariableService.getMessageMap();
                errorMap.putError("document.budgetPeriod[" + budgetPeriodNumber + "].budgetLineItems[" + budgetPeriodNumber + "].budgetPersonnelDetailsList[" + lineNumber + "].personSequenceNumber", "error.effective.date.out.of.range", new String[]{budgetPersonnelDetails.getBudgetPerson().getPersonName()});
            }
        }
    }

    protected void copyLineItemToPersonnelDetails(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails) {
        budgetPersonnelDetails.setBudget(budgetLineItem.getBudget());
        budgetPersonnelDetails.setBudgetId(budgetLineItem.getBudgetId());
        budgetPersonnelDetails.setBudgetPeriod(budgetLineItem.getBudgetPeriod());
        budgetPersonnelDetails.setBudgetPeriodId(budgetLineItem.getBudgetPeriodId());
        budgetPersonnelDetails.setLineItemNumber(budgetLineItem.getLineItemNumber());
        budgetPersonnelDetails.setCostElement(budgetLineItem.getCostElement());
        budgetPersonnelDetails.setCostElementBO(budgetLineItem.getCostElementBO());
        budgetPersonnelDetails.setApplyInRateFlag(budgetLineItem.getApplyInRateFlag());
        budgetPersonnelDetails.setOnOffCampusFlag(budgetLineItem.getOnOffCampusFlag());
        budgetPersonnelDetails.setStartDate(budgetPersonnelDetails.getStartDate());
        budgetPersonnelDetails.setEndDate(budgetPersonnelDetails.getEndDate());
        budgetPersonnelDetails.setBudgetLineItem(budgetLineItem);
    }

    @Override
    public void deleteBudgetPersonnelDetails(Budget budget, int selectedBudgetPeriodIndex, int selectedBudgetLineItemIndex, int lineToDelete) {
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        selectedBudgetLineItem.getBudgetPersonnelDetailsList().remove(lineToDelete);
        selectedBudgetLineItem.setBudgetPersonnelLineItemDeleted(true);
    }

    @Override
    public void deleteBudgetPersonnelDetailsForPerson(Budget document, BudgetPerson person) {
        boolean personFound = false;
        BudgetPersonnelDetails toRemove = null;
        BudgetLineItem lineItem = null;
        Iterator<BudgetPeriod> period_it = document.getBudgetPeriods().iterator();
        while (period_it.hasNext() && !personFound) {
            BudgetPeriod period = period_it.next();
            Iterator<BudgetLineItem> lineItem_it = period.getBudgetLineItems().iterator();
            while (lineItem_it.hasNext() && !personFound) {
                lineItem = lineItem_it.next();
                Iterator<BudgetPersonnelDetails> personnelDetails_it = lineItem.getBudgetPersonnelDetailsList().iterator();
                while (personnelDetails_it.hasNext() && !personFound) {
                    BudgetPersonnelDetails personnelDetails = personnelDetails_it.next();
                    if (personnelDetails.getBudgetPerson() == null) {
                        personnelDetails.refreshReferenceObject("budgetPerson");
                    }
                    if (!ObjectUtils.equalByKeys((PersistableBusinessObject)personnelDetails.getBudgetPerson(), (PersistableBusinessObject)person)) continue;
                    LOG.debug("Comparing " + personnelDetails.getBudgetPerson().getPersonId() + " and " + person.getPersonId());
                    lineItem.setBudgetPersonnelLineItemDeleted(true);
                    personFound = true;
                    toRemove = personnelDetails;
                }
            }
        }
        if (personFound && toRemove != null && lineItem != null) {
            LOG.debug("Removing " + toRemove);
            lineItem.getBudgetPersonnelDetailsList().remove(toRemove);
        }
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public BudgetPersonService getBudgetPersonService() {
        return this.budgetPersonService;
    }

    public void setBudgetPersonService(BudgetPersonService budgetPersonService) {
        this.budgetPersonService = budgetPersonService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public void calculateBudgetPersonnelLineItem(Budget budget, BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails, int lineItemNumber) {
        this.getBudgetCalculationService().updatePersonnelBudgetRate(budgetLineItem);
        if (budgetPersonnelDetails.getPersonSequenceNumber() == BudgetConstants.BudgetPerson.SUMMARYPERSON.getPersonSequenceNumber()) {
            this.getBudgetCalculationService().calculateBudgetLineItem(budget, budgetLineItem);
            this.getBudgetCalculationService().populateCalculatedAmount(budget, budgetLineItem);
        } else {
            this.calculateBudgetPersonnelBudget(budget, budgetLineItem, budgetPersonnelDetails, lineItemNumber);
            this.getBudgetCalculationService().populateCalculatedAmount(budget, budgetLineItem);
            this.getBudgetCalculationService().populateCalculatedAmount(budget, budgetPersonnelDetails);
        }
    }

    @Override
    public void addBudgetPersonnelToPeriod(BudgetPeriod budgetPeriod, BudgetLineItem newBudgetLineItem, BudgetPersonnelDetails newBudgetPersonnelDetail) {
        Budget budget = budgetPeriod.getBudget();
        BudgetLineItem groupedBudgetLineItem = this.getExistingBudgetLineItemBasedOnLineItemsCostElementAndGroup(budgetPeriod, newBudgetLineItem);
        boolean newLineItem = false;
        if (groupedBudgetLineItem == null) {
            groupedBudgetLineItem = newBudgetLineItem;
            this.setNewBudgetLineItemAttributes(budgetPeriod, groupedBudgetLineItem);
            newLineItem = true;
        }
        groupedBudgetLineItem.setQuantity(this.getLineItemQuantity(newBudgetLineItem));
        if (newBudgetPersonnelDetail.getPersonSequenceNumber() != BudgetConstants.BudgetPerson.SUMMARYPERSON.getPersonSequenceNumber()) {
            int newLineNumber = groupedBudgetLineItem.getBudgetPersonnelDetailsList().size() + 1;
            this.addPersonnelToPeriod(budgetPeriod, groupedBudgetLineItem, newBudgetPersonnelDetail);
            this.calculateBudgetPersonnelLineItem(budget, groupedBudgetLineItem, newBudgetPersonnelDetail, newLineNumber);
        }
        if (newLineItem) {
            budgetPeriod.getBudgetLineItems().add(groupedBudgetLineItem);
        }
    }

    protected BudgetLineItem getExistingBudgetLineItemBasedOnLineItemsCostElementAndGroup(BudgetPeriod budgetPeriod, BudgetLineItem newBudgetLineItem) {
        String newLineItemKey = this.getLineItemGroupKey(newBudgetLineItem);
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            String existingLineItemKey = this.getLineItemGroupKey(budgetLineItem);
            if (!newLineItemKey.equalsIgnoreCase(existingLineItemKey)) continue;
            return budgetLineItem;
        }
        return null;
    }

    protected String getLineItemGroupKey(BudgetLineItem budgetLineItem) {
        if (StringUtils.isEmpty((CharSequence)budgetLineItem.getGroupName())) {
            return budgetLineItem.getCostElement();
        }
        return budgetLineItem.getCostElement().concat(budgetLineItem.getGroupName());
    }

    protected void setNewBudgetLineItemAttributes(BudgetPeriod budgetPeriod, BudgetLineItem newBudgetLineItem) {
        Budget budget = budgetPeriod.getBudget();
        Integer lineItemNumber = budget.getNextValue("budget.budgetLineItem.lineItemNumber");
        newBudgetLineItem.setBudgetId(budget.getBudgetId());
        newBudgetLineItem.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
        newBudgetLineItem.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
        newBudgetLineItem.setBudgetPeriodBO(budgetPeriod);
        newBudgetLineItem.setLineItemNumber(lineItemNumber);
        newBudgetLineItem.setLineItemSequence(lineItemNumber);
        newBudgetLineItem.setApplyInRateFlag(true);
        String onOffCampusFlag = budget.getOnOffCampusFlag();
        if (onOffCampusFlag.equalsIgnoreCase("D")) {
            newBudgetLineItem.setOnOffCampusFlag(newBudgetLineItem.getCostElementBO().getOnOffCampusFlag());
        } else {
            newBudgetLineItem.setOnOffCampusFlag(onOffCampusFlag.equalsIgnoreCase("N"));
        }
    }

    private Integer getLineItemQuantity(BudgetLineItem personnelLineItem) {
        HashSet<String> uniqueBudgetPersonnelCount = new HashSet<String>();
        Integer quantity = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : personnelLineItem.getBudgetPersonnelDetailsList()) {
            if (uniqueBudgetPersonnelCount.contains(budgetPersonnelDetails.getPersonId())) continue;
            uniqueBudgetPersonnelCount.add(budgetPersonnelDetails.getPersonId());
            Integer n = quantity;
            Integer n2 = quantity = Integer.valueOf(quantity + 1);
        }
        return quantity;
    }

    protected void addPersonnelToPeriod(BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem, BudgetPersonnelDetails newBudgetPersonnelDetail) {
        Budget budget = budgetPeriod.getBudget();
        this.copyLineItemToPersonnelDetails(budgetLineItem, newBudgetPersonnelDetail);
        newBudgetPersonnelDetail.setPersonNumber(budget.getNextValue("budget.budgetPersonnelDetails.personNumber"));
        newBudgetPersonnelDetail.setSequenceNumber(budget.getNextValue("budget.budgetPersonnelDetails.sequenceNumber"));
        budgetLineItem.getBudgetPersonnelDetailsList().add(newBudgetPersonnelDetail);
    }

    @Override
    public void refreshBudgetPersonnelLineItemReferences(BudgetPersonnelDetails newBudgetPersonnelDetail) {
        BudgetPerson budgetPerson;
        if (newBudgetPersonnelDetail.getBudgetId() != null && newBudgetPersonnelDetail.getPersonSequenceNumber() != null) {
            this.getDataObjectService().wrap((Object)newBudgetPersonnelDetail).fetchRelationship("budgetPerson");
        }
        if (newBudgetPersonnelDetail.getPeriodTypeCode() != null) {
            this.getDataObjectService().wrap((Object)newBudgetPersonnelDetail).fetchRelationship("budgetPeriodType");
        }
        if ((budgetPerson = newBudgetPersonnelDetail.getBudgetPerson()) != null) {
            newBudgetPersonnelDetail.setPersonId(budgetPerson.getPersonRolodexTbnId());
            newBudgetPersonnelDetail.setJobCode(budgetPerson.getJobCode());
        }
    }

    @Override
    public void calculateCurrentBudgetPeriod(BudgetPeriod budgetPeriod) {
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            this.getBudgetCalculationService().updatePersonnelBudgetRate(budgetLineItem);
            if (!budgetLineItem.getFormulatedCostElementFlag().booleanValue()) continue;
            this.getBudgetCalculationService().calculateAndUpdateFormulatedCost(budgetLineItem);
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

