/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.budget.framework.core.AwardBudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetForm;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategory;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.AddPersonnelBudgetEvent;
import org.kuali.coeus.common.budget.framework.personnel.AddPersonnelLineItemBudgetEvent;
import org.kuali.coeus.common.budget.framework.personnel.AddSummaryPersonnelLineItemBudgetEvent;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonSalaryDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelBudgetService;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetSavePersonnelEvent;
import org.kuali.coeus.common.budget.framework.personnel.DeleteBudgetPersonEvent;
import org.kuali.coeus.common.budget.framework.personnel.PersonnelApplyToPeriodsBudgetEvent;
import org.kuali.coeus.common.budget.framework.personnel.TbnPerson;
import org.kuali.coeus.common.budget.impl.struts.BudgetExpensesAction;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodExt;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetPersonnelAction
extends BudgetExpensesAction {
    private static final String CONFIRM_DELETE_BUDGET_PERSON = "confirmDeleteBudgetPerson";
    private static final String EMPTY_GROUP_NAME = "";
    private static final String DEFAULT_GROUP_NAME = "(new group)";
    private static final String BUDGET_PERSONS_FIELD_NAME_START = "budgetPersons[";
    private static final String BUDGET_PERSONS_FIELD_NAME_PERSON_NUMBER = "].personNumber";
    private BudgetPersonnelBudgetService budgetPersonnelBudgetService;
    private BudgetPersonService budgetPersonService;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        if (budget.getBudgetCategoryTypeCodes() == null || budget.getBudgetCategoryTypeCodes().size() == 0) {
            this.populatePersonnelCategoryTypeCodes(budgetForm);
        }
        ActionForward forward = super.execute(mapping, form, request, response);
        return forward;
    }

    public ActionForward closePopUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        budgetForm.setViewDivFlag(false);
        return mapping.findForward("personnel");
    }

    public ActionForward addPersonnelLineItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        Integer budgetCategoryTypeIndex = Integer.parseInt(this.getBudgetCategoryTypeIndex(request));
        BudgetLineItem newBudgetLineItem = budgetForm.getNewBudgetLineItems().get(budgetCategoryTypeIndex);
        final BudgetPersonnelDetails budgetPersonDetails = budgetForm.getNewBudgetPersonnelDetails();
        budgetPersonDetails.setBudgetId(budget.getBudgetId());
        budgetPersonDetails.setPeriodTypeCode(this.getParameterService().getParameterValueAsString(Budget.class, "budgetPersonDetailsDefaultPeriodType"));
        budgetPersonDetails.setCostElement(newBudgetLineItem.getCostElement());
        budgetPersonDetails.setBudgetPerson((BudgetPerson)CollectionUtils.find(budget.getBudgetPersons(), (Predicate)new Predicate<BudgetPerson>(){

            public boolean evaluate(BudgetPerson object) {
                return object != null && object.getBudgetId().equals(budgetPersonDetails.getBudgetId()) && object.getPersonSequenceNumber().equals(budgetPersonDetails.getPersonSequenceNumber());
            }
        }));
        Object groupErrorKey = EMPTY_GROUP_NAME;
        if (StringUtils.isNotEmpty((CharSequence)newBudgetLineItem.getGroupName())) {
            groupErrorKey = "newBudgetLineItems[" + budgetCategoryTypeIndex + "].costElement";
        }
        if (StringUtils.isEmpty((CharSequence)newBudgetLineItem.getGroupName())) {
            newBudgetLineItem.setGroupName(budgetForm.getNewGroupName());
            groupErrorKey = "newGroupName";
        }
        if (StringUtils.isEmpty((CharSequence)newBudgetLineItem.getGroupName()) || StringUtils.equals((CharSequence)newBudgetLineItem.getGroupName(), (CharSequence)DEFAULT_GROUP_NAME)) {
            newBudgetLineItem.setGroupName(EMPTY_GROUP_NAME);
        }
        if (this.getKcBusinessRulesEngine().applyRules(new AddPersonnelBudgetEvent(budget, budget.getBudgetPeriod(budgetForm.getViewBudgetPeriod() - 1), newBudgetLineItem, budgetPersonDetails, (String)groupErrorKey)).booleanValue()) {
            HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
            primaryKeys.put("budgetId", budget.getBudgetId());
            primaryKeys.put("budgetPeriod", budgetForm.getViewBudgetPeriod().toString());
            List budgetPeriods = this.getBusinessObjectService().findMatching(BudgetPeriod.class, primaryKeys);
            BudgetPeriod budgetPeriod = null;
            if (CollectionUtils.isNotEmpty((Collection)budgetPeriods)) {
                budgetPeriod = (BudgetPeriod)budgetPeriods.get(0);
            }
            BudgetCategory newBudgetCategory = new BudgetCategory();
            newBudgetCategory.setBudgetCategoryTypeCode(this.getSelectedBudgetCategoryType(request));
            newBudgetCategory.refreshNonUpdateableReferences();
            boolean existingCeGroupCombo = false;
            int openTabLineItemIndex = -1;
            ArrayList<BudgetLineItem> existingPersonnelLineItems = new ArrayList<BudgetLineItem>();
            List<BudgetLineItem> existingLineItems = budget.getBudgetPeriod(budgetPeriod.getBudgetPeriod() - 1).getBudgetLineItems();
            if (GlobalVariables.getMessageMap().hasNoErrors()) {
                for (BudgetLineItem budgetLineItem : existingLineItems) {
                    budgetLineItem.refreshNonUpdateableReferences();
                    if (!budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode().equalsIgnoreCase(newBudgetCategory.getBudgetCategoryTypeCode())) continue;
                    existingPersonnelLineItems.add(budgetLineItem);
                    if (!newBudgetLineItem.getCostElement().equalsIgnoreCase(budgetLineItem.getCostElement()) || !StringUtils.equals((CharSequence)newBudgetLineItem.getGroupName(), (CharSequence)budgetLineItem.getGroupName()) && (!StringUtils.isEmpty((CharSequence)newBudgetLineItem.getGroupName()) || !StringUtils.isEmpty((CharSequence)budgetLineItem.getGroupName()))) continue;
                    if (budgetPersonDetails.getPersonSequenceNumber() != -1) {
                        if (this.getKcBusinessRulesEngine().applyRules(new AddPersonnelLineItemBudgetEvent(budget, "newBudgetPersonnelDetails", budgetLineItem)).booleanValue()) {
                            this.addBudgetPersonnelDetails(budgetForm, budgetPeriod, budgetLineItem, budgetPersonDetails);
                        }
                    } else if (!this.getKcBusinessRulesEngine().applyRules(new AddSummaryPersonnelLineItemBudgetEvent(budget, "newBudgetPersonnelDetails", budgetLineItem)).booleanValue()) {
                        existingCeGroupCombo = true;
                        break;
                    }
                    openTabLineItemIndex = budgetLineItem.getLineItemNumber();
                    this.setLineItemQuantity(budgetLineItem);
                    existingCeGroupCombo = true;
                    break;
                }
                if (!existingCeGroupCombo) {
                    newBudgetLineItem.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
                    newBudgetLineItem.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
                    newBudgetLineItem.setBudgetPeriodBO(budgetPeriod);
                    newBudgetLineItem.setBudgetCategory(newBudgetCategory);
                    newBudgetLineItem.setStartDate(budget.getBudgetPeriod(budgetPeriod.getBudgetPeriod() - 1).getStartDate());
                    newBudgetLineItem.setEndDate(budget.getBudgetPeriod(budgetPeriod.getBudgetPeriod() - 1).getEndDate());
                    newBudgetLineItem.setStartDate(newBudgetLineItem.getStartDate());
                    newBudgetLineItem.setEndDate(newBudgetLineItem.getEndDate());
                    newBudgetLineItem.setBudgetId(budget.getBudgetId());
                    newBudgetLineItem.setLineItemNumber(budgetForm.getBudgetDocument().getHackedDocumentNextValue("budget.budgetLineItem.lineItemNumber"));
                    newBudgetLineItem.setApplyInRateFlag(true);
                    newBudgetLineItem.refreshReferenceObject("costElementBO");
                    String onOffCampusFlag = budget.getOnOffCampusFlag();
                    if (onOffCampusFlag.equalsIgnoreCase("D")) {
                        newBudgetLineItem.setOnOffCampusFlag(newBudgetLineItem.getCostElementBO().getOnOffCampusFlag());
                    } else {
                        newBudgetLineItem.setOnOffCampusFlag(onOffCampusFlag.equalsIgnoreCase("N"));
                    }
                    newBudgetLineItem.setBudgetCategoryCode(newBudgetLineItem.getCostElementBO().getBudgetCategoryCode());
                    newBudgetLineItem.setLineItemSequence(newBudgetLineItem.getLineItemNumber());
                    if (budgetPersonDetails.getPersonSequenceNumber() != -1) {
                        this.addBudgetPersonnelDetails(budgetForm, budgetPeriod, newBudgetLineItem, budgetPersonDetails);
                    }
                    this.setLineItemQuantity(newBudgetLineItem);
                    budget.getBudgetPeriod(budgetPeriod.getBudgetPeriod() - 1).getBudgetLineItems().add(newBudgetLineItem);
                    this.getAwardBudgetPeriodCalculationService().recalculateBudgetPeriod(budget, budget.getBudgetPeriod(budgetPeriod.getBudgetPeriod() - 1));
                    this.getCalculationService().populateCalculatedAmount(budget, newBudgetLineItem);
                    openTabLineItemIndex = newBudgetLineItem.getLineItemNumber();
                }
                BudgetLineItem newLineItemToAdd = budget.getNewBudgetLineItem();
                budgetForm.getNewBudgetLineItems().set(budgetCategoryTypeIndex, newLineItemToAdd);
                request.setAttribute("openTabLineItemIndex", (Object)openTabLineItemIndex);
                budgetForm.setNewBudgetPersonnelDetails(newLineItemToAdd.getNewBudgetPersonnelLineItem());
            }
        }
        return mapping.findForward("basic");
    }

    private void setLineItemQuantity(BudgetLineItem personnelLineItem) {
        HashMap<Integer, String> uniqueBudgetPersonnelCount = new HashMap<Integer, String>();
        int qty = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : personnelLineItem.getBudgetPersonnelDetailsList()) {
            if (uniqueBudgetPersonnelCount.containsValue(budgetPersonnelDetails.getPersonId())) continue;
            uniqueBudgetPersonnelCount.put(qty, budgetPersonnelDetails.getPersonId());
            ++qty;
        }
        personnelLineItem.setQuantity(new Integer(qty));
    }

    private void addBudgetPersonnelDetails(BudgetForm budgetForm, BudgetPeriod budgetPeriod, BudgetLineItem newBudgetLineItem, BudgetPersonnelDetails newBudgetPersonnelDetails) throws Exception {
        boolean errorFound = false;
        if (budgetForm.getNewBudgetPersonnelDetails().getPersonSequenceNumber() == null) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.personSequenceNumber", "error.required", new String[]{"Person (Person)"});
            errorFound = true;
        }
        if (!errorFound) {
            this.getBudgetPersonnelBudgetService().addBudgetPersonnelDetails(budgetForm.getBudgetDocument().getBudget(), budgetPeriod, newBudgetLineItem, newBudgetPersonnelDetails);
            this.updatePersonnelBudgetRate(newBudgetLineItem);
            budgetForm.setNewBudgetPersonnelDetails(newBudgetLineItem.getNewBudgetPersonnelLineItem());
        }
    }

    public ActionForward deleteBudgetPersonnelDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = this.getSelectedLine(request);
        this.getBudgetPersonnelBudgetService().deleteBudgetPersonnelDetails(budget, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, this.getSelectedPersonnel(request));
        HashMap<Integer, String> uniqueBudgetPersonnelCount = new HashMap<Integer, String>();
        int qty = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex).getBudgetPersonnelDetailsList()) {
            if (uniqueBudgetPersonnelCount.containsValue(budgetPersonnelDetails.getPersonId())) continue;
            uniqueBudgetPersonnelCount.put(qty, budgetPersonnelDetails.getPersonId());
            ++qty;
        }
        budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex).setQuantity(new Integer(qty));
        if (qty == 0) {
            budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItems().remove(selectedBudgetLineItemIndex);
        }
        this.getAwardBudgetPeriodCalculationService().recalculateBudgetPeriod(budget, budget.getBudgetPeriod(selectedBudgetPeriodIndex));
        return mapping.findForward("basic");
    }

    protected int getSelectedPersonnel(HttpServletRequest request) {
        int selectedPersonnel = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            String personnelIndex = StringUtils.substringBetween((String)parameterName, (String)".personnel", (String)".");
            selectedPersonnel = Integer.parseInt(personnelIndex);
        }
        return selectedPersonnel;
    }

    public ActionForward calculateSalary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = this.getSelectedLine(request);
        int selectedPersonnelIndex = this.getSelectedPersonnel(request);
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        this.calculateSalaryForLineItem(budget, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, selectedPersonnelIndex, selectedBudgetLineItem);
        return mapping.findForward("basic");
    }

    public void calculateSalaryForLineItem(Budget budget, int selectedBudgetPeriodIndex, int selectedBudgetLineItemIndex, int selectedPersonnelIndex, BudgetLineItem selectedBudgetLineItem) {
        BudgetPersonnelDetails budgetPersonnelDetails = selectedBudgetLineItem.getBudgetPersonnelDetailsList().get(selectedPersonnelIndex);
        boolean errorFound = this.personnelDetailsCheck(budget, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, selectedPersonnelIndex);
        if (!errorFound) {
            this.updatePersonnelBudgetRate(selectedBudgetLineItem);
            this.getBudgetPersonnelBudgetService().calculateBudgetPersonnelBudget(budget, selectedBudgetLineItem, budgetPersonnelDetails, selectedPersonnelIndex);
            this.getAwardBudgetPeriodCalculationService().recalculateBudgetPeriod(budget, budget.getBudgetPeriod(selectedBudgetPeriodIndex));
            this.getCalculationService().populateCalculatedAmount(budget, selectedBudgetLineItem);
        }
        budget.getBudgetTotals();
    }

    private boolean personnelDetailsCheck(Budget budget, int selectedBudgetPeriodIndex, int selectedBudgetLineItemIndex, int selectedPersonnelIndex) {
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        BudgetPersonnelDetails budgetPersonnelDetails = selectedBudgetLineItem.getBudgetPersonnelDetailsList().get(selectedPersonnelIndex);
        boolean errorFound = false;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if (StringUtils.isEmpty((CharSequence)budgetPersonnelDetails.getPeriodTypeCode())) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + selectedPersonnelIndex + "].periodTypeCode", "error.required.periodTypeCode", new String[0]);
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentEffort().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100))) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + selectedPersonnelIndex + "].percentEffort", "error.percentage", new String[]{"Percent Effort"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(100))) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + selectedPersonnelIndex + "].percentCharged", "error.percentage", new String[]{"Percent Charged"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractDecimal)budgetPersonnelDetails.getPercentEffort())) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + selectedPersonnelIndex + "].percentCharged", "error.percentEffort.lessThan.percentCharged", new String[0]);
            errorFound = true;
        }
        errorFound = errorFound || this.personnelDatesCheck(selectedBudgetLineItem, budgetPersonnelDetails, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, selectedPersonnelIndex);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return errorFound;
    }

    private boolean personnelDatesCheck(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails, int selectedBudgetPeriodIndex, int selectedBudgetLineItemIndex, int detailIndex) {
        boolean errorFound = false;
        if (budgetPersonnelDetails.getStartDate() == null) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].startDate", "error.required", new String[]{"Start Date (Start Date)"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getEndDate() == null) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.required", new String[]{"End Date (End Date)"});
            errorFound = true;
        }
        if (!errorFound) {
            if (budgetPersonnelDetails.getEndDate().compareTo(budgetPersonnelDetails.getStartDate()) < 0) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.personnel.detail.dates", new String[0]);
                errorFound = true;
            }
            if (budgetLineItem.getEndDate().compareTo(budgetPersonnelDetails.getEndDate()) < 0) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.personnel.detail.end.date", new String[]{"can not be after", "end date"});
                errorFound = true;
            }
            if (budgetLineItem.getStartDate().compareTo(budgetPersonnelDetails.getEndDate()) > 0) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.personnel.detail.end.date", new String[]{"can not be before", "start date"});
                errorFound = true;
            }
            if (budgetLineItem.getStartDate().compareTo(budgetPersonnelDetails.getStartDate()) > 0) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].startDate", "error.personnel.detail.start.date", new String[]{"can not be before", "start date"});
                errorFound = true;
            }
            if (budgetLineItem.getEndDate().compareTo(budgetPersonnelDetails.getStartDate()) < 0) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItem[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].startDate", "error.personnel.detail.start.date", new String[]{"can not be after", "end date"});
                errorFound = true;
            }
        }
        return errorFound;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        block3: {
            Collection rawValues;
            Class<Object> lookupResultsBOClass;
            BudgetForm budgetForm;
            block5: {
                block4: {
                    super.refresh(mapping, form, request, response);
                    budgetForm = (BudgetForm)form;
                    if (budgetForm.getLookupResultsBOClassName() == null || budgetForm.getLookupResultsSequenceNumber() == null) break block3;
                    String lookupResultsSequenceNumber = budgetForm.getLookupResultsSequenceNumber();
                    lookupResultsBOClass = Class.forName(budgetForm.getLookupResultsBOClassName());
                    rawValues = KcServiceLocator.getService(LookupResultsService.class).retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, GlobalVariables.getUserSession().getPerson().getPrincipalId());
                    if (!lookupResultsBOClass.isAssignableFrom(KcPerson.class)) break block4;
                    for (KcPerson person : rawValues) {
                        BudgetPerson budgetPerson = new BudgetPerson(person);
                        this.populateAndAddBudgetPerson(budgetPerson, budgetForm.getBudget());
                    }
                    break block3;
                }
                if (!lookupResultsBOClass.isAssignableFrom(NonOrganizationalRolodex.class)) break block5;
                for (Rolodex rolodex : rawValues) {
                    BudgetPerson budgetPerson = new BudgetPerson(rolodex);
                    this.populateAndAddBudgetPerson(budgetPerson, budgetForm.getBudget());
                }
                break block3;
            }
            if (!lookupResultsBOClass.isAssignableFrom(TbnPerson.class)) break block3;
            for (TbnPerson tbn : rawValues) {
                BudgetPerson budgetPerson = new BudgetPerson(tbn);
                this.populateAndAddBudgetPerson(budgetPerson, budgetForm.getBudget());
            }
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        ActionForward forward = mapping.findForward("basic");
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            int i = 0;
            ArrayList<Integer> toBeDeletedLineItems = new ArrayList<Integer>();
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (budgetLineItem.getBudgetCategory() == null && budgetLineItem.getBudgetCategoryCode() != null) {
                    budgetLineItem.setBudgetCategory((BudgetCategory)this.getBusinessObjectService().findBySinglePrimaryKey(BudgetCategory.class, (Object)budgetLineItem.getBudgetCategoryCode()));
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode(), (CharSequence)"P")) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)budgetLineItem.getCostElement(), (CharSequence)budgetLineItem.getCostElementBO().getCostElement())) {
                        budgetLineItem.refreshReferenceObject("costElementBO");
                        budgetLineItem.setBudgetCategoryCode(budgetLineItem.getCostElementBO().getBudgetCategoryCode());
                    }
                    this.updatePersonnelBudgetRate(budgetLineItem);
                    if (this.checkToRetainBudgetLineItem(budgetLineItem, budget)) {
                        toBeDeletedLineItems.add(i);
                    }
                }
                ++i;
            }
            for (Integer lineItemIndex : toBeDeletedLineItems) {
                budgetPeriod.getBudgetLineItems().remove(lineItemIndex);
            }
        }
        this.getBudgetPersonService().populateBudgetPersonDefaultDataIfEmpty(budget);
        this.calculateSalary(budget);
        if (this.getKcBusinessRulesEngine().applyRules(new BudgetSavePersonnelEvent(budget, budget.getBudgetPeriod(budgetForm.getViewBudgetPeriod() - 1))).booleanValue() && this.getKcBusinessRulesEngine().applyRules(new AwardBudgetSaveEvent(budget)).booleanValue()) {
            if (budgetForm.isAuditActivated()) {
                forward = super.save(mapping, form, request, response);
            } else {
                super.save(mapping, form, request, response);
            }
        }
        return forward;
    }

    public void calculateSalary(Budget budget) {
        for (int periodIndex = 0; periodIndex < budget.getBudgetPeriods().size(); ++periodIndex) {
            BudgetPeriod currentPeriod = budget.getBudgetPeriod(periodIndex);
            AwardBudgetPeriodExt awardBudgetPeriod = (AwardBudgetPeriodExt)currentPeriod;
            if (awardBudgetPeriod.isFringeOverridden()) continue;
            for (int lineItemIndex = 0; lineItemIndex < currentPeriod.getBudgetLineItems().size(); ++lineItemIndex) {
                BudgetLineItem currentLineItem = currentPeriod.getBudgetLineItems().get(lineItemIndex);
                for (int personIndex = 0; personIndex < currentLineItem.getBudgetPersonnelDetailsList().size(); ++personIndex) {
                    this.calculateSalaryForLineItem(budget, periodIndex, lineItemIndex, personIndex, currentLineItem);
                }
            }
        }
    }

    public ActionForward deleteBudgetPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((BudgetForm)form).getBudgetDocument();
        AwardBudgetExt budget = awardBudgetDocument.getBudget();
        String errorPath = "budgetPersons[0].personNumber";
        if (!this.getKcBusinessRulesEngine().applyRules(new DeleteBudgetPersonEvent(budget, budget.getBudgetPerson(this.getLineToDelete(request)), errorPath)).booleanValue()) {
            return mapping.findForward("basic");
        }
        return this.confirm(this.buildDeleteBudgetPersonConfirmationQuestion(mapping, form, request, response), CONFIRM_DELETE_BUDGET_PERSON, EMPTY_GROUP_NAME);
    }

    public ActionForward confirmDeleteBudgetPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_BUDGET_PERSON.equals(question)) {
            AwardBudgetDocument awardBudgetDocument = ((BudgetForm)form).getBudgetDocument();
            AwardBudgetExt budget = awardBudgetDocument.getBudget();
            this.getBudgetPersonnelBudgetService().deleteBudgetPersonnelDetailsForPerson(budget, budget.getBudgetPerson(this.getLineToDelete(request)));
            budget.getBudgetPersons().remove(this.getLineToDelete(request));
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        Document document = budgetForm.getDocument();
        budgetForm.setDocId(document.getDocumentNumber());
        budgetForm.setCommand("displayDocSearchView");
        ActionForward actionForward = this.docHandler(mapping, form, request, response);
        KNSGlobalVariables.getMessageList().add("message.document.reloaded", new String[0]);
        this.reconcilePersonnelRoles(budget);
        this.populatePersonnelCategoryTypeCodes(budgetForm);
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)budgetLineItem.getCostElement(), (CharSequence)budgetLineItem.getCostElementBO().getCostElement())) {
                    budgetLineItem.refreshReferenceObject("costElementBO");
                    budgetLineItem.setBudgetCategoryCode(budgetLineItem.getCostElementBO().getBudgetCategoryCode());
                }
                this.updatePersonnelBudgetRate(budgetLineItem);
            }
        }
        return actionForward;
    }

    public ActionForward synchToProposal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        this.getBudgetPersonService().synchBudgetPersonsToProposal(budget);
        this.reconcilePersonnelRoles(budget);
        return mapping.findForward("basic");
    }

    private void populateAndAddBudgetPerson(BudgetPerson budgetPerson, Budget budget) {
        this.getBudgetPersonService().addBudgetPerson(budget, budgetPerson);
    }

    private StrutsConfirmation buildDeleteBudgetPersonConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((BudgetForm)form).getBudgetDocument();
        AwardBudgetExt budget = awardBudgetDocument.getBudget();
        String personName = budget.getBudgetPerson(this.getLineToDelete(request)).getPersonName();
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_BUDGET_PERSON, "document.question.deletePerson.text", personName);
    }

    protected BudgetPersonnelBudgetService getBudgetPersonnelBudgetService() {
        if (this.budgetPersonnelBudgetService == null) {
            this.budgetPersonnelBudgetService = KcServiceLocator.getService(BudgetPersonnelBudgetService.class);
        }
        return this.budgetPersonnelBudgetService;
    }

    public ActionForward personnelRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int budgetPeriodNumber = Integer.parseInt(request.getParameter("budgetPeriod"));
        int budgetLineItemNumber = Integer.parseInt(request.getParameter("line"));
        String rateClassCode = request.getParameter("rateClassCode");
        String rateTypeCode = request.getParameter("rateTypeCode");
        String fieldName = request.getParameter("fieldName");
        BudgetPeriod selectedBudgetPeriod = budget.getBudgetPeriod(budgetPeriodNumber - 1);
        BudgetLineItem selectedLineItem = selectedBudgetPeriod.getBudgetLineItem(budgetLineItemNumber);
        for (BudgetPersonnelDetails budgetPersonnelDetails : selectedLineItem.getBudgetPersonnelDetailsList()) {
            budgetPersonnelDetails.refreshReferenceObject("budgetPerson");
        }
        this.updatePersonnelBudgetRate(selectedLineItem);
        request.setAttribute("budgetPeriod", (Object)budgetPeriodNumber);
        request.setAttribute("lineNumber", (Object)budgetLineItemNumber);
        request.setAttribute("rateClassCode", (Object)rateClassCode);
        request.setAttribute("rateTypeCode", (Object)rateTypeCode);
        request.setAttribute("fieldName", (Object)fieldName);
        return mapping.findForward("personnelRates");
    }

    private boolean checkForDeletedPerson(Budget budget, BudgetPersonnelDetails budgetPersonnelDetails) {
        for (BudgetPerson person : budget.getBudgetPersons()) {
            if (person.getPersonSequenceNumber().intValue() != budgetPersonnelDetails.getPersonSequenceNumber().intValue()) continue;
            return false;
        }
        return true;
    }

    private boolean checkToRetainBudgetLineItem(BudgetLineItem budgetLineItem, Budget budget) {
        ArrayList<Integer> deletedPersons = new ArrayList<Integer>();
        int originalPersonListSize = budgetLineItem.getBudgetPersonnelDetailsList().size();
        int i = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            if (budgetPersonnelDetails.getBudgetPerson() == null) {
                budgetPersonnelDetails.refreshReferenceObject("budgetPerson");
            }
            if (budgetPersonnelDetails.getBudgetPerson() != null && this.checkForDeletedPerson(budget, budgetPersonnelDetails)) {
                deletedPersons.add(i);
            }
            ++i;
        }
        for (Integer deletedPersonIndex : deletedPersons) {
            budgetLineItem.getBudgetPersonnelDetailsList().remove(deletedPersonIndex);
        }
        return originalPersonListSize > 0 && deletedPersons.size() == originalPersonListSize;
    }

    public void updatePersonnelBudgetRate(BudgetLineItem budgetLineItem) {
        int j = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            budgetPersonnelDetails.setApplyInRateFlag(budgetLineItem.getApplyInRateFlag());
            budgetPersonnelDetails.setOnOffCampusFlag(budgetLineItem.getOnOffCampusFlag());
            if (budgetPersonnelDetails.getBudgetPerson() == null) {
                budgetPersonnelDetails.refreshReferenceObject("budgetPerson");
            }
            j = 0;
            for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts()) {
                Boolean updatedApplyRateFlag = null;
                if (budgetPersonnelCalculatedAmount.getRateClass() == null) {
                    budgetPersonnelCalculatedAmount.refreshReferenceObject("rateClass");
                }
                for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmout : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (!budgetLineItemCalculatedAmout.getRateClassCode().equalsIgnoreCase(budgetPersonnelCalculatedAmount.getRateClassCode()) || !budgetLineItemCalculatedAmout.getRateTypeCode().equalsIgnoreCase(budgetPersonnelCalculatedAmount.getRateTypeCode())) continue;
                    updatedApplyRateFlag = budgetLineItemCalculatedAmout.getApplyRateFlag();
                }
                budgetPersonnelCalculatedAmount.setApplyRateFlag(updatedApplyRateFlag);
                ++j;
            }
        }
        for (BudgetLineItemCalculatedAmount lineItemCalculatedAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            if (lineItemCalculatedAmount.getRateClass() != null) continue;
            lineItemCalculatedAmount.refreshReferenceObject("rateClass");
        }
    }

    public ActionForward personnelDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int budgetPeriodNumber = Integer.parseInt(request.getParameter("budgetPeriod"));
        int budgetLineItemNumber = Integer.parseInt(request.getParameter("line"));
        int personNumber = Integer.parseInt(request.getParameter("personNumber"));
        BudgetPeriod selectedBudgetPeriod = budget.getBudgetPeriod(budgetPeriodNumber - 1);
        BudgetLineItem selectedLineItem = selectedBudgetPeriod.getBudgetLineItem(budgetLineItemNumber);
        BudgetPersonnelDetails selectedBudgetPersonnelDetails = selectedLineItem.getBudgetPersonnelDetails(personNumber);
        selectedBudgetPersonnelDetails.refreshReferenceObject("budgetPerson");
        request.setAttribute("budgetPeriod", (Object)budgetPeriodNumber);
        request.setAttribute("lineNumber", (Object)budgetLineItemNumber);
        request.setAttribute("personNumber", (Object)personNumber);
        return mapping.findForward("personnelDetails");
    }

    public ActionForward savePersonnelDescription(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int budgetPeriodNumber = Integer.parseInt(request.getParameter("budgetPeriod"));
        int budgetLineItemNumber = Integer.parseInt(request.getParameter("line"));
        int personNumber = Integer.parseInt(request.getParameter("personnelIndex"));
        BudgetPeriod selectedBudgetPeriod = budget.getBudgetPeriod(budgetPeriodNumber - 1);
        BudgetLineItem selectedLineItem = selectedBudgetPeriod.getBudgetLineItem(budgetLineItemNumber);
        return mapping.findForward("closePage");
    }

    public ActionForward calculateLineItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = this.getSelectedLine(request);
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        if (this.getKcBusinessRulesEngine().applyRules(new AwardBudgetSaveEvent(budget)).booleanValue()) {
            this.updatePersonnelBudgetRate(selectedBudgetLineItem);
            this.getCalculationService().calculateBudgetLineItem(budget, selectedBudgetLineItem);
            this.getAwardBudgetPeriodCalculationService().recalculateBudgetPeriod(budget, budget.getBudgetPeriod(selectedBudgetPeriodIndex));
            this.getCalculationService().populateCalculatedAmount(budget, selectedBudgetLineItem);
        }
        budget.getBudgetTotals();
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward applyToLaterPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudget();
        int sltdLineItem = this.getSelectedLine(request);
        int sltdBudgetPeriod = budgetForm.getViewBudgetPeriod() - 1;
        if (this.getKcBusinessRulesEngine().applyRules(new PersonnelApplyToPeriodsBudgetEvent(budget, "document.budget.budgetPeriod[" + sltdBudgetPeriod + "].budgetLineItem[" + sltdLineItem + "]", budget.getBudgetPeriod(sltdBudgetPeriod).getBudgetLineItem(sltdLineItem), budget.getBudgetPeriod(sltdBudgetPeriod))).booleanValue()) {
            this.getCalculationService().applyToLaterPeriods(budget, budget.getBudgetPeriod(sltdBudgetPeriod), budget.getBudgetPeriod(sltdBudgetPeriod).getBudgetLineItem(sltdLineItem));
        }
        return mapping.findForward("basic");
    }

    public ActionForward calculatePersonSalaryDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
        ArrayList<BudgetPersonSalaryDetails> budgetPersonSalaryDetails = new ArrayList();
        budgetPersonSalaryDetails = this.getBudgetPersonnelBudgetService().calculatePersonSalary(budget, this.getSelectedLine(request));
        budgetForm.getBudgetDocument().getBudget().getBudgetPerson(this.getSelectedLine(request)).setBudgetPersonSalaryDetails(budgetPersonSalaryDetails);
        budgetForm.setViewDivFlag(true);
        budgetForm.setPersonIndex(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward saveBudgetPersonSalaryInDiffPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List salaryDetails;
        boolean zero = false;
        int listIndex = 0;
        BudgetForm budgetForm = (BudgetForm)form;
        AwardBudgetExt budget = budgetForm.getBudgetDocument().getBudget();
        List<BudgetPersonSalaryDetails> budgetPersonSalaryDetails = budget.getBudgetPerson(this.getSelectedLine(request)).getBudgetPersonSalaryDetails();
        HashMap<String, Object> budgetPersonInPeriodsSalaryMap = new HashMap<String, Object>();
        budgetPersonInPeriodsSalaryMap.put("personSequenceNumber", budget.getBudgetPerson(this.getSelectedLine(request)).getPersonSequenceNumber());
        budgetPersonInPeriodsSalaryMap.put("budgetId", budget.getBudgetId());
        if (budget.getBudgetPerson(this.getSelectedLine(request)).getPersonId() != null) {
            budgetPersonInPeriodsSalaryMap.put("personId", budget.getBudgetPerson(this.getSelectedLine(request)).getPersonId());
        } else if (budget.getBudgetPerson(this.getSelectedLine(request)).getRolodexId() != null) {
            budgetPersonInPeriodsSalaryMap.put("personId", budget.getBudgetPerson(this.getSelectedLine(request)).getRolodexId());
        } else {
            budgetPersonInPeriodsSalaryMap.put("personId", budget.getBudgetPerson(this.getSelectedLine(request)).getTbnId());
        }
        List personSalaryDetails = salaryDetails = this.getBusinessObjectService().findMatching(BudgetPersonSalaryDetails.class, budgetPersonInPeriodsSalaryMap);
        for (BudgetPersonSalaryDetails budgetPerSalaryDetails : budgetPersonSalaryDetails) {
            budgetPerSalaryDetails.setBudgetId(budget.getBudgetId());
            budgetPerSalaryDetails.setPersonSequenceNumber(budget.getBudgetPerson(this.getSelectedLine(request)).getPersonSequenceNumber());
            budgetPerSalaryDetails.setBudgetPerson(budget.getBudgetPerson(this.getSelectedLine(request)));
            if (budget.getBudgetPerson(this.getSelectedLine(request)).getPersonId() != null) {
                budgetPerSalaryDetails.setPersonId(budget.getBudgetPerson(this.getSelectedLine(request)).getPersonId());
            } else if (budget.getBudgetPerson(this.getSelectedLine(request)).getRolodexId() != null) {
                budgetPerSalaryDetails.setPersonId(budget.getBudgetPerson(this.getSelectedLine(request)).getRolodexId().toString());
            } else {
                budgetPerSalaryDetails.setPersonId(budget.getBudgetPerson(this.getSelectedLine(request)).getTbnId());
            }
            if (personSalaryDetails != null && personSalaryDetails.size() > 0) {
                budgetPerSalaryDetails.setBudgetPeriod(((BudgetPersonSalaryDetails)personSalaryDetails.get(listIndex)).getBudgetPeriod());
                budgetPerSalaryDetails.setBudgetPersonSalaryDetailId(((BudgetPersonSalaryDetails)personSalaryDetails.get(listIndex)).getBudgetPersonSalaryDetailId());
            } else {
                budgetPerSalaryDetails.setBudgetPeriod(listIndex + 1);
            }
            ++listIndex;
        }
        if (budgetPersonSalaryDetails != null && budgetPersonSalaryDetails.size() > 0) {
            this.getBusinessObjectService().save(budgetPersonSalaryDetails);
        }
        budgetForm.setViewDivFlag(true);
        budgetForm.setPersonIndex(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public void setBudgetPersonnelBudgetService(BudgetPersonnelBudgetService budgetPersonnelBudgetService) {
        this.budgetPersonnelBudgetService = budgetPersonnelBudgetService;
    }

    public BudgetPersonService getBudgetPersonService() {
        if (this.budgetPersonService == null) {
            this.budgetPersonService = KcServiceLocator.getService(BudgetPersonService.class);
        }
        return this.budgetPersonService;
    }

    public void setBudgetPersonService(BudgetPersonService budgetPersonService) {
        this.budgetPersonService = budgetPersonService;
    }
}

