/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.custom;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.util.Wrapper;

public final class CustomDataUtils {
    private static final Logger LOG = LogManager.getLogger(CustomDataUtils.class);

    private CustomDataUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static String serializeListValue(List<Wrapper<String>> value) {
        if (value == null) {
            return null;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(value.stream().map(v -> (String)v.getValue()).collect(Collectors.toList()));
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static void processCustomDataBeforeSave(List<? extends DocumentCustomData> customDataList) {
        CustomDataUtils.deduplicateCustomAttributeLookupReturns(customDataList);
        CustomDataUtils.processCustomDataDeserializedListValues(customDataList);
        CustomDataUtils.serializeListValues(customDataList);
    }

    public static void serializeListValues(List<? extends DocumentCustomData> customDataList) {
        if (customDataList != null) {
            customDataList.stream().filter(cd -> cd.getCustomAttribute().getAllowsMultipleValues()).forEach(cd -> cd.serializeListValue());
        }
    }

    public static List<Wrapper<String>> deserializeListValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return new ArrayList<Wrapper<String>>();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            List unwrappedValues = (List)objectMapper.readValue(value, List.class);
            return unwrappedValues.stream().map(v -> new Wrapper<String>((String)v)).collect(Collectors.toList());
        }
        catch (JsonProcessingException e) {
            LOG.error(e.getMessage());
            return Lists.newArrayList((Object[])new Wrapper[]{new Wrapper<String>(value)});
        }
    }

    public static void addElementNoSave(List<? extends DocumentCustomData> customData, long customDataId) {
        CustomDataUtils.processCustomDataDeserializedListValues(customData);
        DocumentCustomData docCustomData = CustomDataUtils.getCustomDataById(customData, customDataId);
        docCustomData.deserializeListValue();
        List<Wrapper<String>> deserializedListValue = docCustomData.getDeserializedListValue();
        deserializedListValue.add(new Wrapper<String>(docCustomData.getCustomAttribute().getDefaultValue()));
        docCustomData.serializeListValue();
    }

    public static void removeElementNoSave(List<? extends DocumentCustomData> customData, long customDataId, int elementIndex) {
        CustomDataUtils.processCustomDataDeserializedListValues(customData);
        DocumentCustomData docCustomData = CustomDataUtils.getCustomDataById(customData, customDataId);
        docCustomData.deserializeListValue();
        List<Wrapper<String>> deserializedListValue = docCustomData.getDeserializedListValue();
        deserializedListValue.remove(elementIndex);
        docCustomData.serializeListValue();
    }

    public static void processCustomDataDeserializedListValues(List<? extends DocumentCustomData> documentCustomData) {
        documentCustomData.stream().filter(customData -> customData.getCustomAttribute().getAllowsMultipleValues() && customData.getDeserializedListValue() != null).forEach(customData -> customData.setDeserializedListValue(customData.getDeserializedListValue().stream().map(CustomDataUtils::unwrapSingletonArrayIfNeeded).collect(Collectors.toList())));
    }

    public static void deduplicateCustomAttributeLookupReturns(List<? extends DocumentCustomData> documentCustomData) {
        documentCustomData.stream().filter(customData -> customData.getCustomAttribute() != null && customData.getCustomAttribute().getAllowsMultipleValues() && customData.getCustomAttribute().getLookupReturn() != null && customData.getCustomAttribute().getLookupReturn().contains(",")).forEach(customData -> {
            int firstCommaIndex = customData.getCustomAttribute().getLookupReturn().indexOf(44);
            String lookupReturn = customData.getCustomAttribute().getLookupReturn().substring(0, firstCommaIndex);
            customData.getCustomAttribute().setLookupReturn(lookupReturn);
        });
    }

    public static void resetValueToEmpty(DocumentCustomData customData) {
        if (!customData.getCustomAttribute().getAllowsMultipleValues()) {
            customData.setValue("");
        } else {
            customData.setDeserializedListValue(new ArrayList<Wrapper<String>>());
            customData.serializeListValue();
        }
    }

    public static void resetValueToDefault(DocumentCustomData customData) {
        String defaultValue = customData.getCustomAttribute().getDefaultValue();
        if (!customData.getCustomAttribute().getAllowsMultipleValues()) {
            customData.setValue(defaultValue);
        } else {
            customData.setDeserializedListValue(Lists.newArrayList((Object[])new Wrapper[]{new Wrapper<String>(defaultValue)}));
            customData.serializeListValue();
        }
    }

    public static boolean isBlank(DocumentCustomData customData) {
        if (!customData.getCustomAttribute().getAllowsMultipleValues()) {
            return StringUtils.isBlank((CharSequence)customData.getValue());
        }
        customData.deserializeListValue();
        return customData.getDeserializedListValue().isEmpty();
    }

    private static DocumentCustomData getCustomDataById(List<? extends DocumentCustomData> customData, long customDataId) {
        return customData.stream().filter(x -> x.getCustomAttributeId().equals(customDataId)).findFirst().get();
    }

    private static Wrapper<String> unwrapSingletonArrayIfNeeded(Wrapper<?> wrappedValue) {
        Wrapper<String> valueWrapper = wrappedValue;
        Object value = valueWrapper.getValue();
        return value != null && value.getClass().isArray() ? new Wrapper<String>((String)Array.get(value, 0)) : valueWrapper;
    }

    public static String getFormattedValueString(DocumentCustomData customData) {
        return CustomDataUtils.getFormattedValueString(customData, "\n");
    }

    public static String getFormattedValueString(DocumentCustomData customData, String delimiter) {
        if (!customData.getCustomAttribute().getAllowsMultipleValues()) {
            return customData.getValue();
        }
        customData.deserializeListValue();
        return customData.getDeserializedListValue() != null ? String.join((CharSequence)delimiter, customData.getDeserializedListValue().stream().map(w -> (String)w.getValue()).collect(Collectors.toList())) : "";
    }
}

