/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.custom;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.AuditCustomDataEvent;
import org.kuali.coeus.common.framework.custom.CustomDataUtils;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.SaveCustomDataEvent;
import org.kuali.coeus.common.framework.custom.arg.ArgValueLookup;
import org.kuali.coeus.common.framework.custom.attr.CustomAttribute;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDataType;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeService;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.util.Wrapper;
import org.kuali.coeus.propdev.impl.custom.AuditProposalCustomDataEvent;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.charlevel.UTF8AnyCharacterValidationPattern;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.krad.service.LegacyDataAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class CustomDataRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<SaveCustomDataEvent> {
    private static final String STRING = "String";
    private static final String DATE = "Date";
    private static final String NUMBER = "Number";
    public static final String ARGUMENT_NAME = "argumentName";
    public static final String USER_NAME = "userName";
    private static String CUSTOMATTRIBUTE_ERROR_START = "[";
    private static String CUSTOMATTRIBUTE_ERROR_END = "].value";
    private static DateFormat dateFormat;
    private static final String DATE_REGEX = "(0?[1-9]|1[012])/(0?[1-9]|[12][0-9]|3[01])/(19|2[0-9])[0-9]{2}";
    private static Map<String, ValidationPattern> VALIDATION_CLASSES;
    @Autowired
    @Qualifier(value="legacyDataAdapter")
    private LegacyDataAdapter legacyDataAdapter;
    private CustomAttributeService customAttributeService;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean processRules(SaveCustomDataEvent event) {
        boolean rulePassed = true;
        Map<String, CustomAttributeDocument> customAttributeDocuments = event.getCustomAttributeDocuments();
        for (Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry : customAttributeDocuments.entrySet()) {
            CustomAttributeDocument customAttributeDocument = customAttributeDocumentEntry.getValue();
            CustomAttribute customAttribute = customAttributeDocument.getCustomAttribute();
            List<? extends DocumentCustomData> customDataList = event.getCustomDataList();
            if (this.isDocEnrouteAndDoesNotContainCustomAttribute(customAttribute.getId(), customDataList, event.getDocument().getDocumentHeader().getWorkflowDocument())) continue;
            int index = 0;
            for (DocumentCustomData documentCustomData : customDataList) {
                if (documentCustomData.getCustomAttributeId().longValue() == customAttribute.getId().longValue()) {
                    customAttribute.setValue(documentCustomData.getValue());
                    break;
                }
                ++index;
            }
            String errorKey = event.getErrorPathPrefix() + CUSTOMATTRIBUTE_ERROR_START + index + CUSTOMATTRIBUTE_ERROR_END;
            if (StringUtils.isNotBlank((CharSequence)customAttribute.getValue())) {
                void var11_15;
                CustomAttributeDataType customAttributeDataType = customAttribute.getCustomAttributeDataType();
                if (customAttributeDataType == null && customAttribute.getDataTypeCode() != null) {
                    CustomAttributeDataType customAttributeDataType2 = this.getCustomAttributeService().getCustomAttributeDataType(customAttribute.getDataTypeCode());
                }
                if (var11_15 != null) {
                    rulePassed &= this.validateAttributeFormat(customAttribute, errorKey, event);
                }
            }
            if (!event.isValidateRequiredFields() || !customAttributeDocument.isRequired() || !StringUtils.isBlank((CharSequence)customAttribute.getValue())) continue;
            event.reportError(customAttribute, errorKey, "error.required", customAttribute.getLabel(), customAttribute.getValue(), this.getValidFormat(customAttribute.getCustomAttributeDataType().getDescription()));
            rulePassed = false;
        }
        return rulePassed;
    }

    protected boolean isDocEnrouteAndDoesNotContainCustomAttribute(Long customAttributeId, List<? extends DocumentCustomData> customDataList, WorkflowDocument workflowDocument) {
        if (!workflowDocument.isSaved() && !workflowDocument.isInitiated()) {
            for (DocumentCustomData documentCustomData : customDataList) {
                if (!documentCustomData.getCustomAttributeId().equals(customAttributeId)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean validateAttributeFormat(CustomAttribute customAttribute, String errorKey, SaveCustomDataEvent event) {
        CustomAttributeDataType customAttributeDataType;
        boolean isValid = true;
        CustomAttributeDataType customAttributeDataType2 = customAttributeDataType = customAttribute.getCustomAttributeDataType() == null && customAttribute.getDataTypeCode() != null ? this.getCustomAttributeService().getCustomAttributeDataType(customAttribute.getDataTypeCode()) : customAttribute.getCustomAttributeDataType();
        if (customAttributeDataType != null) {
            Stream valueStream = customAttribute.getAllowsMultipleValues() ? CustomDataUtils.deserializeListValue(customAttribute.getValue()).stream() : Stream.of(new Wrapper<String>(customAttribute.getValue()));
            isValid &= valueStream.allMatch(value -> this.validateAttributeValueFormat(customAttribute, customAttributeDataType, (String)value.getValue(), errorKey, event));
        }
        return isValid;
    }

    protected boolean validateAttributeValueFormat(CustomAttribute customAttribute, CustomAttributeDataType customAttributeDataType, String value, String errorKey, SaveCustomDataEvent event) {
        boolean isValid = true;
        value = value != null ? value : "";
        Integer maxLength = customAttribute.getDataLength();
        if (maxLength != null && maxLength < value.length()) {
            event.reportError(customAttribute, errorKey, "error.maxLength", customAttribute.getLabel(), maxLength.toString());
            isValid = false;
        }
        ValidationPattern validationPattern = VALIDATION_CLASSES.get(customAttributeDataType.getDescription());
        String validFormat = this.getValidFormat(customAttributeDataType.getDescription());
        if (validationPattern != null) {
            if (!validationPattern.matches(value)) {
                event.reportError(customAttribute, errorKey, "error.invalidFormat.withFormat", customAttribute.getLabel(), value, validFormat);
                isValid = false;
            }
        } else if (DATE.equals(customAttributeDataType.getDescription())) {
            if (value != null && !value.matches(DATE_REGEX)) {
                event.reportError(customAttribute, errorKey, "error.invalidFormat", customAttribute.getLabel(), value, validFormat);
                isValid = false;
            } else {
                try {
                    dateFormat.parse(value);
                }
                catch (ParseException e) {
                    event.reportError(customAttribute, errorKey, "error.date", value, customAttribute.getLabel());
                    isValid = false;
                }
            }
        }
        if (customAttribute.getLookupClass() != null && customAttribute.getLookupClass().equals(KcPerson.class.getName())) {
            if (customAttribute.getDataTypeCode().equals("1") && customAttribute.getLookupReturn().equals(USER_NAME)) {
                validFormat = this.getValidFormat(customAttributeDataType.getDescription());
                KcPersonService kps = this.getKcPersonService();
                KcPerson customPerson = kps.getKcPersonByUserName(value);
                if (customPerson == null) {
                    this.addError(customAttribute, errorKey, event, value, validFormat);
                    isValid = false;
                }
            }
        } else if (customAttribute.getLookupClass() != null && customAttribute.getLookupClass().equals(ArgValueLookup.class.getName())) {
            if (!this.isValidArgValue(customAttribute, value, errorKey, event, customAttributeDataType)) {
                isValid = false;
            }
        } else if (customAttribute.getLookupClass() != null) {
            Class<?> boClass = null;
            try {
                boClass = Class.forName(customAttribute.getLookupClass());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (this.isInvalid(boClass, this.keyValue(customAttribute.getLookupReturn(), value))) {
                validFormat = this.getValidFormat(customAttributeDataType.getDescription());
                this.addError(customAttribute, errorKey, event, value, validFormat);
                isValid = false;
            }
        }
        return isValid;
    }

    public boolean validateAttributeValueFormat(CustomAttribute customAttribute, String value, String errorKey, SaveCustomDataEvent event) {
        CustomAttributeDataType customAttributeDataType;
        CustomAttributeDataType customAttributeDataType2 = customAttributeDataType = customAttribute.getCustomAttributeDataType() == null && customAttribute.getDataTypeCode() != null ? this.getCustomAttributeService().getCustomAttributeDataType(customAttribute.getDataTypeCode()) : customAttribute.getCustomAttributeDataType();
        if (customAttributeDataType != null) {
            return this.validateAttributeValueFormat(customAttribute, customAttributeDataType, value, errorKey, event);
        }
        return true;
    }

    public boolean isValidArgValue(CustomAttribute customAttribute, String customAttributeValue, String errorKey, SaveCustomDataEvent event, CustomAttributeDataType customAttributeDataType) {
        ArgValueLookup argValue;
        Collection<ArgValueLookup> searchResults = this.getMatchingArgValues(customAttribute);
        Optional<ArgValueLookup> matchedArgValue = searchResults.stream().filter(argValueLookup1 -> customAttributeValue.equals(argValueLookup1.getValue())).findFirst();
        if (!matchedArgValue.isPresent()) {
            String validFormat = this.getValidFormat(customAttributeDataType.getDescription());
            this.addError(customAttribute, errorKey, event, customAttributeValue, validFormat);
            return false;
        }
        if ((event instanceof AuditCustomDataEvent || event instanceof AuditProposalCustomDataEvent) && !(argValue = matchedArgValue.get()).isActive() && StringUtils.equals((CharSequence)customAttributeValue, (CharSequence)argValue.getValue())) {
            event.reportWarning(customAttribute, errorKey, "error.inactive.argument.value", customAttribute.getLabel());
            return false;
        }
        return true;
    }

    public Collection<ArgValueLookup> getMatchingArgValues(CustomAttribute customAttribute) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put(ARGUMENT_NAME, customAttribute.getLookupReturn());
        return this.getLegacyDataAdapter().findMatching(ArgValueLookup.class, criteria);
    }

    public void addError(CustomAttribute customAttribute, String errorKey, SaveCustomDataEvent event, String attributeValue, String validFormat) {
        event.reportError(customAttribute, errorKey, "error.existence", customAttribute.getLabel(), attributeValue, validFormat);
    }

    private String getValidFormat(String dataType) {
        String validFormat = "String - Any Character";
        if (dataType.equalsIgnoreCase(NUMBER)) {
            validFormat = "Number - [0-9]";
        } else if (dataType.equalsIgnoreCase(DATE)) {
            validFormat = "Date - [xx/xx/xxxx]";
        }
        return validFormat;
    }

    public CustomAttributeService getCustomAttributeService() {
        if (this.customAttributeService == null) {
            this.customAttributeService = KcServiceLocator.getService(CustomAttributeService.class);
        }
        return this.customAttributeService;
    }

    public void setCustomAttributeService(CustomAttributeService customAttributeService) {
        this.customAttributeService = customAttributeService;
    }

    protected KcPersonService getKcPersonService() {
        return KcServiceLocator.getService(KcPersonService.class);
    }

    public LegacyDataAdapter getLegacyDataAdapter() {
        if (this.legacyDataAdapter == null) {
            this.legacyDataAdapter = KcServiceLocator.getService(LegacyDataAdapter.class);
        }
        return this.legacyDataAdapter;
    }

    public void setLegacyDataAdapter(LegacyDataAdapter legacyDataAdapter) {
        this.legacyDataAdapter = legacyDataAdapter;
    }

    static {
        VALIDATION_CLASSES = new HashMap<String, ValidationPattern>();
        HashMap<String, Object> tempPatterns = new HashMap<String, Object>();
        UTF8AnyCharacterValidationPattern anyCharVal = new UTF8AnyCharacterValidationPattern();
        anyCharVal.setAllowWhitespace(true);
        tempPatterns.put(STRING, anyCharVal);
        tempPatterns.put(NUMBER, new NumericValidationPattern());
        VALIDATION_CLASSES = Collections.unmodifiableMap(tempPatterns);
        dateFormat = DateFormat.getDateInstance(3);
        dateFormat.setLenient(false);
    }
}

