/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.custom.attr;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.custom.attr.CustomAttribute;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.kns.document.MaintenanceDocument;

public class CustomAttributeMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private static final Set<String> BLACKLISTED_CUSTOM_ATTRIBUTE_NAMES = Set.of("customAttributeId", "name", "label", "group", "allowsMultipleValues", "values");

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.check(document);
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.check(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.check(document);
    }

    private boolean check(MaintenanceDocument document) {
        return this.checkLookupReturn(document) && this.checkNameAllowed(document);
    }

    private boolean checkLookupReturn(MaintenanceDocument maintenanceDocument) {
        CustomAttribute newCustomAttribute;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass());
        }
        if (StringUtils.isNotBlank((CharSequence)(newCustomAttribute = (CustomAttribute)maintenanceDocument.getNewMaintainableObject().getDataObject()).getLookupClass())) {
            this.getGlobalVariableService().getUserSession().addObject("lookupClassName", (Object)newCustomAttribute.getLookupClass());
        }
        if (StringUtils.isNotBlank((CharSequence)newCustomAttribute.getLookupClass()) && StringUtils.isBlank((CharSequence)newCustomAttribute.getLookupReturn())) {
            this.getGlobalVariableService().getMessageMap().putError("document.newMaintainableObject.lookupReturn", "error.required", new String[]{"Lookup Return"});
            return false;
        }
        return true;
    }

    private boolean checkNameAllowed(MaintenanceDocument document) {
        CustomAttribute customAttribute = (CustomAttribute)document.getNewMaintainableObject().getDataObject();
        if (BLACKLISTED_CUSTOM_ATTRIBUTE_NAMES.contains(customAttribute.getName())) {
            this.getGlobalVariableService().getMessageMap().putError("document.newMaintainableObject.name", "error.invalid.customAttribute.name.reserved", new String[]{customAttribute.getName()});
            return false;
        }
        Predicate nameEquals = PredicateFactory.equal((String)"name", (Object)customAttribute.getName());
        Predicate predicate = customAttribute.getId() != null ? PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.notEqual((String)"id", (Object)customAttribute.getId()), nameEquals}) : nameEquals;
        QueryByCriteria.Builder queryBuilder = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{predicate}).setCountFlag(CountFlag.ONLY);
        QueryResults results = this.getDataObjectService().findMatching(CustomAttribute.class, queryBuilder.build());
        if (results.getTotalRowCount() > 0) {
            this.getGlobalVariableService().getMessageMap().putError("document.newMaintainableObject.name", "error.invalid.customAttribute.name.duplicate", new String[]{customAttribute.getName()});
            return false;
        }
        return true;
    }
}

